/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.SSLQueryCallbackHandler;
import org.wildfly.security.ssl.SSLConnection;

public final class SSLSaslServerFactory
extends AbstractDelegatingSaslServerFactory
implements SaslServerFactory {
    private final Supplier<SSLConnection> sslConnectionSupplier;

    public SSLSaslServerFactory(Supplier<SSLConnection> sslConnectionSupplier, SaslServerFactory delegate) {
        super(delegate);
        this.sslConnectionSupplier = (Supplier)Assert.checkNotNullParam((String)"sslConnectionSupplier", sslConnectionSupplier);
    }

    @Deprecated
    public SSLSaslServerFactory(SaslServerFactory delegate, Supplier<SSLSession> sslSession) {
        this(() -> SSLConnection.forSession((SSLSession)((SSLSession)sslSession.get()), (boolean)false), delegate);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SSLQueryCallbackHandler newHandler = new SSLQueryCallbackHandler(cbh, this.sslConnectionSupplier);
        SaslServer saslServer = super.createSaslServer(mechanism, protocol, serverName, props, newHandler);
        newHandler.activate();
        return saslServer;
    }
}

