/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.v1.GeoLocation;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 7196404519192910019L;
    @NotNull
    public final String query;
    public final String lang;
    public final String locale;
    public final long maxId;
    public final int count;
    @Nullable
    public final String since;
    public final long sinceId;
    @Nullable
    public final String geocode;
    @Nullable
    public final String until;
    @Nullable
    public final ResultType resultType;
    @Nullable
    public final String nextPageQuery;
    public static final Unit MILES = Unit.mi;
    public static final Unit KILOMETERS = Unit.km;
    public static final ResultType MIXED = ResultType.mixed;
    public static final ResultType POPULAR = ResultType.popular;
    public static final ResultType RECENT = ResultType.recent;

    @NotNull
    public Query lang(@NotNull String lang) {
        return new Query(this.query, lang, this.locale, this.maxId, this.count, this.since, this.sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query locale(@NotNull String locale) {
        return new Query(this.query, this.lang, locale, this.maxId, this.count, this.since, this.sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query maxId(long maxId) {
        return new Query(this.query, this.lang, this.locale, maxId, this.count, this.since, this.sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query count(int count) {
        return new Query(this.query, this.lang, this.locale, this.maxId, count, this.since, this.sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query since(@NotNull String since) {
        return new Query(this.query, this.lang, this.locale, this.maxId, this.count, since, this.sinceId, this.geocode, null, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query sinceId(long sinceId) {
        return new Query(this.query, this.lang, this.locale, this.maxId, this.count, this.since, sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query geoCode(@NotNull GeoLocation location, double radius, Unit unit) {
        String geocode = location.latitude + "," + location.longitude + "," + radius + unit.name();
        return new Query(this.query, this.lang, this.locale, this.maxId, this.count, this.since, this.sinceId, geocode, this.until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query until(@NotNull String until) {
        return new Query(this.query, this.lang, this.locale, this.maxId, this.count, this.since, this.sinceId, this.geocode, until, this.resultType, this.nextPageQuery);
    }

    @NotNull
    public Query resultType(@NotNull ResultType resultType) {
        return new Query(this.query, this.lang, this.locale, this.maxId, this.count, this.since, this.sinceId, this.geocode, this.until, resultType, this.nextPageQuery);
    }

    Query(@NotNull String query, String lang, String locale, long maxId, int count, @Nullable String since, long sinceId, @Nullable String geocode, @Nullable String until, @Nullable ResultType resultType, @Nullable String nextPageQuery) {
        this.query = query;
        this.lang = lang;
        this.locale = locale;
        this.maxId = maxId;
        this.count = count;
        this.since = since;
        this.sinceId = sinceId;
        this.geocode = geocode;
        this.until = until;
        this.resultType = resultType;
        this.nextPageQuery = nextPageQuery;
    }

    @NotNull
    public static Query of(@NotNull String query) {
        return new Query(query, null, null, -1L, -1, null, -1L, null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        return this.maxId == query1.maxId && this.count == query1.count && this.sinceId == query1.sinceId && this.query.equals(query1.query) && Objects.equals(this.lang, query1.lang) && Objects.equals(this.locale, query1.locale) && Objects.equals(this.since, query1.since) && Objects.equals(this.geocode, query1.geocode) && Objects.equals(this.until, query1.until) && this.resultType == query1.resultType && Objects.equals(this.nextPageQuery, query1.nextPageQuery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.lang, this.locale, this.maxId, this.count, this.since, this.sinceId, this.geocode, this.until, this.resultType, this.nextPageQuery});
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", lang='" + this.lang + '\'' + ", locale='" + this.locale + '\'' + ", maxId=" + this.maxId + ", count=" + this.count + ", since='" + this.since + '\'' + ", sinceId=" + this.sinceId + ", geocode='" + this.geocode + '\'' + ", until='" + this.until + '\'' + ", resultType=" + (Object)((Object)this.resultType) + ", nextPageQuery='" + this.nextPageQuery + '\'' + '}';
    }

    public static enum ResultType {
        popular,
        mixed,
        recent;

    }

    public static enum Unit {
        mi,
        km;

    }
}

