/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class NonAggregatedIdentifierMappingInitializer
extends AbstractInitializer<NonAggregatedIdentifierMappingInitializerData>
implements EmbeddableInitializer<NonAggregatedIdentifierMappingInitializerData> {
    private final NavigablePath navigablePath;
    private final NonAggregatedIdentifierMapping embedded;
    private final EmbeddableMappingType virtualIdEmbeddable;
    private final EmbeddableMappingType representationEmbeddable;
    private final EmbeddableInstantiator embeddableInstantiator;
    private final @Nullable InitializerParent<?> parent;
    private final boolean isResultInitializer;
    private final DomainResultAssembler<?>[] assemblers;
    private final @Nullable Initializer<InitializerData>[] initializers;
    private final @Nullable Initializer<InitializerData>[] subInitializersForResolveFromInitialized;
    private final @Nullable Initializer<InitializerData>[] collectionContainingSubInitializers;
    private final boolean lazyCapable;
    private final boolean hasLazySubInitializer;
    private final boolean hasIdClass;

    public NonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        this(resultDescriptor, parent, creationState, isResultInitializer, Function.identity());
    }

    protected NonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer, Function<Fetch, Fetch> fetchConverter) {
        super(creationState);
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = (NonAggregatedIdentifierMapping)resultDescriptor.getReferencedMappingContainer();
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        this.virtualIdEmbeddable = this.embedded.getEmbeddableTypeDescriptor();
        this.representationEmbeddable = this.embedded.getMappedIdEmbeddableTypeDescriptor();
        this.embeddableInstantiator = this.representationEmbeddable.getRepresentationStrategy().getInstantiator();
        this.hasIdClass = this.embedded.hasContainingClass() && this.virtualIdEmbeddable != this.representationEmbeddable;
        int size = this.virtualIdEmbeddable.getNumberOfFetchables();
        DomainResultAssembler[] assemblers = new DomainResultAssembler[size];
        this.assemblers = assemblers;
        Initializer[] initializers = new Initializer[assemblers.length];
        Initializer[] eagerSubInitializers = new Initializer[assemblers.length];
        Initializer[] collectionContainingSubInitializers = new Initializer[assemblers.length];
        boolean empty = true;
        boolean emptyEager = true;
        boolean emptyCollectionInitializers = true;
        boolean lazyCapable = false;
        boolean hasLazySubInitializers = false;
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = this.virtualIdEmbeddable.getFetchable(i);
            Fetch fetch = fetchConverter.apply(resultDescriptor.findFetch(stateArrayContributor));
            assemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
            Initializer<?> initializer = stateAssembler.getInitializer();
            if (initializer == null) continue;
            if (initializer.isEager()) {
                eagerSubInitializers[i] = initializer;
                hasLazySubInitializers = hasLazySubInitializers || initializer.hasLazySubInitializers();
                emptyEager = false;
                assert (fetch != null);
                FetchParent fetchParent = fetch.asFetchParent();
                if (fetchParent != null && fetchParent.containsCollectionFetches() || initializer.isCollectionInitializer()) {
                    collectionContainingSubInitializers[i] = initializer;
                    emptyCollectionInitializers = false;
                }
            } else {
                hasLazySubInitializers = true;
            }
            lazyCapable = lazyCapable || initializer.isLazyCapable();
            initializers[i] = initializer;
            empty = false;
        }
        this.initializers = empty ? Initializer.EMPTY_ARRAY : initializers;
        this.subInitializersForResolveFromInitialized = emptyEager ? Initializer.EMPTY_ARRAY : initializers;
        this.collectionContainingSubInitializers = emptyCollectionInitializers ? Initializer.EMPTY_ARRAY : collectionContainingSubInitializers;
        this.lazyCapable = lazyCapable;
        this.hasLazySubInitializer = hasLazySubInitializers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new NonAggregatedIdentifierMappingInitializerData(this, rowProcessingState);
    }

    @Override
    public void resolveKey(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setInstance(null);
        data.setState(Initializer.State.KEY_RESOLVED);
        if (this.initializers.length == 0) {
            this.resolveInstance(data);
        } else {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (Initializer<InitializerData> initializer : this.initializers) {
                if (initializer == null) continue;
                InitializerData subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (subData.getState() != Initializer.State.MISSING) continue;
                data.setState(Initializer.State.MISSING);
                return;
            }
        }
    }

    @Override
    public void resetResolvedEntityRegistrations(RowProcessingState rowProcessingState) {
        NonAggregatedIdentifierMappingInitializerData data = (NonAggregatedIdentifierMappingInitializerData)this.getData(rowProcessingState);
        for (Initializer<InitializerData> initializer : this.initializers) {
            if (initializer == null) continue;
            EntityInitializer<?> entityInitializer = initializer.asEntityInitializer();
            if (entityInitializer != null) {
                entityInitializer.resetResolvedEntityRegistrations(rowProcessingState);
                continue;
            }
            EmbeddableInitializer<?> embeddableInitializer = initializer.asEmbeddableInitializer();
            if (embeddableInitializer == null) continue;
            embeddableInitializer.resetResolvedEntityRegistrations(rowProcessingState);
        }
    }

    @Override
    public void resolveFromPreviousRow(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            if (data.getInstance() == null) {
                data.setState(Initializer.State.MISSING);
            } else {
                RowProcessingState rowProcessingState = data.getRowProcessingState();
                for (Initializer<InitializerData> initializer : this.collectionContainingSubInitializers) {
                    if (initializer == null) continue;
                    initializer.resolveFromPreviousRow(rowProcessingState);
                }
                data.setState(Initializer.State.INITIALIZED);
            }
        }
    }

    @Override
    public void resolveInstance(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        if (data.isFindByIdLookup) {
            data.setInstance(data.getRowProcessingState().getEntityId());
            data.setState(Initializer.State.INITIALIZED);
            return;
        }
        data.setState(Initializer.State.RESOLVED);
        this.extractRowState(data);
        if (data.getState() == Initializer.State.MISSING) {
            data.setInstance(null);
        } else {
            data.setInstance(this.embeddableInstantiator.instantiate(data));
        }
        if (this.parent == null) {
            data.setState(Initializer.State.INITIALIZED);
        }
    }

    @Override
    public void resolveInstance(@Nullable Object instance, NonAggregatedIdentifierMappingInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            this.resolveInstanceSubInitializers(instance, rowProcessingState);
            if (rowProcessingState.needsResolveState()) {
                for (DomainResultAssembler<?> assembler : this.assemblers) {
                    assembler.resolveState(rowProcessingState);
                }
            }
        }
    }

    private void resolveInstanceSubInitializers(Object instance, RowProcessingState rowProcessingState) {
        for (int i = 0; i < this.subInitializersForResolveFromInitialized.length; ++i) {
            Initializer<InitializerData> initializer = this.subInitializersForResolveFromInitialized[i];
            if (initializer == null) continue;
            Object subInstance = this.representationEmbeddable.getValue(instance, i);
            if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                initializer.resolveKey(rowProcessingState);
                continue;
            }
            initializer.resolveInstance(subInstance, rowProcessingState);
        }
    }

    @Override
    public void initializeInstance(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        if (this.parent != null) {
            assert (this.parent.isEntityInitializer());
            Object parentInstance = this.parent.getResolvedInstance(data.getRowProcessingState());
            assert (parentInstance != null);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(parentInstance);
            if (lazyInitializer != null) {
                this.virtualIdEmbeddable.setValues(lazyInitializer.getImplementation(), data.virtualIdState);
            } else {
                this.virtualIdEmbeddable.setValues(parentInstance, data.virtualIdState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<InitializerData> initializer : this.initializers) {
            if (initializer == null) continue;
            consumer.accept(initializer, rowProcessingState);
        }
    }

    private void extractRowState(NonAggregatedIdentifierMappingInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (int i = 0; i < this.assemblers.length; ++i) {
            Object associationKey;
            Object contributorValue = this.assemblers[i].assemble(rowProcessingState);
            if (contributorValue == null) {
                data.setState(Initializer.State.MISSING);
                return;
            }
            if (contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY) {
                data.virtualIdState[i] = null;
                data.idClassState[i] = null;
                continue;
            }
            data.virtualIdState[i] = contributorValue;
            data.idClassState[i] = contributorValue;
            if (!this.hasIdClass) continue;
            AttributeMapping virtualIdAttribute = this.virtualIdEmbeddable.getAttributeMapping(i);
            AttributeMapping mappedIdAttribute = this.representationEmbeddable.getAttributeMapping(i);
            if (!(virtualIdAttribute instanceof ToOneAttributeMapping)) continue;
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
            if (mappedIdAttribute instanceof ToOneAttributeMapping) continue;
            ForeignKeyDescriptor fkDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
            data.idClassState[i] = associationKey = fkDescriptor.getAssociationKeyFromSide(data.virtualIdState[i], toOneAttributeMapping.getSideNature().inverse(), rowProcessingState.getSession());
        }
    }

    @Override
    public void resolveState(NonAggregatedIdentifierMappingInitializerData data) {
        if (!data.isFindByIdLookup) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                assembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    public boolean isPartOfKey() {
        return true;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean isLazyCapable() {
        return this.lazyCapable;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializer;
    }

    protected @Nullable Initializer<InitializerData>[] getInitializers() {
        return this.initializers;
    }

    public String toString() {
        return "NonAggregatedIdentifierMappingInitializer(" + String.valueOf(this.navigablePath) + ") : `" + String.valueOf(this.getInitializedPart().getJavaType().getJavaTypeClass()) + "`";
    }

    public static class NonAggregatedIdentifierMappingInitializerData
    extends InitializerData
    implements ValueAccess {
        protected final boolean isFindByIdLookup;
        protected final InitializerData parentData;
        protected final Object[] virtualIdState;
        protected final Object[] idClassState;

        public NonAggregatedIdentifierMappingInitializerData(NonAggregatedIdentifierMappingInitializer initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            this.isFindByIdLookup = !initializer.hasIdClass && rowProcessingState.getEntityId() != null && initializer.navigablePath.getParent().getParent() == null && initializer.navigablePath instanceof EntityIdentifierNavigablePath;
            this.parentData = initializer.parent == null ? null : initializer.parent.getData(rowProcessingState);
            EmbeddableMappingType virtualIdEmbeddable = initializer.embedded.getEmbeddableTypeDescriptor();
            int size = virtualIdEmbeddable.getNumberOfFetchables();
            this.virtualIdState = new Object[size];
            this.idClassState = new Object[size];
        }

        @Override
        public Object[] getValues() {
            assert (this.getState() == Initializer.State.RESOLVED);
            return this.idClassState;
        }

        @Override
        public <T> T getValue(int i, Class<T> clazz) {
            assert (this.getState() == Initializer.State.RESOLVED);
            return clazz.cast(this.idClassState[i]);
        }

        @Override
        public Object getOwner() {
            return this.parentData == null ? null : this.parentData.getInstance();
        }
    }
}

