/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.range;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.query.range.CaseInsensitiveValue;
import org.hibernate.query.range.EmptyRange;
import org.hibernate.query.range.FullRange;
import org.hibernate.query.range.Interval;
import org.hibernate.query.range.LowerBound;
import org.hibernate.query.range.NotNull;
import org.hibernate.query.range.Pattern;
import org.hibernate.query.range.UpperBound;
import org.hibernate.query.range.Value;
import org.hibernate.query.range.ValueList;

@Incubating
public interface Range<U> {
    public Class<? extends U> getType();

    @Internal
    public Predicate toPredicate(Path<? extends U> var1, CriteriaBuilder var2);

    public static <U> Range<U> singleValue(U value) {
        return new Value<U>(value);
    }

    public static Range<String> singleCaseInsensitiveValue(String value) {
        return new CaseInsensitiveValue(value);
    }

    public static <U> Range<U> valueList(List<U> values) {
        return new ValueList<U>(values);
    }

    public static <U extends Comparable<U>> Range<U> greaterThan(U bound) {
        return new LowerBound<U>(bound, true);
    }

    public static <U extends Comparable<U>> Range<U> greaterThanOrEqualTo(U bound) {
        return new LowerBound<U>(bound, false);
    }

    public static <U extends Comparable<U>> Range<U> lessThan(U bound) {
        return new UpperBound<U>(bound, true);
    }

    public static <U extends Comparable<U>> Range<U> lessThanOrEqualTo(U bound) {
        return new UpperBound<U>(bound, false);
    }

    public static <U extends Comparable<U>> Range<U> open(U lowerBound, U upperBound) {
        return new Interval<U>(new LowerBound<U>(lowerBound, true), new UpperBound<U>(upperBound, true));
    }

    public static <U extends Comparable<U>> Range<U> closed(U lowerBound, U upperBound) {
        return new Interval<U>(new LowerBound<U>(lowerBound, false), new UpperBound<U>(upperBound, false));
    }

    public static Range<String> pattern(String pattern, boolean caseSensitive) {
        return new Pattern(pattern, caseSensitive);
    }

    public static Range<String> pattern(String pattern, boolean caseSensitive, char charWildcard, char stringWildcard) {
        return new Pattern(pattern, caseSensitive, charWildcard, stringWildcard);
    }

    public static Range<String> pattern(String pattern) {
        return Range.pattern(pattern, true);
    }

    public static Range<String> prefix(String prefix, boolean caseSensitive) {
        return Range.pattern(Range.escape(prefix) + "%", caseSensitive);
    }

    public static Range<String> suffix(String suffix, boolean caseSensitive) {
        return Range.pattern("%" + Range.escape(suffix), caseSensitive);
    }

    public static Range<String> containing(String substring, boolean caseSensitive) {
        return Range.pattern("%" + Range.escape(substring) + "%", caseSensitive);
    }

    public static Range<String> prefix(String prefix) {
        return Range.prefix(prefix, true);
    }

    public static Range<String> suffix(String suffix) {
        return Range.pattern(suffix, true);
    }

    public static Range<String> containing(String substring) {
        return Range.containing(substring, true);
    }

    public static <U> Range<U> empty(Class<U> type) {
        return new EmptyRange<U>(type);
    }

    public static <U> Range<U> full(Class<U> type) {
        return new FullRange<U>(type);
    }

    public static <U> Range<U> notNull(Class<U> type) {
        return new NotNull<U>(type);
    }

    private static String escape(String literal) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < literal.length(); ++i) {
            char ch = literal.charAt(i);
            if (ch == '%' || ch == '_' || ch == '\\') {
                result.append('\\');
            }
            result.append(ch);
        }
        return result.toString();
    }
}

