"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3c_21-daea39"],{74227:(t,e,n)=>{n.d(e,{A:()=>i});var o=n(71354),a=n.n(o),l=n(76314),r=n.n(l)()(a());r.push([t.id,"\n#modal-inner[data-v-5e94966b] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n}\nul[data-v-5e94966b] {\n\tmin-height: 100px;\n}\nli[data-v-5e94966b] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-5e94966b]:hover, li[data-v-5e94966b]:focus {\n\tbackground-color: var(--color-background-dark);\n}\nli.selected[data-v-5e94966b] {\n\tborder: 1px solid var(--color-primary-element);\n}\n.board-bullet[data-v-5e94966b] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nli > span[data-v-5e94966b],\n.avatar[data-v-5e94966b] {\n\tvertical-align: middle;\n}\n\n","",{version:3,sources:["webpack://./src/BoardSelector.vue"],names:[],mappings:";AAmHA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;;CAEA,sBAAA;AAEA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<template>\n\t<NcModal @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h1>{{ t('deck', 'Select the board to link to a project') }}</h1>\n\t\t\t<input v-model=\"filter\" type=\"text\" :placeholder=\"t('deck', 'Search by board title')\">\n\t\t\t<ul v-if=\"!loading\">\n\t\t\t\t<li v-for=\"board in availableBoards\"\n\t\t\t\t\t:key=\"board.id\"\n\t\t\t\t\t:class=\"{'selected': (selectedBoard === board.id) }\"\n\t\t\t\t\t@click=\"selectedBoard=board.id\">\n\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + board.color }\" class=\"board-bullet\" />\n\t\t\t\t\t<span>{{ board.title }}</span>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t\t<button v-if=\"!loading\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ t('deck', 'Select board') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'BoardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tfilter: '',\n\t\t\tboards: [],\n\t\t\tselectedBoard: null,\n\t\t\tloading: true,\n\t\t\tcurrentBoard: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tavailableBoards() {\n\t\t\treturn this.boards.filter((board) => (\n\t\t\t\t'' + board.id !== '' + this.currentBoard\n\t\t\t\t&& board.title.match(this.filter)\n\t\t\t))\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t\tconst hash = window.location.hash.match(/\\/boards\\/([0-9]+)/)\n\t\tthis.currentBoard = hash.length > 0 ? hash[1] : null\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedBoard)\n\t\t},\n\t},\n\n}\n<\/script>\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\tli.selected {\n\t\tborder: 1px solid var(--color-primary-element);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tli > span,\n\t.avatar {\n\t\tvertical-align: middle;\n\n\t}\n\n</style>\n"],sourceRoot:""}]);const i=r},4417:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},34203:(t,e,n)=>{n.r(e),n.d(e,{default:()=>C});var o=n(76333),a=n(66802),l=n(63814);const r={name:"BoardSelector",components:{NcModal:o.FH},data:()=>({filter:"",boards:[],selectedBoard:null,loading:!0,currentBoard:null}),computed:{availableBoards(){return this.boards.filter((t=>""+t.id!=""+this.currentBoard&&t.title.match(this.filter)))}},beforeMount(){this.fetchBoards();const t=window.location.hash.match(/\/boards\/([0-9]+)/);this.currentBoard=t.length>0?t[1]:null},methods:{fetchBoards(){a.Ay.get((0,l.Jv)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedBoard)}}};var i=n(85072),d=n.n(i),s=n(97825),c=n.n(s),A=n(77659),h=n.n(A),p=n(55056),u=n.n(p),g=n(10540),N=n.n(g),b=n(41113),m=n.n(b),v=n(74227),x={};x.styleTagTransform=m(),x.setAttributes=u(),x.insert=h().bind(null,"head"),x.domAPI=c(),x.insertStyleElement=N();d()(v.A,x);v.A&&v.A.locals&&v.A.locals;const C=(0,n(14486).A)(r,(function(){var t=this,e=t._self._c;return e("NcModal",{on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h1",[t._v(t._s(t.t("deck","Select the board to link to a project")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.filter,expression:"filter"}],attrs:{type:"text",placeholder:t.t("deck","Search by board title")},domProps:{value:t.filter},on:{input:function(e){e.target.composing||(t.filter=e.target.value)}}}),t._v(" "),t.loading?t._e():e("ul",t._l(t.availableBoards,(function(n){return e("li",{key:n.id,class:{selected:t.selectedBoard===n.id},on:{click:function(e){t.selectedBoard=n.id}}},[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])})),0),t._v(" "),t.loading?t._e():e("button",{staticClass:"primary",on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.t("deck","Select board"))+"\n\t\t")])])])}),[],!1,null,"5e94966b",null).exports},27518:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},27514:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},79722:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},86886:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},76333:(t,e,n)=>{n.d(e,{B6:()=>A.N,Bx:()=>$.N,EQ:()=>Bt.N,FH:()=>ut.A,Ki:()=>d.A,Ko:()=>o.N,c:()=>O.A,ne:()=>pt.A,x1:()=>H.N,yI:()=>nt.A,z:()=>h.A});var o=n(46651),a=n(25386),l=n(3877),r=n(23372),i=n(58162),d=n(57908),s=n(9423),c=n(59915),A=n(5153),h=n(24070),p=n(71711),u=n(59281),g=n(10776),N=n(47611),b=n(10363),m=n(23272),v=n(53183),x=n(66229),C=n(3886),f=n(80522),w=n(55118),k=n(92268),B=n(90613),_=n(57652),y=n(13214),S=n(25536),L=n(63412),M=n(57100),P=n(30539),I=n(50017),D=n(57229),E=n(66194),X=n(70588),T=n(74675),$=n(79017),F=n(53879),G=n(54936),z=n(33415),H=n(97221),j=n(313),U=n(8340),Y=n(76048),K=n(35936),Q=n(21913),W=n(24028),q=n(16854),J=n(44025),R=n(63522),O=n(48198),V=n(78102),Z=n(80216),tt=n(83194),et=n(53876),nt=n(42507),ot=n(79704),at=n(66547),lt=n(41663),rt=n(51550),it=n(23785),dt=n(92093),st=n(57833),ct=n(15063),At=n(65783),ht=n(48242),pt=n(88289),ut=n(42486),gt=n(31133),Nt=n(92200),bt=n(60451),mt=n(71797),vt=n(48525),xt=n(7336),Ct=n(50650),ft=n(36079),wt=n(4018),kt=(n(21777),n(66802),n(27759),n(52781),n(3168),n(59384)),Bt=n(42946),_t=n(42502),yt=(n(61338),n(71639)),St=n(82484),Lt=n(295),Mt=n(39453),Pt=n(54028),It=n(28657),Dt=n(12417),Et=n(18127),Xt=n(72632),Tt=n(89695),$t=n(72003),Ft=n(23610),Gt=(n(55581),n(94205),n(95462),n(23020),n(53429),n(23739),n(16343),n(29928),n(12311),n(18547),n(42892)),zt=n(65842),Ht=(n(77965),n(75105),n(92471),n(16406),n(33884));o.N,a.N,l.A,r.N,i.N,d.A,s.N,c.A,h.A,p.A,u.N,A.N,g.N,N.A,b.A,m.N,v.N,x.A,C.N,f.A,w.N,k.N,B.N,_.N,y.A,S.N,L.N,M.N,P.N,I.N,D.A,E.N,X.A,T.N,wt.N,$.N,F.N,G.N,z.N,H.N,j.N,U.N,Y.N,K.N,Q.N,W.N,q.N,J.N,R.default,O.A,V.N,Z.N,tt.A,et.N,nt.A,ot.A,at.N,lt.N,rt.N,it.N,dt.N,st.N,ct.N,At.N,ht.N,pt.A,ft.N,ut.A,gt.A,Nt.N,bt.N,mt.N,vt.N,xt.N,Ct.N,wt.a,kt.N,yt.N,Bt.N,St.N,Lt.N,Mt.N,Pt.N,It.N,Dt.N,_t.N,Et.N,Xt.N,Tt.N,$t.N,Ft.A,Symbol.toStringTag,Gt.A,zt.A,Ht.yw,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3c_21-daea39.js.map?v=80d87607022d1bd9e8b2