/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.function.Consumer;
import oracle.ons.CallBack;
import oracle.ons.Notification;
import oracle.ons.Subscriber;

public interface NotificationCallback
extends CallBack {
    public void notification(Notification var1);

    public void error(Throwable var1);

    default public void system(Notification notification) {
    }

    default public void close() {
    }

    @Override
    default public void notification_callback(Notification notification) {
        if (notification.isSystemNotification()) {
            if (notification == Subscriber.loopbackCloseEvent) {
                this.close();
            } else if (notification.getException() != null) {
                this.error(notification.getException());
            } else {
                this.system(notification);
            }
        } else {
            this.notification(notification);
        }
    }

    public static class ErrorCallBack
    implements NotificationCallback {
        private final Consumer<Notification> parent;
        private Consumer<Notification> systemHandler;
        private Consumer<Throwable> errorHandler;
        private Runnable onClose;

        public ErrorCallBack(CallBack callBack) {
            this.parent = callBack::notification_callback;
        }

        public ErrorCallBack(Consumer<Notification> consumer, Consumer<Throwable> consumer2, Runnable runnable) {
            this.parent = consumer;
            this.errorHandler = consumer2;
            this.onClose = runnable;
        }

        public ErrorCallBack(Consumer<Notification> consumer) {
            this.parent = consumer;
        }

        public ErrorCallBack onClose(Runnable runnable) {
            this.onClose = runnable;
            return this;
        }

        public ErrorCallBack setSystemHandler(Consumer<Notification> consumer) {
            this.systemHandler = consumer;
            return this;
        }

        public ErrorCallBack setErrorHandler(Consumer<Throwable> consumer) {
            this.errorHandler = consumer;
            return this;
        }

        @Override
        public void notification(Notification notification) {
            this.parent.accept(notification);
        }

        @Override
        public void error(Throwable throwable) {
            if (this.errorHandler != null) {
                this.errorHandler.accept(throwable);
            }
        }

        @Override
        public void system(Notification notification) {
            if (this.systemHandler != null) {
                this.systemHandler.accept(notification);
            }
        }

        @Override
        public void close() {
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }
}

