"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_PREFIX_DICT = exports.TRIGGER_TYPE_DICT = exports.REPORT_STATE_DICT = exports.REPORT_SOURCE_DICT = exports.REPORT_FORMAT_DICT = exports.BACKEND_TRIGGER_TYPE = exports.BACKEND_REPORT_STATE = exports.BACKEND_REPORT_SOURCE = exports.BACKEND_REPORT_FORMAT = exports.BACKEND_DELIVERY_FORMAT = void 0;
var _constants = require("../routes/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let BACKEND_DELIVERY_FORMAT = exports.BACKEND_DELIVERY_FORMAT = /*#__PURE__*/function (BACKEND_DELIVERY_FORMAT) {
  BACKEND_DELIVERY_FORMAT["linkOnly"] = "LinkOnly";
  BACKEND_DELIVERY_FORMAT["attachment"] = "Attachment";
  BACKEND_DELIVERY_FORMAT["embedded"] = "Embedded";
  return BACKEND_DELIVERY_FORMAT;
}({});
let BACKEND_REPORT_SOURCE = exports.BACKEND_REPORT_SOURCE = /*#__PURE__*/function (BACKEND_REPORT_SOURCE) {
  BACKEND_REPORT_SOURCE["dashboard"] = "Dashboard";
  BACKEND_REPORT_SOURCE["visualization"] = "Visualization";
  BACKEND_REPORT_SOURCE["savedSearch"] = "SavedSearch";
  BACKEND_REPORT_SOURCE["notebook"] = "Notebook";
  return BACKEND_REPORT_SOURCE;
}({});
let BACKEND_REPORT_STATE = exports.BACKEND_REPORT_STATE = /*#__PURE__*/function (BACKEND_REPORT_STATE) {
  BACKEND_REPORT_STATE["scheduled"] = "Scheduled";
  BACKEND_REPORT_STATE["executing"] = "Executing";
  BACKEND_REPORT_STATE["success"] = "Success";
  BACKEND_REPORT_STATE["failed"] = "Failed";
  return BACKEND_REPORT_STATE;
}({});
let BACKEND_REPORT_FORMAT = exports.BACKEND_REPORT_FORMAT = /*#__PURE__*/function (BACKEND_REPORT_FORMAT) {
  BACKEND_REPORT_FORMAT["pdf"] = "Pdf";
  BACKEND_REPORT_FORMAT["png"] = "Png";
  BACKEND_REPORT_FORMAT["csv"] = "Csv";
  BACKEND_REPORT_FORMAT["xlsx"] = "Xlsx";
  return BACKEND_REPORT_FORMAT;
}({});
let BACKEND_TRIGGER_TYPE = exports.BACKEND_TRIGGER_TYPE = /*#__PURE__*/function (BACKEND_TRIGGER_TYPE) {
  BACKEND_TRIGGER_TYPE["download"] = "Download";
  BACKEND_TRIGGER_TYPE["onDemand"] = "OnDemand";
  BACKEND_TRIGGER_TYPE["cronSchedule"] = "CronSchedule";
  BACKEND_TRIGGER_TYPE["intervalSchedule"] = "IntervalSchedule";
  return BACKEND_TRIGGER_TYPE;
}({});
const REPORT_STATE_DICT = exports.REPORT_STATE_DICT = {
  [_constants.REPORT_STATE.pending]: BACKEND_REPORT_STATE.executing,
  [_constants.REPORT_STATE.error]: BACKEND_REPORT_STATE.failed,
  [_constants.REPORT_STATE.shared]: BACKEND_REPORT_STATE.success,
  [_constants.REPORT_STATE.created]: BACKEND_REPORT_STATE.success
};
const REPORT_SOURCE_DICT = exports.REPORT_SOURCE_DICT = {
  [_constants.REPORT_TYPE.dashboard]: BACKEND_REPORT_SOURCE.dashboard,
  [_constants.REPORT_TYPE.visualization]: BACKEND_REPORT_SOURCE.visualization,
  [_constants.REPORT_TYPE.savedSearch]: BACKEND_REPORT_SOURCE.savedSearch,
  [_constants.REPORT_TYPE.notebook]: BACKEND_REPORT_SOURCE.notebook
};
const REPORT_FORMAT_DICT = exports.REPORT_FORMAT_DICT = {
  [_constants.FORMAT.csv]: BACKEND_REPORT_FORMAT.csv,
  [_constants.FORMAT.xlsx]: BACKEND_REPORT_FORMAT.xlsx,
  [_constants.FORMAT.pdf]: BACKEND_REPORT_FORMAT.pdf,
  [_constants.FORMAT.png]: BACKEND_REPORT_FORMAT.png
};
const TRIGGER_TYPE_DICT = exports.TRIGGER_TYPE_DICT = {
  [_constants.TRIGGER_TYPE.schedule]: [BACKEND_TRIGGER_TYPE.cronSchedule, BACKEND_TRIGGER_TYPE.intervalSchedule],
  [_constants.TRIGGER_TYPE.onDemand]: [BACKEND_TRIGGER_TYPE.onDemand, BACKEND_TRIGGER_TYPE.download]
};
const URL_PREFIX_DICT = exports.URL_PREFIX_DICT = {
  [BACKEND_REPORT_SOURCE.dashboard]: '/app/dashboards#/view/',
  [BACKEND_REPORT_SOURCE.savedSearch]: '/app/discover#/view/',
  [BACKEND_REPORT_SOURCE.visualization]: '/app/visualize#/edit/',
  [BACKEND_REPORT_SOURCE.notebook]: '/app/notebooks-dashboards?view=output_only#/'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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