/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;

public class McpSyncServer {
    private final McpAsyncServer asyncServer;
    private final boolean immediateExecution;

    public McpSyncServer(McpAsyncServer asyncServer) {
        this(asyncServer, false);
    }

    public McpSyncServer(McpAsyncServer asyncServer, boolean immediateExecution) {
        Assert.notNull(asyncServer, "Async server must not be null");
        this.asyncServer = asyncServer;
        this.immediateExecution = immediateExecution;
    }

    public void addTool(McpServerFeatures.SyncToolSpecification toolHandler) {
        this.asyncServer.addTool(McpServerFeatures.AsyncToolSpecification.fromSync(toolHandler, this.immediateExecution)).block();
    }

    public void removeTool(String toolName) {
        this.asyncServer.removeTool(toolName).block();
    }

    public void addResource(McpServerFeatures.SyncResourceSpecification resourceHandler) {
        this.asyncServer.addResource(McpServerFeatures.AsyncResourceSpecification.fromSync(resourceHandler, this.immediateExecution)).block();
    }

    public void removeResource(String resourceUri) {
        this.asyncServer.removeResource(resourceUri).block();
    }

    public void addPrompt(McpServerFeatures.SyncPromptSpecification promptSpecification) {
        this.asyncServer.addPrompt(McpServerFeatures.AsyncPromptSpecification.fromSync(promptSpecification, this.immediateExecution)).block();
    }

    public void removePrompt(String promptName) {
        this.asyncServer.removePrompt(promptName).block();
    }

    public void notifyToolsListChanged() {
        this.asyncServer.notifyToolsListChanged().block();
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.asyncServer.getServerCapabilities();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.asyncServer.getServerInfo();
    }

    public void notifyResourcesListChanged() {
        this.asyncServer.notifyResourcesListChanged().block();
    }

    public void notifyResourcesUpdated(McpSchema.ResourcesUpdatedNotification resourcesUpdatedNotification) {
        this.asyncServer.notifyResourcesUpdated(resourcesUpdatedNotification).block();
    }

    public void notifyPromptsListChanged() {
        this.asyncServer.notifyPromptsListChanged().block();
    }

    @Deprecated
    public void loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        this.asyncServer.loggingNotification(loggingMessageNotification).block();
    }

    public void closeGracefully() {
        this.asyncServer.closeGracefully().block();
    }

    public void close() {
        this.asyncServer.close();
    }

    public McpAsyncServer getAsyncServer() {
        return this.asyncServer;
    }
}

