/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScriptQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, ScriptQuery> {
    @Nonnull
    private final Script script;
    public static final JsonpDeserializer<ScriptQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptQuery::setupScriptQueryDeserializer);

    private ScriptQuery(Builder builder) {
        super(builder);
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ScriptQuery of(Function<Builder, ObjectBuilder<ScriptQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Script;
    }

    @Nonnull
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScriptQueryDeserializer(ObjectDeserializer<Builder> op) {
        ScriptQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.script.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptQuery other = (ScriptQuery)o;
        return this.script.equals(other.script);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ScriptQuery> {
        private Script script;

        public Builder() {
        }

        private Builder(ScriptQuery o) {
            super(o);
            this.script = o.script;
        }

        private Builder(Builder o) {
            super(o);
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public ScriptQuery build() {
            this._checkSingleUse();
            return new ScriptQuery(this);
        }
    }
}

