\name{LabelMapMaskImageFilter}
\alias{LabelMapMaskImageFilter}
\title{LabelMapMaskImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Mask and image with a LabelMap .
LabelMapMaskImageFilter}
\details{
LabelMapMaskImageFilter mask the content of an input image according to the content of the
input LabelMap . The masked pixel of the input image are set to the BackgroundValue. LabelMapMaskImageFilter can keep the input image for one label only, with Negated = false
(the default) or it can mask the input image for a single label, when
Negated equals true. In Both cases, the label is set with SetLabel() .
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter
LabelMapMask for the procedural interface
itk::LabelMapMaskImageFilter for the Doxygen on the original ITK class.
LabelMapMaskImageFilter}
%C++ includes: sitkLabelMapMaskImageFilter.h
\section{Methods}{
\describe{
\item{Self CropOff():}{}
\item{Self CropOn():}{
Set the value of Crop to true or false respectfully.
}
\item{Image Execute(const Image &labelMapImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::ZeroValue() .
}
\item{bool GetCrop() const:}{
Set/Get whether the image size should be adjusted to the masked image
or not.
}
\item{std::vector< unsigned int > GetCropBorder() const:}{
Set/Get the border added to the mask before the crop. The default is 0
on all the axes.
}
\item{uint64_t GetLabel() const:}{
The label to mask or to not mask, depending on the value of the
Negated ivar.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNegated() const:}{
Set/Get whether the Label should be masked or not.
}
\item{ LabelMapMaskImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self NegatedOff():}{}
\item{Self NegatedOn():}{
Set the value of Negated to true or false respectfully.
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::ZeroValue() .
}
\item{Self SetCrop(bool Crop):}{
Set/Get whether the image size should be adjusted to the masked image
or not.
}
\item{Self SetCropBorder(std::vector< unsigned int > CropBorder):}{
Set/Get the border added to the mask before the crop. The default is 0
on all the axes.
}
\item{Self SetCropBorder(unsigned int value):}{
Set the values of the CropBorder vector all to value
}
\item{Self SetLabel(uint64_t Label):}{
The label to mask or to not mask, depending on the value of the
Negated ivar.
}
\item{Self SetNegated(bool Negated):}{
Set/Get whether the Label should be masked or not.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelMapMaskImageFilter():}{
Destructor
}
}
}
