/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.formatter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.Lints;
import schemacrawler.tools.lint.formatter.LintReportGenerator;
import schemacrawler.tools.options.OutputOptions;

abstract class BaseLintReportJacksonGenerator
implements LintReportGenerator {
    private final PrintWriter out;

    BaseLintReportJacksonGenerator(OutputOptions outputOptions) {
        this.out = outputOptions.openNewOutputWriter();
    }

    @Override
    public void generateLintReport(Lints report) {
        Objects.requireNonNull(this.out, "No output stream provided");
        try {
            ObjectMapper mapper = this.newConfiguredObjectMapper();
            mapper.writeValue((Writer)this.out, (Object)report);
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Could not generate lint report", (Throwable)e);
        }
    }

    protected abstract ObjectMapper newObjectMapper();

    private ObjectMapper newConfiguredObjectMapper() {
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ObjectMapper mapper = this.newObjectMapper();
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
        @JsonPropertyOrder(alphabetic=true)
        @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
        abstract class JacksonAnnotationMixIn {
            @JsonIgnore
            public Object value;
            @JsonProperty(value="key")
            private final String[] key = new String[0];

            JacksonAnnotationMixIn() {
            }

            @JsonProperty(value="value")
            public abstract Object getValueAsString();

            @JsonIgnore
            public abstract List<?> getCatalogLints();

            @JsonIgnore
            public abstract boolean isEmpty();
        }
        mapper.addMixIn(Object.class, JacksonAnnotationMixIn.class);
        mapper.addMixIn(Lint.class, JacksonAnnotationMixIn.class);
        mapper.addMixIn(Lints.class, JacksonAnnotationMixIn.class);
        mapper.addMixIn(NamedObjectKey.class, JacksonAnnotationMixIn.class);
        mapper.registerModule((Module)timeModule);
        return mapper;
    }
}

