/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;

@GenerateCached(value=false)
public abstract class PyNumberLshiftFastPathsBase
extends BinaryOpNode {
    @Specialization(guards={"right < 32", "right >= 0"}, rewriteOn={OverflowException.class})
    public static int doII(int left, int right) throws OverflowException {
        int result = left << right;
        if (left != result >> right) {
            throw OverflowException.INSTANCE;
        }
        return result;
    }

    @Specialization(guards={"right < 64", "right >= 0"}, rewriteOn={OverflowException.class})
    public static long doLL(long left, long right) throws OverflowException {
        long result = left << (int)right;
        if (left != result >> (int)right) {
            throw OverflowException.INSTANCE;
        }
        return result;
    }
}

