/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSmartLobOutputStream;
import com.informix.jdbc.IfxSmartLobWriter;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.stringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;

public class IfxCblob
extends IfxLob
implements NClob,
Clob {
    public IfxCblob() {
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxLocator locator) {
        this.locatorPointer = locator;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxConnection con) throws SQLException {
        super(con);
        this.ifxType = (short)3;
    }

    public IfxCblob(IfxConnection connection, IfxLocator locator, int mode) throws SQLException {
        this.conn = connection;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(connection);
        this.smb.IfxLoOpen(locator, mode);
    }

    public IfxCblob(IfxConnection connection, IfxLocator locator) throws SQLException {
        this(connection, locator, connection.getLOMode());
    }

    protected IfxCblob(byte[] buffer) {
        this.blobBuffer = buffer;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(Connection c, byte[] buffer) throws SQLException {
        this.conn = (IfxConnection)c;
        this.blobBuffer = buffer;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(InputStream fin) {
        this.blobStream = fin;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    protected IfxCblob(IfxTmpFile tempFile) {
        this.tempBlobFile = tempFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(Connection conn, InputStream fin, int length) throws SQLException {
        super(conn, fin, length);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection conn, InputStream fin, int length, String sbspaceName) throws SQLException {
        super(conn, fin, length, sbspaceName);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection conn, InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        super(conn, fin, length, loDesc);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection conn, String str) throws SQLException {
        super(conn, str.getBytes());
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection conn, String str, String sbspaceName) throws SQLException {
        super(conn, str.getBytes(), sbspaceName);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection conn, String str, IfxLobDescriptor loDesc) throws SQLException {
        super(conn, str.getBytes(), loDesc);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    @Override
    public long length() throws SQLException {
        this.checkIfFreed();
        return this.blobSize;
    }

    @Override
    public String getSubString(long position, int length) throws SQLException {
        if (position < 1L || length < 0) {
            throw IfxErrMsg.getSQLException(-80502);
        }
        if (length == 0) {
            return "";
        }
        return new String(super.getPortion(position, length));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String enc = this.conn.getdbEncoding();
        try {
            if (enc != null) {
                return new InputStreamReader(super.getStream(), enc);
            }
            return new InputStreamReader(super.getStream());
        }
        catch (UnsupportedEncodingException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String enc = this.conn.getdbEncoding();
        try {
            if (enc != null) {
                return new InputStreamReader(super.getStream(pos, length), enc);
            }
            return new InputStreamReader(super.getStream(pos, length));
        }
        catch (UnsupportedEncodingException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return super.getStream();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        byte[] b = super.getPortion(start, this.blobSize);
        String s = new String(b);
        long ret_val = s.indexOf(searchstr);
        if (ret_val >= 0L) {
            ++ret_val;
        }
        return ret_val;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    public void setAsciiStream(long position, InputStream fin, int length) throws SQLException {
        this.verifyClob();
        this.smb.seek(this.smb.getHandle(), position, 0);
        super.setStream(fin, length);
    }

    public void setSubString(long position, String str, int length) throws SQLException {
        this.verifyClob();
        this.smb.seek(this.smb.getHandle(), position, 0);
        try {
            super.setBuffer(stringUtil.getBytes(str, this.conn));
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.verifyClob();
        this.smb.seek(this.smb.getHandle(), pos, 0);
        try {
            return super.setBuffer(stringUtil.getBytes(str, this.conn));
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.verifyClob();
        this.smb.seek(this.smb.getHandle(), pos, 0);
        try {
            return super.setBuffer(stringUtil.getBytes(str.substring(offset, offset + len), this.conn));
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.verifyClob();
        return new IfxSmartLobOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.verifyClob();
        return new IfxSmartLobWriter(new IfxSmartLobOutputStream(this, pos), this.conn.getdbEncoding());
    }

    private void verifyClob() throws SQLException {
        if (this.ifxType != 3) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.verifySmbMode();
    }

    @Override
    public void free() throws SQLException {
        super.free();
    }
}

