/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J)\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0096\u0002J\b\u0010$\u001a\u00020\u000bH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/github/ajalt/colormath/model/LCHabColorSpaceImpl;", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "(Lcom/github/ajalt/colormath/WhitePoint;)V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "component1", "convert", "Lcom/github/ajalt/colormath/model/LCHab;", "color", "Lcom/github/ajalt/colormath/Color;", "copy", "create", "", "equals", "", "other", "", "hashCode", "", "invoke", "l", "", "c", "h", "alpha", "toString", "colormath"})
final class LCHabColorSpaceImpl
implements LCHabColorSpace {
    @NotNull
    private final WhitePoint whitePoint;
    @NotNull
    private final List<ColorComponentInfo> components;

    public LCHabColorSpaceImpl(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        this.whitePoint = whitePoint;
        this.components = ColorSpaceUtilsKt.polarComponentInfo("LCH");
    }

    @Override
    @NotNull
    public WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Override
    @NotNull
    public String getName() {
        return "LCHab";
    }

    @Override
    @NotNull
    public List<ColorComponentInfo> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public LCHab convert(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        WhitePointColorSpace $this$adaptToThis$iv = this;
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        Object object = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        if (object == null || (object = object.getWhitePoint()) == null) {
            object = Illuminant.INSTANCE.getD65();
        }
        if (Intrinsics.areEqual(object, $this$adaptToThis$iv.getWhitePoint())) {
            Color it = color;
            boolean bl = false;
            color2 = it.toLCHab();
        } else {
            Color it = color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis$iv.getWhitePoint()));
            boolean bl = false;
            color2 = it.toLCHab();
        }
        return (LCHab)color2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LCHab create(@NotNull float[] components) {
        void p3;
        void p2;
        void p1;
        float f;
        Intrinsics.checkNotNullParameter(components, "components");
        ColorSpace $this$doCreate$iv = this;
        boolean $i$f$doCreate = false;
        ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
        boolean $i$f$withValidComps = false;
        int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
        int n = size$iv$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it$iv = components;
        boolean bl = false;
        float f2 = components[0];
        float f3 = components[1];
        float f4 = components[2];
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex(fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            float f5 = f4;
            float f6 = f3;
            float f7 = f2;
            boolean bl2 = false;
            float f8 = 1.0f;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        float f9 = f;
        float f10 = f4;
        float f11 = f3;
        float p0 = f2;
        boolean bl3 = false;
        return (LCHab)((Color)this.invoke(p0, (float)p1, (float)p2, (float)p3));
    }

    @NotNull
    public String toString() {
        return "LCHabColorSpace(" + this.getWhitePoint() + ')';
    }

    @Override
    @NotNull
    public LCHab invoke(float l, float c, float h, float alpha) {
        return new LCHab(l, c, h, alpha, this);
    }

    @Override
    @NotNull
    public LCHab invoke(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
        return LCHabColorSpace.DefaultImpls.invoke(this, l, c, h, alpha);
    }

    @NotNull
    public final WhitePoint component1() {
        return this.getWhitePoint();
    }

    @NotNull
    public final LCHabColorSpaceImpl copy(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        return new LCHabColorSpaceImpl(whitePoint);
    }

    public static /* synthetic */ LCHabColorSpaceImpl copy$default(LCHabColorSpaceImpl lCHabColorSpaceImpl, WhitePoint whitePoint, int n, Object object) {
        if ((n & 1) != 0) {
            whitePoint = lCHabColorSpaceImpl.getWhitePoint();
        }
        return lCHabColorSpaceImpl.copy(whitePoint);
    }

    public int hashCode() {
        return this.getWhitePoint().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LCHabColorSpaceImpl)) {
            return false;
        }
        LCHabColorSpaceImpl lCHabColorSpaceImpl = (LCHabColorSpaceImpl)other;
        return Intrinsics.areEqual(this.getWhitePoint(), lCHabColorSpaceImpl.getWhitePoint());
    }
}

