/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class ConcurrentLruCache<T> {
    private volatile LimitedLinkedHashMap<T, T> map;
    private final Object lock = new Object();

    public ConcurrentLruCache(int n) {
        this.setLimit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        if (this.map == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return;
            }
            this.map.put(t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T t) {
        if (this.map == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return false;
            }
            return this.map.get(t) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.map == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return;
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > 0) {
                LimitedLinkedHashMap<T, T> limitedLinkedHashMap = this.map;
                this.map = new LimitedLinkedHashMap(n);
                if (limitedLinkedHashMap != null) {
                    this.map.putAll(limitedLinkedHashMap);
                }
            } else {
                this.map = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLimit() {
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return -1;
            }
            return ((LimitedLinkedHashMap)this.map).getLimit();
        }
    }

    private static class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int limit;

        LimitedLinkedHashMap(int n) {
            super(16, 0.75f, true);
            this.limit = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.limit;
        }

        private int getLimit() {
            return this.limit;
        }
    }
}

