#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("get next help message")

    def run(self):
        self.env["runtime"]["HelpManager"].next_index()
        text = self.env["runtime"]["HelpManager"].get_help_for_current_index()
        self.env["runtime"]["OutputManager"].present_text(text, interrupt=True)

    def set_callback(self, callback):
        pass
