#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils
from fenrirscreenreader.utils import word_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return ""

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "focus", "cursor"
        ):
            return
        if self.env["runtime"]["ScreenManager"].is_screen_change():
            return
        # detect an change on the screen, we just want to cursor arround, so no
        # change should appear
        if self.env["runtime"]["ScreenManager"].is_delta():
            return
        if self.env["runtime"]["ScreenManager"].is_negative_delta():
            return
        # is a vertical change?
        if self.env["runtime"]["CursorManager"].is_cursor_vertical_move():
            return
        # is it a horizontal change?
        if not self.env["runtime"][
            "CursorManager"
        ].is_cursor_horizontal_move():
            return

        # echo word insteed of char
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "keyboard", "wordEcho"
        ):
            if (
                abs(
                    self.env["screen"]["old_cursor"]["x"]
                    - self.env["screen"]["new_cursor"]["x"]
                )
                != 1
            ):
                # get the word
                new_content = self.env["screen"]["new_content_text"].split(
                    "\n"
                )[self.env["screen"]["new_cursor"]["y"]]
                x, y, curr_word, end_of_screen, line_break = (
                    word_utils.get_current_word(
                        self.env["screen"]["new_cursor"]["x"], 0, new_content
                    )
                )
                if self.env["screen"]["new_cursor"]["x"] == x:
                    return
        x, y, curr_char = char_utils.get_current_char(
            self.env["screen"]["new_cursor"]["x"],
            self.env["screen"]["new_cursor"]["y"],
            self.env["screen"]["new_content_text"],
        )
        if curr_char.isspace():
            # Only announce spaces during pure navigation (arrow keys)
            # Check if this is really navigation by looking at input history
            if self.env["runtime"]["InputManager"].get_shortcut_type() in [
                "KEY"
            ] and self.env["runtime"]["InputManager"].get_last_deepest_input()[
                0
            ] in [
                "KEY_LEFT",
                "KEY_RIGHT",
                "KEY_UP",
                "KEY_DOWN",
            ]:
                char_utils.present_char_for_review(
                    self.env,
                    curr_char,
                    interrupt=True,
                    announce_capital=True,
                    flush=False,
                )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                curr_char,
                interrupt=True,
                ignore_punctuation=True,
                announce_capital=True,
                flush=False,
            )

    def set_callback(self, callback):
        pass
