#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import time

from fenrirscreenreader.core import debug
from fenrirscreenreader.core.inputDriver import InputDriver as inputDriver


class driver(inputDriver):
    def __init__(self):
        inputDriver.__init__(self)

    def initialize(self, environment):
        self.env = environment
        self.env["runtime"]["InputManager"].set_shortcut_type("KEY")
        self._initialized = True
        print("Input Debug Driver: Initialized")

    def shutdown(self):
        if self._initialized:
            self.remove_all_devices()
        self._initialized = False
        print("Input Debug Driver: Shutdown")

    def get_input_event(self):
        time.sleep(0.1)
        if not self._initialized:
            return None
        print("Input Debug Driver: get_input_event")
        return None

    def write_event_buffer(self):
        if not self._initialized:
            return
        print("Input Debug Driver: write_event_buffer")

    def clear_event_buffer(self):
        if not self._initialized:
            return
        del self.env["input"]["eventBuffer"][:]
        print("Input Debug Driver: clear_event_buffer")

    def update_input_devices(self, new_devices=None, init=False):
        if not self._initialized:
            return
        print("Input Debug Driver: update_input_devices")

    def get_led_state(self, led=0):
        if not self._initialized:
            return False
        return False

    def toggle_led_state(self, led=0):
        if not self._initialized:
            return
        print("Input Debug Driver: toggle_led_state")

    def grab_all_devices(self):
        if not self._initialized:
            return
        print("Input Debug Driver: grab_all_devices")

    def ungrab_all_devices(self):
        if not self._initialized:
            return
        print("Input Debug Driver: ungrab_all_devices")

    def remove_all_devices(self):
        if not self._initialized:
            return
        print("Input Debug Driver: remove_all_devices")

    def __del__(self):
        if self._initialized:
            self.remove_all_devices()
        print("Input Debug Driver: __del__")
