/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#include "dlgtest1.h"
#include "ui_dlgtest1.h"
#include "common.h"


dlgTest1::dlgTest1(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dlgTest1)
{
    ui->setupUi(this);
    sPrompt = "correct - ";
    sResult = " words copleted; success - ";
    sResultComplete = "test completed with success - ";
    sStatistic = " words total, attempts ";
}

dlgTest1::~dlgTest1()
{
    delete ui;
}

bool dlgTest1::event(QEvent *ev)
{
    if (ev->type() == QEvent::Hide)
    {
        lTopicDataReverse.clear();
        return true;
    }
    return QWidget::event(ev);
}

void dlgTest1::Init()
{
    QString s;
    vSucceed = true;//                  sucsses effort indicator
    vTotalEfforts = 0;//                #total number of attempts
    vSucceedEfforts = 0;//               #number of right attempts
    vDictRandVal = 0;//                 #a random value for test dim
    vButtonNumber = 0;//                #number of botton of the correct ansver
    vLenth = 0;

    aDictIndex.clear();
    srand(time(0));
    vLenth = lTopicData->count();
    vWordsNumber = QString().setNum(vLenth);
    ui->lbResult->setText("0" + sResult + "0");
    ui->lbStatistic->setText(vWordsNumber + sStatistic + " 0");
    int i = 0;
    while (i < vLenth)
    {
        aDictIndex.append(i);
        i++;
    }
    SetButtons();
    ui->lbPrompt->setText("");
}

void dlgTest1::TestStart(QList<QStringList> *topicdata, TestType tt)
{
    if(tt==DirectTest)
    {
        lTopicData = topicdata;
        setWindowTitle("Test1: Direct test.");
        ui->chbSpeech->setEnabled(true);
    }
    else
    {
        lTopicDataReverse = *topicdata;
        for (int i = 0; i < lTopicDataReverse.count(); ++i)
        {
            lTopicDataReverse[i].swapItemsAt(0,1);
        }
        lTopicData = &lTopicDataReverse;
        setWindowTitle("Test2: Reverse test.");
        ui->chbSpeech->setEnabled(false);
    }
    Init();
    this->show();
}

void dlgTest1::SetButtons()
{
    int ind;
    int btCount = 5;
    int lent = aDictIndex.count();
    if (lent < 1)
    {
        ui->lbResult->setText(sResultComplete + fPercent( &vTotalEfforts, &vSucceedEfforts ));
        return;
    }
    if (vSucceed)
    {
        if (lent < 2)
            vDictRandVal = 0;
        else
            vDictRandVal = fRandom(&lent);
    }
    ind = aDictIndex[vDictRandVal];
    vQuestion = lTopicData->at(ind)[0];
    ui->pbQuestion->setText(vQuestion);
    vButtonNumber = fRandom(&btCount);
    aButtonDim[vButtonNumber] = ind;
    int i = 0;
    int j = 0;
    int rnd;    //random value
    int tr;    //chois trigger: 1 - nothing chosen, 0 - something chosen
    while (i < 5)
    {
        tr = 0;
        if (i == vButtonNumber)
        {
            i++;
            continue;
        }
        j = 0;
        rnd = fRandom(&vLenth);
        while (j < i)
        {
            if (j == vButtonNumber)
            {
                j++;
                continue;
            }
            if (rnd == aButtonDim[j])
                tr = 1;
            j++;
        }
        if (rnd == aButtonDim[vButtonNumber])
            tr = 1;
        if (tr == 0) {
            aButtonDim[i] = rnd;
            i++;
        }
    }
    if (ui->chbSpeech->isEnabled() && ui->chbSpeech->isChecked())
    {
        emit textToSpeech(vQuestion);
    }
    ui->pbAnswer1->setText(lTopicData->at(aButtonDim[0])[1]);
    ui->pbAnswer2->setText(lTopicData->at(aButtonDim[1])[1]);
    ui->pbAnswer3->setText(lTopicData->at(aButtonDim[2])[1]);
    ui->pbAnswer4->setText(lTopicData->at(aButtonDim[3])[1]);
    ui->pbAnswer5->setText(lTopicData->at(aButtonDim[4])[1]);
}

void dlgTest1::fCheck(int n)
{
    QString s;
    int vInd;
    int lent = aDictIndex.count();
    if (lent < 1)
    {
        fShowMsg(sResultComplete + fPercent(&vTotalEfforts, &vSucceedEfforts));
        return;
    }
    vTotalEfforts++;
    if (n == vButtonNumber)
    {
        ui->lbResult->setText("");
        ui->lbPrompt->setText("");
        if (lent > 0)
        {
            if (vSucceed)
            {
                aDictIndex.removeAt(vDictRandVal);
                vSucceedEfforts++;
                ui->lbStatistic->setText(QString().setNum(vTotalEfforts)+sStatistic
                                         +QString().setNum(vSucceedEfforts));
            }
            else
            {
                vSucceed = true;
                vTotalEfforts--;
            }
        }
    }
    else
    {
        vSucceed = false;
        vInd = aButtonDim[vButtonNumber];
        ui->lbPrompt->setText(sPrompt + lTopicData->at(vInd)[1]);
    }
    ui->lbStatistic->setText(vWordsNumber + sStatistic + QString().setNum(vTotalEfforts));
    ui->lbResult->setText(QString().setNum(vSucceedEfforts) + sResult +
                          fPercent(&vTotalEfforts,&vSucceedEfforts));
    lent = aDictIndex.count();
    if (lent <1 )
    {
        ui->lbResult->setText(sResultComplete + fPercent(&vTotalEfforts, &vSucceedEfforts));
        return;
    }
    SetButtons();
}

void dlgTest1::GetUiText(QJsonObject *uitext)
{
    QJsonObject jobj;
    jobj.insert("exit",QJsonValue(ui->pbExit->text()));
    jobj.insert("speech",QJsonValue(ui->chbSpeech->text()));
    jobj.insert("prompt",QJsonValue(sPrompt));
    jobj.insert("result",QJsonValue(sResult));
    jobj.insert("resultComplete",QJsonValue(sResultComplete));
    jobj.insert("statistic",QJsonValue(sStatistic));
    uitext->insert("test1",QJsonValue(jobj));
}

void dlgTest1::SetUiText(QJsonObject *uitext)
{
    QJsonObject jobj = uitext->value("test1").toObject();
    ui->pbExit->setText(jobj.value("exit").toString());
    ui->chbSpeech->setText(jobj.value("speech").toString());
    sPrompt = jobj.value("prompt").toString();
    sResult = jobj.value("result").toString();
    sResultComplete = jobj.value("resultComplete").toString();
    sStatistic = jobj.value("statistic").toString();
}

void dlgTest1::TurnOffSpeech()
{
    ui->chbSpeech->setEnabled(false);
}

void dlgTest1::on_pbQuestion_clicked()
{
    if(ui->chbSpeech->isEnabled())
    {
        emit textToSpeech(vQuestion);
    }
}

void dlgTest1::on_pbAnswer1_clicked()
{
    fCheck(0);
}


void dlgTest1::on_pbAnswer2_clicked()
{
    fCheck(1);
}


void dlgTest1::on_pbAnswer3_clicked()
{
    fCheck(2);
}


void dlgTest1::on_pbAnswer4_clicked()
{
    fCheck(3);
}


void dlgTest1::on_pbAnswer5_clicked()
{
    fCheck(4);
}


void dlgTest1::on_pbExit_clicked()
{
    this->close();
    lTopicDataReverse.clear();
}

