// This file is part of meshoptimizer library and is distributed under the terms of MIT License.
// Copyright (C) 2016-2019, by Arseny Kapoulkine (arseny.kapoulkine@gmail.com)
var MeshoptDecoder = (function() {
	"use strict";
	var wasm = "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";

	var instance, heap;

	var env = {
		emscripten_notify_memory_growth: function(index) {
			heap = new Uint8Array(instance.exports.memory.buffer);
		}
	};

	var promise =
		(typeof fetch === 'function' ?
			fetch('data:application/octet-stream;base64,' + wasm)
			.then(response => response.arrayBuffer()) :
			Promise.resolve(Buffer.from(wasm, 'base64').buffer))
		.then(bytes => WebAssembly.instantiate(bytes, { env }))
		.then(function(result) {
			instance = result.instance;
			if (instance.exports.__wasm_call_ctors) {
				instance.exports.__wasm_call_ctors();
			}
			env.emscripten_notify_memory_growth(0);
		});

	function decode(fun, target, count, size, source) {
		var sbrk = instance.exports.sbrk;
		var tp = sbrk(count * size);
		var sp = sbrk(source.length);
		heap.set(source, sp);
		var res = fun(tp, count, size, sp, source.length);
		target.set(heap.subarray(tp, tp + count * size));
		sbrk(tp - sbrk(0));
		if (res != 0) {
			throw new Error("Malformed buffer data: " + res);
		}
	};

	return {
		ready: promise,
		decodeVertexBuffer: function(target, count, size, source) {
			decode(instance.exports.meshopt_decodeVertexBuffer, target, count, size, source);
		},
		decodeIndexBuffer: function(target, count, size, source) {
			decode(instance.exports.meshopt_decodeIndexBuffer, target, count, size, source);
		}
	};
})();

if (typeof exports === 'object' && typeof module === 'object')
	module.exports = MeshoptDecoder;
else if (typeof define === 'function' && define['amd'])
	define([], function() {
		return MeshoptDecoder;
	});
else if (typeof exports === 'object')
	exports["MeshoptDecoder"] = MeshoptDecoder;
