# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class ImageCanvasSource2D(ImageAlgorithm):
    r"""
    ImageCanvasSource2D - Paints on a canvas
    
    Superclass: ImageAlgorithm
    
    ImageCanvasSource2D is a source that starts as a blank image. you
    may add to the image with two-dimensional drawing routines. It can
    paint multi-spectral images.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageCanvasSource2D, obj, update, **traits)
    
    scalar_type = tvtk_base.RevPrefixMap({'double': 11, 'char': 2, 'float': 10, 'int': 6, 'long': 8, 'short': 4, 'unsigned_char': 3, 'unsigned_int': 7, 'unsigned_long': 9, 'unsigned_short': 5}, default_value='double', desc=\
        r"""
        
        """
    )

    def _scalar_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarType,
                        self.scalar_type_)

    default_z = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        The drawing operations can only draw into one 2D XY plane at a
        time. If the canvas is a 3D volume, then this z value is used as
        the default for 2D operations. The default is 0.
        """
    )

    def _default_z_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDefaultZ,
                        self.default_z)

    draw_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get draw_color.  This is the value that is used when filling
        data or drawing lines. Default is (0,0,0,0)
        """
    )

    def _draw_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawColor,
                        self.draw_color)

    number_of_scalar_components = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of scalar components
        """
    )

    def _number_of_scalar_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfScalarComponents,
                        self.number_of_scalar_components)

    ratio = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Set/Get Ratio. This is the value that is used to pre-multiply
        each (x, y, z) drawing coordinates (including DefaultZ). The
        default is (1, 1, 1)
        """
    )

    def _ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRatio,
                        self.ratio)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def draw_circle(self, *args):
        """
        draw_circle(self, c0:int, c1:int, radius:float) -> None
        C++: void draw_circle(int c0, int c1, double radius)"""
        ret = self._wrap_call(self._vtk_obj.DrawCircle, *args)
        return ret

    def draw_image(self, *args):
        """
        draw_image(self, x0:int, y0:int, i:ImageData) -> None
        C++: void draw_image(int x0, int y0, ImageData *i)
        draw_image(self, x0:int, y0:int, __c:ImageData, sx:int, sy:int,
            width:int, height:int) -> None
        C++: void draw_image(int x0, int y0, ImageData *, int sx,
            int sy, int width, int height)
        Draw subimage of the input image in the canvas at position x0 and
        y0. The subimage is defined with sx, sy, width, and height.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawImage, *my_args)
        return ret

    def draw_point(self, *args):
        """
        draw_point(self, p0:int, p1:int) -> None
        C++: void draw_point(int p0, int p1)"""
        ret = self._wrap_call(self._vtk_obj.DrawPoint, *args)
        return ret

    def draw_segment(self, *args):
        """
        draw_segment(self, x0:int, y0:int, x1:int, y1:int) -> None
        C++: void draw_segment(int x0, int y0, int x1, int y1)"""
        ret = self._wrap_call(self._vtk_obj.DrawSegment, *args)
        return ret

    def draw_segment3d(self, *args):
        """
        draw_segment3d(self, p0:[float, ...], p1:[float, ...]) -> None
        C++: void draw_segment3d(double *p0, double *p1)
        draw_segment3d(self, x1:float, y1:float, z1:float, x2:float,
            y2:float, z2:float) -> None
        C++: void draw_segment3d(double x1, double y1, double z1,
            double x2, double y2, double z2)"""
        ret = self._wrap_call(self._vtk_obj.DrawSegment3D, *args)
        return ret

    def fill_box(self, *args):
        """
        fill_box(self, min0:int, max0:int, min1:int, max1:int) -> None
        C++: void fill_box(int min0, int max0, int min1, int max1)
        Set the pixels inside the box (min0, max0, min1, max1) to the
        current draw_color
        """
        ret = self._wrap_call(self._vtk_obj.FillBox, *args)
        return ret

    def fill_pixel(self, *args):
        """
        fill_pixel(self, x:int, y:int) -> None
        C++: void fill_pixel(int x, int y)
        Fill a colored area with another color. (like connectivity) All
        pixels connected (and with the same value) to pixel (x, y) get
        replaced by the current "draw_color".
        """
        ret = self._wrap_call(self._vtk_obj.FillPixel, *args)
        return ret

    def fill_triangle(self, *args):
        """
        fill_triangle(self, x0:int, y0:int, x1:int, y1:int, x2:int, y2:int)
             -> None
        C++: void fill_triangle(int x0, int y0, int x1, int y1, int x2,
            int y2)"""
        ret = self._wrap_call(self._vtk_obj.FillTriangle, *args)
        return ret

    def fill_tube(self, *args):
        """
        fill_tube(self, x0:int, y0:int, x1:int, y1:int, radius:float)
            -> None
        C++: void fill_tube(int x0, int y0, int x1, int y1, double radius)"""
        ret = self._wrap_call(self._vtk_obj.FillTube, *args)
        return ret

    def initialize_canvas_volume(self, *args):
        """
        initialize_canvas_volume(self, volume:ImageData) -> None
        C++: void initialize_canvas_volume(ImageData *volume)
        Initialize the canvas with a given volume
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeCanvasVolume, *my_args)
        return ret

    def set_extent(self, *args):
        """
        set_extent(self, extent:[int, ...]) -> None
        C++: void set_extent(int *extent)
        set_extent(self, x1:int, x2:int, y1:int, y2:int, z1:int, z2:int)
            -> None
        C++: void set_extent(int x1, int x2, int y1, int y2, int z1,
            int z2)
        These methods set the whole_extent of the output It sets the size
        of the canvas. Extent is a min max 3D box.  Minimums and maximums
        are inclusive.
        """
        ret = self._wrap_call(self._vtk_obj.SetExtent, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('scalar_type',
    'GetScalarType'), ('default_z', 'GetDefaultZ'), ('draw_color',
    'GetDrawColor'), ('number_of_scalar_components',
    'GetNumberOfScalarComponents'), ('ratio', 'GetRatio'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_type', 'default_z', 'draw_color',
    'number_of_scalar_components', 'progress_text', 'ratio'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageCanvasSource2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageCanvasSource2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['scalar_type'], ['default_z', 'draw_color',
            'number_of_scalar_components', 'ratio']),
            title='Edit ImageCanvasSource2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageCanvasSource2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

