%feature("docstring") OT::SQP
"Sequential Quadratic Programming solver.

This solver uses second derivative information and can only be used to solve level function problems.

Available constructors:
    SQP(*problem*)

    SQP(*problem, tau, omega, smooth*)

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`
    Optimization problem to solve.
tau : float
    Multiplicative decrease of linear step.
omega : float
    Armijo factor.
smooth : float
    Growing factor in penalization term.

Notes
-----
SQP methods solve a sequence of optimization subproblems,
each of which optimizes a quadratic model of the objective
subject to a linearization of the constraints.

See also
--------
AbdoRackwitz, Cobyla, TNC, NLopt

Examples
--------
>>> import openturns as ot
>>> model = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'], ['x1*cos(x1)+2*x2*x3-3*x3+4*x3*x4'])
>>> problem = ot.NearestPointProblem(model, -0.5)
>>> algo = ot.SQP(problem)
>>> algo.setStartingPoint([1.0] * 4)
>>> algo.run()
>>> result = algo.getResult()"

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::getTau
"Accessor to tau parameter.

Returns
-------
tau : float
    Multiplicative decrease of linear step."

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::setTau
"Accessor to tau parameter.

Parameters
----------
tau : float
    Multiplicative decrease of linear step."

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::getOmega
"Accessor to omega parameter.

Returns
-------
omega : float
    Armijo factor."

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::setOmega
"Accessor to omega parameter.

Parameters
----------
omega : float
    Armijo factor."

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::getSmooth
"Accessor to smooth parameter.

Returns
-------
smooth : float
    Growing factor in penalization term."

// ---------------------------------------------------------------------

%feature("docstring") OT::SQP::setSmooth
"Accessor to smooth parameter.

Parameters
----------
smooth : float
    Growing factor in penalization term."
