# 设置
## 概 述
设置提供了一个友好的图形用户界面，用于对操作系统常用配置项进行管理。主界面如图所示。

![图 1 设置-big](image/ukcc.png)

<br>

## 账 户
账户设置提供了账户信息、登录选项和云账户三个模块。

### 账户信息

对系统用户进行管理配置，允许管理员创建用户、删除用户、修改用户信息。

![图 2-1 账户信息设置-big](image/account.png)

#### 更改用户头像

点击用户头像，即可进行修改，图片可从本机图片中选择。

![图 2-2 更改用户头像](image/account-face.png)

#### 更改密码

点击“修改密码”，即可修改当前用户的密码。

![图 2-3 更改密码](image/account-pwd.png)

#### 更改账户类型

系统用户类型分两种：标准用户和管理员用户。

- 管理员用户：输入用户密码，可以临时提升root权限
- 标准用户：无法提升权限

Tips：系统至少需要存在一个管理员用户。

![图 2-4 更改用户类型](image/account-type.png)

#### 其他用户

可编辑其他用户信息，添加新用户，删除用户等。

- 添加新用户：输入用户名、密码，并选择用户类型，如图所示

![图 2-5 添加新用户](image/account-add.png)

- 编辑用户

![图 2-6 编辑用户](image/account-edit.png)

### 登录选项

可对登录选项进行配置。

- 关闭生物识别：登录时禁用生物识别。

![图 3-1 关闭生物识别-big](image/login-options-close.png)

- 打开生物识别：登录时可以使用生物识别，可以对生物特征进行录入、重命名、删除。

![图 3-2 打开生物识别-big](image/login-options-open.png)

- 录入新特征

![图 3-3 录入新特征-big](image/login-options-scroll.png)

- 修改特征名

![图 3-4 修改特征名-big](image/login-options-rename.png)

### 云账户
云账户可用于同步设置配置选项，需要注册登录生效。

![图 4 云账户-big](image/cloudaccount.png)
#### 登录方式
- 通过麒麟ID登录中心登录，使用云账户只需拥有麒麟ID即可。


#### 可同步项
- 桌面背景：同步桌面背景
- 屏保：同步屏保壁纸、屏保休眠时间等
- 字体：同步设置字体设置
- 头像：同步系统用户头像
- 开始菜单：开始菜单的相关设置
- 任务栏： 同步任务栏位置、大小等
- 快速启动项：同步任务栏插件快速启动栏相关设置
- 主题：同步设置主题设置
- 鼠标：同步设置鼠标设置
- 触控板：如果有触控板的话，同步设置触控板界面
- 键盘：同步设置键盘设置
- 快捷键：同步设置自定义快捷键
- 语言和地区：同步语言以及地区时区，并非一一对应设置
- 时间和日期：同步时间，并非一一对应设置
- 默认打开方式：同步设置默认应用相关设置
- 侧边栏：同步设置通知页面相关设置
- 登录选项：同步设置用户信息自动登录以及免密登录
- 电源：同步设置电源相关选项
- 文本编辑器：同步文本编辑器Pluma的设置，需要关闭所有Pluma进程并重新打开文本编辑器才能看到效果
- 终端：同步终端设置资料卡，需要关闭所有终端实例再打开终端才能看到效果
- 天气：同步天气设置
- 文件管理器：同步文件管理器的设置，不包括置顶窗口设置
- 开机启动项：同步设置开机启动设置
- 影音：同步影音相关设置


#### 使用须知
- 使用麒麟ID登录云账户，首次打开默认会同步一次，如果云端有配置文件，则会先把云端配置下载下来同步到本地，否则把本地账户配置上传到云端。
- 登录云账户之后，如果打开了自动同步按钮，用户无需其他操作，云账户每隔5分钟会同步一次本地配置到云端，上传的配置可供跨机器，跨用户同步。
- 单独的同步开关关闭会导致此项停止上传到云端，如果开启，则会将之前的此项的云端配置同步到本地。
- 如果关闭自动同步按钮，所有云端配置将会保留在关闭同步前最后一次上传到云端的本地配置。
- 如果开启自动同步按钮，则将云端配置下载下来并同步到本地。
- 单独的开关类似自动同步按钮效果，只是同步效果范围变成了当前项的同步效果。

<br>

## 系 统
系统配置设置提供了显示器、声音、电源、通知、远程桌面、关于、触摸校准七个模块。

### 显示器
显示器可以配置显示相关的设置，上方彩色矩形代表当前屏幕，中间显示了显示器名称及接口名，如图所示。

![图 5 显示器设置-big](image/display.png)

- 显示器：选择当前显示器
- 分辨率、方向、刷新率、缩放屏幕的修改都是针对当前活动显示器
- 屏幕缩放为全局缩放，可以设置的缩放项与屏幕当前的分辨率有关，具体如下：

| 分辨率宽度w | 最大缩放 |
| :---: | :---: |
| （0,1080] | 100% |
| (1080,1920) | 125% |
| 1920 | 150% |
| (1920,2560] | 200% |
| (2560,3072] | 225% |
| (3072,3840) | 250% |
| 3840+ | 275% |

- 夜间模式具有调整色温度、夜间模式自定义时间段打开/关闭

### 声 音
对输入、输出和系统音效进行设置，如图所示。

![图 6 声音-big](image/audio.png)

- 选择输出设备：输出设备是获取声卡选择的输出配置文件生成的，可以点击下拉框查看当前系统可用的输出设备，可根据需要切换的对应的输出设备

- 音量：调节当前的输出音量，通过移动滑动条来控制系统输出音量大小

- 声道平衡：调节输出音量的左右声道

- 选择输入设备：输入设备是获取声卡选择的输入配置文件生成的，可以点击下拉框查看当前系统可用的输入设备，可根据需要切换的对应的输入设备（输入设备主要用来录音视频以及通话）

- 音量大小：调节当前的输入音量，通过移动滑动条来控制系统输入音量大小

- 输入反馈：检测当前输入设备的输入等级（检测到有可用的输入设备时开始检测输入等级）

- 开关机音乐：控制系统开关机时是否播放开关机音乐

- 提示音：系统收到通知或改变音量的提示音

- 音效主题：系统的声音主题

- 音量调节：调节音量时播放的提示音类型

- 通知：系统收到通知时播放的提示音类型

### 电 源

可进行通用功能设置，电源计划和电池节能计划设置（机器存在电池的情况下）

![图 7 系统电源设置-big](image/power.png)

- 在通用设置中，可以对系统唤醒功能进行设置，以及设置系统进入睡眠等操作的时间

- 在电源计划中，选择不同的模式对应不同的系统性能消耗

- 在电池节能计划中，通过选择对应的选项达到电池节能效果

### 通 知

可通过开关的开启/关闭，选择是否获取来自对应应用的通知

![图 8 通知-big](image/notice.png)

### 远程桌面
通过开启和关闭本地vnc服务来控制是否可远程访问你的桌面

![图 9 远程桌面-big](image/vino.png)

- "允许其他人远程连接您的桌面"默认状态由系统是否自启vnc服务决定

- “允许其他人远程连接您的桌面并控制您的屏幕”默认状态为关闭，只可被访问，不可被操控

- “您必须为本机机器确认每次访问”默认状态为开启，需应答每次访问请求

- “要求用户输入此密码”默认状态为关闭

### 关 于

显示本机系统的版本、设备规格、用户部分信息、以及隐私协议相关信息

![图 10 系统信息-big](image/about.jpg)

<br>

## 设 备

设备设置提供了蓝牙、打印机、鼠标、触控板、平板与触摸屏、键盘、快捷键和多屏协调八个设置模块。

### 蓝 牙

蓝牙模块提供了开关蓝牙、修改蓝牙名称、显示隐藏蓝牙任务图标、自动发现周围蓝牙设备、本机设备的可见性；与发现的蓝牙设备配对、连接、断开、移除蓝牙设备、文件传输的基本功能、自动发现蓝牙音频设备、已连接设备重命名，如图所示。

- 开关蓝牙：点击开启蓝牙按钮，对本机的蓝牙适配器开启和关闭
- 修改蓝牙名称：将鼠标在“修改图标”或者“蓝牙名称”上单击，在弹出输入框输入想要的名称
- 显示隐藏蓝牙任务栏图标：点击按钮，可以在任务上显示或者不显示托盘上的蓝牙图标
- 蓝牙设备分类 ： 通过选择下拉框选择显示的蓝牙设备类型，类型选项(所有、音频设备、键鼠设备、电脑、手机、其他)
- 发现的蓝牙设备基础操作：鼠标单击已发现的蓝牙设备执行连接，断开、移除和发送文件选项需要通过蓝牙设备的设置选项打开(注：部分蓝牙设备/机型无发送文件选项)
- 自动发现蓝牙音频设备：自动发现蓝牙音频设备功能开关开启后，蓝牙服务会开启对周围3m内的音频设备进行检测，检测符合条件则提示用户是否需要连接；功能开关关闭则不会处理
- 已连接设备重命名：对用户已连接的设备提供本地的重命名功能

![图 11 蓝牙-big](image/bluetooth.png)

### 打印机

打印机功能提供了打印机程序入口

![图 12 打印机-big](image/printer.png)

### 鼠 标

为满足您对鼠标使用习惯的个性化需求，可在“鼠标”配置中，可进行鼠标、指针、光标的个性化设置。

1）鼠标键设置：

- 鼠标主按钮设置（左键/右键）

- 鼠标滚轮速度

- 鼠标双击间隔时长

2）指针设置：

- 速度设置

- 鼠标加速

- 按Ctrl键显示指针位置

- 指针大小设置（小，中，大）

3）光标设置：

- 启用文本区域的光标闪烁

- 光标速度设置

![图 13 鼠标设备-big](image/mouse.png)

### 触控板

触控板提供了以下功能设置

1）插入鼠标时触控板开启/关闭

2）指针速度慢/快

3）打字时禁用触控板开启/关闭

4）触控板轻触点击开启/关闭

5）滚动条跟随手指滑动开启/关闭

6）触控滚动方式(中间区域滚动，边界滚动，禁用滚动)，设置边界滚动时，垂直边界及水平边界滚动有效，设置为中间区域滚动时，垂直中间及水平中间滚动有效。

7）交互手势：
- 三指单击：进入全局搜索页面
- 三指向下滑动：最小化/关闭窗口或标签页
- 三指向上滑动：显示所有任务视图
- 三指左右滑动：在打开的应用窗口之间切换
- 四指左右滑动：在多个桌面之间切换
- 四指点击：呼出侧边栏

![图 14 触控板-big](image/touchpad.png)

### 触摸屏

系统支持多任务、多场景的桌面触控交互，若您的设备支持触控功能，可使用多种触控手势进行桌面操作。

触摸屏又称为“触控屏”、“触控面板”，使用规范手势触碰计算机显示屏上的图符或文字即可实现与桌面的交互。

![图 15 触摸屏-big](image/touchscreen-gesture.png)

触摸屏基础手势交互如下：
- 单击：手指轻点触控设备，触发功能，例如：选择对象、打开菜单栏、执行按钮命令等
- 双击：手指快速点击两次触控设备，触发功能，例如：打开桌面应用、打开文件夹/文件、选择文字等
- 长按：手指长按某个元素触发功能，例如：显示弹出菜单栏、右键菜单栏、多选、选择文字等
- 滑动：滑动以连续滚动列表和页面、切换页面/对象、滑动以调节滑动条数值
- 拖动：移动对象位置，或拖动进行批量操作，例如：移动窗口/文件、框选图标/文字等
- 捏合：两个手指按住屏幕向外展开以放大内容，向内收拢以缩小内容，例如：网页、图片

注意：若您的设备不具有此功能，且未外接触摸屏，控制面板中不显示触摸屏的设置。

### 键 盘

您可在“键盘”配置中，进行键盘响应速度、键盘布局、添加输入法等相关配置。

![图 16 键盘设备-big](image/keyboard.png)

1）通用设置：

- 可设置启用按键重复设置：按下某个按键不放，系统会将该行为作为重复的键盘输入。启用按键重复设置后，可对延时、速度两个选项进行设置。

- 可设置延迟：按下按键后，到系统开始接收键盘输入之间的间隔

- 可设置速度：按下按键后，重复输入之间的间隔；间隔越长，同样时间内，重复输入的次数越少

- 可设置启用按键提示：大小写切换提示。

2）输入法设置：

- 输入法语言、国家设置

- 全局配置

### 快捷键

您可在该配置中查看系统快捷键，添加自定义快捷键等相关配置。

快捷键根据系统版本有所调整。

![图 17-1 快捷键-big](image/shortcut.png)



![图 17-2 添加快捷键](image/add-shortcut.png)

### 多屏协同
多屏协同是一款在KyLin-OS桌面环境下允许被手机以及其它Kylin-OS进行投射且可投射到其它Kylin-OS的软件，分为接收端和投射端两部分，主界面如图所示。
![图 18-1 多屏协同主界面-big](image/mainInterface.png)

接收端的功能按钮在主界面的上半部分，由上到下依次为：

1）接收端开/关按钮：按钮开启后，当前Kylin-OS设备可被手机设备或其它Kylin-OS设备搜索到；

2）PIN码功能开/关按钮：按钮开启后，在连接过程中，需要输入PIN码；
![图 18-2 带PIN码的弹窗提示-big](image/PINCodeinterface.png)

![图 18-3 不带PIN码的弹窗提示-big](image/withoutPINCodeinterface.png)

3）历史设备显示/隐藏按钮：按钮箭头指向下时，可看见与曾经当前Kylin-OS设备连接过的相关设备。
![图 18-4 历史设备界面-big](image/deviceInterface.png)

投射端的功能按钮在主界面的下半部分，包括：

投射端开/关按钮：此按钮与接收端开/关按钮互斥，当接收端开/关按钮开启时，需要先关闭接收端开/关按钮，才能开启投射端开/关按钮（开启接收端开/关按钮时同理）。开启此按钮后，点击查找设备会弹出搜索窗口，窗口中会显示可搜索到的接收端Kylin-OS设备。

手机与Kylin-OS连接过程:

1）开启接收端开/关按钮（需先关闭接收端开/关按钮）；

2）手机下拉菜单打开投屏（也可能是手机投屏/多屏协同）；

![图 18-5 手机开启投屏界面-big](image/phoneOpenProjectionInterface.png)

3）在手机搜索设备列表里选择要投射到的Kylin-OS设备；

![图 18-6 手机搜索设备界面-big](image/phoneSearchInterface.png)

4）进行连接（分为需要PIN码和不需要PIN码两种）；

![图 18-7 手机输入PIN码界面-big](image/phonePINcodeInterface.png)

5）选择手机型号（目前分为华为、小米、其它）；

![图 18-8 选择手机型号界面-big](image/chooseTypeInterface.png)

6）投屏界面，在界面的中央显示手机屏幕，界面右侧有5个按钮，有上到下依次为：软/硬解码切换按钮；全屏/窗口切换按钮；返回上级目录按钮；返回主界面按钮；显示应用进程按钮。

![图 18-9 接收端投屏界面-big](image/receiverConnectInterface.png)

Kylin-OS与Kylin-OS连接过程：

1）开启投射端开/关按钮（需提前将接收端开/关按钮关闭）；

2）点击开/关按钮左侧的查找设备；

![图 18-10 查找设备界面-big](image/searchDeviceInterface.png)

3）在弹出的搜索窗口中选择要投射到的Kylin-OS设备；

![图 18-11 选择设备界面-big](image/chooseDevice.png)

4）投屏界面。

![图 18-12 投射端投射界面-big](image/senderConnectInterface.png)

**FAQ**

1.如未成功投屏，可重新尝试连接，连接过一次的设备会自动记录到历史设备中。

2.Kylin-OS、部分手机支持控制回传功能（即可通过鼠标或键盘操作投屏界面间接影响投射设备）。

3.当前仅有部分华为手机以及小米手机支持安卓三键功能（投屏右侧界面倒数的三个按钮），其余型号手机点击这些按钮可能出现未知问题。

4.系统会默认使用软解码，此时可手动切换成硬解码（使用硬件对视频进行解码，降低CPU占用，需要硬件支持）。

5.在投屏界面可以更改接收设备的名称，点击开启投屏右侧的“笔”图标，即可进入修改界面。
![图 18-13 投射端名称修改界面-big](image/nameChangeInterface.png)

6.当未插入无线网卡，或无线网卡不支持建立投屏所需的连接时，需要插入网卡或者对已插入网卡进行更换处理。
![图 18-14 投屏功能不可用界面-big](image/unUseInterface.png)

7.当未安装无线投屏的包或包版本过低时，在控制面板中不会显示投屏功能。

8.当作为投射端使用时，暂不支持投射到SP1版本的接收端。

<br>

## 网 络

网络主要包含了有线网络、无线局域网、代理、VPN和移动热点五个模块。

### 有线网络

提供有线网络的显示、连接或断开，可以分别对单张有线网卡进行开关管理。

![图 19 有线网络-big](image/netconnect.png)

### 无线局域网

提供无线网络的显示、连接或断开，可以对无线功能进行开关管理。

![图 20 无线网络-big](image/wlanconnect.png)

### 代 理

可设置系统代理、应用代理以及APT代理

![图 21 代理-big](image/delegate.png)

- 系统代理可选择自动代理和手动代理，手动代理包括HTTP，HTTPS，SOCKET，FTP代理
- 应用代理可以勾选要使用代理的应用，这些应用可以通过指定的代理去访问网络
- 开启APT代理，通过设置的代理服务器可在软件商店进行应用程序的下载和更新

### VPN

打开外部VPN设置程序

![图 22 VPN-big](image/vpn.png)

### 移动热点

使用本机作为无线网络提供方，其他设备连接后可以进行上网操作。

![图 23 移动热点-big](image/mobilehotspot.png)

<br>

## 个性化

个性化设置提供了背景、主题、锁屏、屏保、字体五个模块。

### 背 景

针对桌面背景，提供两种背景形式的选择：颜色、图片。

![图 24 背景-big](image/background.png)

### 主 题

主题包括主题模式、窗口外观、图标主题、光标主题、窗口特效和相关设置。

- 主题模式：

![图 25-1 主题模式](image/theme.png)

- 窗口外观：

![图 25-2 窗口外观](image/appearance.png)

- 图标主题和光标主题：

![图 25-3 图标&光标主题](image/theme-cursor.png)

- 窗口特效（部分机型不支持）：

![图 25-4 窗口特效](image/theme-effect.png)

- 相关设置：

![图 25-5 相关设置](image/related-settings.png)

### 锁 屏

选择在登录界面显示的背景图片。

![图 26 锁屏设置-big](image/screenlock.png)

### 屏 保

设置屏保程序、等待时间。

![图 27 屏保设置-big](image/screensaver.png)

### 字 体

对字体、大小、等宽进行常规设置。

点击“恢复默认设置”按钮将所有字体设置还原为系统默认状态。

![图 28 字体设置-big](image/font.png)

<br>

## 时间语言

包括时间日期和区域语言两个模块

### 时间和日期

![图 29-1 时间和日期-big](image/datetime.png)

- 自动同步时间：与互联网上的NTP服务器时间同步

- 手动设置时间：手动设置时间和年月日

![图 29-2 手动更改时间](image/datetime-change.png)

- 更改时区：如图所示，根据个人需求进行选择

![图 29-3 时区-big](image/datetime-zone.png)

### 区域语言

主界面如图所示:

![图 30-1 区域语言-big](image/area.png)

- 语言格式：自定义日历、一周第一天、日期、时间

- 系统语言：系统窗口、菜单及网页的显示语言，首选推荐语言为简体中文

- 点击“添加”，可添加其他地区语言作为备选

<br>

## 更新操作

在“更新”配置中，可进行“备份”、“更新”的相关配置。

### 备 份
​	备份”模块可以创建系统、数据的备份，还原历史备份。点击“开始备份”或“开始还原”会自动打开备份还原工具，您可以进行系统备份、系统还原、数据备份、数据还原等操作。详细操作介绍请见手册中备份还原工具部分内容。

![图 31 备份还原-big](image/backup.png)

### 更 新
- “更新”模块可以检测系统是否有可用更新并进行更新的相关设置。
- “系统更新”中显示当前系统更新状态和上次检测更新时间，点击“检查更新”，会自动打开麒麟更新管理器进行更新内容的获取。
- “更新设置”中您可以设置是否允许通知可更新的应用、是否自动下载和安装更新、下载限速，开启下载限速后会在下次下载时进行限速。
- 在“查看历史更新”中可以搜索和查看更新详情。

![图 32 系统更新-big](image/update.png)

<br>

## 应 用

应用包括默认应用和开机启动

### 开机启动
列表中显示当前系统已存在的开机启动软件。

![图 34 开机启动-big](image/autoboot.png)

点击“添加”，可添加开机启动应用。

### 默认应用
默认应用可以修改图中几种类型的默认打开应用：

![图 35 默认应用-big](image/default.png)

<br>

## 搜 索

### 全局搜索

通过设置提高搜索效率。
![图 36 搜索-big](image/search.png)
<br>


## 常见问题
#### 点击开始菜单上的设置按钮，无反应 
 在键盘上按下 Ctrl + Alt + T 组合键打开命令行终端，输入“ukui-control-center”后按下Enter，查看错误输出。

#### 版本问题
- 如何查看系统版本？
     可右键状态栏空白区域，选择关于麒麟查看系统版本。
- 如何查看服务序列号？
     可右键任务栏空白区域，选择关于麒麟查看服务序列号。
- 如何区别哪个光盘是对应哪个版本的系统？
     挂载光盘后打开挂载目录下的LICENSE或.kyinfo文件，可查看版本相关信息。
- 在麒麟软件官网上申请的试用版本使用期限是多久？
     在麒麟软件官网上申请的试用版本可以一直使用，但是不享受售后服务。
- 怎么查看内核版本？
     可右键任务栏空白区域，选择关于麒麟查看系统内核版本。
- Openkylin桌面操作系统不同大版本之间有什么区别？
     不同大版本之间会有内核或者其他的层面的不同，具体可咨询商务或者参考官网对不同版本的系统介绍。
- 电脑装了Windows 10和Openkylin桌面操作系统双系统数据盘可以共用吗？
     可以共用。
#### 显示问题
- Ctrl+alt+T无法打开终端怎么办？
     通过开始菜单打开终端，执行ukui-settings-daemon，看是否会报错。
- 开始菜单无法打开了怎么办？
     可通过删除./face文件解决，打开终端执行指令：sudo rm -f~/.face。
- 在哪里关闭锁屏并且设置锁屏时间？
     打开开始菜单-设置-个性化-锁屏来设置锁屏时间。

<br>
