<!--
%CopyrightBegin%

Copyright Ericsson AB 2023-2024. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# Standards Compliance

The table below summarizes the diameter application's compliance with RFC 6733.
Since the diameter application isn't a Diameter node on its own, compliance is
strictly the responsibility of the user in many cases, diameter providing the
means for the user to be compliant rather than being compliant on its own.

The Compliance column notes _C_ (Compliant) if the required functionality is
implemented, _PC_ (Partially Compliant) if there are limitations, _NC_ (Not
Compliant) if functionality is not implemented, or a dash if text is
informational or only places requirements that must be met by the user's
implementation.

Capitalized _Diameter_ refers to the protocol, lowercase _diameter_ to the
Erlang application.

## RFC 6733 - Diameter Base Protocol

| _Section_ | _Title_                                               | _Compliance_ | _Notes_                                                                                                                                                                                                                                                                                                                                                                               |
| --------- | ----------------------------------------------------- | ------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1         | Introduction                                          | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.1      | Diameter Protocol                                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.1.1    | Description of the Document Set                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.1.2    | Conventions Used in This Document                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.1.3    | Changes from RFC 3588                                 | —            | It is possible to configure a 3588 dictionary in order to get 3588 semantics, where the differ from 6733.                                                                                                                                                                                                                                                                             |
| 1\.2      | Terminology                                           | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.3      | Approach to Extensibility                             | —            | The dictionary interface documented in [diameter_dict(4)](diameter_dict.md) provides extensibility, allowing the user to defined new AVPs, commands, and applications. Ready dictionaries are provided for the RFC 6733 common message, base accounting, and relay applications, as well as for RFC 7683, Diameter Overload Indicator Conveyance.                                     |
| 1\.3.1    | Defining New AVP Values                               | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 1\.3.2    | Creating New AVPs                                     | —            | New AVPs can be defined using the dictionary interface. Both RFC data formats and extensions are supported.                                                                                                                                                                                                                                                                           |
| 1\.3.3    | Creating New Commands                                 | —            | New commands can be defined using the dictionary interface.                                                                                                                                                                                                                                                                                                                           |
| 1\.3.4    | Creating New Diameter Applications                    | —            | New applications can be defined using the dictionary interface.                                                                                                                                                                                                                                                                                                                       |
| 2         | Protocol Overview                                     | —            | Session state is the responsibility of the user.   The role of a Diameter node is determined by the user's implementation.                                                                                                                                                                                                                                                            |
| 2\.1      | Transport                                             | PC           | Ports are configured by the user: diameter places no restrictions.   The transport interface documented in `m:diameter_transport` allows the user to implement their own methods. Ready support is provided for TCP, TCP/TLS, and SCTP, but not DTLS/SCTP.   Multiple connections to the same peer is possible. ICMP messages are not interpreted.                                    |
| 2\.1.1    | SCTP Guidelines                                       | C            | Unordered sending is configurable in `m:diameter_sctp`. There is no special handling of DPR/DPA: since a user that cares about pending answers should wait for them before initiating DPR.   A PPID can be configured with a a gen_sctp sctp_default_send_param option.                                                                                                               |
| 2\.2      | Securing Diameter Messages                            | PC           | DTLS is not supported by `m:diameter_sctp`. See also 2.1.                                                                                                                                                                                                                                                                                                                             |
| 2\.3      | Diameter Application Compliance                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 2\.4      | Application Identifiers                               | C            | The user configures diameter with the identifiers to send at capabilities exchange, along with corresponding dictionaries defining the messages of the applications.                                                                                                                                                                                                                  |
| 2\.5      | Connections vs. Sessions                              | C            | Connections are realized by configuring transport. Sessions are the responsibility of the user.                                                                                                                                                                                                                                                                                       |
| 2\.6      | Peer Table                                            | PC           | Routing is implemented by the user in callbacks documented in `m:diameter_app`. A peer table of the documented form is not exposed to the user.                                                                                                                                                                                                                                       |
| 2\.7      | Routing Table                                         | PC           | See 2.6. A routing table of the documented form is not exposed to the user.                                                                                                                                                                                                                                                                                                           |
| 2\.8      | Role of Diameter Agents                               | C            | Most role-specific behaviour is implemented by the user. How a node advertises itself at capabilities exchange is determined by user configuration.                                                                                                                                                                                                                                   |
| 2\.8.1    | Relay Agents                                          | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 2\.8.2    | Proxy Agents                                          | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 2\.8.3    | Redirect Agents                                       | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 2\.8.4    | Translation Agents                                    | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 2\.9      | Diameter Path Authorization                           | —            | Authorization is the responsibility of the user.                                                                                                                                                                                                                                                                                                                                      |
| 3         | Diameter Header                                       | C            | Hop-by-Hop and End-to-End Identifiers are set by diameter when sending outgoing requests.                                                                                                                                                                                                                                                                                             |
| 3\.1      | Command Codes                                         | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 3\.2      | Command Code Format Specification                     | C            | Commands are defined as CCF specifications in dictionary files.                                                                                                                                                                                                                                                                                                                       |
| 3\.3      | Diameter Command Naming Conventions                   | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 4         | Diameter AVPs                                         | C            | Any required padding is added by diameter when encoding outgoing messages.                                                                                                                                                                                                                                                                                                            |
| 4\.1      | AVP Header                                            | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 4\.1.1    | Optional Header Elements                              | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 4\.2      | Basic AVP Data Formats                                | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 4\.3      | Derived AVP Data Formats                              | C            | Arbitrary derived data formats are supported by the dictionary interface.                                                                                                                                                                                                                                                                                                             |
| 4\.3.1    | Common Derived AVP Data Formats                       | C            | Beware that RFC 6733 changed the DiameterURI transport/port defaults specified in RFC3588. Relying on the defaults can result in interoperability problems.                                                                                                                                                                                                                           |
| 4\.4      | Grouped AVP Values                                    | C            | The M-bit on a component AVP of a Grouped AVP that does not set M is ignored: such AVPs are not regarded as erroneous at decode.   Grouped AVPs are defined as CCF specifications in dictionary files.                                                                                                                                                                                |
| 4\.4.1    | Example AVP with a Grouped Data Type                  | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 4\.5      | Diameter Base Protocol AVPs                           | C            | The base AVPs are defined in the common dictionary provided by diameter. There are common dictionaries for both RFC 3588 and RFC 6733 since the latter made changes to both syntax and semantics.                                                                                                                                                                                     |
| 5         | Diameter Peers                                        | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.1      | Peer Connections                                      | PC           | A peer's DiameterIdentity is not required when initiating a connection: the identify is received at capabilities exchange, at which time the connection can be rejected if the identity is objectionable.   The number of connections established depends on the user's configuration. Multiple connections per peer is possible.                                                     |
| 5\.2      | Diameter Peer Discovery                               | NC           | No form of peer discovery is implemented. The user can implement this independently of diameter if required.                                                                                                                                                                                                                                                                          |
| 5\.3      | Capabilities Exchange                                 | C            | All supported applications are sent in CEA. The user can reject an incoming CER or CEA in a configured callback.   Both transport security at connection establishment and negotiated via an Inband-Security AVP are supported.                                                                                                                                                       |
| 5\.3.1    | Capabilities-Exchange-Request                         | C            | CER is sent and received by diameter.                                                                                                                                                                                                                                                                                                                                                 |
| 5\.3.2    | Capabilities-Exchange-Answer                          | C            | CEA is sent and received by diameter.                                                                                                                                                                                                                                                                                                                                                 |
| 5\.3.3    | Vendor-Id AVP                                         | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.3.4    | Firmware-Revision AVP                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.3.5    | Host-IP-Address AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.3.6    | Supported-Vendor-Id AVP                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.3.7    | Product-Name AVP                                      | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.4      | Disconnecting Peer Connections                        | C            | DPA will not be answered with error: a peer that wants to a avoid a race can wait for pending answers before sending DPR.                                                                                                                                                                                                                                                             |
| 5\.4.1    | Disconnect-Peer-Request                               | C            | DPR is sent by diameter in response to configuration changes requiring a connection to be broken. The user can also send DPR.                                                                                                                                                                                                                                                         |
| 5\.4.2    | Disconnect-Peer-Answer                                | C            | DPR is answered by diameter.                                                                                                                                                                                                                                                                                                                                                          |
| 5\.4.3    | Disconnect-Cause AVP                                  | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.5      | Transport Failure Detection                           | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.5.1    | Device-Watchdog-Request                               | C            | DWR is sent and received by diameter. Callbacks notify the user of transitions into and out of the OKAY state.                                                                                                                                                                                                                                                                        |
| 5\.5.2    | Device-Watchdog-Answer                                | C            | DWA is sent and received by diameter.                                                                                                                                                                                                                                                                                                                                                 |
| 5\.5.3    | Transport Failure Algorithm                           | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.5.4    | Failover and Failback Procedures                      | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.6      | Peer State Machine                                    | PC           | The election process is modified as described in 5.6.4.                                                                                                                                                                                                                                                                                                                               |
| 5\.6.1    | Incoming Connections                                  | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.6.2    | Events                                                | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.6.3    | Actions                                               | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 5\.6.4    | The Election Process                                  | PC           | As documented, the election assumes knowledge of a peer's DiameterIdentity when initiating a connection, which diameter doesn't require. Connections will be accepted if configuration allows multiple connections per peer to be established or there is no existing connection. Note that the election process is only applicable when multiple connections per peer is disallowed. |
| 6         | Diameter Message Processing                           | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.1      | Diameter Request Routing Overview                     | —            | Routing is performed by the user. A callback from diameter provides a list of available suitable peer connections.                                                                                                                                                                                                                                                                    |
| 6\.1.1    | Originating a Request                                 | C            | Requests are constructed by the user; diameter sets header fields as defined in the relevant dictionary.                                                                                                                                                                                                                                                                              |
| 6\.1.2    | Sending a Request                                     | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.1.3    | Receiving Requests                                    | C            | Loops are detected by diameter when the return value of a request callback asks that a request be forwarded. Loop detection in other cases is the responsibility of the user.                                                                                                                                                                                                         |
| 6\.1.4    | Processing Local Requests                             | C            | The user decides whether or not to process a request locally in the request callback from diameter.                                                                                                                                                                                                                                                                                   |
| 6\.1.5    | Request Forwarding                                    | PC           | See 2.6.                                                                                                                                                                                                                                                                                                                                                                              |
| 6\.1.6    | Request Routing                                       | PC           | See 2.7.                                                                                                                                                                                                                                                                                                                                                                              |
| 6\.1.7    | Predictive Loop Avoidance                             | C            | See 6.1.3.                                                                                                                                                                                                                                                                                                                                                                            |
| 6\.1.8    | Redirecting Requests                                  | PC           | See 2.6.                                                                                                                                                                                                                                                                                                                                                                              |
| 6\.1.9    | Relaying and Proxying Requests                        | C            | A Route-Record AVP is appended by diameter when the return value of a request callback asks that a request be forwarded. Appending the AVP in other cases is the responsibility of the user.                                                                                                                                                                                          |
| 6\.2      | Diameter Answer Processing                            | C            | Answer message are constructed by the user, except in the case of some protocol errors, in which case the procedures are followed.                                                                                                                                                                                                                                                    |
| 6\.2.1    | Processing Received Answers                           | C            | Answers with an unknown Hop-by-Hop Identifier are discarded.                                                                                                                                                                                                                                                                                                                          |
| 6\.2.2    | Relaying and Proxying Answers                         | —            | Modifying answers is the responsibility of the user in callbacks from diameter.                                                                                                                                                                                                                                                                                                       |
| 6\.3      | Origin-Host AVP                                       | C            | The order of AVPs in an encoded message is determined by the CCF of the message in question.   AVPs defined in the RFC are defined in dictionaries provided by diameter. Their proper use in application messages is the responsibility of the user.                                                                                                                                  |
| 6\.4      | Origin-Realm AVP                                      | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.5      | Destination-Host AVP                                  | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.6      | Destination-Realm AVP                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.7      | Routing AVPs                                          | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.7.1    | Route-Record AVP                                      | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.7.2    | Proxy-Info AVP                                        | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.7.3    | Proxy-Host AVP                                        | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.7.4    | Proxy-State AVP                                       | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.8      | Auth-Application-Id AVP                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.9      | Acct-Application-Id AVP                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.10     | Inband-Security-Id AVP                                | C            | See 2.1.                                                                                                                                                                                                                                                                                                                                                                              |
| 6\.11     | Vendor-Specific-Application-Id AVP                    | C            | Note that the CCF of this AVP is not the same as in RFC 3588.                                                                                                                                                                                                                                                                                                                         |
| 6\.12     | Redirect-Host AVP                                     | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.13     | Redirect-Host-Usage AVP                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 6\.14     | Redirect-Max-Cache-Time AVP                           | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7         | Error Handling                                        | C            | Answers are formulated by the user in most cases. Answers setting the E-bit can be sent by diameter itself in response to a request that cannot be handled by the user.                                                                                                                                                                                                               |
| 7\.1      | Result-Code AVP                                       | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7\.1.1    | Informational                                         | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7\.1.2    | Success                                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7\.1.3    | Protocol Errors                                       | C            | Result codes 3001, 3002, 3005, and 3007 can be sent in answers formulated by diameter, if configured to do so.                                                                                                                                                                                                                                                                        |
| 7\.1.4    | Transient Failures                                    | C            | Result code 4003 is sent in CEA if there is an existing connection to the peer in question and configuration does not allow more than one.                                                                                                                                                                                                                                            |
| 7\.1.5    | Permanent Failures                                    | C            | Message reception detects 5001, 5004, 5005, 5008, 5009, 5010, 5011, 5014, 5015, and 5017 errors. It ignores 5013 errors at the admonition of sections 3 and 4.1.   Note that RFC 3588 did not allow 5xxx result codes in answers setting the E-bit, while RFC 6733 does. This is a potential interoperability problem since the Diameter protocol version has not changed.            |
| 7\.2      | Error Bit                                             | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7\.3      | Error-Message AVP                                     | C            | The user can include this AVP as required.                                                                                                                                                                                                                                                                                                                                            |
| 7\.4      | Error-Reporting-Host AVP                              | C            | The user can include this AVP as required.                                                                                                                                                                                                                                                                                                                                            |
| 7\.5      | Failed-AVP AVP                                        | C            | The user constructs application-specific messages, but diameter provides failed AVPs in message callbacks. Failed component AVPs are grouped within the relevant Grouped AVPs.                                                                                                                                                                                                        |
| 7\.6      | Experimental-Result AVP                               | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 7\.7      | Experimental-Result-Code AVP                          | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8         | Diameter User Sessions                                | —            | Authorization and accounting AVPs are defined in provided dictionaries. Their proper use is the responsibility of the user.                                                                                                                                                                                                                                                           |
| 8\.1      | Authorization Session State Machine                   | —            | Authorization is the responsibility of the user: diameter does not implement this state machine.                                                                                                                                                                                                                                                                                      |
| 8\.2      | Accounting Session State Machine                      | —            | Accounting is the responsibility of the user: diameter does not implement this state machine.                                                                                                                                                                                                                                                                                         |
| 8\.3      | Server-Initiated Re-Auth                              | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.3.1    | Re-Auth-Request                                       | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.3.2    | Re-Auth-Answer                                        | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.4      | Session Termination                                   | —            | Session-related messages and AVPs are defined in provided dictionaries. Their proper use is the user's responsibility.                                                                                                                                                                                                                                                                |
| 8\.4.1    | Session-Termination-Request                           | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.4.2    | Session-Termination-Answer                            | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.5      | Aborting a Session                                    | —            | Session-related messages and AVPs are defined in provided dictionaries. Their proper use is the user's responsibility.                                                                                                                                                                                                                                                                |
| 8\.5.1    | Abort-Session-Request                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.5.2    | Abort-Session-Answer                                  | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.6      | Inferring Session Termination from Origin-State-Id    | —            | Session-related messages and AVPs are defined in provided dictionaries. Their proper use is the user's responsibility.                                                                                                                                                                                                                                                                |
| 8\.7      | Auth-Request-Type AVP                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.8      | Session-Id AVP                                        | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.9      | Authorization-Lifetime AVP                            | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.10     | Auth-Grace-Period AVP                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.11     | Auth-Session-State AVP                                | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.12     | Re-Auth-Request-Type AVP                              | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.13     | Session-Timeout AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.14     | User-Name AVP                                         | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.15     | Termination-Cause AVP                                 | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.16     | Origin-State-Id AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.17     | Session-Binding AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.18     | Session-Server-Failover AVP                           | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.19     | Multi-Round-Time-Out AVP                              | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.20     | Class AVP                                             | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 8\.21     | Event-Timestamp AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9         | Accounting                                            | —            | Accounting-related messages and AVPs are defined in provided dictionaries. Their proper use is the user's responsibility.                                                                                                                                                                                                                                                             |
| 9\.1      | Server Directed Model                                 | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.2      | Protocol Messages                                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.3      | Accounting Application Extension and Requirements     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.4      | Fault Resilience                                      | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.5      | Accounting Records                                    | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.6      | Correlation of Accounting Records                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.7      | Accounting Command Codes                              | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.7.1    | Accounting-Request                                    | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.7.2    | Accounting-Answer                                     | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8      | Accounting AVPs                                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.1    | Accounting-Record-Type AVP                            | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.2    | Acct-Interim-Interval AVP                             | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.3    | Accounting-Record-Number AVP                          | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.4    | Acct-Session-Id AVP                                   | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.5    | Acct-Multi-Session-Id AVP                             | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.6    | Accounting-Sub-Session-Id AVP                         | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 9\.8.7    | Accounting-Realtime-Required AVP                      | C            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 10        | AVP Occurrence Tables                                 | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 10\.1     | Base Protocol Command AVP Table                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 10\.2     | Accounting AVP Table                                  | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11        | IANA Considerations                                   | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.1     | AVP Header                                            | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.1.1   | AVP Codes                                             | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.1.2   | AVP Flags                                             | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.2     | Diameter Header                                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.2.1   | Command Codes                                         | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.2.2   | Command Flags                                         |              |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3     | AVP Values                                            | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.1   | Experimental-Result-Code AVP                          | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.2   | Result-Code AVP Values                                | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.3   | Accounting-Record-Type AVP Values                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.4   | Termination-Cause AVP Values                          | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.5   | Redirect-Host-Usage AVP Values                        | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.6   | Session-Server-Failover AVP Values                    | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.7   | Session-Binding AVP Values                            | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.8   | Disconnect-Cause AVP Values                           | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.9   | Auth-Request-Type AVP Values                          | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.10  | Auth-Session-State AVP Values                         | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.11  | Re-Auth-Request-Type AVP Values                       | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.12  | Accounting-Realtime-Required AVP Values               | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.3.13  | Inband-Security-Id AVP (code 299)                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.4     | \_diameters Service Name and Port Number Registration | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.5     | SCTP Payload Protocol Identifiers                     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 11\.6     | S-NAPTR Parameters                                    | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 12        | Diameter Protocol-Related Configurable Parameters     | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 13        | Security Considerations                               | PC           | See 2.1.   IPsec is transparent to diameter.                                                                                                                                                                                                                                                                                                                                          |
| 13\.1     | TLS/TCP and DTLS/SCTP Usage                           | PC           | See 2.1.                                                                                                                                                                                                                                                                                                                                                                              |
| 13\.2     | Peer-to-Peer Considerations                           | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 13\.3     | AVP Considerations                                    | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 14        | References                                            | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 14\.1     | Normative References                                  | —            |                                                                                                                                                                                                                                                                                                                                                                                       |
| 14\.2     | Informative References                                | —            |                                                                                                                                                                                                                                                                                                                                                                                       |

_Table: RFC 6733 Compliance_
