static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" *                                                                            \n"
" * Exchange one color with the other (settable threshold to convert from      \n"
" * one color-shade to another...might do wonders on certain images, or be     \n"
" * totally useless on others).                                                \n"
" *                                                                            \n"
" * Author: robert@experimental.net                                            \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color (from_color, _(\"From Color\"), \"white\")                     \n"
"    description(_(\"The color to change.\"))                                  \n"
"                                                                              \n"
"property_color (to_color, _(\"To Color\"), \"black\")                         \n"
"    description(_(\"Replacement color.\"))                                    \n"
"                                                                              \n"
"property_double (red_threshold, _(\"Red Threshold\"), 0.0)                    \n"
"    description (_(\"Red threshold of the input color\"))                     \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (green_threshold, _(\"Green Threshold\"), 0.0)                \n"
"    description (_(\"Green threshold of the input color\"))                   \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (blue_threshold, _(\"Blue Threshold\"), 0.0)                  \n"
"    description (_(\"Blue threshold of the input color\"))                    \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE color-exchange.c                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gfloat color_diff[3];                                                       \n"
"  gfloat min[3];                                                              \n"
"  gfloat max[3];                                                              \n"
"} CeParamsType;                                                               \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = babl_format (\"R'G'B'A float\");                   \n"
"  const Babl     *colorformat = babl_format (\"R'G'B' float\");               \n"
"  CeParamsType *params;                                                       \n"
"  gfloat        color_in[3];                                                  \n"
"  gfloat        color_out[3];                                                 \n"
"  gint          chan;                                                         \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (CeParamsType);                               \n"
"                                                                              \n"
"  params = (CeParamsType*) o->user_data;                                      \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->from_color, colorformat, &color_in);               \n"
"  gegl_color_get_pixel (o->to_color, colorformat, &color_out);                \n"
"                                                                              \n"
"  params->min[0] = CLAMP (color_in[0] - o->red_threshold,                     \n"
"                          0.0, 1.0) - GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  params->max[0] = CLAMP (color_in[0] + o->red_threshold,                     \n"
"                          0.0, 1.0) + GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  params->min[1] = CLAMP (color_in[1] - o->green_threshold,                   \n"
"                          0.0, 1.0) - GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  params->max[1] = CLAMP (color_in[1] + o->green_threshold,                   \n"
"                          0.0, 1.0) + GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  params->min[2] = CLAMP (color_in[2] - o->blue_threshold,                    \n"
"                          0.0, 1.0) - GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  params->max[2] = CLAMP (color_in[2] + o->blue_threshold,                    \n"
"                          0.0, 1.0) + GEGL_FLOAT_EPSILON;                     \n"
"                                                                              \n"
"  for (chan = 0; chan < 3; chan++)                                            \n"
"    params->color_diff[chan] = color_out[chan] - color_in[chan];              \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (CeParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties     *o      = GEGL_PROPERTIES (operation);                   \n"
"  const CeParamsType *params = (CeParamsType*) o->user_data;                  \n"
"  gint    chan;                                                               \n"
"  gfloat *input  = in_buf;                                                    \n"
"  gfloat *output = out_buf;                                                   \n"
"                                                                              \n"
"  g_assert (params != NULL);                                                  \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      if (input[0] > params->min[0] && input[0] < params->max[0] &&           \n"
"          input[1] > params->min[1] && input[1] < params->max[1] &&           \n"
"          input[2] > params->min[2] && input[2] < params->max[2])             \n"
"        {                                                                     \n"
"          for (chan = 0; chan < 3 ; chan++)                                   \n"
"              output[chan] = CLAMP (input[chan] + params->color_diff[chan],   \n"
"                                    0.0, 1.0);                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          for (chan = 0; chan < 3 ; chan++)                                   \n"
"              output[chan] = input[chan];                                     \n"
"        }                                                                     \n"
"                                                                              \n"
"      output[3] = input[3];                                                   \n"
"                                                                              \n"
"      input  += 4;                                                            \n"
"      output += 4;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/color-exchange.cl.h\"                                       \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem              in,                                           \n"
"            cl_mem              out,                                          \n"
"            size_t              global_worksize,                              \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  CeParamsType   *params = (CeParamsType*) o->user_data;                      \n"
"  cl_float3   color_diff;                                                     \n"
"  cl_float3   min;                                                            \n"
"  cl_float3   max;                                                            \n"
"  cl_int      cl_err = 0;                                                     \n"
"  gint        i;                                                              \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_color_exchange\",                     \n"
"                                   NULL};                                     \n"
"      cl_data = gegl_cl_compile_and_build (color_exchange_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    {                                                                         \n"
"      color_diff.s[i] = params->color_diff[i];                                \n"
"      min.s[i] = params->min[i];                                              \n"
"      max.s[i] = params->max[i];                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem),    &in,                   \n"
"                                    sizeof(cl_mem),    &out,                  \n"
"                                    sizeof(cl_float3), &color_diff,           \n"
"                                    sizeof(cl_float3), &min,                  \n"
"                                    sizeof(cl_float3), &max,                  \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  object_class       = G_OBJECT_CLASS (klass);                                \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->prepare     = prepare;                                     \n"
"                                                                              \n"
"  point_filter_class->process    = process;                                   \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color-exchange\",                                 \n"
"    \"title\",       _(\"Exchange color\"),                                   \n"
"    \"categories\",  \"color\",                                               \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Exchange one color with another, optionally setting \"\n"
"                     \"a threshold to convert from one shade to another.\"),  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
