/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/* Copyright (c) 2022-2025, NVIDIA CORPORATION. All rights reserved. */

#ifndef DT_BINDINGS_CLOCK_NVIDIA_TEGRA264_H
#define DT_BINDINGS_CLOCK_NVIDIA_TEGRA264_H

#define TEGRA264_CLK_OSC				1
#define TEGRA264_CLK_CLK_S				2
#define TEGRA264_CLK_JTAG_REG				3
#define TEGRA264_CLK_SPLL				4
#define TEGRA264_CLK_SPLL_OUT0				5
#define TEGRA264_CLK_SPLL_OUT1				6
#define TEGRA264_CLK_SPLL_OUT2				7
#define TEGRA264_CLK_SPLL_OUT3				8
#define TEGRA264_CLK_SPLL_OUT4				9
#define TEGRA264_CLK_SPLL_OUT5				10
#define TEGRA264_CLK_SPLL_OUT6				11
#define TEGRA264_CLK_SPLL_OUT7				12
#define TEGRA264_CLK_AON_I2C				13
#define TEGRA264_CLK_HOST1X				14
#define TEGRA264_CLK_ISP				15
#define TEGRA264_CLK_ISP1				16
#define TEGRA264_CLK_ISP_ROOT				17
#define TEGRA264_CLK_NAFLL_PVA0_CORE			18
#define TEGRA264_CLK_NAFLL_PVA0_VPS			19
#define TEGRA264_CLK_NVCSI				20
#define TEGRA264_CLK_NVCSILP				21
#define TEGRA264_CLK_PLLP_OUT0				22
#define TEGRA264_CLK_PVA0_CPU_AXI			23
#define TEGRA264_CLK_PVA0_VPS				24
#define TEGRA264_CLK_PWM10				25
#define TEGRA264_CLK_PWM2				26
#define TEGRA264_CLK_PWM3				27
#define TEGRA264_CLK_PWM4				28
#define TEGRA264_CLK_PWM5				29
#define TEGRA264_CLK_PWM9				30
#define TEGRA264_CLK_QSPI0				31
#define TEGRA264_CLK_QSPI0_2X_PM			32
#define TEGRA264_CLK_RCE1_CPU				33
#define TEGRA264_CLK_RCE1_NIC				34
#define TEGRA264_CLK_RCE_CPU				35
#define TEGRA264_CLK_RCE_NIC				36
#define TEGRA264_CLK_SE					37
#define TEGRA264_CLK_SEU1				38
#define TEGRA264_CLK_SEU2				39
#define TEGRA264_CLK_SEU3				40
#define TEGRA264_CLK_SE_ROOT				41
#define TEGRA264_CLK_SPI1				42
#define TEGRA264_CLK_SPI2				43
#define TEGRA264_CLK_SPI3				44
#define TEGRA264_CLK_SPI4				45
#define TEGRA264_CLK_SPI5				46
#define TEGRA264_CLK_TOP_I2C				47
#define TEGRA264_CLK_TSEC				48
#define TEGRA264_CLK_TSEC_PKA				49
#define TEGRA264_CLK_UART0				50
#define TEGRA264_CLK_UART10				51
#define TEGRA264_CLK_UART11				52
#define TEGRA264_CLK_UART4				53
#define TEGRA264_CLK_UART5				54
#define TEGRA264_CLK_UART8				55
#define TEGRA264_CLK_UART9				56
#define TEGRA264_CLK_VI					57
#define TEGRA264_CLK_VI1				58
#define TEGRA264_CLK_VIC				59
#define TEGRA264_CLK_VI_ROOT				60
#define TEGRA264_CLK_DISPPLL				61
#define TEGRA264_CLK_SPPLL0				62
#define TEGRA264_CLK_SPPLL0_CLKOUT1A			63
#define TEGRA264_CLK_SPPLL0_CLKOUT2A			64
#define TEGRA264_CLK_SPPLL1				65
#define TEGRA264_CLK_VPLL0				66
#define TEGRA264_CLK_VPLL1				67
#define TEGRA264_CLK_VPLL2				68
#define TEGRA264_CLK_VPLL3				69
#define TEGRA264_CLK_VPLL4				70
#define TEGRA264_CLK_VPLL5				71
#define TEGRA264_CLK_VPLL6				72
#define TEGRA264_CLK_VPLL7				73
#define TEGRA264_CLK_RG0_DIV				74
#define TEGRA264_CLK_RG1_DIV				75
#define TEGRA264_CLK_RG2_DIV				76
#define TEGRA264_CLK_RG3_DIV				77
#define TEGRA264_CLK_RG4_DIV				78
#define TEGRA264_CLK_RG5_DIV				79
#define TEGRA264_CLK_RG6_DIV				80
#define TEGRA264_CLK_RG7_DIV				81
#define TEGRA264_CLK_RG0				82
#define TEGRA264_CLK_RG1				83
#define TEGRA264_CLK_RG2				84
#define TEGRA264_CLK_RG3				85
#define TEGRA264_CLK_RG4				86
#define TEGRA264_CLK_RG5				87
#define TEGRA264_CLK_RG6				88
#define TEGRA264_CLK_RG7				89
#define TEGRA264_CLK_DISP				90
#define TEGRA264_CLK_DSC				91
#define TEGRA264_CLK_DSC_ROOT				92
#define TEGRA264_CLK_HUB				93
#define TEGRA264_CLK_VPLLX_SOR0_MUXED			94
#define TEGRA264_CLK_VPLLX_SOR1_MUXED			95
#define TEGRA264_CLK_VPLLX_SOR2_MUXED			96
#define TEGRA264_CLK_VPLLX_SOR3_MUXED			97
#define TEGRA264_CLK_LINKA_SYM				98
#define TEGRA264_CLK_LINKB_SYM				99
#define TEGRA264_CLK_LINKC_SYM				100
#define TEGRA264_CLK_LINKD_SYM				101
#define TEGRA264_CLK_PRE_SOR0				102
#define TEGRA264_CLK_PRE_SOR1				103
#define TEGRA264_CLK_PRE_SOR2				104
#define TEGRA264_CLK_PRE_SOR3				105
#define TEGRA264_CLK_SOR0_PLL_REF			106
#define TEGRA264_CLK_SOR1_PLL_REF			107
#define TEGRA264_CLK_SOR2_PLL_REF			108
#define TEGRA264_CLK_SOR3_PLL_REF			109
#define TEGRA264_CLK_SOR0_PAD				110
#define TEGRA264_CLK_SOR1_PAD				111
#define TEGRA264_CLK_SOR2_PAD				112
#define TEGRA264_CLK_SOR3_PAD				113
#define TEGRA264_CLK_SOR0_REF				114
#define TEGRA264_CLK_SOR1_REF				115
#define TEGRA264_CLK_SOR2_REF				116
#define TEGRA264_CLK_SOR3_REF				117
#define TEGRA264_CLK_SOR0_DIV				118
#define TEGRA264_CLK_SOR1_DIV				119
#define TEGRA264_CLK_SOR2_DIV				120
#define TEGRA264_CLK_SOR3_DIV				121
#define TEGRA264_CLK_SOR0				122
#define TEGRA264_CLK_SOR1				123
#define TEGRA264_CLK_SOR2				124
#define TEGRA264_CLK_SOR3				125
#define TEGRA264_CLK_SF0_SOR				126
#define TEGRA264_CLK_SF1_SOR				127
#define TEGRA264_CLK_SF2_SOR				128
#define TEGRA264_CLK_SF3_SOR				129
#define TEGRA264_CLK_SF4_SOR				130
#define TEGRA264_CLK_SF5_SOR				131
#define TEGRA264_CLK_SF6_SOR				132
#define TEGRA264_CLK_SF7_SOR				133
#define TEGRA264_CLK_SF0				134
#define TEGRA264_CLK_SF1				135
#define TEGRA264_CLK_SF2				136
#define TEGRA264_CLK_SF3				137
#define TEGRA264_CLK_SF4				138
#define TEGRA264_CLK_SF5				139
#define TEGRA264_CLK_SF6				140
#define TEGRA264_CLK_SF7				141
#define TEGRA264_CLK_MAUD				142
#define TEGRA264_CLK_AZA_2XBIT				143
#define TEGRA264_CLK_DCE_CPU				144
#define TEGRA264_CLK_DCE_NIC				145
#define TEGRA264_CLK_PLLC4				146
#define TEGRA264_CLK_PLLC4_OUT0				147
#define TEGRA264_CLK_PLLC4_OUT1				148
#define TEGRA264_CLK_PLLC4_MUXED			149
#define TEGRA264_CLK_SDMMC1				150
#define TEGRA264_CLK_SDMMC_LEGACY_TM			151
#define TEGRA264_CLK_PLLC0				152
#define TEGRA264_CLK_NAFLL_BPMP				153
#define TEGRA264_CLK_PLLP_OUT_PDIV			154
#define TEGRA264_CLK_DISP_ROOT				155
#define TEGRA264_CLK_ADSP				156
#define TEGRA264_CLK_PLLA				157
#define TEGRA264_CLK_PLLA1				158
#define TEGRA264_CLK_PLLA1_OUT1				159
#define TEGRA264_CLK_PLLAON				160
#define TEGRA264_CLK_PLLAON_APE				161
#define TEGRA264_CLK_PLLA_OUT0				162
#define TEGRA264_CLK_AHUB				163
#define TEGRA264_CLK_APE				164
#define TEGRA264_CLK_I2S1_SCLK_IN			165
#define TEGRA264_CLK_I2S2_SCLK_IN			166
#define TEGRA264_CLK_I2S3_SCLK_IN			167
#define TEGRA264_CLK_I2S4_SCLK_IN			168
#define TEGRA264_CLK_I2S5_SCLK_IN			169
#define TEGRA264_CLK_I2S6_SCLK_IN			170
#define TEGRA264_CLK_I2S7_SCLK_IN			171
#define TEGRA264_CLK_I2S8_SCLK_IN			172
#define TEGRA264_CLK_I2S9_SCLK_IN			173
#define TEGRA264_CLK_I2S1_AUDIO_SYNC			174
#define TEGRA264_CLK_I2S2_AUDIO_SYNC			175
#define TEGRA264_CLK_I2S3_AUDIO_SYNC			176
#define TEGRA264_CLK_I2S4_AUDIO_SYNC			177
#define TEGRA264_CLK_I2S5_AUDIO_SYNC			178
#define TEGRA264_CLK_I2S6_AUDIO_SYNC			179
#define TEGRA264_CLK_I2S7_AUDIO_SYNC			180
#define TEGRA264_CLK_I2S8_AUDIO_SYNC			181
#define TEGRA264_CLK_DMIC1_AUDIO_SYNC			182
#define TEGRA264_CLK_DSPK1_AUDIO_SYNC			183
#define TEGRA264_CLK_I2S1				184
#define TEGRA264_CLK_I2S2				185
#define TEGRA264_CLK_I2S3				186
#define TEGRA264_CLK_I2S4				187
#define TEGRA264_CLK_I2S5				188
#define TEGRA264_CLK_I2S6				189
#define TEGRA264_CLK_I2S7				190
#define TEGRA264_CLK_I2S8				191
#define TEGRA264_CLK_I2S9				192
#define TEGRA264_CLK_DMIC1				193
#define TEGRA264_CLK_DMIC5				194
#define TEGRA264_CLK_DSPK1				195
#define TEGRA264_CLK_AON_CPU				196
#define TEGRA264_CLK_AON_NIC				197
#define TEGRA264_CLK_BPMP				198
#define TEGRA264_CLK_AXI_CBB				199
#define TEGRA264_CLK_FUSE				200
#define TEGRA264_CLK_TSENSE				201
#define TEGRA264_CLK_CSITE				202
#define TEGRA264_CLK_HCSITE				203
#define TEGRA264_CLK_DBGAPB				204
#define TEGRA264_CLK_LA					205
#define TEGRA264_CLK_PLLREFGP				206
#define TEGRA264_CLK_PLLE0				207
#define TEGRA264_CLK_UPHY0_PLL0_XDIG			208
#define TEGRA264_CLK_EQOS_APP				209
#define TEGRA264_CLK_EQOS_MAC				210
#define TEGRA264_CLK_EQOS_MACSEC			211
#define TEGRA264_CLK_EQOS_TX_PCS			212
#define TEGRA264_CLK_MGBES_PTP_REF			213
#define TEGRA264_CLK_MGBE0_UPHY1_PLL_XDIG		214
#define TEGRA264_CLK_MGBE0_TX_PCS			215
#define TEGRA264_CLK_MGBE0_MAC				216
#define TEGRA264_CLK_MGBE0_MACSEC			217
#define TEGRA264_CLK_MGBE0_APP				218
#define TEGRA264_CLK_MGBE1_UPHY1_PLL_XDIG		219
#define TEGRA264_CLK_MGBE1_TX_PCS			220
#define TEGRA264_CLK_MGBE1_MAC				221
#define TEGRA264_CLK_MGBE1_MACSEC			222
#define TEGRA264_CLK_MGBE1_APP				223
#define TEGRA264_CLK_MGBE2_UPHY1_PLL_XDIG		224
#define TEGRA264_CLK_MGBE2_TX_PCS			225
#define TEGRA264_CLK_MGBE2_MAC				226
#define TEGRA264_CLK_MGBE2_MACSEC			227
#define TEGRA264_CLK_MGBE2_APP				228
#define TEGRA264_CLK_MGBE3_UPHY1_PLL_XDIG		229
#define TEGRA264_CLK_MGBE3_TX_PCS			230
#define TEGRA264_CLK_MGBE3_MAC				231
#define TEGRA264_CLK_MGBE3_MACSEC			232
#define TEGRA264_CLK_MGBE3_APP				233
#define TEGRA264_CLK_PLLREFUFS				234
#define TEGRA264_CLK_PLLREFUFS_CLKOUT624		235
#define TEGRA264_CLK_PLLREFUFS_REFCLKOUT		236
#define TEGRA264_CLK_PLLREFUFS_UFSDEV_REFCLKOUT		237
#define TEGRA264_CLK_UFSHC_CG_SYS			238
#define TEGRA264_CLK_MPHY_L0_RX_LS_BIT_DIV		239
#define TEGRA264_CLK_MPHY_L0_RX_LS_BIT			240
#define TEGRA264_CLK_MPHY_L0_RX_LS_SYMB_DIV		241
#define TEGRA264_CLK_MPHY_L0_RX_HS_SYMB_DIV		242
#define TEGRA264_CLK_MPHY_L0_RX_SYMB			243
#define TEGRA264_CLK_MPHY_L0_UPHY_TX_FIFO		244
#define TEGRA264_CLK_MPHY_L0_TX_LS_3XBIT_DIV		245
#define TEGRA264_CLK_MPHY_L0_TX_LS_SYMB_DIV		246
#define TEGRA264_CLK_UPHY0_PLL4_XDIG			247
#define TEGRA264_CLK_MPHY_L0_TX_HS_SYMB_DIV		248
#define TEGRA264_CLK_MPHY_L0_TX_SYMB			249
#define TEGRA264_CLK_MPHY_L0_TX_LS_3XBIT		250
#define TEGRA264_CLK_MPHY_L0_RX_ANA			251
#define TEGRA264_CLK_MPHY_L1_RX_ANA			252
#define TEGRA264_CLK_MPHY_TX_1MHZ_REF			253
#define TEGRA264_CLK_MPHY_CORE_PLL_FIXED		254
#define TEGRA264_CLK_MPHY_IOBIST			255
#define TEGRA264_CLK_UFSHC_CG_SYS_DIV			256
#define TEGRA264_CLK_XUSB1_CORE				257
#define TEGRA264_CLK_XUSB1_FALCON			258
#define TEGRA264_CLK_XUSB1_FS				259
#define TEGRA264_CLK_XUSB1_SS				260
#define TEGRA264_CLK_UPHY0_USB_P0_RX_CORE		261
#define TEGRA264_CLK_UPHY0_USB_P1_RX_CORE		262
#define TEGRA264_CLK_UPHY0_USB_P2_RX_CORE		263
#define TEGRA264_CLK_UPHY0_USB_P3_RX_CORE		264
#define TEGRA264_CLK_XUSB1_CLK480M_NVWRAP_CORE		265
#define TEGRA264_CLK_XUSB1_CORE_HOST			266
#define TEGRA264_CLK_XUSB1_CORE_DEV			267
#define TEGRA264_CLK_XUSB1_CORE_SUPERSPEED		268
#define TEGRA264_CLK_XUSB1_FALCON_HOST			269
#define TEGRA264_CLK_XUSB1_FALCON_SUPERSPEED		270
#define TEGRA264_CLK_XUSB1_FS_HOST			271
#define TEGRA264_CLK_XUSB1_FS_DEV			272
#define TEGRA264_CLK_XUSB1_HS_HSICP			273
#define TEGRA264_CLK_XUSB1_SS_DEV			274
#define TEGRA264_CLK_XUSB1_SS_SUPERSPEED		275
#define TEGRA264_CLK_AON_TOUCH				276
#define TEGRA264_CLK_AUD_MCLK				277
#define TEGRA264_CLK_EXTPERIPH1				278
#define TEGRA264_CLK_EXTPERIPH2				279
#define TEGRA264_CLK_EXTPERIPH3				280
#define TEGRA264_CLK_EXTPERIPH4				281
#define TEGRA264_CLK_JTAG_REG_UNGATED			282
#define TEGRA264_CLK_IST_BUS				283
#define TEGRA264_CLK_IST_BUS_RIST_MCC			284
#define TEGRA264_CLK_MATHS_SEC_RIST			285
#define TEGRA264_CLK_NAFLL_IST				286
#define TEGRA264_CLK_RIST_ROOT				287
#define TEGRA264_CLK_IST_CONTROLLER_RIST		288
#define TEGRA264_CLK_MSS_ENCRYPT			289
#define TEGRA264_CLK_EMC				290
#define TEGRA264_CLK_SPPLL0_CLKOUT100			291
#define TEGRA264_CLK_SPPLL0_CLKOUT270			292
#define TEGRA264_CLK_SPPLL1_CLKOUT100			293
#define TEGRA264_CLK_SPPLL1_CLKOUT270			294
#define TEGRA264_CLK_DP_LINKA_REF			295
#define TEGRA264_CLK_DP_LINKB_REF			296
#define TEGRA264_CLK_DP_LINKC_REF			297
#define TEGRA264_CLK_DP_LINKD_REF			298
#define TEGRA264_CLK_PLLNVCSI				299
#define TEGRA264_CLK_PLLBPMPCAM				300
#define TEGRA264_CLK_UTMI_PLL1				301
#define TEGRA264_CLK_UTMI_PLL1_CLKOUT48			302
#define TEGRA264_CLK_UTMI_PLL1_CLKOUT60			303
#define TEGRA264_CLK_UTMI_PLL1_CLKOUT480		304
#define TEGRA264_CLK_NAFLL_ISP				305
#define TEGRA264_CLK_NAFLL_RCE				306
#define TEGRA264_CLK_NAFLL_RCE1				307
#define TEGRA264_CLK_NAFLL_SE				308
#define TEGRA264_CLK_NAFLL_VI				309
#define TEGRA264_CLK_NAFLL_VIC				310
#define TEGRA264_CLK_NAFLL_DCE				311
#define TEGRA264_CLK_NAFLL_TSEC				312
#define TEGRA264_CLK_NAFLL_CPAIR0			313
#define TEGRA264_CLK_NAFLL_CPAIR1			314
#define TEGRA264_CLK_NAFLL_CPAIR2			315
#define TEGRA264_CLK_NAFLL_CPAIR3			316
#define TEGRA264_CLK_NAFLL_CPAIR4			317
#define TEGRA264_CLK_NAFLL_CPAIR5			318
#define TEGRA264_CLK_NAFLL_CPAIR6			319
#define TEGRA264_CLK_NAFLL_GPU_SYS			320
#define TEGRA264_CLK_NAFLL_GPU_NVD			321
#define TEGRA264_CLK_NAFLL_GPU_UPROC			322
#define TEGRA264_CLK_NAFLL_GPU_GPC0			323
#define TEGRA264_CLK_NAFLL_GPU_GPC1			324
#define TEGRA264_CLK_NAFLL_GPU_GPC2			325
#define TEGRA264_CLK_SOR_LINKA_INPUT			326
#define TEGRA264_CLK_SOR_LINKB_INPUT			327
#define TEGRA264_CLK_SOR_LINKC_INPUT			328
#define TEGRA264_CLK_SOR_LINKD_INPUT			329
#define TEGRA264_CLK_SOR_LINKA_AFIFO			330
#define TEGRA264_CLK_SOR_LINKB_AFIFO			331
#define TEGRA264_CLK_SOR_LINKC_AFIFO			332
#define TEGRA264_CLK_SOR_LINKD_AFIFO			333
#define TEGRA264_CLK_I2S1_PAD_M				334
#define TEGRA264_CLK_I2S2_PAD_M				335
#define TEGRA264_CLK_I2S3_PAD_M				336
#define TEGRA264_CLK_I2S4_PAD_M				337
#define TEGRA264_CLK_I2S5_PAD_M				338
#define TEGRA264_CLK_I2S6_PAD_M				339
#define TEGRA264_CLK_I2S7_PAD_M				340
#define TEGRA264_CLK_I2S8_PAD_M				341
#define TEGRA264_CLK_I2S9_PAD_M				342
#define TEGRA264_CLK_BPMP_NIC				343
#define TEGRA264_CLK_CLK1M				344
#define TEGRA264_CLK_RDET				345
#define TEGRA264_CLK_ADC_SOC_REF			346
#define TEGRA264_CLK_UPHY0_PLL0_TXREF			347
#define TEGRA264_CLK_EQOS_TX				348
#define TEGRA264_CLK_EQOS_TX_M				349
#define TEGRA264_CLK_EQOS_RX_PCS_IN			350
#define TEGRA264_CLK_EQOS_RX_PCS_M			351
#define TEGRA264_CLK_EQOS_RX_IN				352
#define TEGRA264_CLK_EQOS_RX				353
#define TEGRA264_CLK_EQOS_RX_M				354
#define TEGRA264_CLK_MGBE0_UPHY1_PLL_TXREF		355
#define TEGRA264_CLK_MGBE0_TX				356
#define TEGRA264_CLK_MGBE0_TX_M				357
#define TEGRA264_CLK_MGBE0_RX_PCS_IN			358
#define TEGRA264_CLK_MGBE0_RX_PCS_M			359
#define TEGRA264_CLK_MGBE0_RX_IN			360
#define TEGRA264_CLK_MGBE0_RX_M				361
#define TEGRA264_CLK_MGBE1_UPHY1_PLL_TXREF		362
#define TEGRA264_CLK_MGBE1_TX				363
#define TEGRA264_CLK_MGBE1_TX_M				364
#define TEGRA264_CLK_MGBE1_RX_PCS_IN			365
#define TEGRA264_CLK_MGBE1_RX_PCS_M			366
#define TEGRA264_CLK_MGBE1_RX_IN			367
#define TEGRA264_CLK_MGBE1_RX_M				368
#define TEGRA264_CLK_MGBE2_UPHY1_PLL_TXREF		369
#define TEGRA264_CLK_MGBE2_TX				370
#define TEGRA264_CLK_MGBE2_TX_M				371
#define TEGRA264_CLK_MGBE2_RX_PCS_IN			372
#define TEGRA264_CLK_MGBE2_RX_PCS_M			373
#define TEGRA264_CLK_MGBE2_RX_IN			374
#define TEGRA264_CLK_MGBE2_RX_M				375
#define TEGRA264_CLK_MGBE3_UPHY1_PLL_TXREF		376
#define TEGRA264_CLK_MGBE3_TX				377
#define TEGRA264_CLK_MGBE3_TX_M				378
#define TEGRA264_CLK_MGBE3_RX_PCS_IN			379
#define TEGRA264_CLK_MGBE3_RX_PCS_M			380
#define TEGRA264_CLK_MGBE3_RX_IN			381
#define TEGRA264_CLK_MGBE3_RX_M				382
#define TEGRA264_CLK_UPHY0_USB_P0_TX_CORE		383
#define TEGRA264_CLK_UPHY0_USB_P1_TX_CORE		384
#define TEGRA264_CLK_UPHY0_USB_P2_TX_CORE		385
#define TEGRA264_CLK_UPHY0_USB_P3_TX_CORE		386
#define TEGRA264_CLK_UPHY0_USB_P0_TX			387
#define TEGRA264_CLK_UPHY0_USB_P1_TX			388
#define TEGRA264_CLK_UPHY0_USB_P2_TX			389
#define TEGRA264_CLK_UPHY0_USB_P3_TX			390
#define TEGRA264_CLK_UPHY0_USB_P0_RX_IN			391
#define TEGRA264_CLK_UPHY0_USB_P1_RX_IN			392
#define TEGRA264_CLK_UPHY0_USB_P2_RX_IN			393
#define TEGRA264_CLK_UPHY0_USB_P3_RX_IN			394
#define TEGRA264_CLK_UPHY0_USB_P0_RX_M			395
#define TEGRA264_CLK_UPHY0_USB_P1_RX_M			396
#define TEGRA264_CLK_UPHY0_USB_P2_RX_M			397
#define TEGRA264_CLK_UPHY0_USB_P3_RX_M			398
#define TEGRA264_CLK_UPHY0_LANE0_TX_M			399
#define TEGRA264_CLK_PCIE_C1_XCLK_NOBG_M		400
#define TEGRA264_CLK_PCIE_C2_XCLK_NOBG_M		401
#define TEGRA264_CLK_PCIE_C3_XCLK_NOBG_M		402
#define TEGRA264_CLK_PCIE_C4_XCLK_NOBG_M		403
#define TEGRA264_CLK_PCIE_C5_XCLK_NOBG_M		404
#define TEGRA264_CLK_PCIE_C1_L0_RX_M			405
#define TEGRA264_CLK_PCIE_C1_L1_RX_M			406
#define TEGRA264_CLK_PCIE_C1_L2_RX_M			407
#define TEGRA264_CLK_PCIE_C1_L3_RX_M			408
#define TEGRA264_CLK_PCIE_C2_L0_RX_M			409
#define TEGRA264_CLK_PCIE_C2_L1_RX_M			410
#define TEGRA264_CLK_PCIE_C2_L2_RX_M			411
#define TEGRA264_CLK_PCIE_C2_L3_RX_M			412
#define TEGRA264_CLK_PCIE_C3_L0_RX_M			413
#define TEGRA264_CLK_PCIE_C3_L1_RX_M			414
#define TEGRA264_CLK_PCIE_C4_L0_RX_M			415
#define TEGRA264_CLK_PCIE_C4_L1_RX_M			416
#define TEGRA264_CLK_PCIE_C4_L2_RX_M			417
#define TEGRA264_CLK_PCIE_C4_L3_RX_M			418
#define TEGRA264_CLK_PCIE_C4_L4_RX_M			419
#define TEGRA264_CLK_PCIE_C4_L5_RX_M			420
#define TEGRA264_CLK_PCIE_C4_L6_RX_M			421
#define TEGRA264_CLK_PCIE_C4_L7_RX_M			422
#define TEGRA264_CLK_PCIE_C5_L0_RX_M			423
#define TEGRA264_CLK_PCIE_C5_L1_RX_M			424
#define TEGRA264_CLK_PCIE_C5_L2_RX_M			425
#define TEGRA264_CLK_PCIE_C5_L3_RX_M			426
#define TEGRA264_CLK_MPHY_L0_RX_PWM_BIT_M		427
#define TEGRA264_CLK_MPHY_L1_RX_PWM_BIT_M		428
#define TEGRA264_CLK_DBB_UPHY0				429
#define TEGRA264_CLK_UPHY0_UXL_CORE			430
#define TEGRA264_CLK_ISC_CPU_ROOT			431
#define TEGRA264_CLK_ISC_NIC				432
#define TEGRA264_CLK_CTC_TXCLK0_M			433
#define TEGRA264_CLK_CTC_TXCLK1_M			434
#define TEGRA264_CLK_CTC_RXCLK0_M			435
#define TEGRA264_CLK_CTC_RXCLK1_M			436
#define TEGRA264_CLK_PLLREFGP_OUT			437
#define TEGRA264_CLK_PLLREFGP_OUT1			438
#define TEGRA264_CLK_GPU_SYS				439
#define TEGRA264_CLK_GPU_NVD				440
#define TEGRA264_CLK_GPU_UPROC				441
#define TEGRA264_CLK_GPU_GPC0				442
#define TEGRA264_CLK_GPU_GPC1				443
#define TEGRA264_CLK_GPU_GPC2				444
#define TEGRA264_CLK_PLLX				445
#define TEGRA264_CLK_APE_SOUNDWIRE_MSRC0		446
#define TEGRA264_CLK_APE_SOUNDWIRE_DATA_EN_SHAPER	447
#define TEGRA264_CLK_AO_SOUNDWIRE_MSRC0			448
#define TEGRA264_CLK_AO_SOUNDWIRE_DATA_EN_SHAPER	449
#define TEGRA264_CLK_MGBE0_TX_SER			459
#define TEGRA264_CLK_MGBE1_TX_SER			460
#define TEGRA264_CLK_MGBE2_TX_SER			461
#define TEGRA264_CLK_MGBE3_TX_SER			462
#define TEGRA264_CLK_MGBE0_RX_SER			463
#define TEGRA264_CLK_MGBE1_RX_SER			464
#define TEGRA264_CLK_MGBE2_RX_SER			465
#define TEGRA264_CLK_MGBE3_RX_SER			466
#define TEGRA264_CLK_DPAUX				467

#endif /* DT_BINDINGS_CLOCK_NVIDIA_TEGRA264_H */
