!{\src2tex{textfont=tt}}
!!****f* ABINIT/mkffkg3_htor
!! NAME
!! mkffkg3_htor
!!
!! FUNCTION
!! Prepare the application of the projectors to the shifted wavefunctions,
!! by precomputing the k+G factors and their product with the form factors
!! Do this on a block of plane wave.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, MT, DRH)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  choice=governs the combination of k+G vectors to be computed
!!  ffnl(npw,nffnl,lmnmax,ntypat)=nonlocal form factors on basis sphere.
!!  gmet(3,3)=metric tensor for G vecs (in bohr**-2)
!!  nffnl=3rd dimension of ffnl(2, conventional, or 3 for 2nd derivatives)
!!  idir=direction of the perturbation (needed if choice==2 and ndgxdt==1,
!!       or if choice==5)
!!  indlmn(6,i,ntypat)=array giving l,m,n,lm,ln,spin for i=ln
!!  ipw1 = index of the first plane wave treated in this block
!!  ispinor=1 or 2, gives the spinorial component of ffnl to be used
!!  itypat = type of atom, needed for ffnl
!!  kg_k(3,npw)=integer coords of planewaves in basis sphere
!!  kpg_k(npw,npkg)= (k+G) components and related data
!!  kpt(3)=real components of k point in terms of recip. translations
!!  lmnmax=max. number of (l,n) components over all type of psps
!!  mblkpw=first dimension of kpgx
!!  ndgxdt=number of components of first order derivative
!!  nffkg=number of products of ffnls with combinations of k+G
!!  nincpw=number of plane waves in the block
!!  nkpg=second size of array kpg_k
!!  nlang = number of angular momenta to be treated = 1 + highest ang. mom.
!!  nloalg(5)=governs the choice of the algorithm for non-local operator.
!!  npw  = total number of plane waves in reciprocal space
!!  ntens=second dimension of kpgx, number of distinct tensorial products
!!  ntypat = number of type of atoms, dimension needed for ffnl
!!
!! OUTPUT
!!  kpgx(mblkpw,ntens)=different tensorial products of k+G
!!  ffkg(nffkg,mblkpw)=different products of ffnls with k+G
!!  parity(nffkg)=parity of the tensorial product of k+G (2 if even, 1 of odd)
!!
!! PARENTS
!!      nonlop_htor
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mkffkg3_htor(choice,ffkg,ffnl,gmet,idir,indlmn,ipw1,ispinor,itypat,&
&                  kg_k,kpg_k,kpgx,kpt,lmnmax,mblkpw,ndgxdt,nffkg,nffnl,nincpw,nkpg,nlang,&
&                  nloalg,npw,ntens,ntypat,parity)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: choice,idir,ipw1,ispinor,itypat,lmnmax,mblkpw,ndgxdt
 integer,intent(in) :: nffkg,nffnl,nincpw,nkpg,nlang,npw,ntens,ntypat
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),kg_k(3,npw),nloalg(5)
 integer,intent(out) :: parity(nffkg)
 real(dp),intent(in) :: ffnl(npw,nffnl,lmnmax,ntypat),gmet(3,3),kpg_k(npw,nkpg)
 real(dp),intent(in) :: kpt(3)
 real(dp),intent(out) :: ffkg(nffkg,mblkpw),kpgx(mblkpw,ntens)

!Local variables-------------------------------
!scalars
 integer :: iffkg,ig,ii,ilang,ilang2,ilang3,ilangx,ilmn,iln,iln0,iproj,ipw,jj
 integer :: nffkge
 real(dp) :: ffkg_now,kpg_x,kpg_y,kpg_z
 character(len=500) :: message
!arrays
 real(dp) :: tsec(2)

! *************************************************************************

!This will be useless after all the modifications have been done
 kpgx(:,1)=1.0d0

!Initialize kpgx array related to tensors defined below
 if (nlang>=2) then
  if (nkpg>=3) then
   kpgx(1:nincpw,2)=kpg_k(ipw1+1:ipw1+nincpw,1)
   kpgx(1:nincpw,3)=kpg_k(ipw1+1:ipw1+nincpw,2)
   kpgx(1:nincpw,4)=kpg_k(ipw1+1:ipw1+nincpw,3)
  else
   ig=ipw1
   do ipw=1,nincpw
    kpgx(ipw,2)=kpt(1)+dble(kg_k(1,ig))
    kpgx(ipw,3)=kpt(2)+dble(kg_k(2,ig))
    kpgx(ipw,4)=kpt(3)+dble(kg_k(3,ig))
    ig=ig+1
   end do
  end if
 end if
 if (nlang>=3) then
! Define (k+G) part of rank 2 symmetric tensor (6 components), l=2
! Compressed storage is 11 22 33 32 31 21
  if (nkpg>=9) then
   kpgx(1:nincpw,5) =kpg_k(ipw1+1:ipw1+nincpw,4)
   kpgx(1:nincpw,6) =kpg_k(ipw1+1:ipw1+nincpw,5)
   kpgx(1:nincpw,7) =kpg_k(ipw1+1:ipw1+nincpw,6)
   kpgx(1:nincpw,8) =kpg_k(ipw1+1:ipw1+nincpw,7)
   kpgx(1:nincpw,9) =kpg_k(ipw1+1:ipw1+nincpw,8)
   kpgx(1:nincpw,10)=kpg_k(ipw1+1:ipw1+nincpw,9)
  else
   do ipw=1,nincpw
    kpgx(ipw, 5) =      kpgx(ipw, 2)*kpgx(ipw, 2)
    kpgx(ipw, 6) =      kpgx(ipw, 3)*kpgx(ipw, 3)
    kpgx(ipw, 7) =      kpgx(ipw, 4)*kpgx(ipw, 4)
    kpgx(ipw, 8) =      kpgx(ipw, 4)*kpgx(ipw, 3)
    kpgx(ipw, 9) =      kpgx(ipw, 4)*kpgx(ipw, 2)
    kpgx(ipw,10) =      kpgx(ipw, 3)*kpgx(ipw, 2)
   end do
  end if
 end if
 if (nlang>=4) then
! Define (k+G) part of rank 3 symmetric tensor (10 components), l=3
! Compressed storage is 111 221 331 321 311 211 222 332 322 333
  do ipw=1,nincpw
   kpgx(ipw,11) =     kpgx(ipw, 5)*kpgx(ipw, 2)
   kpgx(ipw,12) =     kpgx(ipw, 6)*kpgx(ipw, 2)
   kpgx(ipw,13) =     kpgx(ipw, 7)*kpgx(ipw, 2)
   kpgx(ipw,14) =     kpgx(ipw, 8)*kpgx(ipw, 2)
   kpgx(ipw,15) =     kpgx(ipw, 9)*kpgx(ipw, 2)
   kpgx(ipw,16) =     kpgx(ipw,10)*kpgx(ipw, 2)
   kpgx(ipw,17) =     kpgx(ipw, 6)*kpgx(ipw, 3)
   kpgx(ipw,18) =     kpgx(ipw, 7)*kpgx(ipw, 3)
   kpgx(ipw,19) =     kpgx(ipw, 8)*kpgx(ipw, 3)
   kpgx(ipw,20) =     kpgx(ipw, 7)*kpgx(ipw, 4)
  end do
 end if

! *****************************************************************************
!
! Packing of composite projectors in ffkg

 iffkg=0

!Treat composite projectors for the energy
 iln0=0
 do ilmn=1,lmnmax
  iln=indlmn(5,ilmn,itypat)
  if (iln>iln0) then
   iln0=iln
   ilang=1+indlmn(1,ilmn,itypat)
   iproj=indlmn(3,ilmn,itypat)
   if(iproj>0)then
    ilang2=(ilang*(ilang+1))/2

    if(ilang==1)then
!   Treat s-component separately
     ig=ipw1
     iffkg=iffkg+1
     do ipw=1,nincpw
      ffkg(iffkg,ipw)=ffnl(ig,1,ilmn,itypat)
      ig=ig+1
     end do
     parity(iffkg)=2
    else
!    Treat other components (could be made faster by treating explicitely
!    each angular momentum)
     do ii=1,ilang2
!     Get the starting address for the relevant tensor
      jj=ii+((ilang-1)*ilang*(ilang+1))/6
      ig=ipw1
      iffkg=iffkg+1
      do ipw=1,nincpw
       ffkg(iffkg,ipw)=ffnl(ig,1,ilmn,itypat)*kpgx(ipw,jj)
       ig=ig+1
      end do
      if(ilang==2 .or. ilang==4)parity(iffkg)=1
      if(ilang==3)parity(iffkg)=2
     end do
    end if

!  End condition if(iproj>0)
   end if

! End loop on ilang (ilmn)
  end if
 end do

!This is the number of composite projectors for the energy
 nffkge=iffkg

end subroutine mkffkg3_htor
!!***
