//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>. 
void acetoneiso::md5check()
{
QDir Home = QDir::home();
QString immagine = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d)"));
	if (!immagine.isEmpty() ){
	 MD5.setReadChannel(QProcess::StandardOutput);
	 MD5.start("md5sum", QStringList() << immagine );
	 //progBarra();
			if (!MD5.waitForFinished()){
        		qDebug() << "Make failed:" << MD5.errorString();
			}
    			else{
			QByteArray ba = MD5.readAll();
			QString s( ba );
			QMessageBox::information(this, "AcetoneISO::Md5 Check", s );
			}
	}
}


 void acetoneiso::md5generate()
{
QDir Home = QDir::home();
QString immagine = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d)"));
	if (!immagine.isNull() ){
	 
	 QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Md5 text file"),Home.path() + "/md5.txt",
													tr("Md5 (*.md5)"));
	if (!fileName.isNull()){
	 MD5.setReadChannel(QProcess::StandardOutput);
	 MD5.start("md5sum", QStringList() << immagine );
	 //progBarra();
			if (!MD5.waitForFinished()){
        		qDebug() << "Make failed:" << MD5.errorString();
			}
    			else{
			QByteArray ba = MD5.readAll();
			QString s( ba );
			//QMessageBox::question(this, "AcetoneISO::Warning!", s );
			QFile f1(fileName);
			f1.open(QIODevice::WriteOnly | QIODevice::Text);
			QTextStream out(&f1);
			out << (ba);
			}
	}
	}
}





void acetoneiso::sha1() {
QDir Home = QDir::home();
QString immagine = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d)"));
	if (immagine.isNull() ){
	 return; 
	}
	
SHA.setReadChannel(QProcess::StandardOutput);
SHA.start("sha1sum", QStringList() << immagine );
SHA.waitForFinished();
QByteArray ba = SHA.readAll();
QString s( ba );
QMessageBox::information(this, "AcetoneISO::Sha1 Check", s );	
	
}

void acetoneiso::sha256() {
QDir Home = QDir::home();
QString immagine = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d)"));
	if (immagine.isNull() ){
	 return; 
	}
	
SHA.setReadChannel(QProcess::StandardOutput);
SHA.start("sha256sum", QStringList() << immagine );
SHA.waitForFinished();
QByteArray ba = SHA.readAll();
QString s( ba );
QMessageBox::information(this, "AcetoneISO::Sha256 Check", s );
}


void acetoneiso::sha384() {
QDir Home = QDir::home();
QString immagine = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d)"));
	if (immagine.isNull() ){
	 return; 
	}
	
SHA.setReadChannel(QProcess::StandardOutput);
SHA.start("sha384sum", QStringList() << immagine );
SHA.waitForFinished();
QByteArray ba = SHA.readAll();
QString s( ba );
QMessageBox::information(this, "AcetoneISO::Sha384 Check", s );



}











