#!/usr/bin/python
from albatross import ModularSessionApp, SessionAppContext
from albatross.cgiapp import Request
import popviewlib


class AppContext(SessionAppContext):

    def open_mbox(self):
        if hasattr(self.locals, 'mbox'):
            return
        self.locals.mbox = popviewlib.Mbox(self.locals.username, self.locals.passwd)

    def read_msg(self):
        if hasattr(self.locals, 'msg'):
            return
        self.locals.msg = self.locals.mbox[int(self.locals.msgnum) - 1]
        self.locals.msg.read_body()


class App(ModularSessionApp):

    def __init__(self):
        ModularSessionApp.__init__(self,
                                   base_url='popview.py',
                                   module_path='.',
                                   template_path='.',
                                   start_page='login',
                                   secret='-=-secret-=-',
                                   session_appid='popview4')

    def create_context(self):
        return AppContext(self)


app = App()


if __name__ == '__main__':
    app.run(Request())
