/*
    Copyright (c) 2008-12 Qtrac Ltd. All rights reserved.
    This program or module is free software: you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 2 of
    the License, or version 3 of the License, or (at your option) any
    later version. This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
*/

#include "syntaxhighlighter.hpp"


void SyntaxHighlighter::highlightBlock(const QString &text)
{
    QTextCharFormat comment;
    comment.setFontItalic(true);

    if (text.trimmed().startsWith("#")) {
        setFormat(0, text.length(), comment);
        return;
    }

    QTextCharFormat format;
    format.setFontWeight(QFont::Bold);
    format.setFontUnderline(true);

    for (int i = 1; i < text.length(); ++i)
        if (text[i - 1] == '&' && text[i] != '&' &&
            text[i].isLetterOrNumber())
            setFormat(i, 1, format);
}

