# B.3 Why are anarchists against private property?

Private property is one of the three things all anarchists oppose, along side
hierarchical authority and the state. Today, the dominant system of private
property is capitalist in nature and, as such, anarchists tend to concentrate
on this system and its property rights regime. We will be reflecting this here
but do not, because of this, assume that anarchists consider other forms of
private property regime (such as, say, feudalism) as acceptable. This is not
the case -- anarchists are against every form of property rights regime which
results in the many working for the few.

Anarchist opposition to private property rests on two, related, arguments.
These were summed up by Proudhon's maxims (from What is Property? that
_"property is theft"_ and _"property is despotism."_ In his words, _"Property
. . . violates equality by the rights of exclusion and increase, and freedom
by despotism . . . [and has] perfect identity with robbery."_ [Proudhon, What
is Property, p. 251] Anarchists, therefore, oppose private property (i.e.
capitalism) because it is a source of coercive, hierarchical authority as well
as exploitation and, consequently, elite privilege and inequality. It is based
on and produces inequality, in terms of both wealth and power.

We will summarise each argument in turn.

The statement _"property is theft"_ is one of anarchism's most famous sayings.
Indeed, it is no exaggeration to say that anyone who rejects this statement is
not an anarchist. This maxim works in two related ways. Firstly, it recognises
the fact that the earth and its resources, the common inheritance of all, have
been monopolised by a few. Secondly, it argues that, as a consequence of this,
those who own property exploit those who do not. This is because those who do
not own have to pay or sell their labour to those who do own in order to get
access to the resources they need to live and work (such as workplaces,
machinery, land, credit, housing, products under patents, and such like -- see
[section B.3.2](secB3.md#secb32) for more discussion).

As we discuss in [section B.3.3](secB3.md#secb33), this exploitation (theft)
flows from the fact that workers do not own or control the means of production
they use and, as a consequence, are controlled by those who do during work
hours. This alienation of control over labour to the boss places the employer
in a position to exploit that labour -- to get the worker to produce more than
they get paid in wages. That is precisely **why** the boss employs the worker.
Combine this with rent, interest and intellectual property rights and we find
the secret to maintaining the capitalist system as all allow enormous
inequalities of wealth to continue and keep the resources of the world in the
hands of a few.

Yet labour cannot be alienated. Therefore when you sell your labour you sell
yourself, your liberty, for the time in question. This brings us to the second
reason why anarchists oppose private property, the fact it produces
authoritarian social relationships. For all true anarchists, property is
opposed as a source of authority, indeed despotism. To quote Proudhon on this
subject:

> _ "The proprietor, the robber, the hero, the sovereign -- for all these
titles are synonymous -- imposes his will as law, and suffers neither
contradiction nor control; that is, he pretends to be the legislative and the
executive power at once . . . [and so] property engenders despotism . . . That
is so clearly the essence of property that, to be convinced of it, one need
but remember what it is, and observe what happens around him. Property is the
right to **use** and **abuse** . . . if goods are property, why should not the
proprietors be kings, and despotic kings -- kings in proportion to their
**facultes bonitaires**? And if each proprietor is sovereign lord within the
sphere of his property, absolute king throughout his own domain, how could a
government of proprietors be any thing but chaos and confusion?"_ [**Op.
Cit.**, pp. 266-7]

In other words, private property is the state writ small, with the property
owner acting as the _"sovereign lord"_ over their property, and so the
absolute king of those who use it. As in any monarchy, the worker is the
subject of the capitalist, having to follow their orders, laws and decisions
while on their property. This, obviously, is the total denial of liberty (and
dignity, we may note, as it is degrading to have to follow orders). And so
private property (capitalism) necessarily excludes participation, influence,
and control by those who use, but do not own, the means of life.

It is, of course, true that private property provides a sphere of decision-
making free from outside interference -- but only for the property's owners.
But for those who are not property owners the situation if radically
different. In a system of exclusively private property does not guarantee them
any such sphere of freedom. They have only the freedom to sell their liberty
to those who **do** own private property. If I am evicted from one piece of
private property, where can I go? Nowhere, unless another owner agrees to
allow me access to their piece of private property. This means that everywhere
I can stand is a place where I have no right to stand without permission and,
as a consequence, I exist only by the sufferance of the property owning elite.
Hence Proudhon:

> _ "Just as the commoner once held his land by the munificence and
condescension of the lord, so to-day the working-man holds his labour by the
condescension and necessities of the master and proprietor."_ [Proudhon, **Op.
Cit.**, p. 128]

This means that far from providing a sphere of independence, a society in
which all property is private thus renders the property-less completely
dependent on those who own property. This ensures that the exploitation of
another's labour occurs and that some are subjected to the will of others, in
direct contradiction to what the defenders of property promise. This is
unsurprising given the nature of the property they are defending:

> _ "Our opponents . . . are in the habit of justifying the right to private
property by stating that property is the condition and guarantee of liberty.  
>  _

>

> _"And we agree with them. Do we not say repeatedly that poverty is slavery?
_

>

> _"But then why do we oppose them? _

>

> _"The reason is clear: in reality the property that they defend is
capitalist property, namely property that allows its owners to live from the
work of others and which therefore depends on the existence of a class of the
disinherited and dispossessed, forced to sell their labour to the property
owners for a wage below its real value . . . This means that workers are
subjected to a kind of slavery, which, though it may vary in degree of
harshness, always means social inferiority, material penury and moral
degradation, and is the primary cause of all the ills that beset today's
social order."_ [Malatesta, **The Anarchist Revolution**, p. 113]

It will, of course, be objected that no one forces a worker to work for a
given boss. However, as we discuss in [section B.4.3](secB4.md#secb43), this
assertion (while true) misses the point. While workers are not forced to work
for a **specific** boss, they inevitably have to work for a boss. This is
because there is literally no other way to survive -- all other economic
options have been taken from them by state coercion. The net effect is that
the working class has little choice but to hire themselves out to those with
property and, as a consequence, the labourer _"has sold and surrendered his
liberty"_ to the boss. [Proudhon, **Op. Cit.**, p. 130]

Private property, therefore, produces a very specific form of authority
structure within society, a structure in which a few govern the many during
working hours. These relations of production are inherently authoritarian and
embody and perpetuate the capitalist class system. The moment you enter the
factory gate or the office door, you lose all your basic rights as a human
being. You have no freedom of speech nor association and no right of assembly.
If you were asked to ignore your values, your priorities, your judgement, and
your dignity, and leave them at the door when you enter your home, you would
rightly consider that tyranny yet that is exactly what you do during working
hours if you are a worker. You have no say in what goes on. You may as well be
a horse (to use John Locke's analogy -- see [section
B.4.2](secB4.md#secb42)) or a piece of machinery.

Little wonder, then, that anarchists oppose private property as Anarchy is
_"the absence of a master, of a sovereign"_ [Proudhon, **Op. Cit.**, p. 264]
and call capitalism for what it is, namely **wage slavery**!

For these reasons, anarchists agree with Rousseau when he stated:

> _ "The first man who, having fenced off a plot of land, thought of saying,
'This is mine' and found people simple enough to believe him was the real
founder of civil society. How many crimes, wars, murders, how many miseries
and horrors might the human race had been spared by the one who, upon pulling
up the stakes or filling in the ditch, had shouted to his fellow men: 'Beware
of listening to this impostor; you are lost if you forget the fruits of the
earth belong to all and that the earth belongs to no one.'"_ [_"Discourse on
Inequality,"_ **The Social Contract and Discourses**, p. 84]

This explains anarchist opposition to capitalism. It is marked by two main
features, _"private property"_ (or in some cases, state-owned property -- see
[section B.3.5](secB3.md#secb35)) and, consequently, wage labour and
exploitation and authority. Moreover, such a system requires a state to
maintain itself for as _"long as within society a possessing and non-
possessing group of human beings face one another in enmity, the state will be
indispensable to the possessing minority for the protection for its
privileges."_ [Rudolf Rocker, Anarcho-Syndicalism, p. 11] Thus private
ownership of the means of production is only possible if there is a state,
meaning mechanisms of organised coercion at the disposal of the propertied
class (see [section B.2](secB2.md)).

Also, it ought to be easy to see that capitalism, by giving rise to an
ideologically inalienable _"right"_ to private property, will also quickly
give rise to inequalities in the distribution of external resources, and that
this inequality in resource distribution will give rise to a further
inequality in the relative bargaining positions of the propertied and the
property less. While apologists for capitalism usually attempt to justify
private property by claiming that "self-ownership" is a "universal right" (see
section B.4.2 -- [_"Is capitalism based on self-
ownership?"_](secB4.md#secb42)), it is clear that capitalism actually makes
universal autonomy implied by the flawed concept of self-ownership (for the
appeal of the notion of self-ownership rests on the ideal that people are not
used as a means but only as an end in themselves). The capitalist system,
however, has undermined autonomy and individual freedom, and ironically, has
used the term _"self-ownership"_ as the basis for doing so. Under capitalism,
as will be seen in [section B.4](secB4.md), most people are usually left in
a situation where their best option is to allow themselves to be used in just
those ways that are logically incompatible with genuine self-ownership, i.e.
the autonomy which makes it initially an appealing concept.

Only libertarian socialism can continue to affirm the meaningful autonomy and
individual freedom which self-ownership promises whilst building the
conditions that guarantee it. Only by abolishing private property can there be
access to the means of life for all, so making the autonomy which self-
ownership promises but cannot deliver a reality by universalising self-
management in all aspects of life.

Before discussing the anti-libertarian aspects of capitalism, it will be
necessary to define _"private property"_ as distinct from _"personal
possessions"_ and show in more detail why the former requires state protection
and is exploitative.

## B.3.1 What is the difference between private property and possession?

Anarchists define _"private property"_ (or just _"property,"_ for short) as
state-protected monopolies of certain objects or privileges which are used to
control and exploit others. _"Possession,"_ on the other hand, is ownership of
things that are not used to exploit others (e.g. a car, a refrigerator, a
toothbrush, etc.). Thus many things can be considered as either property or
possessions depending on how they are used.

To summarise, anarchists are in favour of the kind of property which _"cannot
be used to exploit another -- those kinds of personal possessions which we
accumulate from childhood and which become part of our lives."_ We are opposed
to the kind of property _"which can be used only to exploit people -- land and
buildings, instruments of production and distribution, raw materials and
manufactured articles, money and capital."_ [Nicholas Walter, **About
Anarchism**, p. 40] As a rule of thumb, anarchists oppose those forms of
property which are owned by a few people but which are used by others. This
leads to the former controlling the latter and using them to produce a surplus
for them (either directly, as in the case of a employee, or indirectly, in the
case of a tenant).

The key is that _"possession"_ is rooted in the concept of _"use rights"_ or
_"usufruct"_ while _"private property"_ is rooted in a divorce between the
users and ownership. For example, a house that one lives in is a possession,
whereas if one rents it to someone else at a profit it becomes property.
Similarly, if one uses a saw to make a living as a self-employed carpenter,
the saw is a possession; whereas if one employs others at wages to use the saw
for one's own profit, it is property. Needless to say, a capitalist workplace,
where the workers are ordered about by a boss, is an example of _"property"_
while a co-operative, where the workers manage their own work, is an example
of _"possession."_ To quote Proudhon:

> _ "The proprietor is a man who, having absolute control of an instrument of
production, claims the right to enjoy the product of the instrument without
using it himself. To this end he lends it."_ [**Op. Cit.**, p. 293]

While it may initially be confusing to make this distinction, it is very
useful to understand the nature of capitalist society. Capitalists tend to use
the word _"property"_ to mean anything from a toothbrush to a transnational
corporation -- two very different things, with very different impacts upon
society. Hence Proudhon:

> _ "Originally the word **property** was synonymous with **proper** or
**individual possession.** It designated each individual's special right to
the use of a thing. But when this right of use . . . became active and
paramount -- that is, when the usufructuary converted his right to personally
use the thing into the right to use it by his neighbour's labour -- then
property changed its nature and this idea became complex."_ [**Op. Cit.**, pp.
395-6]

Proudhon graphically illustrated the distinction by comparing a lover as a
possessor, and a husband as a proprietor! As he stressed, the _"double
definition of property -- domain and possession -- is of highest importance;
and must be clearly understood, in order to comprehend"_ what anarchism is
really about. So while some may question why we make this distinction, the
reason is clear. As Proudhon argued, _"it is proper to call different things
by different names, if we keep the name 'property' for the former
[possession], we must call the latter [the domain of property] robbery,
repine, brigandage. If, on the contrary, we reserve the name 'property' for
the latter, we must designate the former by the term **possession** or some
other equivalent; otherwise we should be troubled with an unpleasant
synonym."_ [**Op. Cit.**, p. 65 and p. 373]

The difference between property and possession can be seen from the types of
authority relations each generates. Taking the example of a capitalist
workplace, its clear that those who own the workplace determine how it is
used, not those who do the actual work. This leads to an almost totalitarian
system. As Noam Chomsky points out, _"the term 'totalitarian' is quite
accurate. There is no human institution that approaches totalitarianism as
closely as a business corporation. I mean, power is completely top-down. You
can be inside it somewhere and you take orders from above and hand 'em down.
Ultimately, it's in the hands of owners and investors."_ Thus the actual
producer does not control their own activity, the product of their labour nor
the means of production they use. In modern class societies, the producer is
in a position of subordination to those who actually do own or manage the
productive process.

In an anarchist society, as noted, actual use is considered the only title.
This means that a workplace is organised and run by those who work within it,
thus reducing hierarchy and increasing freedom and equality within society.
Hence anarchist opposition to private property and capitalism flows naturally
from anarchism's basic principles and ideas. Hence all anarchists agree with
Proudhon:

> _ "Possession is a right; property is against right. Suppress property while
maintaining possession."_ [**Op. Cit.**, p. 271]

As Alexander Berkman frames this distinction, anarchism _"abolishes private
ownership of the means of production and distribution, and with it goes
capitalistic business. Personal possession remains only in the things you use.
Thus, your watch is your own, but the watch factory belongs to the people.
Land, machinery, and all other public utilities will be collective property,
neither to be bought nor sold. Actual use will be considered the only title --
not to ownership but to possession."_ [**What is Anarchism?**, p. 217]

This analysis of different forms of property is at the heart of both social
and individualist anarchism. This means that all anarchists seek to change
people's opinions on what is to be considered as valid forms of property,
aiming to see that _"the Anarchistic view that occupancy and use should
condition and limit landholding becomes the prevailing view"_ and so ensure
that _"individuals should no longer be protected by their fellows in anything
but personal occupation and cultivation [i.e. use] of land."_ [Benjamin
Tucker, **The Individualist Anarchists**, p. 159 and p. 85] The key
differences, as we noted in [section A.3.1](secA3.md#seca31), is how they
apply this principle.

This anarchist support for possession does not imply the break up of large
scale organisations such as factories or other workplaces which require large
numbers of people to operate. Far from it. Anarchists argue for association as
the complement of possession. This means applying _"occupancy and use"_ to
property which is worked by more than one person results in associated labour,
i.e. those who collectively work together (i.e. use a given property) manage
it and their own labour as a self-governing, directly democratic, association
of equals (usually called _"self-management"_ for short).

This logically flows from the theory of possession, of _"occupancy and use."_
For if production is carried on in groups who is the legal occupier of the
land? The employer or their manager? Obviously not, as they are by definition
occupying more than they can use by themselves. Clearly, the association of
those engaged in the work can be the only rational answer. Hence Proudhon's
comment that _"all accumulated capital being social property, no one can be
its exclusive proprietor."_ _"In order to destroy despotism and inequality of
conditions, men must . . . become associates"_ and this implies workers' self-
management -- _"leaders, instructors, superintendents . . . must be chosen
from the labourers by the labourers themselves."_ [Proudhon, **Op. Cit.**, p.
130, p. 372 and p. 137]

In this way, anarchists seek, in Proudhon's words, _"abolition of the
proletariat"_ and consider a key idea of our ideas that _"Industrial Democracy
must. . . succeed Industrial Feudalism."_ [Proudhon, **Selected Writings of
Pierre-Joseph Proudhon**, p. 179 and p. 167] Thus an anarchist society would
be based on possession, with workers' self-management being practised at all
levels from the smallest one person workplace or farm to large scale industry
(see [section I.3](secI3.md) for more discussion).

Clearly, then, all anarchists seek to transform and limit property rights.
Capitalist property rights would be ended and a new system introduced rooted
in the concept of possession and use. While the exact nature of that new
system differs between schools of anarchist thought, the basic principles are
the same as they flow from the same anarchist theory of property to be found
in Proudhon's, What is Property?.

Significantly, William Godwin in his Enquiry Concerning Political Justice
makes the same point concerning the difference between property and possession
(although not in the same language) fifty years before Proudhon, which
indicates its central place in anarchist thought. For Godwin, there were
different kinds of property. One kind was _"the empire to which every [person]
is entitled over the produce of his [or her] own industry."_ However, another
kind was _"a system, in whatever manner established, by which one man enters
into the faculty of disposing of the produce of another man's industry."_ This
_"species of property is in direct contradiction"_ to the former kind (he
similarities with subsequent anarchist ideas is striking). For Godwin,
inequality produces a _"servile"_ spirit in the poor and, moreover, a person
who _"is born to poverty, may be said, under a another name, to be born a
slave."_ [**The Anarchist Writings of William Godwin**, p. 133, p. 134, p. 125
and p. 126]

Needless to say, anarchists have not be totally consistent in using this
terminology. Some, for example, have referred to the capitalist and landlord
classes as being the _"possessing classes."_ Others prefer to use the term
_"personal property"_ rather than _"possession"_ or _"capital"_ rather than
_"private property."_ Some, like many individualist anarchists, use the term
_"property"_ in a general sense and qualify it with _"occupancy and use"_ in
the case of land, housing and workplaces. However, no matter the specific
words used, the key idea is the same.

## B.3.2 What kinds of property does the state protect?

Kropotkin argued that the state was _"the instrument for establishing
monopolies in favour of the ruling minorities."_ [**Anarchism**, p. 286] In
every system of class exploitation, a ruling class controls access to the
means of production in order to extract tribute from labour. Capitalism is no
exception. In this system the state maintains various kinds of _"class
monopolies"_ (to use Tucker's phrase) to ensure that workers do not receive
their _"natural wage,"_ the full product of their labour. While some of these
monopolies are obvious (such as tariffs, state granted market monopolies and
so on), most are _"behind the scenes"_ and work to ensure that capitalist
domination does not need extensive force to maintain.

Under capitalism, there are four major kinds of property, or exploitative
monopolies, that the state protects:

      (1) the power to issue credit and currency, the basis of capitalist
banking;

     (2) land and buildings, the basis of landlordism;

     (3) productive tools and equipment, the basis of industrial capitalism;

     (4) ideas and inventions, the basis of copyright and patent
(_"intellectual property"_) royalties.

By enforcing these forms of property, the state ensures that the objective
conditions within the economy favour the capitalist, with the worker free only
to accept oppressive and exploitative contracts within which they forfeit
their autonomy and promise obedience or face misery and poverty. Due to these
_"initiations of force"_ conducted **previously** to any specific contract
being signed, capitalists enrich themselves at our expense because we _"are
compelled to pay a heavy tribute to property holders for the right of
cultivating land or putting machinery into action."_ [Kropotkin, **The
Conquest of Bread**, p. 103] These conditions obviously also make a mockery of
free agreement (see [section B.4](secB4.md)).

These various forms of state intervention are considered so normal many people
do not even think of them as such. Thus we find defenders of "free market"
capitalism thundering against forms of "state intervention" which are designed
to aid the poor while seeing nothing wrong in defending intellectual property
rights, corporations, absentee landlords and the other multitude of laws and
taxes capitalists and their politicians have placed and kept upon the statute-
books to skew the labour market in favour of themselves (see [section
F.8](secF8.md) on the state's role in developing capitalism in the first
place).

Needless to say, despite the supposedly subtle role of such _"objective"_
pressures in controlling the working class, working class resistance has been
such that capital has never been able to dispense with the powers of the
state, both direct and indirect. When _"objective"_ means of control fail, the
capitalists will always turn to the use of state repression to restore the
_"natural"_ order. Then the _"invisible"_ hand of the market is replaced by
the visible fist of the state and the indirect means of securing ruling class
profits and power are supplemented by more direct forms by the state. As we
indicate in [section D.1](secD1.md), state intervention beyond enforcing
these forms of private property is the norm of capitalism, not the exception,
and is done so to secure the power and profits of the capitalist class.

To indicate the importance of these state backed monopolies, we shall sketch
their impact.

The credit monopoly, by which the state controls who can and cannot issue or
loan money, reduces the ability of working class people to create their own
alternatives to capitalism. By charging high amounts of interest on loans
(which is only possible because competition is restricted) few people can
afford to create co-operatives or one-person firms. In addition, having to
repay loans at high interest to capitalist banks ensures that co-operatives
often have to undermine their own principles by having to employ wage labour
to make ends meet (see [section J.5.11](secJ5.md#secj511)). It is
unsurprising, therefore, that the very successful Mondragon co-operatives in
the Basque Country created their own credit union which is largely responsible
for the experiment's success.

Just as increasing wages is an important struggle within capitalism, so is the
question of credit. Proudhon and his followers supported the idea of a
**People's Bank.** If the working class could take over and control increasing
amounts of money it could undercut capitalist power while building its own
alternative social order (for money is ultimately the means of buying labour
power, and so authority over the labourer - which is the key to surplus value
production). Proudhon hoped that by credit being reduced to cost (namely
administration charges) workers would be able to buy the means of production
they needed. While most anarchists would argue that increased working class
access to credit would no more bring down capitalism than increased wages, all
anarchists recognise how more cheap credit, like more wages, can make life
easier for working people and how the struggle for such credit, like the
struggle for wages, might play a useful role in the development of the power
of the working class within capitalism. Obvious cases that spring to mind are
those where money has been used by workers to finance their struggles against
capital, from strike funds and weapons to the periodical avoidance of work
made possible by sufficiently high money income. Increased access to cheap
credit would give working class people slightly more options than selling
their liberty or facing misery (just as increased wages and unemployment
benefit also gives us more options).

Therefore, the credit monopoly reduces competition to capitalism from co-
operatives (which are generally more productive than capitalist firms) while
at the same time forcing down wages for all workers as the demand for labour
is lower than it would otherwise be. This, in turn, allows capitalists to use
the fear of the sack to extract higher levels of surplus value from employees,
so consolidating capitalist power (within and outwith the workplace) and
expansion (increasing set-up costs and so creating oligarchic markets
dominated by a few firms). In addition, high interest rates transfer income
directly from producers to banks. Credit and money are both used as weapons in
the class struggle. This is why, again and again, we see the ruling class call
for centralised banking and use state action (from the direct regulation of
money itself, to the attempted management of its flows by the manipulation of
the interest) in the face of repeated threats to the nature (and role) of
money within capitalism.

The credit monopoly has other advantages for the elite. The 1980s were marked
by a rising debt burden on households as well as the increased concentration
of wealth in the US. The two are linked. Due to _"the decline in real hourly
wages, and the stagnation in household incomes, the middle and lower classes
have borrowed more to stay in place"_ and they have _"borrowed from the very
rich who have [become] richer."_ By 1997, US households spent $1 trillion (or
17% of the after-tax incomes) on debt service. _"This represents a massive
upward redistribution of income."_ And why did they borrow? The bottom 40% of
the income distribution _"borrowed to compensate for stagnant or falling
incomes"_ while the upper 20% borrowed _"mainly to invest."_ Thus _"consumer
credit can be thought of as a way to sustain mass consumption in the face of
stagnant or falling wages. But there's an additional social and political
bonus, from the point of view of the creditor class: it reduces pressure for
higher wages by allowing people to buy goods they couldn't otherwise afford.
It helps to nourish both the appearance and reality of a middle-class standard
of living in a time of polarisation. And debt can be a great conservatising
force; with a large monthly mortgage and/or MasterCard bill, strikes and other
forms of troublemaking look less appealing than they would other wise."_ [Doug
Henwood, **Wall Street**, pp. 64-6]

Thus credit _"is an important form of social coercion; mortgaged workers are
more pliable."_ [Henwood, **Op. Cit.**, p. 232] Money is power and any means
which lessens that power by increasing the options of workers is considered a
threat by the capitalist class -- whether it is tight labour markets, state
provided unemployment benefit, or cheap, self-organised, credit -- will be
resisted. The credit monopoly can, therefore, only be fought as part of a
broader attack on all forms of capitalist social power.

In summary, the credit monopoly, by artificially restricting the option to
work for ourselves, ensures we work for a boss while also enriching the few at
the expense of the many.

The land monopoly consists of enforcement by government of land titles which
do not rest upon personal occupancy and use. It also includes making the
squatting of abandoned housing and other forms of property illegal. This leads
to ground-rent, by which landlords get payment for letting others use the land
they own but do not actually cultivate or use. It also allows the ownership
and control of natural resources like oil, gas, coal and timber. This monopoly
is particularly exploitative as the owner cannot claim to have created the
land or its resources. It was available to all until the landlord claimed it
by fencing it off and barring others from using it.

Until the nineteenth century, the control of land was probably the single most
important form of privilege by which working people were forced to accept less
than its product as a wage. While this monopoly is less important in a modern
capitalist society (as few people know how to farm), it still plays a role
(particularly in terms of ownership of natural resources). At a minimum, every
home and workplace needs land on which to be built. Thus while cultivation of
land has become less important, the use of land remains crucial. The land
monopoly, therefore, ensures that working people find no land to cultivate, no
space to set up shop and no place to sleep without first having to pay a
landlord a sum for the privilege of setting foot on the land they own but
neither created nor use. At best, the worker has mortgaged their life for
decades to get their wee bit of soil or, at worse, paid their rent and
remained as property-less as before. Either way, the landlords are richer for
the exchange.

Moreover, the land monopoly did play an important role in **creating**
capitalism (also see [section F.8.3](secF8.md#secf83)). This took two main
forms. Firstly, the state enforced the ownership of large estates in the hands
of a single family. Taking the best land by force, these landlords turned vast
tracks of land into parks and hunting grounds so forcing the peasants little
option but to huddle together on what remained. Access to superior land was
therefore only possible by paying a rent for the privilege, if at all. Thus an
elite claimed ownership of vacant lands, and by controlling access to it
(without themselves ever directly occupying or working it) they controlled the
labouring classes of the time. Secondly, the ruling elite also simply stole
land which had traditionally been owned by the community. This was called
enclosure, the process by which common land was turned into private property.
Economist William Lazonick summaries this process:

> _ "The reorganisation of agricultural land [the enclosure movement] . . .
inevitably undermined the viability of traditional peasant agriculture . . .
[it] created a sizeable labour force of disinherited peasants with only
tenuous attachments to the land. To earn a living, many of these peasants
turned to 'domestic industry' - the production of goods in their cottages . .
. It was the eighteenth century expansion of domestic industry . . . that laid
the basis for the British Industrial Revolution. The emergence of labour-
saving machine technology transformed . . . textile manufacture . . . and the
factory replaced the family home as the predominant site of production."_
[**Business Organisation and the Myth of the Market Economy**, pp. 3-4]

By being able to _"legally"_ bar people from _"their"_ property, the landlord
class used the land monopoly to ensure the creation of a class of people with
nothing to sell but their labour (i.e. liberty). Land was taken from those who
traditionally used it, violating common rights, and it was used by the
landlord to produce for their own profit (more recently, a similar process has
been going on in the Third World as well). Personal occupancy was replaced by
landlordism and agricultural wage slavery, and so _"the Enclosure Acts . . .
reduced the agricultural population to misery, placed them at the mercy of the
landowners, and forced a great number of them to migrate to the towns where,
as proletarians, they were delivered to the mercy of the middle-class
manufacturers."_ [Peter Kropotkin, **The Great French Revolution**, vol. 1,
pp. 117-8]

A variation of this process took place in countries like America, where the
state took over ownership of vast tracks of land and then sold it to farmers.
As Howard Zinn notes, the Homestead Act _"gave 160 acres of western land,
unoccupied and publicly owned, to anyone who would cultivate it for fives
years. Anyone willing to pay $1.25 an acre could buy a homestead. Few ordinary
people had the $200 necessary to do this; speculators moved in and bought up
much of the land."_ [**A People's History of the United States**, p. 233]
Those farmers who did pay the money often had to go into debt to do so,
placing an extra burden on their labour. Vast tracks of land were also given
to railroad and other companies either directly (by gift or by selling cheap)
or by lease (in the form of privileged access to state owned land for the
purpose of extracting raw materials like lumber and oil). Either way, access
to land was restricted and those who actually did work it ended up paying a
tribute to the landlord in one form or another (either directly in rent or
indirectly by repaying a loan).

This was the land monopoly in action (also see sections
[F.8.3](secF8.md#secf83), [F.8.4](secF8.md#secf84) and
[F.8.5](secF8.md#secf85) for more details) and from it sprang the tools and
equipment monopoly as domestic industry could not survive in the face of
industrial capitalism. Confronted with competition from industrial production
growing rich on the profits produced from cheap labour, the ability of workers
to own their own means of production decreased over time. From a situation
where most workers owned their own tools and, consequently, worked for
themselves, we now face an economic regime were the tools and equipment needed
for work are owned by a capitalists and, consequently, workers now work for a
boss.

The tools and equipment monopoly is similar to the land monopoly as it is
based upon the capitalist denying workers access to their capital unless the
worker pays tribute to the owner for using it. While capital is _"simply
stored-up labour which has already received its pay in full"_ and so _"the
lender of capital is entitled to its return intact, and nothing more"_ (to use
Tucker's words), due to legal privilege the capitalist is in a position to
charge a _"fee"_ for its use. This is because, with the working class legally
barred from both the land and available capital (the means of life), members
of that class have little option but to agree to wage contracts which let
capitalists extract a _"fee"_ for the use of their equipment (see [section
B.3.3](secB3.md#secb33)).

Thus the capital-monopoly is, like the land monopoly, enforced by the state
and its laws. This is most clearly seen if you look at the main form in which
such capital is held today, the corporation. This is nothing more than a legal
construct. _"Over the last 150 years,"_ notes Joel Bakan, _"the corporation
has risen from relative obscurity to becomes the world's dominant economic
institution."_ The law has been changed to give corporations _"limited
liability"_ and other perks in order _"to attract valuable incorporation
business . . . by jettisoning unpopular [to capitalists] restrictions from . .
. corporate laws."_ Finally, the courts _"fully transformed the corporation
onto a 'person,' with its own identity . . . and empowered, like a real
person, to conduct business in its own name, acquire assets, employ workers,
pay taxes, and go to court to assert its rights and defend its actions."_ In
America, this was achieved using the 14th Amendment (which was passed to
protect freed slaves!). In summary, the corporation _"is not an independent
'person' with its own rights, needs, and desires . . . It is a state-created
tool for advancing social and economic policy."_ [**The Corporation**, p. 5,
p. 13, p. 16 and p. 158]

Nor can it be said that this monopoly is the product of hard work and saving.
The capital-monopoly is a recent development and how this situation developed
is usually ignored. If not glossed over as irrelevant, some fairy tale is spun
in which a few bright people saved and worked hard to accumulate capital and
the lazy majority flocked to be employed by these (almost superhuman)
geniuses. In reality, the initial capital for investing in industry came from
wealth plundered from overseas or from the proceeds of feudal and landlord
exploitation. In addition, as we discuss in [section F.8](secF8.md),
extensive state intervention was required to create a class of wage workers
and ensure that capital was in the best position to exploit them. This
explicit state intervention was scaled down once the capital-monopoly found
its own feet.

Once this was achieved, state action became less explicit and becomes focused
around defending the capitalists' property rights. This is because the _"fee"_
charged to workers was partly reinvested into capital, which reduced the
prices of goods, ruining domestic industry and so narrowing the options
available to workers in the economy. In addition, investment also increased
the set-up costs of potential competitors, which continued the dispossession
of the working class from the means of production as these _"natural"_
barriers to entry into markets ensured few members of that class had the
necessary funds to create co-operative workplaces of appropriate size. So
while the land monopoly was essential to create capitalism, the _"tools and
equipment"_ monopoly that sprang from it soon became the mainspring of the
system.

In this way usury became self-perpetuating, with apparently _"free exchanges"_
being the means by which capitalist domination survives. In other words, "past
initiations of force" combined with the current state protection of property
ensure that capitalist domination of society continues with only the use of
_"defensive"_ force (i.e. violence used to protect the power of property
owners against unions, strikes, occupations, etc.). The _"fees"_ extracted
from previous generations of workers has ensured that the current one is in no
position to re-unite itself with the means of life by _"free competition"_ (in
other words, the paying of usury ensures that usury continues). Needless to
say, the surplus produced by this generation will be used to increase the
capital stock and so ensure the dispossession of future generations and so
usury becomes self-perpetuating. And, of course, state protection of
_"property"_ against _"theft"_ by working people ensures that property remains
theft and the **real** thieves keep their plunder.

As far as the _"ideas"_ monopoly is concerned, this has been used to enrich
capitalist corporations at the expense of the general public and the inventor.
Patents make an astronomical price difference. Until the early 1970s, for
example, Italy did not recognise drug patents. As a result, Roche Products
charged the British National Health Service over 40 times more for patented
components of Librium and Valium than charged by competitors in Italy. As
Tucker argued, the patent monopoly _"consists in protecting investors and
authors against competition for a period long enough to enable them to extort
from the people a reward enormously in excess of the labour measure of their
services, -- in other words, in giving certain people a right of property for
a term of years and facts of nature, and the power to extract tribute from
others for the use of this natural wealth which should be open to all."_
[**The Individualist Anarchists**, p. 86]

The net effect of this can be terrible. The Uruguay Round of global trade
negotiations _"strengthen intellectual property rights. American and other
Western drug companies could now stop drug companies in India and Brazil from
'stealing' their intellectual property. But these drug companies in the
developing world were making these life-saving drugs available to their
citizens at a fraction of the price at which the drugs were sold by the
Western drug companies . . . Profits of the Western drug companies would go up
. . . but the increases profits from sales in the developing world were small,
since few could afford the drugs . . . [and so] thousands were effectively
condemned to death, becomes governments and individuals in developing
countries could no longer pay the high prices demanded."_ [Joseph Stiglitz,
**Globalisation and its discontents**, pp. 7-8] While international outrage
over AIDS drugs eventually forced the drug companies to sell the drugs at cost
price in late 2001, the underlying intellectual property rights regime was
still in place.

The irony that this regime was created in a process allegedly about trade
liberalisation should not go unnoticed. _"Intellectual property rights,"_ as
Noam Chomsky correctly points out, _"are a protectionist measure, they have
nothing to do with free trade -- in fact, they're the exact **opposite** of
free trade."_ [**Understanding Power**, p. 282] The fundamental injustice of
the _"ideas monopoly"_ is exacerbated by the fact that many of these patented
products are the result of government funding of research and development,
with private industry simply reaping monopoly profits from technology it did
not spend a penny to develop. In fact, extending government aid for research
and development is considered an important and acceptable area of state
intervention by governments and companies verbally committed to the neo-
liberal agenda.

The _"ideas monopoly"_ actually works against its own rationale. Patents
suppress innovation as much as they encourage it. The research scientists who
actually do the work of inventing are required to sign over patent rights as a
condition of employment, while patents and industrial security programs used
to bolster competitive advantage on the market actually prevent the sharing of
information, so reducing innovation (this evil is being particularly felt in
universities as the new _"intellectual property rights"_ regime is spreading
there). Further research stalls as the incremental innovation based on others'
patents is hindered while the patent holder can rest on their laurels as they
have no fear of a competitor improving the invention. They also hamper
technical progress because, by their very nature, preclude the possibility of
independent discovery. Also, of course, some companies own a patent explicitly
not to use it but simply to prevent someone else from so doing.

As Noam Chomsky notes, today trade agreements like GATT and NAFTA _"impose a
mixture of liberalisation and protection, going far beyond trade, designed to
keep wealth and power firmly in the hands of the masters."_ Thus _"investor
rights are to be protected and enhanced"_ and a key demand _"is increased
protection for 'intellectual property,' including software and patents, with
patent rights extending to process as well as product"_ in order to _"ensure
that US-based corporations control the technology of the future"_ and so
_"locking the poor majority into dependence on high-priced products of Western
agribusiness, biotechnology, the pharmaceutical industry and so on."_ [**World
Orders, Old and New**, p. 183, p. 181 and pp. 182-3] This means that if a
company discovers a new, more efficient, way of producing a drug then the
_"ideas monopoly"_ will stop them and so _"these are not only highly
protectionist measures . . . they're a blow **against** economic efficiency
and technological process -- that just shows you how much 'free trade' really
is involved in all of this."_ [Chomsky, **Understanding Power**, p. 282]

All of which means that the corporations (and their governments) in the
developed world are trying to prevent emergence of competition by controlling
the flow of technology to others. The "free trade" agreements are being used
to create monopolies for their products and this will either block or slow
down the rise of competition. While corporate propagandists piously denounce
"anti-globalisation" activists as enemies of the developing world, seeking to
use trade barriers to maintain their (Western) lifestyles at the expense of
the poor nations, the reality is different. The _"ideas monopoly"_ is being
aggressively used to either suppress or control the developing world's
economic activity in order to keep the South as, effectively, one big
sweatshop. As well as reaping monopoly profits directly, the threat of "low-
wage" competition from the developing world can be used to keep the wage
slaves of the developed world in check and so maintain profit levels at home.

This is not all. Like other forms of private property, the usury produced by
it helps ensure it becomes self-perpetuating. By creating "legal" absolute
monopolies and reaping the excess profits these create, capitalists not only
enrich themselves at the expense of others, they also ensure their dominance
in the market. Some of the excess profits reaped due to patents and copyrights
are invested back into the company, securing advantages by creating various
"natural" barriers to entry for potential competitors. Thus patents impact on
business structure, encouraging the formation and dominance of big business.

Looking at the end of the nineteenth century, the ideas monopoly played a key
role in promoting cartels and, as a result, laid the foundation for what was
to become corporate capitalism in the twentieth century. Patents were used on
a massive scale to promote concentration of capital, erect barriers to entry,
and maintain a monopoly of advanced technology in the hands of western
corporations. The exchange or pooling of patents between competitors,
historically, has been a key method for the creation of cartels in industry.
This was true especially of the electrical appliance, communications, and
chemical industries. For example, by the 1890s, two large companies, General
Electric and Westinghouse, _"monopolised a substantial part of the American
electrical manufacturing industry, and their success had been in large measure
the result of patent control."_ The two competitors simply pooled their
patents and _"yet another means of patent and market control had developed:
corporate patent-pooling agreements. Designed to minimise the expense and
uncertainties of conflict between the giants, they greatly reinforced the
position of each vis-à-vis lesser competitors and new entrants into the
field."_ [David Noble, **American By Design**, p. 10]

While the patent system is, in theory, promoted to defend the small scale
inventor, in reality it is corporate interests that benefit. As David Noble
points out, the _"inventor, the original focus of the patent system, tended to
increasingly to 'abandon' his patent in exchange for corporate security; he
either sold or licensed his patent rights to industrial corporations or
assigned them to the company of which he became an employee, bartering his
genius for a salary. In addition, by means of patent control gained through
purchase, consolidation, patent pools, and cross-licensing agreements, as well
as by regulated patent production through systematic industrial research, the
corporations steadily expanded their 'monopoly of monopolies.'"_ As well as
this, corporations used _"patents to circumvent anti-trust laws."_ This
reaping of monopoly profits at the expense of the customer made such
_"tremendous strides"_ between 1900 and 1929 and _"were of such proportions as
to render subsequent judicial and legislative effects to check corporate
monopoly through patent control too little too late."_ [**Op. Cit.**, p. 87,
p. 84 and p. 88]

Things have changed little since Edwin Prindle, a corporate patent lawyer,
wrote in 1906 that:

> _ "Patents are the best and most effective means of controlling competition.
They occasionally give absolute command of the market, enabling their owner to
name the price without regard to the cost of production. . . Patents are the
only legal form of absolute monopoly . . . The power which a patentee has to
dictate the conditions under which his monopoly may be exercised had been used
to form trade agreements throughout practically entire industries."_ [quoted
by Noble, **Op. Cit.**, p. 89]

Thus, the ruling class, by means of the state, is continually trying to
develop new forms of private property by creating artificial scarcities and
monopolies, e.g. by requiring expensive licenses to engage in particular types
of activities, such as broadcasting or producing certain kinds of medicines or
products. In the _"Information Age,"_ usury (use fees) from intellectual
property are becoming a much more important source of income for elites, as
reflected in the attention paid to strengthening mechanisms for enforcing
copyright and patents in the recent GATT agreements, or in US pressure on
foreign countries (like China) to respect such laws.

This allows corporations to destroy potential competitors and ensure that
their prices can be set as high as possible (and monopoly profits maintained
indefinitely). It also allows them to enclose ever more of the common
inheritance of humanity, place it under private ownership and charge the
previous users money to gain access to it. As Chomsky notes, _"U.S.
corporations must control seeds, plant varieties, drugs, and the means of life
generally."_ [**World Orders, Old and New**, p. 183] This has been termed _
"bio-piracy"_ (a better term may be the new enclosures) and it is a process by
which _"international companies [are] patenting traditional medicines or
foods."_ They _"seek to make money from 'resources' and knowledge that
rightfully belongs to the developing countries"_ and _"in so doing, they
squelch domestic firms that have long provided the products. While it is not
clear whether these patents would hold up in court if they were effectively
challenged, it is clear that the less developed countries many not have the
legal and financial resources required to challenge the patent."_ [Joseph
Stiglitz, **Op. Cit.**, p. 246] They may also not withstand the economic
pressures they may experience if the international markets conclude that such
acts indicate a regime that is less that business friendly. That the people
who were dependent on the generic drugs or plants can no longer afford them is
as irrelevant as the impediments to scientific and technological advance they
create.

In other words, capitalists desire to skew the _"free market"_ in their favour
by ensuring that the law reflects and protects their interests, namely their
_"property rights."_ By this process they ensure that co-operative tendencies
within society are crushed by state-supported "market forces." As Noam Chomsky
puts it, modern capitalism is _"state protection and public subsidy for the
rich, market discipline for the poor."_ [_"Rollback, Part I"_, **Z Magazine**]
Self-proclaimed defenders of "free market" capitalism are usually nothing of
the kind, while the few who actually support it only object to the _"public
subsidy"_ aspect of modern capitalism and happily support state protection for
property rights.

All these monopolies seek to enrich the capitalist (and increase their capital
stock) at the expense of working people, to restrict their ability to
undermine the ruling elites power and wealth. All aim to ensure that any
option we have to work for ourselves (either individually or collectively) is
restricted by tilting the playing field against us, making sure that we have
little option but to sell our labour on the _"free market"_ and be exploited.
In other words, the various monopolies make sure that "natural" barriers to
entry (see [section C.4](secC4.md)) are created, leaving the heights of the
economy in the control of big business while alternatives to capitalism are
marginalised at its fringes.

So it is these kinds of property and the authoritarian social relationships
that they create which the state exists to protect. It should be noted that
converting private to state ownership (i.e. nationalisation) does not
fundamentally change the nature of property relationships; it just removes
private capitalists and replaces them with bureaucrats (as we discuss in
[section B.3.5](secB3.md#secb35)).

## B.3.3 Why is property exploitative?

To answer this question, consider the monopoly of productive _"tools and
equipment."_ This monopoly, obtained by the class of industrial capitalists,
allows this class in effect to charge workers a _"fee"_ for the privilege of
using the monopolised tools and equipment.

This occurs because property, in Proudhon words, _"excommunicates"_ the
working class. This means that private property creates a class of people who
have no choice but to work for a boss in order to pay the landlord rent or buy
the goods they, as a class, produce but do not own. The state enforces
property rights in land, workplaces and so on, meaning that the owner can bar
others from using them and enforce **their** rules on those they do let use
_"their"_ property. So the boss _"gives you a job; that is, permission to work
in the factory or mill which was not built by him but by other workers like
yourself. And for that permission you help to support him for . . . as long as
you work for him."_ [Alexander Berkman, **What is Anarchism?**, p. 14] This is
called wage labour and is, for anarchists, the defining characteristic of
capitalism.

This class of people who are dependent on wages to survive was sometimes
called the _"proletariat"_ by nineteenth century anarchists. Today most
anarchists usually call it the _"working class"_ as most workers in modern
capitalist nations are wage workers rather than peasants or artisans (i.e.
self-employed workers who are also exploited by the private property system,
but in different ways). It should also be noted that property used in this way
(i.e. to employ and exploit other people's labour) is also called
_**"capital"**_ by anarchists and other socialists. Thus, for anarchists,
private property generates a class system, a regime in which the few, due to
their ownership of wealth and the means of producing it, rule over the many
who own very little (see [section B.7](secB7.md) for more discussion of
classes).

This ensures that the few can profit from the work of others:

> _ "In the capitalist system the working man cannot [in general] work for
himself . . . So . . . you must find an employer. You work for him . . . In
the capitalist system the whole working class sells its labour power to the
employing class. The workers build factories, make machinery and tools, and
produce goods. The employers keep the factories, the machinery, the tools and
the goods for themselves as **their profit.** The workers only get their wages
. . . Though the workers, as a class, have built the factories, a slice of
their daily labour is taken from them for the privilege of **using** those
factories . . . Though the workers have made the tools and the machinery,
another slice of their daily labour is taken from them for the privilege of
**using** those tools and machinery . . .  
>  _

>

> _"Can you guess now why the wisdom of Proudhon said that **the possessions
of the rich are stolen property**? Stolen from the producer, the worker."_
[Berkman, **Op. Cit.**, pp. 7-8]

Thus the daily theft/exploitation associated with capitalism is dependent on
the distribution of wealth and private property (i.e. the initial theft of the
means of life, the land, workplaces and housing by the owning class). Due to
the dispossession of the vast majority of the population from the means of
life, capitalists are in an ideal position to charge a _"use-fee"_ for the
capital they own, but neither produced nor use. Having little option, workers
agree to contracts within which they forfeit their autonomy during work and
the product of that work. This results in capitalists having access to a
_"commodity"_ (labour) that can potentially produce more value than it gets
paid for in wages.

For this situation to arise, for wage labour to exist, workers must not own or
control the means of production they use. As a consequence, are controlled by
those who do own the means of production they use during work hours. As their
labour is owned by their boss and as labour cannot be separated from the
person who does it, the boss effectively owns the worker for the duration of
the working day and, as a consequence, exploitation becomes possible. This is
because during working hours, the owner can dictate (within certain limits
determined by worker resistance and solidarity as well as objective
conditions, such as the level of unemployment within an industry or country)
the organisation, level, duration, conditions, pace and intensity of work, and
so the amount of output (which the owner has sole rights over even though they
did not produce it).

Thus the _"fee"_ (or _"surplus value"_) is created by owners paying workers
less than the full value added by their labour to the products or services
they create for the firm. The capitalist's profit is thus the difference
between this _"surplus value,"_ created by and appropriated from labour, minus
the firm's overhead and cost of raw materials (See also section C.2 --
[_"Where do profits come from?"_](secC2.md)).

So property is exploitative because it allows a surplus to be monopolised by
the owners. Property creates hierarchical relationships within the workplace
(the _"tools and equipment monopoly"_ might better be called the _"power
monopoly"_) and as in any hierarchical system, those with the power use it to
protect and further their own interests at the expense of others. Within the
workplace there is resistance by workers to this oppression and exploitation,
which the _"hierarchical . . . relations of the capitalist enterprise are
designed to resolve this conflict in favour of the representatives of
capital."_ [William Lazonick, **Op. Cit.**, p. 184]

Needless to say, the state is always on hand to protect the rights of property
and management against the actions of the dispossessed. When it boils down to
it, it is the existence of the state as protector of the _"power monopoly"_
that allows it to exist at all.

So, capitalists are able to appropriate this surplus value from workers solely
because they own the means of production, not because they earn it by doing
productive work themselves. Of course some capitalists **may** also contribute
to production, in which case they are in fairness entitled to the amount of
value added to the firm's output by their own labour; but owners typically pay
themselves much more than this, and are able to do so because the state
guarantees them that right as property owners (which is unsurprising, as they
alone have knowledge of the firms inputs and outputs and, like all people in
unaccountable positions, abuse that power -- which is partly why anarchists
support direct democracy as the essential counterpart of free agreement, for
no one in power can be trusted not to prefer their own interests over those
subject to their decisions). And of course many capitalists hire managers to
run their businesses for them, thus collecting income for doing nothing except
owning.

Capitalists' profits, then, are a form of state-supported exploitation. This
is equally true of the interest collected by bankers and rents collected by
landlords. Without some form of state, these forms of exploitation would be
impossible, as the monopolies on which they depend could not be maintained.
For instance, in the absence of state troops and police, workers would simply
take over and operate factories for themselves, thus preventing capitalists
from appropriating an unjust share of the surplus they create.

## B.3.4 Can private property be justified?

No. Even though a few supporters of capitalism recognise that private
property, particularly in land, was created by the use of force, most maintain
that private property is just. One common defence of private property is found
in the work of Robert Nozick (a supporter of _"free market"_ capitalism). For
Nozick, the use of force makes acquisition illegitimate and so any current
title to the property is illegitimate (in other words, theft and trading in
stolen goods does not make ownership of these goods legal). So, if the initial
acquisition of land was illegitimate then all current titles are also
illegitimate. And since private ownership of land is the basis of capitalism,
capitalism itself would be rendered illegal.

To get round this problem, Nozick utilises the work of Locke (_"The Lockean
Proviso"_) which can be summarised as:

       1. People own themselves and, consequently, their labour. 

       2. The world is initially owned in common (or unowned in Nozick's case.)

       3. By working on common (or unowned) resources, people turn it into their own property because they own their own labour.

       4. You can acquire absolute rights over a larger than average share in the world, if you do not worsen the condition of others.

      5. Once people have appropriated private property, a free market in capital and labour is morally required.

However, there are numerous flaws in this theory. Most obvious is why does the
mixing of something you own (labour) with something owned by all (or unowned)
turn it in your property? Surely it would be as likely to simply mean that you
have lost the labour you have expended (for example, few would argue that you
owned a river simply because you swam or fished in it). Even if we assume the
validity of the argument and acknowledge that by working on a piece of land
creates ownership, why assume that this ownership must be based on
**capitalist** property rights? Many cultures have recognised no such
_"absolute"_ forms of property, admitted the right of property in what is
produced but not the land itself.

As such, the assumption that expending labour turns the soil into private
property does not automatically hold. You could equally argue the opposite,
namely that labour, while producing ownership of the goods created, does not
produce property in land, only possession. In the words of Proudhon:

> _ "I maintain that the possessor is paid for his trouble and industry . . .
but that he acquires no right to the land. 'Let the labourer have the fruits
of his labour.' Very good; but I do not understand that property in products
carries with it property in raw material. Does the skill of the fisherman, who
on the same coast can catch more fish than his fellows, make him proprietor of
the fishing-grounds? Can the expertness of a hunter ever be regarded as a
property-title to a game-forest? The analogy is perfect, -- the industrious
cultivator finds the reward of his industry in the abundancy and superiority
of his crop. If he has made improvements in the soil, he has the possessor's
right of preference. Never, under any circumstances, can he be allowed to
claim a property-title to the soil which he cultivates, on the ground of his
skill as a cultivator.  
>  _

>

> _"To change possession into property, something is needed besides labour,
without which a man would cease to be proprietor as soon as he ceased to be a
laborer. Now, the law bases property upon immemorial, unquestionable
possession; that is, prescription. Labour is only the sensible sign, the
physical act, by which occupation is manifested. If, then, the cultivator
remains proprietor after he has ceased to labor and produce; if his
possession, first conceded, then tolerated, finally becomes inalienable, -- it
happens by permission of the civil law, and by virtue of the principle of
occupancy. So true is this, that there is not a bill of sale, not a farm
lease, not an annuity, but implies it . . . _

>

> _"Man has created every thing -- every thing save the material itself. Now,
I maintain that this material he can only possess and use, on condition of
permanent labor, -- granting, for the time being, his right of property in
things which he has produced. _

>

> _"This, then, is the first point settled: property in product, if we grant
so much, does not carry with it property in the means of production; that
seems to me to need no further demonstration. There is no difference between
the soldier who possesses his arms, the mason who possesses the materials
committed to his care, the fisherman who possesses the water, the hunter who
possesses the fields and forests, and the cultivator who possesses the lands:
all, if you say so, are proprietors of their products -- not one is proprietor
of the means of production. The right to product is exclusive --**jus in re**;
the right to means is common -- **jus ad rem**."_ [**What is Property?**, pp.
120-1]

Proudhon's argument has far more historical validity than Nozick's. Common
ownership of land combined with personal use has been the dominant form of
property rights for tens of thousands of years while Nozick's _"natural law"_
theory dates back to Locke's work in the seventh century (itself an attempt to
defend the encroachment of capitalist norms of ownership over previous common
law ones). Nozick's theory only appears valid because we live in a society
where the dominant form of property rights are capitalist. As such, Nozick is
begging the question -- he is assuming the thing he is trying to prove.

Ignoring these obvious issues, what of Nozick's actual argument?

The first thing to note is that it is a fairy tale, it is a myth. The current
property system and its distribution of resources and ownership rights is a
product of thousands of years of conflict, coercion and violence. As such,
given Nozick's arguments, it is illegitimate and the current owners have no
right to deprive others of access to them or to object to taxation or
expropriation. However, it is precisely this conclusion which Nozick seeks to
eliminate by means of his story. By presenting an ahistoric thought
experiment, he hopes to convince the reader to ignore the actual history of
property in order to defend the current owners of property from
redistribution. Nozick's theory is only taken seriously because, firstly, it
assumes the very thing it is trying to justify (i.e. capitalist property
rights) and, as such, has a superficial coherence as a result and, secondly,
it has obvious political utility for the rich.

The second thing to note is that the argument itself is deeply flawed. To see
why, take (as an example) two individuals who share land in common. Nozick
allows for one individual to claim the land as their own as long as the
_"process normally giving rise to a permanent bequeathable property right in a
previously unowned thing will not do so if the position of others no longer at
liberty to use the thing is therefore worsened."_ [**Anarchy, State and
Utopia**, p. 178] Given this, one of our two land sharers can appropriate the
land as long as they can provide the other with a wage greater than what they
were originally producing. If this situation is achieved then, according to
Nozick, the initial appropriation was just and so are all subsequent market
exchanges. In this way, the unowned world becomes owned and a market system
based on capitalist property rights in productive resources (the land) and
labour develop.

Interestingly, for a ideology that calls itself "libertarian" Nozick's theory
defines _"worse off"_ in terms purely of material welfare, compared to the
conditions that existed within the society based upon common use. However, the
fact is if one person appropriated the land that the other cannot live off the
remaining land then we have a problem. The other person has no choice but to
agree to become employed by the landowner. The fact that the new land owner
offers the other a wage to work their land that exceeds what the new wage
slave originally produced may meet the _"Lockean Proviso"_ misses the point.
The important issue is that the new wage slave has no option but to work for
another and, as a consequence, becomes subject to that person's authority. In
other words, being _"worse off"_ in terms of liberty (i.e. autonomy or self-
government) is irrelevant for Nozick, a **very** telling position to take.

Nozick claims to place emphasis on self-ownership in his ideology because we
are separate individuals, each with our own life to lead. It is strange,
therefore, to see that Nozick does not emphasise people's ability to act on
their own conception of themselves in his account of appropriation. Indeed,
there is no objection to an appropriation that puts someone in an unnecessary
and undesirable position of subordination and dependence on the will of
others.

Notice that the fact that individuals are now subject to the decisions of
other individuals is not considered by Nozick in assessing the fairness of the
appropriation. The fact that the creation of private property results in the
denial of important freedoms for wage slaves (namely, the wage slave has no
say over the status of the land they had been utilising and no say over how
their labour is used). Before the creation of private property, all managed
their own work, had self-government in all aspects of their lives. After the
appropriation, the new wage slave has no such liberty and indeed must accept
the conditions of employment within which they relinquish control over how
they spend much of their time. That this is issue is irrelevant for the
Lockean Proviso shows how concerned about liberty capitalism actually is.

Considering Nozick's many claims in favour of self-ownership and why it is
important, you would think that the autonomy of the newly dispossessed wage
slaves would be important to him. However, no such concern is to be found --
the autonomy of wage slaves is treated as if it were irrelevant. Nozick claims
that a concern for people's freedom to lead their own lives underlies his
theory of unrestricted property-rights, but, this apparently does not apply to
wage slaves. His justification for the creation of private property treats
only the autonomy of the land owner as relevant. However, as Proudhon rightly
argues:

> _ "if the liberty of man is sacred, it is equally sacred in all individuals;
that, if it needs property for its objective action, that is, for its life,
the appropriation of material is equally necessary for all . . . Does it not
follow that if one individual cannot prevent another . . . from appropriating
an amount of material equal to his own, no more can he prevent individuals to
come."_ [**Op. Cit.**, pp. 84-85]

The implications of Nozick's argument become clear once we move beyond the
initial acts of appropriation to the situation of a developed capitalist
economy. In such a situation, **all** of the available useful land has been
appropriated. There is massive differences in who owns what and these
differences are passed on to the next generation. Thus we have a (minority)
class of people who own the world and a class of people (the majority) who can
only gain access to the means of life on terms acceptable to the former. How
can the majority really be said to own themselves if they may do nothing
without the permission of others (the owning minority).

Under capitalism people are claimed to own themselves, but this is purely
formal as most people do not have independent access to resources. And as they
have to use other peoples' resources, they become under the control of those
who own the resources. In other words, private property reduces the autonomy
of the majority of the population and creates a regime of authority which has
many similarities to enslavement. As John Stuart Mill put it:

> _ "No longer enslaved or made dependent by force of law, the great majority
are so by force of property; they are still chained to a place, to an
occupation, and to conformity with the will of an employer, and debarred by
the accident of birth to both the enjoyments, and from the mental and moral
advantages, which others inherit without exertion and independently of desert.
That this is an evil equal to almost any of those against which mankind have
hitherto struggles, the poor are not wrong in believing."_ [_"Chapters on
Socialism"_, **Principles of Political Economy**, pp. 377-8]

Capitalism, even though claiming formal self-ownership, in fact not only
restricts the self-determination of working class people, it also makes them a
resource for others. Those who enter the market after others have appropriated
all the available property are limited to charity or working for others. The
latter, as we discuss in [section C](secCcon.md), results in exploitation as
the worker's labour is used to enrich others. Working people are compelled to
co-operate with the current scheme of property and are forced to benefit
others. This means that self-determination requires resources as well as
rights over one's physical and mental being. Concern for self-determination
(i.e. meaningful self-ownership) leads us to common property plus workers'
control of production and so some form of libertarian socialism - **not**
private property and capitalism.

And, of course, the appropriation of the land requires a state to defend it
against the dispossessed as well as continuous interference in people's lives.
Left to their own devices, people would freely use the resources around them
which they considered unjustly appropriated by others and it is only
continuous state intervention that prevents then from violating Nozick's
principles of justice (to use Nozick's own terminology, the _"Lockean
Proviso"_ is a patterned theory, his claims otherwise not withstanding).

In addition, we should note that private ownership by one person presupposes
non-ownership by others (_"we who belong to the proletaire class, property
excommunicates us!"_ [Proudhon, **Op. Cit.**, p. 105]) and so the _"free
market"_ restricts as well as creates liberties just as any other economic
system. Hence the claim that capitalism constitutes _"economic liberty"_ is
obviously false. In fact, it is **based** upon denying liberty for the vast
majority during work hours (as well as having serious impacts on liberty
outwith work hours due to the effects of concentrations of wealth upon
society).

Perhaps Nozick can claim that the increased material benefits of private
property makes the acquisition justified. However, it seems strange that a
theory supporting "liberty" should consider well off slaves to be better than
poor free men and women. As Nozick claims that the wage slaves consent is not
required for the initial acquisition, so perhaps he can claim that the gain in
material welfare outweighs the loss of autonomy and so allows the initial act
as an act of paternalism. But as Nozick opposes paternalism when it restricts
private property rights he can hardly invoke it when it is required to
generate these rights. And if we exclude paternalism and emphasise autonomy
(as Nozick claims he does elsewhere in his theory), then justifying the
initial creation of private property becomes much more difficult, if not
impossible.

And if each owner's title to their property includes the historical shadow of
the Lockean Proviso on appropriation, then such titles are invalid. Any title
people have over unequal resources will be qualified by the facts that
_"property is theft"_ and that _"property is despotism."_ The claim that
private property is economic liberty is obviously untrue, as is the claim that
private property can be justified in terms of anything except _"might is
right."_

In summary, _"[i]f the right of life is equal, the right of labour is equal,
and so is the right of occupancy."_ This means that _"those who do not possess
today are proprietors by the same title as those who do possess; but instead
of inferring therefrom that property should be shared by all, I demand, in the
name of general security, its entire abolition."_ [Proudhon, **Op. Cit.**, p.
77 and p. 66] Simply put, if it is right for the initial appropriation of
resources to be made then, by that very same reason, it is right for others in
the same and subsequent generations to abolish private property in favour of a
system which respects the liberty of all rather than a few.

For more anarchist analysis on private property and why it cannot be justified
(be it by occupancy, labour, natural right, or whatever) consult Proudhon's
classic work What is Property?. For further discussion on capitalist property
rights see [section F.4](secF4.md).

## B.3.5 Is state owned property different from private property?

No, far from it.

State ownership should not be confused with the common or public ownership
implied by the concept of _"use rights."_ The state is a hierarchical
instrument of coercion and, as we discussed in [section B.2](secB2.md), is
marked by power being concentrated in a few hands. As the general populate is,
by design, excluded from decision making within it this means that the state
apparatus has control over the property in question. As the general public and
those who use a piece of property are excluded from controlling it, state
property is identical to private property. Instead of capitalists owning it,
the state bureaucracy does.

This can easily be seen from the example of such so-called _"socialist"_
states as the Soviet Union or China. To show why, we need only quote a market
socialist who claims that China is not capitalist. According to David
Schweickart a society is capitalist if, _"[i]n order to gain access to means
of production (without which no one can work), most people must contract with
people who own (or represent the owners of) such means. In exchange for a wage
of a salary, they agree to supply the owners with a certain quantity and
quality of labour. **It is a crucial characteristic of the institution of wage
labour that the goods or services produced do not belong to the workers who
produce them but to those who supply the workers with the means of
production.**"_ Anarchists agree with Schweickart's definition of capitalism.
As such, he is right to argue that a _"society of small farmers and artisans .
. . is not a capitalist society, since wage labour is largely absent."_ He is,
however, wrong to assert that a _"society in which most of [the] means of
production are owned by the central government or by local communities --
contemporary China, for example -- is not a capitalist society, since private
ownership of the means of production is not dominant."_ [**After Capitalism**,
p. 23]

The reason is apparent. As Emma Goldman said (pointing out the obvious), if
property is nationalised _"it belongs to the state; this is, the government
has control of it and can dispose of it according to its wishes and views . .
. Such a condition of affairs may be called state capitalism, but it would be
fantastic to consider it in any sense Communistic"_ (as that needs the
_"socialisation of the land and of the machinery of production and
distribution"_ which _"belong[s] to the people, to be settled and used by
individuals or groups according to their needs"_ based on _"free access"_).
[**Red Emma Speaks**, pp. 406-7]

Thus, by Schweickart's own definition, a system based on state ownership
**is** capitalist as the workers clearly do not own the own means of
production they use, the state does. Neither do they own the goods or services
they produce, the state which supplies the workers with the means of
production does. The difference is that rather than being a number of
different capitalists there is only one, the state. It is, as Kropotkin
warned, the _"mere substitution . . . of the State as the universal capitalist
for the present capitalists."_ [**Evolution and Environment**, p. 106] This is
why anarchists have tended to call such regimes _"state capitalist"_ as the
state basically replaces the capitalist as boss.

While this is most clear for regimes like China's which are dictatorships, the
logic also applies to democratic states. No matter if a state is democratic,
state ownership is a form of exclusive property ownership which implies a
social relationship which is totally different from genuine forms of
socialism. Common ownership and use rights produce social relationships based
on liberty and equality. State ownership, however, presupposes the existence
of a government machine, a centralised bureaucracy, which stands above the
members of society, both as individuals and as a group, and has the power to
coerce and dominate them. In other words, when a state owns the means of life,
the members of society remain proletarians, non-owners, excluded from control.
Both legally and in reality, the means of life belong not to them, but to the
state. As the state is not an abstraction floating above society but rather a
social institution made up of a specific group of human beings, this means
that this group controls and so effectively owns the property in question, not
society as a whole nor those who actually use it. Just as the owning class
excludes the majority, so does the state bureaucracy which means it owns the
means of production, whether or not this is formally and legally recognised.

This explains why libertarian socialists have consistently stressed workers'
self-management of production as the basis of any real form of socialism. To
concentrate on ownership, as both Leninism and social democracy have done,
misses the point. Needless to say, those regimes which have replaced
capitalist ownership with state property have shown the validity the anarchist
analysis in these matters (_"all-powerful, centralised Government with State
Capitalism as its economic expression,"_ to quote Emma Goldman's summation of
Lenin's Russia [**Op. Cit.**, p. 388]). State property is in no way
fundamentally different from private property -- all that changes is who
exploits and oppresses the workers.

For more discussion see section H.3.13 -- [_"Why is state socialism just state
capitalism?"_](secH3.md#sech313)

[‹ B.2 Why are anarchists against the state?](secB2.md "Go to previous page"
) [up](secBcon.md "Go to parent page" ) [B.4 How does capitalism affect
liberty? ›](secB4.md "Go to next page" )

