# FindPCAP search and find the libpcap library path
#
# The following variables are set:
# CMAKE_C_FLAGS - flags to add to the C compiler for build arpon
# CMAKE_INCLUDE - include path Cflag
# CMAKE_LIBS    - library path Cflag
#
# Copyright 2010 <Giuseppe Marco Randazzo> zeld@freaknet.org
#
# Redistribution AND use is allowed according to the terms of the New
# BSD license.

find_path(PCAP_INCLUDE_DIR ${libpcap_h} ${CMAKE_INCLUDE_PATH})

find_path(PCAP_LIB_DIR ${libpcap} ${CMAKE_LIBRARY_PATH})

find_library(PCAP_LIBRARY NAMES ${libpcap} PATH ${CMAKE_LIBRARY_PATH})

if(PCAP_INCLUDE_DIR AND PCAP_LIB_DIR AND PCAP_LIBRARY )
  message(STATUS "Found Libpcap.")

  if(NOT ${INCLUDE_DIR} MATCHES ${PCAP_INCLUDE_DIR})
    include_directories(${PCAP_INCLUDE_DIR})
    set(INCLUDE_DIR "${INCLUDE_DIR} ${PCAP_INCLUDE_DIR}")
  endif(NOT ${INCLUDE_DIR} MATCHES ${PCAP_INCLUDE_DIR})

  if(NOT ${LIB_DIR} MATCHES ${PCAP_LIB_DIR})
    link_directories(${PCAP_LIB_DIR})
    set(LIB_DIR "${LIB_DIR} ${PCAP_LIB_DIR}")
  endif(NOT ${LIB_DIR} MATCHES ${PCAP_LIB_DIR})

else(NOT PCAP_INCLUDE_DIR OR NOT PCAP_LIB_DIR OR NOT PCAP_LIBRARY)
  message(FATAL_ERROR " Libpcap not found! Please visit http://www.tcpdump.org/ or see in the arpon 'INSTALL' file.")
endif(PCAP_INCLUDE_DIR AND PCAP_LIB_DIR AND PCAP_LIBRARY)
