/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:26:26 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import java.util.NoSuchElementException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeaturePredicateConjunction;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FilteredEntryGroup_ESTest extends FilteredEntryGroup_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, "");
      Entry entry0 = Entry.newEntry((Bases) null);
      filteredEntryGroup0.addElement(entry0);
      filteredEntryGroup0.setIsActive(entry0, true);
      assertEquals(0, entry0.getFeatureCount());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "yP~}-(\"VZ");
      Entry entry0 = filteredEntryGroup0.createEntry("`wum;u^?~*");
      boolean boolean0 = filteredEntryGroup0.isActive(entry0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(2);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry((String) null);
      Entry entry1 = entry0.truncate(bases0, range0);
      int int0 = filteredEntryGroup0.indexOf(entry1);
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      int int0 = filteredEntryGroup0.getSequenceLength();
      assertEquals(12, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, "");
      Entry entry0 = Entry.newEntry((Bases) null);
      filteredEntryGroup0.addElement(entry0);
      Entry entry1 = filteredEntryGroup0.getSequenceEntry();
      assertSame(entry1, entry0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("]:G");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "]:G");
      String string0 = filteredEntryGroup0.getFilterName();
      assertEquals("]:G", string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "~");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "O9Q4O.;#& GG");
      Bases bases0 = filteredEntryGroup0.getBases();
      assertNull(bases0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("s4OI\u0002qN%%8?u");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "s4OI\u0002qN%%8?u");
      filteredEntryGroup0.createEntry("s4OI\u0002qN%%8?u");
      EntryVector entryVector0 = filteredEntryGroup0.getActiveEntries();
      assertEquals(1, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(2);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInRange(range0);
      FeatureVector featureVector1 = filteredEntryGroup0.filterFeatures(featureVector0);
      assertNotSame(featureVector1, featureVector0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInIndexRange((-1), (-930));
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "internal error in FeatureDisplay.setScaleValue() - scale value must be positive");
      FeatureVector featureVector1 = filteredEntryGroup0.filterFeatures();
      assertFalse(featureVector1.equals((Object)featureVector0));
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "PHRED");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.reverseComplement();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("BUG: VariantContextBuilder parent argument cannot be null in VariantContextBuilder");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.removeElement((Entry) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("I<M;D4|^;$U]");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "I<M;D4|^;$U]", "I<M;D4|^;$U]", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "2G");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.getFeaturesInIndexRange(0, 0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.filterFeatures((FeatureVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.featureAt((-2953));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "show_reverse_lines");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.entryChanged((EntryChangeEvent) null);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.FilteredEntryGroup$2 cannot be cast to uk.ac.sanger.artemis.FeatureChangeListener
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      filteredEntryGroup0.createEntry((String) null);
      // Undeclared exception!
      filteredEntryGroup0.createEntry("10nl8OgX:");
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("s4OI\u0002qN%%8?u");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "s4OI\u0002qN%%8?u");
      filteredEntryGroup0.createEntry("s4OI\u0002qN%%8?u");
      // Undeclared exception!
      filteredEntryGroup0.createEntry();
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.contains((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = null;
      try {
        filteredEntryGroup0 = new FilteredEntryGroup((EntryGroup) null, featureVector0, "$)lyzuq?5W");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FeaturePredicateConjunction featurePredicateConjunction0 = new FeaturePredicateConjunction((FeaturePredicate) null, (FeaturePredicate) null, 0);
      FilteredEntryGroup filteredEntryGroup0 = null;
      try {
        filteredEntryGroup0 = new FilteredEntryGroup((EntryGroup) null, featurePredicateConjunction0, "");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("_qXxnkQVL\u0000i%-Fmg(t");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.addEntryChangeListener(selection0);
      assertEquals(0, filteredEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "4mo(=#6d2");
      filteredEntryGroup0.addFeatureChangeListener(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      filteredEntryGroup0.addEntryGroupChangeListener(actionController0);
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      FeatureEnumeration featureEnumeration0 = filteredEntryGroup0.features();
      assertNotNull(featureEnumeration0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Intrinsic Codon Deviation Index");
      FilteredEntryGroup.FeatureEnumerator filteredEntryGroup_FeatureEnumerator0 = filteredEntryGroup0.new FeatureEnumerator();
      try { 
        filteredEntryGroup_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup$FeatureEnumerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, (String) null);
      filteredEntryGroup0.createEntry("&tZV`/lC*");
      FilteredEntryGroup.FeatureEnumerator filteredEntryGroup_FeatureEnumerator0 = filteredEntryGroup0.new FeatureEnumerator();
      try { 
        filteredEntryGroup_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FilteredEntryGroup$FeatureEnumerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "show_reverse_lines");
      FilteredEntryGroup.FeatureEnumerator filteredEntryGroup_FeatureEnumerator0 = filteredEntryGroup0.new FeatureEnumerator();
      boolean boolean0 = filteredEntryGroup_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.getFeaturesInIndexRange((-301), (-301));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("I<M;D4|^;$U]");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "I<M;D4|^;$U]", "I<M;D4|^;$U]", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "2G");
      FeatureVector featureVector0 = filteredEntryGroup0.getFeaturesInIndexRange(0, (-3374));
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      Bases bases1 = filteredEntryGroup0.getBases();
      assertSame(bases0, bases1);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      Entry entry0 = simpleEntryGroup0.createEntry("Options");
      boolean boolean0 = filteredEntryGroup0.removeElement(entry0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "8Lp|I9CGZBF;:", true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "8Lp|I9CGZBF;:");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.remove((Entry) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInIndexRange((-1), (-930));
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "internal error in FeatureDisplay.setScaleValue() - scale value must be positive");
      Range range0 = new Range((-1577));
      // Undeclared exception!
      try { 
        filteredEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry();
      assertEquals(0, entry0.getFeatureCount());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("wq+Ok^|_&uP=A=Q:lu");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.reverseComplement();
      assertEquals("", filteredEntryGroup0.getFilterName());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("]:G");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "]:G");
      boolean boolean0 = filteredEntryGroup0.isActive((Entry) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      filteredEntryGroup0.removeEntryChangeListener(simpleEntryGroup0);
      assertEquals(0, filteredEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "the %s tag has the incorrect number of records at position %s:%d, %d vs. %d");
      filteredEntryGroup0.ref();
      assertEquals("the %s tag has the incorrect number of records at position %s:%d, %d vs. %d", filteredEntryGroup0.getFilterName());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("{bxbp2f;s5/hW`");
      FeatureVector featureVector0 = entry0.checkForMissingQualifiers();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "+J+@*/;5|?X0$]!{");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 0);
      filteredEntryGroup0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(2, EntryGroupChangeEvent.ENTRY_ADDED);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      String string0 = filteredEntryGroup0.getFilterName();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "1h, C\"T$CaJZ^oW");
      Range range0 = new Range(2002, 2002);
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(range0, (Entry) null, 2002);
      filteredEntryGroup0.entryChanged(entryChangeEvent0);
      assertEquals(4, EntryChangeEvent.HEADER_CHANGED);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("BUG: VariantContextBuilder parent argument cannot be null in VariantContextBuilder");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      Entry entry0 = filteredEntryGroup0.getDefaultEntry();
      assertNull(entry0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("I<M;D4|^;$U]");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "I<M;D4|^;$U]", "I<M;D4|^;$U]", true, true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "2G");
      ActionController actionController0 = new ActionController();
      filteredEntryGroup0.removeEntryGroupChangeListener(actionController0);
      assertEquals(0, filteredEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      FeatureVector featureVector1 = filteredEntryGroup0.getAllFeatures();
      assertNotSame(featureVector0, featureVector1);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "4mo(=#6d2");
      filteredEntryGroup0.removeFeatureChangeListener(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "1h, C\"T$CaJZ^oW");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.addElement((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("A9v)Q,!");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Yh>Zj 3J,iw8zQ");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.featureAt(0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "Filters by class must be over Feature classes: ");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.getSequenceLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate((FeatureVector) null);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, (String) null);
      // Undeclared exception!
      try { 
        filteredEntryGroup0.setIsActive((Entry) null, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      boolean boolean0 = filteredEntryGroup0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(")a=mi7]X}9JN");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "At,`:Cdi:}NXal");
      boolean boolean0 = filteredEntryGroup0.hasUnsavedChanges();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "?#&c:7c)");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.elementAt((-2223));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(bases0.letter_index, true);
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate(aminoAcidSequence0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.setIsActive(2, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 2 >= 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      ActionController actionController0 = filteredEntryGroup0.getActionController();
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      FeatureVector featureVector1 = filteredEntryGroup0.getFeaturesInRange((Range) null);
      assertNotSame(featureVector0, featureVector1);
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("wq+Ok^|_&uP=A=Q:lu");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.unref();
      assertEquals(0, filteredEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("s4OI\u0002qN%%8?u");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "s4OI\u0002qN%%8?u");
      EntryVector entryVector0 = filteredEntryGroup0.getActiveEntries();
      assertEquals(0, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(2);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInRange(range0);
      FilteredEntryGroup filteredEntryGroup1 = new FilteredEntryGroup(filteredEntryGroup0, featureVector0, "");
      Entry entry0 = filteredEntryGroup1.createEntry((String) null);
      Feature feature0 = entry0.createFeature();
      int int0 = filteredEntryGroup1.indexOf(feature0);
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("s4OI\u0002qN%%8?u");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "s4OI\u0002qN%%8?u");
      int int0 = filteredEntryGroup0.getAllFeaturesCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("2u$Q:[vwN{i#x2");
      filteredEntryGroup0.add(entry0);
      assertEquals(0, entry0.getFeatureCount());
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "8Lp|I9CGZBF;:", true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "8Lp|I9CGZBF;:");
      Entry entry0 = filteredEntryGroup0.getSequenceEntry();
      assertNull(entry0);
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry("&tZV`/lC*");
      filteredEntryGroup0.setDefaultEntry(entry0);
      assertNull(filteredEntryGroup0.getFilterName());
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "mL3pj1;[@s=Qdx&");
      int int0 = filteredEntryGroup0.size();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "BOANX*3SWp");
      filteredEntryGroup0.featureChanged((FeatureChangeEvent) null);
      assertEquals("BOANX*3SWp", filteredEntryGroup0.getFilterName());
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("empty attribute value for ", (String) null);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("10nl8OgX:");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry((String) null);
      filteredEntryGroup0.indexOf(entry0);
  }
}
