/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 18:51:20 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import org.junit.runner.RunWith;

import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.RenderingHints.Key;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import uk.ac.sanger.artemis.components.filetree.FileList;
import uk.ac.sanger.artemis.components.filetree.FileNode;
import uk.ac.sanger.artemis.components.filetree.FileSystemModel;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class FileSystemModel_ESTest extends FileSystemModel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      File[] fileArray0 = new File[3];
      FileSystemModel fileSystemModel0 = null;
      try {
        fileSystemModel0 = new FileSystemModel(fileArray0, (FileFilter) null, (JFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      File file0 = MockFile.createTempFile(" to a subdirectory of itself: ", " to a subdirectory of itself: ");
      FileNode fileNode0 = new FileNode(file0);
      boolean boolean0 = fileSystemModel0.isLeaf(fileNode0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Object object0 = fileSystemModel0.getRoot();
      boolean boolean0 = fileSystemModel0.isLeaf(object0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileFilter fileFilter0 = fileSystemModel0.getFilter();
      assertNotNull(fileFilter0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      String[] stringArray0 = new String[1];
      FileSystemModel.cNames = stringArray0;
      String string0 = fileSystemModel0.getColumnName(0);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      String string0 = fileSystemModel0.getColumnName(1);
      assertEquals("Size", string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      String[] stringArray0 = new String[0];
      FileSystemModel.cNames = stringArray0;
      int int0 = fileSystemModel0.getColumnCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Class class0 = fileSystemModel0.getColumnClass(2);
      assertEquals(17, class0.getModifiers());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("xW", "xW");
      FileNode fileNode0 = new FileNode(mockFile0);
      Object[] objectArray0 = fileSystemModel0.getChildren(fileNode0);
      assertNull(objectArray0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.isLeaf((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      JPopupMenu.Separator jPopupMenu_Separator0 = new JPopupMenu.Separator();
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt(jPopupMenu_Separator0, 0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // javax.swing.JPopupMenu$Separator cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileSystemModel.cNames = null;
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnName((-1462));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileSystemModel.cTypes = null;
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnClass((-3443));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnClass((-3443));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -3443
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildren((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_ON;
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildren(integer0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Integer cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      File[] fileArray0 = new File[3];
      File file0 = MockFile.createTempFile("*E7Gr)E4b5It#*{p", "*E7Gr)E4b5It#*{p");
      fileArray0[0] = file0;
      fileArray0[1] = file0;
      fileArray0[2] = file0;
      FileSystemModel fileSystemModel0 = new FileSystemModel(fileArray0, (FileFilter) null, (JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildCount((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      String[] stringArray0 = new String[3];
      stringArray0[0] = "";
      stringArray0[1] = "wZ1yUr1lvL]q1Nzk\"k";
      stringArray0[2] = "{ P5rFx";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildCount("");
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild((Object) null, 1071);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Object object0 = fileSystemModel0.getRoot();
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild(object0, 8824);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 8824
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("Artemis", "Artemis", (FileList) null, "Artemis", true);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild(remoteFileNode0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      FileSystemModel fileSystemModel0 = null;
      try {
        fileSystemModel0 = new FileSystemModel((String[]) null, (JFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt((Object) null, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt((Object) null, 1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileNode fileNode0 = (FileNode)fileSystemModel0.getRoot();
      String string0 = (String)fileSystemModel0.getValueAt(fileNode0, 2);
      assertNotNull(string0);
      assertEquals("Feb 14 20:21 2014", string0);
      assertTrue(fileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("Bf");
      FileNode fileNode0 = new FileNode(mockFile0);
      Object object0 = fileSystemModel0.getValueAt(fileNode0, 2);
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileNode fileNode0 = (FileNode)fileSystemModel0.getRoot();
      Integer integer0 = (Integer)fileSystemModel0.getValueAt(fileNode0, 1);
      assertNull(integer0);
      assertTrue(fileNode0.getAllowsChildren());
      assertFalse(fileNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileNode fileNode0 = (FileNode)fileSystemModel0.getRoot();
      String string0 = (String)fileSystemModel0.getValueAt(fileNode0, 0);
      assertNotNull(string0);
      assertTrue(fileNode0.getAllowsChildren());
      assertTrue(fileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("^", "^");
      FileNode fileNode0 = new FileNode(mockFile0);
      Object object0 = fileSystemModel0.getValueAt(fileNode0, (-725));
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Key key0 = RenderingHints.KEY_COLOR_RENDERING;
      Object object0 = fileSystemModel0.getValueAt(key0, 41);
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("^", "^");
      FileNode fileNode0 = new FileNode(mockFile0);
      int int0 = fileSystemModel0.getChildCount(fileNode0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      File[] fileArray0 = new File[3];
      File file0 = MockFile.createTempFile("*E7Gr)E4b5It#*{p", "*E7Gr)E4b5It#*{p");
      fileArray0[0] = file0;
      fileArray0[1] = file0;
      fileArray0[2] = file0;
      FileSystemModel fileSystemModel0 = new FileSystemModel(fileArray0, (FileFilter) null, (JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild("*E7Gr)E4b5It#*{p", 3);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      String[] stringArray0 = new String[2];
      stringArray0[0] = "'-SAcuwg3-8q&,q:";
      stringArray0[1] = "'-SAcuwg3-8q&,q:";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      JTree jTree0 = null;
      try {
        jTree0 = new JTree(fileSystemModel0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("^", "^");
      MockFile.createTempFile("\nPrivate SOAP service: ", "\nPrivate SOAP service: ", (File) mockFile0);
      FileNode fileNode0 = new FileNode(mockFile0);
      int int0 = fileSystemModel0.getChildCount(fileNode0);
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      MockFile mockFile0 = new MockFile("^");
      MockFile.createTempFile(".}_vFZxq!B>0.tmp", ".}_vFZxq!B>0.tmp", (File) mockFile0);
      FileNode fileNode0 = new FileNode(mockFile0);
      int int0 = fileSystemModel0.getChildCount(fileNode0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileNode fileNode0 = (FileNode)fileSystemModel0.getRoot();
      FileNode fileNode1 = (FileNode)fileNode0.getNextNode();
      fileNode0.add(fileNode1);
      FileNode fileNode2 = (FileNode)fileSystemModel0.getChild(fileNode0, 0);
      Object[] objectArray0 = fileSystemModel0.getChildren(fileNode2);
      assertEquals(1, objectArray0.length);
      assertFalse(fileNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnName((-1462));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1462
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileNode fileNode0 = (FileNode)fileSystemModel0.getRoot();
      FileNode fileNode1 = (FileNode)fileSystemModel0.getChild(fileNode0, 0);
      assertNotNull(fileNode1);
      
      Object[] objectArray0 = fileSystemModel0.getChildren(fileNode1);
      assertTrue(fileNode0.getAllowsChildren());
      assertEquals(0, objectArray0.length);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      int int0 = fileSystemModel0.getColumnCount();
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Class class0 = fileSystemModel0.getColumnClass(0);
      assertEquals(1537, class0.getModifiers());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      File[] fileArray0 = new File[3];
      File file0 = MockFile.createTempFile("*E7Gr)E4b5It#*{p", "*E7Gr)E4b5It#*{p");
      fileArray0[0] = file0;
      fileArray0[1] = file0;
      fileArray0[2] = file0;
      FileSystemModel fileSystemModel0 = new FileSystemModel(fileArray0, (FileFilter) null, (JFrame) null);
      FileFilter fileFilter0 = fileSystemModel0.getFilter();
      assertNull(fileFilter0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      File[] fileArray0 = new File[3];
      File file0 = MockFile.createTempFile("*E7Gr)E4b5It#*{p", "*E7Gr)E4b5It#*{p");
      fileArray0[0] = file0;
      fileArray0[1] = file0;
      fileArray0[2] = file0;
      FileSystemModel fileSystemModel0 = new FileSystemModel(fileArray0, (FileFilter) null, (JFrame) null);
      JPopupMenu.Separator jPopupMenu_Separator0 = new JPopupMenu.Separator();
      // Undeclared exception!
      try { 
        fileSystemModel0.isLeaf(jPopupMenu_Separator0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // javax.swing.JPopupMenu$Separator cannot be cast to javax.swing.tree.TreeNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      ArrayList<IOFileFilter> arrayList0 = new ArrayList<IOFileFilter>();
      OrFileFilter orFileFilter0 = new OrFileFilter(arrayList0);
      fileSystemModel0.setFilter(orFileFilter0);
      assertEquals(3, fileSystemModel0.getColumnCount());
  }
}
