/****************************************************************
**
** Attal : Lords of Doom
**
** loadGame.h
** manage loading of scenarii and campaigns
**
** Version : $Id: loadGame.h,v 1.17 2007/10/23 22:15:50 lusum Exp $
**
** Author(s) : Sardi Carlo
**
** Date : 11/10/2006
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef LOADGAME_H
#define LOADGAME_H

// generic include files
// include files for QT
#include <QObject>
#include <QList>
// application specific includes

#include "libServer/attalServer.h"

class Campaign;
class Engine;

class LoadGame
{
public:

	enum StatusWidget {
		W_NORMAL,
		W_CLIENT,
		W_ENGINE
	};
	
	LoadGame();
	
	virtual ~LoadGame();

	void initEngine();

	void load( const QString  & filename);

	void loadCampaign(QString fileName);

	void loadSingle(const QString & filename);
	
	virtual void addInternalAI();
	
	virtual	void disconnectAI() = 0;

	bool fillWithAI(const QString  & filename);
	
	void endGame();

	void reinitStatus();
	
	virtual void endEngine() = 0;
	
	virtual	void endServer() = 0;
	
	virtual	bool killAI() { return true; }
				
	virtual void adjustWidgetLoading( StatusWidget type ) = 0;

	void autosave();
	
	void save();
	
	void save(QString filename);

	QString getFileName(QString filename);

	void continueCampaign( bool next );

protected:
	
	void newEngine();

	void loadScenario( int num );
	
	void handleResult(bool result);
	
	bool _readyIn, _winner, _readyOut;
	bool _aiDbg;

	AttalServer * _server;
	Engine * _engine;
	
private:
	bool _inLoad;
};

#endif // LOADGAME_H
