#!/bin/bash

exec_prefix="${FRICAS_PREFIX:-/usr}"
FRICAS="${exec_prefix}/lib/fricas/target/x86_64-linux-gnu"
export FRICAS

INPUT=${exec_prefix}/share/fricas/input

REGRESS="agcd array bezout bugs2007 bugs2008  bugs2009  bugs2010 bugs2011  bugs2012  bugs2013  bugs2014 \
         bugs2015  bugs2016  bugs2017  bugs2018 bugs2019  bugs2020 charpol cyldec derham dirichlet discrgrp distro \
         ellip expps finite free_mod fun gpresent integ intlocp isprime limit linalg2 lll lode lodo2 lodof lodof2 \
         mantepse matcat mts ncalg ord pgcd polylift psgenfcn series3 ssolve table tensor vsbasis"

if [ $# -gt 0 ] ; then
	j=$@
else
        j=$REGRESS
fi

k=$(mktemp XXXXXX -p /tmp --suffix=.input)
trap "rm -f $k" exit

for i in $j ; do 
	cat >$k <<EOF
)set message test on
)set message auto off
)read $INPUT/$i.input
)lisp (quit)
EOF

	echo Testing $i
	echo ")read \"$k\"" | $(find /usr/lib/fricas -name FRICASsys) >/tmp/$i.output

done

awk -f $INPUT/check_result $(for i in $j; do echo /tmp/$i.output; done)
