
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HiLoTechniqueAttributes.h
    \\brief Definition of HiLoTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "HiLoTechniqueWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



HiLoTechniqueWrapper::HiLoTechniqueWrapper(): hilotechnique_(new HiLoTechnique())


{


	

}
HiLoTechniqueWrapper::HiLoTechniqueWrapper(HiLoTechnique* hilotechnique): hilotechnique_(hilotechnique)
{

	
}

HiLoTechniqueWrapper::~HiLoTechniqueWrapper()
{

}

void HiLoTechniqueWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("CONTOUR_HILO_HEIGHT") ) {
		double contour_hilo_height_value = request("CONTOUR_HILO_HEIGHT");
		hilotechnique_->contour_hilo_height_ = contour_hilo_height_value;
		}
	if  (request.countValues("CONTOUR_HILO_FORMAT") ) {
		string format_value = request("CONTOUR_HILO_FORMAT");
		hilotechnique_->format_ = format_value;
		}
	
	if  (request.countValues("CONTOUR_HI_COLOUR") ) {
		string hi_colour_value = request("CONTOUR_HI_COLOUR");
		hilotechnique_->hi_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(hi_colour_value));
	}
		
	if  (request.countValues("CONTOUR_LO_COLOUR") ) {
		string lo_colour_value = request("CONTOUR_LO_COLOUR");
		hilotechnique_->lo_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(lo_colour_value));
	}
		
	
}

void HiLoTechniqueWrapper::print(ostream& out)  const
{
	out << "HiLoTechniqueWrapper[]";
}




