/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtVectorMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Init utility for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtVectorMetaData::Init()
{
    varDim = 0;

    avtVectorMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Copy utility for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtVectorMetaData::Copy(const avtVectorMetaData &obj)
{
    varDim = obj.varDim;

    avtVectorMetaData::SelectAll();
}

// Type map format string
const char *avtVectorMetaData::TypeMapFormatString = AVTVECTORMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtVectorMetaData::TmfsStruct = {AVTVECTORMETADATA_TMFS};


// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Default constructor for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData() : 
    avtVarMetaData(avtVectorMetaData::TmfsStruct)
{
    avtVectorMetaData::Init();
}

// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtVectorMetaData::Init();
}

// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Copy constructor for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData(const avtVectorMetaData &obj) : 
    avtVarMetaData(obj,avtVectorMetaData::TmfsStruct)
{
    avtVectorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtVectorMetaData::avtVectorMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData(const avtVectorMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtVectorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtVectorMetaData::~avtVectorMetaData
//
// Purpose: 
//   Destructor for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData::~avtVectorMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtVectorMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVectorMetaData& 
avtVectorMetaData::operator = (const avtVectorMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtVectorMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtVectorMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVectorMetaData::operator == (const avtVectorMetaData &obj) const
{
    // Create the return value
    return ((varDim == obj.varDim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtVectorMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVectorMetaData::operator != (const avtVectorMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtVectorMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtVectorMetaData::TypeName() const
{
    return "avtVectorMetaData";
}

// ****************************************************************************
// Method: avtVectorMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVectorMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtVectorMetaData *tmp = (const avtVectorMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtVectorMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtVectorMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtVectorMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtVectorMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtVectorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtVectorMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtVectorMetaData(*this);
    else
        retval = new avtVectorMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtVectorMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtVectorMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_varDim, (void *)&varDim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtVectorMetaData::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtVectorMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_varDim: return "varDim";
    default:  return avtVarMetaData::GetFieldName(index);
    }
}

// ****************************************************************************
// Method: avtVectorMetaData::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
avtVectorMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_varDim: return FieldType_int;
    default:  return avtVarMetaData::GetFieldType(index);
    }
}

// ****************************************************************************
// Method: avtVectorMetaData::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtVectorMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_varDim: return "int";
    default:  return avtVarMetaData::GetFieldTypeName(index);
    }
}

// ****************************************************************************
// Method: avtVectorMetaData::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVectorMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtVectorMetaData &obj = *((const avtVectorMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_varDim:
        {  // new scope
        retval = (varDim == obj.varDim);
        }
        break;
    default: retval = avtVarMetaData::FieldsEqual(index_, rhs);
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtVectorMetaData constructor
//
//  Arguments:
//      n           The name of the vector variable.
//      mn          The name of the mesh the vector var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//
//  Programmer: Hank Childs
//  Creation:   August 25, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:48:31 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Brad Whitlock, Fri Mar 2 15:33:10 PST 2007
//    Updated.
//
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData(std::string n, std::string mn, 
                                     avtCentering c, int vd)
    : avtVarMetaData(avtVectorMetaData::TmfsStruct, n, mn, c)
{
    avtVectorMetaData::Init();
    varDim = vd;
}

// ****************************************************************************
//  Method: avtVectorMetaData constructor
//
//  Arguments:
//      n           The name of the vector variable.
//      mn          The name of the mesh the vector var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//      extents     The extents of the variable.
//
//  Programmer: Hank Childs
//  Creation:   August 25, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:48:55 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************

avtVectorMetaData::avtVectorMetaData(std::string n, std::string mn,
                                     avtCentering c, int vd,
                                     const double *extents)
    : avtVarMetaData(avtVectorMetaData::TmfsStruct, n, mn, c)
{
    avtVectorMetaData::Init();
    varDim = vd;
    SetExtents(extents);
}

// ****************************************************************************
//  Method: avtVectorMetaData::SetExtents
//
//  Purpose:
//      Sets the extents of the vector
//
//  Arguments:
//      extents     vector extents as <min_v1, max_v1, min_v2, max_v2, ...>.
//
//  Programmer: Hank Childs
//  Creation:   August 30, 2000
//
//  Modifications:
//
//    Hank Childs, Tue May  1 12:53:10 PDT 2001
//    Check for NULL extents.
//
//    Kathleen Bonnell, Thu Mar 11 10:59:14 PST 2004 
//    DataExtents now only has 2 components. 
//
// ****************************************************************************

void
avtVectorMetaData::SetExtents(const double *extents)
{
    if (extents == NULL)
    {
        hasDataExtents = false;
    }
    else
    {
        hasDataExtents = true;
        minDataExtents = extents[0];
        maxDataExtents = extents[1];
    }
}

void
avtVectorMetaData::UnsetExtents()
{
    hasDataExtents = false;
}

// ****************************************************************************
//  Method: avtVectorMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    August 28, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Added validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:51:08 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtVectorMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);
    Indent(out, indent);
    out << "Variable Dimension = " << varDim << endl;
}

