.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_sqlite n "March 2018" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_sqlite \- implements a bridge between PostgreSQL and Sqlite3 using the Pgtcl and sqlite3 packages. 
.SH SYNOPSIS
.nf

pg_sqlite \*(T<sqlite_db\*(T> \*(T<command\*(T> [args]
.fi
.SH DESCRIPTION
\*(T<\fBpg_sqlite\fR\*(T> can import the results of a Postgres SQL query
(previously made via \*(T<\fBpg_exec\fR\*(T>)
directly into an sqlite3 table, export the results of an Sqlite SQL query into
a Postgres table (via \*(T<write_tabsep\*(T>), or import TSV files directly into sqlite3.
.PP
The commands currently implemented are import_postgres_result, read_tabsep, write_tabsep, and read_tabsep_keylist.
.SH ARGUMENTS
.TP 
\*(T<sqlite_db\*(T>
An Sqlite3 database handle previously created via the \*(T<sqlite3\*(T> command.
.TP 
\*(T<command\*(T>
The command, one of
\*(T<info\*(T>,
\*(T<import_postgres_result\*(T>,
\*(T<read_tabsep\*(T>,
\*(T<write_tabsep\*(T>, or
\*(T<read_tabsep_keylist\*(T>,
.TP 
\*(T<args\*(T>
Command-specific arguments.
.SH COMMANDS
\fBinfo\fR
.nf

    \*(T<\fBpg_sqlite\fR\*(T> \*(T<sqlite_db\*(T> info
	[\-busy]
	[\-filename]
	[\-db \*(T<database_name\*(T>]
   
.fi
.PP
Request information from an SQLITE database connection. Returns a key-value list containing the values requested if available. With no arguments, all available info is returned.
.TP 
-filename
Request the filename associated with a database.
.TP 
-db \*(T<database\*(T>
For the -filename option, specify the database name (default "main").
.TP 
-busy
Request a list of prepared commands that are currently busy.
.PP
\fBimport_postgres_result\fR
.nf

    \*(T<\fBpg_sqlite\fR\*(T> \*(T<sqlite_db\*(T> import_postgres_result \*(T<handle\*(T>
	[\-rowbyrow]
	[\-sql \*(T<target_sql\*(T>]
	[\-create \*(T<new_table\*(T>]
	[\-into \*(T<table\*(T>]
	[\-replace]
	[\-as \*(T<name_type_list\*(T>]
	[\-types \*(T<type_list\*(T>]
	[\-names \*(T<name_list\*(T>]
	[\-pkey \*(T<primary_key\*(T>]
	[\-sep \*(T<separator\*(T>]
	[\-null \*(T<null_string\*(T>]
	[\-poll_interval \*(T<rows\*(T>]
	[\-recommit \*(T<rows\*(T>]
	[\-check]
	[\-max \*(T<column\-name variable\-name\*(T>]
   
.fi
.PP
Import the result of a PostgreSQL request into an sqlite3 table.
.TP 
\*(T<handle\*(T>
A database or result handle. Normally, you would call \*(T<\fBpg_exec\fR\*(T> and pass the result
handle to \*(T<\fBpg_sqlite\fR\*(T> here. If you are using row_by_row mode, though, you use pg_sendquery and pass the
PostgreSQL database handle here.
.TP 
-rowbyrow
Perform the request using row-by-row mode. This injects the data to sqlite directly without making
an internal copy, but the result may be incomplete or inconsistent if an error occurs during the
request.
.TP 
-sep \*(T<separator\*(T>
String to use to separate columns. Default is "\et" (tab).
.TP 
-null \*(T<null_string\*(T>
String to use to indicate a null value. Default is to treat all strings literally.
.TP 
-sql \*(T<target_sql\*(T>
An INSERT statement, suitable to be compiled into a prepared statement to be applied to each row.
For example "INSERT INTO newtable (id, name, value) VALUES (?,?,?)"
.TP 
-create \*(T<new_table\*(T>
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP 
-into \*(T<table\*(T>
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP 
-replace
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP 
-as \*(T<name\-type\-list\*(T>
A list of alternating column names and types. See note on types.
.TP 
-types \*(T<type\-list\*(T>
A list of column types. See note on types.
.TP 
-names \*(T<name\-list\*(T>
A list of column names.
.TP 
-pkey \*(T<primary_key\*(T>
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR.
.TP 
-poll_interval \*(T<count\*(T>
Call DoOneEvent() every \*(T<count\*(T> rows to keep the event loop alive
during long transactions.
.TP 
-recommit \*(T<count\*(T>
Chunk the operation in transactions, with one transaction every \*(T<count\*(T> rows.
.TP 
-check
Check (via a SELECT) whether the exact row is already present, and skip inserting the row if so. This
avoids bloating the WAL log during large re-loads of databases, at some performance cost.
.TP 
-max \*(T<column\-name variable\-name\*(T>
Set $variable-name to the maximum value of column-name imported.
.PP
\fBwrite_tabsep\fR
.nf

    \*(T<\fBpg_sqlite\fR\*(T> \*(T<sqlite_db\*(T> write_tabsep \*(T<handle\*(T> \*(T<sql\*(T>
	[\*(T<sql\*(T>]
	[\-sep \*(T<separator\*(T>]
	[\-null \*(T<null_string\*(T>]
	[\-poll_interval \*(T<rows\*(T>]
   
.fi
.PP
Write the results of the provided \*(T<sql\*(T> to a file handle
.PP
This command may be used to export sqlite3 data to postgres. You issue a \fBCOPY FROM STDIN ... FORMAT text\fR command, then use \fBpg_sqlite write_tabsep ...\fR to write the data directly to the Postgresql handle, followed by writing the terminator line to the same handle. See the PostgreSQL documentation on the "COPY" command for more details.
.TP 
\*(T<handle\*(T>
File handle.
.TP 
-sep \*(T<separator\*(T>
String to use to separate columns. Default is "\et" (tab).
.TP 
-null \*(T<null_string\*(T>
String to use to indicate a null value. Default is to treat all strings literally.
.TP 
-poll_interval \*(T<count\*(T>
Call DoOneEvent() every \*(T<count\*(T> rows to keep the event loop alive
during long transactions.
.PP
\fBread_tabsep\fR
.nf

    \*(T<\fBpg_sqlite\fR\*(T> \*(T<sqlite_db\*(T> read_tabsep
	[\-row \*(T<single_tab_separated_row\*(T>]
	[\-file \*(T<file_handle\*(T>]
	[\-sql \*(T<target_sql\*(T>]
	[\-create \*(T<new_table\*(T>]
	[\-into \*(T<table\*(T>]
	[\-replace]
	[\-as \*(T<name_type_list\*(T>]
	[\-types \*(T<type_list\*(T>]
	[\-names \*(T<name_list\*(T>]
	[\-pkey \*(T<primary_key\*(T>]
	[\-sep \*(T<separator\*(T>]
	[\-null \*(T<null_string\*(T>]
	[\-poll_interval \*(T<rows\*(T>]
	[\-recommit \*(T<rows\*(T>]
	[\-check]
   
.fi
.PP
Read a previously opened file into an sqlite3 table.
.TP 
-row \*(T<single_tab_separated_row\*(T>
An already read tab-separated line.
.TP 
-file \*(T<file_handle\*(T>
An open file consistion of tab-separated rows.
.TP 
-sep \*(T<separator\*(T>
String to use to separate columns. Default is "\et" (tab).
.TP 
-null \*(T<null_string\*(T>
String to use to indicate a null value. Default is to treat all strings literally.
.TP 
-sql \*(T<target_sql\*(T>
An INSERT statement, suitable to be compiled into a prepared statement to be applied to each row.
For example "INSERT INTO newtable (id, name, value) VALUES (?,?,?)"
.TP 
-create \*(T<new_table\*(T>
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP 
-into \*(T<table\*(T>
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP 
-replace
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP 
-as \*(T<name\-type\-list\*(T>
A list of alternating column names and types. See note on types.
.TP 
-types \*(T<type\-list\*(T>
A list of column types. See note on types.
.TP 
-names \*(T<name\-list\*(T>
A list of column names.
.TP 
-pkey \*(T<primary_key\*(T>
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR.
.TP 
-poll_interval \*(T<count\*(T>
Call DoOneEvent() every \*(T<count\*(T> rows to keep the event loop alive
during long transactions.
.TP 
-recommit \*(T<count\*(T>
Chunk the operation in transactions, with one transaction every \*(T<count\*(T> rows.
.TP 
-check
Check (via a SELECT) whether the exact row is already present, and skip inserting the row if so. This
avoids bloating the WAL log during large re-loads of databases, at some performance cost.
.PP
\fBread_tabsep_keylist\fR
.nf

    \*(T<\fBpg_sqlite\fR\*(T> \*(T<sqlite_db\*(T> read_tabsep_keylist
	[\-row \*(T<single_tab_separated_row\*(T>]
	[\-file \*(T<file_handle\*(T>]
	[\-create \*(T<new_table\*(T>]
	[\-into \*(T<table\*(T>]
	[\-replace]
	[\-as \*(T<name_type_list\*(T>]
	[\-names \*(T<name_list\*(T>]
	[\-pkey \*(T<primary_key\*(T>]
	[\-sep \*(T<separator\*(T>]
	[\-null \*(T<null_string\*(T>]
	[\-poll_interval \*(T<rows\*(T>]
	[\-recommit \*(T<rows\*(T>]
   
.fi
.PP
Read a previously opened file containing alternating key-value columns into an sqlite3 table.
.TP 
-row \*(T<single_tab_separated_row\*(T>
An already read tab-separated key-value list line.
.TP 
-file \*(T<file_handle\*(T>
An open file consistion of tab-separated key-value list rows.
.TP 
-sep \*(T<separator\*(T>
String to use to separate columns. Default is "\et" (tab).
.TP 
-null \*(T<null_string\*(T>
String to use to indicate a null value. Default is to treat all strings literally.
.TP 
-create \*(T<new_table\*(T>
A table to be created in sqlite. The names and types of columns, and the primary key, must be provided.
.TP 
-into \*(T<table\*(T>
An existing sqlite table to insert the data. The names of the columns must be provided, if the type can not be inferred it will be assumed to be "text".
.TP 
-replace
When performing the insert on an existing or newly create table, use "INSERT OR REPLACE" semantics. Not compatible with "-sql".
.TP 
-as \*(T<name\-type\-list\*(T>
A list of alternating column names and types. See note on types.
.TP 
-names \*(T<name\-list\*(T>
A list of column names.
.TP 
-pkey \*(T<primary_key\*(T>
A list containing key names and optional sorting to indicate primary key where needed. For example
\fB-pkey {{clock ASC} {sequence ASC}}\fR.
.TP 
-poll_interval \*(T<count\*(T>
Call DoOneEvent() every \*(T<count\*(T> rows to keep the event loop alive
during long transactions.
.TP 
-recommit \*(T<count\*(T>
Chunk the operation in transactions, with one transaction every \*(T<count\*(T> rows.
.SH TYPES
\fIA note on types:\fR \*(T<\fBpg_sqlite\fR\*(T> supports four types: \*(T<integer\*(T> (or int), \*(T<boolean\*(T> (or bool), \*(T<double\*(T> (or real), and \*(T<text\*(T>. \*(T<Integer\*(T>, \*(T<double\*(T>, and \*(T<text\*(T> match both sqlite and postgresql types. \*(T<Boolean\*(T> is an integer type in sqlite, and boolean in postgresql, and converts postgresql boolean values (such as 'yes', 'no', 'true', or 'false') to integer 1 and 0.
.PP
In addition, \*(T<\fBpg_sqlite\fR\*(T> will accept PostgreSQL boolean values for the integer type. This may be made conditional on a "strict" mode in the future.
.SH "RETURN VALUE"
Number of rows imported or exported.
.SH "SEE ALSO"
Sqlite 3
