with Standard_Integer_Numbers;          use Standard_Integer_Numbers;
with C_Integer_Arrays;                  use C_Integer_Arrays;
with C_Double_Arrays;                   use C_Double_Arrays;

function use_c2phc4c ( job : integer32;
                       a : C_intarrs.Pointer;
		       b : C_intarrs.Pointer;
                       c : C_dblarrs.Pointer;
                       vrblvl : integer32 := 0 ) return integer32;

-- DESCRIPTION :
--   Provides a gateway from C to the operations in PHCpack.

-- ON ENTRY :
--   job   =   0 : writes the welcome banner.
--         = 998 : sets the seed of the random number generator,
--                 on entry in a[0] is the value for the seed;
--         = 997 : returns the seed of the random number generator in a;
--         = 999 : returns the version string of PHCpack,
--                 in a are the characters of the string,
--                 and in b[0] is the number of characters.
--         = 994 : returns the number of available cores in a.
--
-- moving data from PHCpack_operations from and to containers :
--
--   job   =   1 : copy target system to systems container;
--         =   2 : copy system in container to target system;
--         =   3 : copy start system to systems container;
--         =   4 : copy system in container to start system;
--         =   5 : copy target solutions to solutions container;
--         =   6 : copy solutions in container to target solutions;
--         =   7 : copy start solutions to solutions container;
--         =   8 : copy solutions in container to start solutions;
--         =   9 : verify the solutions in the container, using
--                 the contents of the system container as target.
--
-- moving double double data between containers and PHCpack :
--
--   job   = 251 : copy target system to systems container;
--         = 252 : copy system in container to target system;
--         = 253 : copy start system to systems container;
--         = 254 : copy system in container to start system;
--         = 255 : copy target solutions to solutions container;
--         = 256 : copy solutions in container to target solutions;
--         = 257 : copy start solutions to solutions container;
--         = 258 : copy solutions in container to start solutions;
--
-- moving quad double data between containers and PHCpack :
--
--   job   = 261 : copy target system to systems container;
--         = 262 : copy system in container to target system;
--         = 263 : copy start system to systems container;
--         = 264 : copy system in container to start system;
--         = 265 : copy target solutions to solutions container;
--         = 266 : copy solutions in container to target solutions;
--         = 267 : copy start solutions to solutions container;
--         = 268 : copy solutions in container to start solutions;
--
-- moving multiprecision data between containers and PHCpack :
--
--   job   = 281 : copy target system to systems container;
--         = 282 : copy system in container to target system;
--         = 283 : copy start system to systems container;
--         = 284 : copy system in container to start system;
--         = 285 : copy target solutions to solutions container;
--         = 286 : copy solutions in container to target solutions;
--         = 287 : copy start solutions to solutions container;
--         = 288 : copy solutions in container to start solutions;
--
-- the core operations in PHCpack :
--
--   job   =  10 : displays the menu of available operations;
--         =  11 : read target polynomial system;
--         =  12 : write target polynomial system;
--         =  13 : read start polynomial system;
--         =  14 : write start polynomial system;
--         =  15 : write start solutions;
--         =  16 : solve by homotopy continuation;
--         =  17 : write the target solutions;
--         =  18 : clear the data in PHCpack_Operations;
--         =  19 : define the output file;
--         = 191 : define the output file from a string,
--                 with in a the number of characters, and
--                      in b the character string of the file name;
--         = 192 : close the defined output file.
--
-- analogue operations for double doubles and quad doubles :
--
--   job   = 231 : read double double target polynomial system;
--         = 232 : write double double target polynomial system;
--         = 233 : read double double start polynomial system;
--         = 234 : write double double start polynomial system;
--         = 235 : write double double start solutions;
--         = 236 : solve by double double homotopy continuation;
--         = 237 : write the double double target solutions;
--         = 238 : clear the double double data;
--         = 241 : read quad double target polynomial system;
--         = 242 : write quad double target polynomial system;
--         = 243 : read quad double start polynomial system;
--         = 244 : write quad double start polynomial system;
--         = 245 : write quad double start solutions;
--         = 246 : solve by quad double homotopy continuation;
--         = 247 : write the quad double target solutions;
--         = 248 : clear the quad double data.
--
-- analogue operations for multiprecision numbers :
--
--   job   = 491 : read multiprecision target polynomial system,
--                 the number of decimal places in the working
--                 precision must be given in the value of a[0];
--         = 492 : write multiprecision target polynomial system;
--         = 493 : read multiprecision start polynomial system,
--                 the number of decimal places in the working
--                 precision must be given in the value of a[0];
--         = 494 : write multiprecision start polynomial system;
--         = 495 : write multiprecision start solutions;
--         = 496 : solve by multiprecision homotopy continuation;
--         = 497 : write the multiprecision target solutions;
--         = 498 : clear the multiprecision data;
--
-- operations for systems in Laurent homotopies :
--
--   job   = 759 : read standard double Laurent start system;
--         = 760 : write standard double Laurent start system;
--         = 761 : read standard double Laurent target system;
--         = 762 : write standard double Laurent target system;
--         = 763 : read double double Laurent start system;
--         = 764 : write double double Laurent start system;
--         = 765 : read double double Laurent target system;
--         = 766 : write double double Laurent target system;
--         = 767 : read quad double Laurent start system;
--         = 768 : write quad double Laurent start system;
--         = 769 : read quad double Laurent target system;
--         = 770 : write quad double Laurent target system;
--         = 771 : clear data for Laurent homotopy with standard doubles;
--         = 772 : clear data for Laurent homotopy with double doubles;
--         = 773 : clear data for Laurent homotopy with quad doubles;
--         = 774 : solve stored Laurent target system using the stored
--                 Laurent system in standard double precision,
--                 using as many tasks as the value of number_of_tasks,
--                 if that value is zero, then no multitasking is used;
--         = 775 : solve stored Laurent target system using the stored
--                 Laurent system in double double precision,
--                 using as many tasks as the value of number_of_tasks,
--                 if that value is zero, then no multitasking is used;
--         = 776 : solve stored Laurent target system using the stored
--                 Laurent system in quad double precision,
--                 using as many tasks as the value of number_of_tasks,
--                 if that value is zero, then no multitasking is used;
--         = 777 : copy standard Laurent container to start system;
--         = 778 : copy dobldobl Laurent container to start system;
--         = 779 : copy quaddobl Laurent container to start system;
--         = 780 : copy standard Laurent container to target system;
--         = 781 : copy dobldobl Laurent container to target system;
--         = 782 : copy quaddobl Laurent container to target system;
--         = 783 : copy standard Laurent start system to container;
--         = 784 : copy dobldobl Laurent start system to container;
--         = 785 : copy quaddobl Laurent start system to container;
--         = 786 : copy standard Laurent target system to container;
--         = 787 : copy dobldobl Laurent target system to container;
--         = 788 : copy quaddobl Laurent target system to container;
--         = 789 : defines a cascade homotopy for Laurent systems
--                 in standard double precision;
--         = 790 : defines a cascade homotopy for Laurent systems
--                 in double double precision;
--         = 791 : defines a cascade homotopy for Laurent systems
--                 in quad double precision;
--         = 792 : creates a homotopy with the Laurent systems stored
--                 as target and start in standard double precision;
--         = 793 : creates a homotopy with the Laurent systems stored
--                 as target and start in double double precision;
--         = 794 : creates a homotopy with the Laurent systems stored
--                 as target and start in quad double precision.
--
-- more homotopy operations on Laurent systems :
--
--         = 921 : make double Laurent homotopy with given gamma;
--         = 922 : make double double Laurent homotopy with given gamma;
--         = 923 : make quad double Laurent homotopy with given gamma;
--         = 924 : clear double Laurent homotopy;
--         = 925 : clear double double Laurent homotopy;
--         = 926 : clear quad double Laurent homotopy;
--
-- the operations of the systems container :
--
--   job   =  20 : read polynomial system and put in container;
--         =  21 : write the polynomial system in the container;
--         =  22 : return in a[0] the dimension of the polynomial system;
--         =  23 : initializes the container with the dimension in a[0];
--         =  24 : return in a[0] the number of terms in the i-th polynomial;
--         =  25 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         =  26 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         =  27 : the systems container is cleared;
--         =  28 : returns in a[0] the total degree of the system;
--         =  29 : clears the symbol table, used to read polynomials;
--         = 291 : removes the symbol with number in a[0] from the table,
--                 see job 296 for the "by name" removal of a symbol;
--         = 292 : sorts the embed symbols and permutes the variables of
--                 the system in the container, on return is in a the
--                 the number of embed symbols;
--         = 293 : returns in a[0] the number of symbols in the table;
--         = 294 : writes the symbols to screen.
--         = 295 : returns in b a string of all symbols
--                 and in a[0] the number of characters in b.
--         = 296 : removes the symbol with name in b and number of
--                 characters in a[0] from the symbol table,
--                 this is the "by name" removal corresponding to the
--                 "by index" removal of job 291.
--
-- with the following meaning of the parameters (a,b,c) :
--
--   a       memory allocated for array of integers, a = (n,i,j),
--           where n is the dimension,
--                 i is index to the polynomial in the system to work on;
--                 j is index to the mononomial in the i-th polynomial;
--   b       memory allocated for array of integers, used for exponents;
--   c       memory allocated for array of double floating-point numbers,
--           used for real and imaginary part of complex coefficient.
--
-- the operations in the double double polynomial systems container :
-- 
--   job   = 330 : read polynomial system and put in container;
--         = 331 : write the polynomial system in the container;
--         = 332 : return in a[0] the dimension of the polynomial system;
--         = 333 : initializes the container with the dimension in a[0];
--         = 334 : return in a[0] the number of terms in the i-th polynomial;
--         = 335 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         = 336 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         = 337 : the systems container is cleared;
--         = 338 : puts a polynomial given as a string in the system 
--                 container, with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : index of the polynomial in the system,
--                   b : string converted to an integer array;
--         = 339 : returns in b[0] the degree of polynomial with index a[0]
--                 stored in the double double polynomial systems container;
--        =  106 : loads a polynomial from the double double systems
--                 container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 338.   
--
-- the operations in the quad double polynomial systems container :
-- 
--   job   = 380 : read polynomial system and put in container;
--         = 381 : write the polynomial system in the container;
--         = 382 : return in a[0] the dimension of the polynomial system;
--         = 383 : initializes the container with the dimension in a[0];
--         = 384 : return in a[0] the number of terms in the i-th polynomial;
--         = 385 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         = 386 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         = 387 : the systems container is cleared;
--         = 388 : puts a polynomial given as a string in the system 
--                 container, with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : index of the polynomial in the system,
--                   b : string converted to an integer array;
--         = 389 : returns in b[0] the degree of polynomial with index a[0]
--                 stored in the quad double polynomial systems container;
--         = 107 : loads a polynomial from the double double systems
--                 container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 388.   
--
-- the operations in the multiprecision polynomial systems container :
-- 
--   job   = 440 : read polynomial system and put in container;
--         = 441 : write the polynomial system in the container;
--         = 442 : return in a[0] the dimension of the polynomial system;
--         = 443 : initializes the container with the dimension in a[0];
--         = 444 : return in a[0] the number of terms in the i-th polynomial.
--         = 447 : the systems container is cleared;
--         = 448 : puts a polynomial given as a string in the system 
--                 container, with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : index of the polynomial in the system,
--                   a[2] : the number of decimal places of the numbers
--                          to set the precision for the parsing operations,
--                   b : string converted to an integer array;
--         = 449 : returns in b[0] the degree of polynomial with index a[0]
--                 stored in the quad double polynomial systems container.
--         = 108 : loads a polynomial from the multiprecision systems
--                 container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 448.   
--
-- the operations to drop variables from a polynomial system :
--  
--   job   = 306 : replaces the system in the standard double container
--                 by a system with variable of index a[0] removed;
--         = 307 : replaces the system in the double double container
--                 by a system with variable of index a[0] removed;
--         = 308 : replaces the system in the quad double container
--                 by a system with variable of index a[0] removed;
--         = 309 : replaces the system in the standard double container
--                 by a system with variable with name in b and
--                 number of characters in a[0] removed;
--         = 310 : replaces the system in the double double container
--                 by a system with variable with name in b and
--                 number of characters in a[0] removed;
--         = 311 : replaces the system in the quad double container
--                 by a system with variable with name in b and
--                 number of characters in a[0] removed.
--
-- the operations to drop variables from a Laurent polynomial system :
--  
--   job   = 828 : replaces the Laurent system in the standard dobl container
--                 by a Laurent system with variable of index a[0] removed;
--         = 829 : replaces the Laurent system in the double double container
--                 by a Laurent system with variable of index a[0] removed;
--         = 830 : replaces the Laurent system in the quad double container
--                 by a Laurent system with variable of index a[0] removed;
--         = 831 : replaces the Laurent system in the standard dobl container
--                 by a Laurent system with variable with name in b and
--                 number of characters in a[0] removed;
--         = 832 : replaces the Laurent system in the double double container
--                 by a Laurent system with variable with name in b and
--                 number of characters in a[0] removed;
--         = 833 : replaces the Laurent system in the quad double container
--                 by a Laurent system with variable with name in b and
--                 number of characters in a[0] removed.
--
-- the operations in the solutions container :
--
--   job   =  30 : read solutions from file and put in container;
--         =  31 : write solutions in the container;
--         =  32 : return in b the length of the container;
--         =  33 : return in b the dimension of the solution vectors;
--         =  34 : return in b the multiplicity m of the solution (# in a),
--                        in c the solution as an array of 2*n+5 doubles,
--            in the following order:
--                 two doubles for the complex continuation parameter t,
--                 2*n doubles for the coefficients of the solution vector,
--                 one double for the norm of last Newton update,
--                 one double for the inverse of condition# estimate,
--                 one double for the norm of the residual;
--         =  35 : changes the solution with number in to the values 
--                 in b and c, where b is the array (n,m),
--                 where n is the dimension and m the multiplicity;
--         =  36 : appends the solution with data in b  = (n,m) and
--                 (also see job = 4 for info) to the container;
--         =  37 : clears all solutions from the container;
--         =  38 : replaces the solutions in the container by solutions
--                 with the coordinate with index a[0] dropped
--         = 146 : replaces the solutions in the container by solutions
--                 with the coordinate with name in b 
--                 and #characters in a[0] dropped
--
-- with the following meaning of the parameters (a,b,c) :
--
--   a        indicates the number of solution to work on;
--   b        array with allocated memory for integers,
--            usually only len, n, m, or the array (n,m),
--            where len is the length of the container;
--                  n is the dimension of the solution vectors; and
--                  m is the multiplicity of the solution;
--   c        array with allocated memory for double floats to store
--            the complex value for the continuation parameter t,
--            the complex coefficients (real and imaginary parts)
--            of the solution vector, err, rco, and res.
--
-- CORRESPONDING JOBS for containers of DOUBLE DOUBLE solutions :
-- 
--   job   = 340 : read solutions from file and put in container;
--         = 341 : write solutions in the container;
--         = 342 : return in b the length of the container;
--         = 343 : return in b the dimension of the solution vectors;
--         = 344 : return in b the multiplicity m of the solution (# in a),
--                        in c the solution as an array of 4*n+10 doubles,
--           in the following order:
--                 two double doubles for the complex parameter t,
--                 4*n doubles for the coefficients of the solution vector,
--                 one double double for the norm of last Newton update,
--                 one double double for the inverse of condition# estimate,
--                 one double double for the norm of the residual;
--         = 345 : changes the double double solution with data in b and c,
--                 as the double double equivalent to job 35;
--         = 346 : appends the solution with data in b  = (n,m) and
--                 (also see job = 344 for info) to the container;
--         = 347 : clears all solutions from the container;
--         = 348 : replaces the solutions in the container by solutions
--                 with the coordinate with index a[0] dropped
--         = 349 : replaces the solutions in the container by solutions
--                 with the coordinate with name in b 
--                 and #characters in a[0] dropped
--         = 370 : in a is given a solution number, returns in b the number
--                 of characters to write the entire solution as string;
--         = 371 : on input in a[0] is a solution number and in a[1] is
--                 the number of characters for the entire string,
--                 returns in b the string representation of the solution;
--         = 378 : on input in a[0] is the number of variables 
--                 and in a[1] is the length of characters in the string
--                 representation of a solution stored in b, the solution
--                 will be appended to the solutions container.
--
-- CORRESPONDING JOBS for containers of QUAD DOUBLE solutions :
-- 
--   job   = 390 : read solutions from file and put in container;
--         = 391 : write solutions in the container;
--         = 392 : return in b the length of the container;
--         = 393 : return in b the dimension of the solution vectors;
--         = 394 : return in b the multiplicity m of the solution (# in a),
--                        in c the solution as an array of 8*n+20 doubles,
--           in the following order:
--                 two quad doubles for the complex parameter t,
--                 8*n doubles for the coefficients of the solution vector,
--                 one quad double for the norm of last Newton update,
--                 one quad double for the inverse of condition# estimate,
--                 one quad double for the norm of the residual;
--         = 395 : changes the quad double solution with data in b and c,
--                 as the quad double equivalent to job 35;
--         = 396 : appends the solution with data in b  = (n,m) and
--                 (also see job = 394 for info) to the container;
--         = 397 : clears all solutions from the container;
--         = 398 : replaces the solutions in the container by solutions
--                 with the coordinate with index a[0] dropped
--         = 399 : replaces the solutions in the container by solutions
--                 with the coordinate with name in b 
--                 and #characters in a[0] dropped
--         = 420 : in a is given a solution number, returns in b the number
--                 of characters to write the entire solution as string;
--         = 421 : on input in a[0] is a solution number and in a[1] is
--                 the number of characters for the entire string,
--                 returns in b the string representation of the solution;
--         = 428 : on input in a[0] is the number of variables 
--                 and in a[1] is the length of characters in the string
--                 representation of a solution stored in b, the solution
--                 will be appended to the solutions container.
--
-- CORRESPONDING JOBS for containers of MULTIPRECISION solutions :
-- 
--   job   = 450 : read solutions from file and put in container;
--         = 451 : write solutions in the container;
--         = 452 : return in b the length of the container;
--         = 453 : return in b the dimension of the solution vectors;
--         = 457 : clears the multiprecision solutions in the container.
--         = 480 : in a is given a solution number, returns in b the number
--                 of characters to write the entire solution as string;
--         = 481 : on input in a[0] is a solution number and in a[1] is
--                 the number of characters for the entire string,
--                 returns in b the string representation of the solution;
--         = 488 : on input in a[0] is the number of variables 
--                 and in a[1] is the length of characters in the string
--                 representation of a solution stored in b, the solution
--                 will be appended to the solutions container.
--
-- RETRIEVE NEXT SOLUTION :
--
--   job   = 276 : if a[0] = 0 on entry, then the pointer to the current
--                 solution in the standard solutions container will be
--                 reset to the first solution, otherwise
--                 returns in b the multiplicity m of the current solution
--                 and in c the current solution as an array of 2*n+5
--                 doubles, in the following order:
--                 two doubles for the complex continuation parameter t,
--                 2*n doubles for the coefficients of the solution vector,
--                 one double for the norm of last Newton update,
--                 one double for the inverse of condition# estimate,
--                 one double for the norm of the residual;
--   job   = 277 : if a[0] = 0 on entry, then the pointer to the current
--                 solution in the dobldobl solutions container will be
--                 reset to the first solution, otherwise
--                 returns in b the multiplicity m of the current solution,
--                 and in c the current solution as an array of 4*n+10
--                 doubles, in the following order:
--                 two double doubles for the complex parameter t,
--                 4*n doubles for the coefficients of the solution vector,
--                 one double double for the norm of last Newton update,
--                 one double double for the inverse of condition# estimate,
--                 one double double for the norm of the residual;
--   job   = 278 : if a[0] = 0 on entry, then the pointer to the current
--                 solution in the quaddobl solutions container will be
--                 reset to the first solution, otherwise
--                 returns in b the multiplicity m of the current solution,
--                 and in c the current solution as an array of 8*n+20
--                 doubles, in the following order:
--                 two quad doubles for the complex parameter t,
--         = 279 : initializes the pointer to the current solution in the
--                 multiprecision container to the first solution.
--
-- MOVE POINTER to next solution in container :
--
--   job   = 454 : moves the pointer to the next standard solution
--                 in then container and returns in a[0] the cursor
--                 of the current solution, 0 if there is no solution;
--         = 455 : moves the pointer to the next dobldobl solution
--                 in then container and returns in a[0] the cursor
--                 of the current solution, 0 if there is no solution;
--         = 456 : moves the pointer to the next quaddobl solution
--                 in then container and returns in a[0] the cursor
--                 of the current solution, 0 if there is no solution;
--         = 458 : moves the pointer to the next multprec solution
--                 in then container and returns in a[0] the cursor
--                 of the current solution, 0 if there is no solution.
--
-- RETURN LENGTH of the current solution string :
--
--         = 525 : returns in a[0] the value of the cursor of the current
--                 standard solution and if a[0] is nonzero, then in b[0]
--                 is the length of the current standard solution string;
--         = 526 : returns in a[0] the value of the cursor of the current
--                 dobldobl solution and if a[0] is nonzero, then in b[0]
--                 is the length of the current dobldobl solution string;
--         = 527 : returns in a[0] the value of the cursor of the current
--                 quaddobl solution and if a[0] is nonzero, then in b[0]
--                 is the length of the current quaddobl solution string;
--         = 528 : returns in a[0] the value of the cursor of the current
--                 multprec solution and if a[0] is nonzero, then in b[0]
--                 is the length of the current multprec solution string.
--
-- RETURN CURRENT solution string :
--
--         = 533 : given in a[0] the length of the current standard solution
--                 string, returns in a[0] the value of the cursor to the
--                 current standard solution an if a[0] is nonzero, then
--                 in b on return is the current standard solution string;
--         = 534 : given in a[0] the length of the current dobldobl solution
--                 string, returns in a[0] the value of the cursor to the
--                 current dobldobl solution an if a[0] is nonzero, then
--                 in b on return is the current dobldobl solution string;
--         = 535 : given in a[0] the length of the current quaddobl solution
--                 string, returns in a[0] the value of the cursor to the
--                 current quaddobl solution an if a[0] is nonzero, then
--                 in b on return is the current quaddobl solution string;
--         = 536 : given in a[0] the length of the current multprec solution
--                 string, returns in a[0] the value of the cursor to the
--                 current multprec solution an if a[0] is nonzero, then
--                 in b on return is the current multprec solution string.
--
-- setting the value of the continuation parameter to zero :
--
--   job   = 875 : sets the value of the continuation parameter to zero
--                 for all the solutions in the standard double precision
--                 solutions container;
--   job   = 876 : sets the value of the continuation parameter to zero
--                 for all the solutions in the double double precision
--                 solutions container;
--   job   = 877 : sets the value of the continuation parameter to zero
--                 for all the solutions in the quad double precision
--                 solutions container.
--
-- the operations of the monodromy factorization :
--
--   job    = 39 : makes the factorization with standard doubles go silent;
--         =  40 : display the menu of all available options;
--         =  41 : prompts the user for a witness set,
--                 stores the system in the systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--   job   =  42 : takes the system and the solutions from the containers
--                 and initializes the sampling machine, on input,
--                 the dimension of the witness set must be in a;
--   job   =  43 : assigns the coefficient c[0] + c[1]*I to the
--                 b-th coefficient of the a-th slice;
--   job   =  44 : stores the c[0] + c[1]*I as random gamma constant
--                 for the a-th equation, in standard double precision;
--   job   =  45 : compute a new witness set on the new slices;
--         =  46 : swaps slices and solution sets to turn back;
--         =  47 : copy embedded system from sampler to systems container;
--         =  48 : copy first standard solution list to container;
--         =  49 : put solutions with index in a from monodromy grid
--                 in the solutions container (companion to job = 11);
--   job   =  50 : initializes Standard_Monodromy_Permutations
--                 with two numbers:
--                   a[0] : number of monodromy loops,
--                   b[0] : degree of the solution component to factor;
--   job   =  51 : store solutions in container in standard double precision
--                 to Standard_Monodromy_Permutations;
--   job   =  52 : compute permutation by last stored solution list,
--                 in standard double precision,
--                 and return this new permutation in b;
--   job   =  53 : updates decomposition with a new permutation,
--                 computed on data in standard double precision,
--                 a[0] must contain the dimension and b the permutation;
--   job   =  54 : writes the current standard precision decomposition;
--         =  55 : applies the linear trace to certify the decomposition,
--                 in standard double precision;
--   job   =  56 : returns in c the diagnostics of the standard trace grid;
--         =  57 : returns in c difference between trace and actual sum,
--                 computed in standard double precision;
--   job   =  58 : finds the index of a solution label in a slice,
--                 in standard double precision;
--                 on entry: a[0] is label to a solution,
--                           a[1] is the number of a slice;
--                 on return: b is index to solution if label occurs,
--                            otherwise, b is zero.
--   job   =  59 : initialize number of slices in Standard_Sampling_Operations
--                 with the content of a;
--         =  60 : adds a new slice to Sampling_Operations, 
--                 where a[0] = total number of doubles in the slices;
--                       a[1] = dimension of the solution set;
--                       a[2] = the ambient dimension;
--                 the coefficients are in c.
--         =  61 : returns in c the coefficients of a slice,
--                 where a[0] = total number of doubles in the slices;
--                       a[1] = dimension of the solution set;
--                       a[2] = the ambient dimension;
--                 the index to the slice is in b.
--         =  62 : sets the target slices to the a-th slice stored 
--                 in Standard_Sampling_Operations.
--         =  63 : completes one loop, sampling from one solution,
--                 where a[0] = index for the starting hyperplane sections;
--                       a[1] = index for the target hyperplanes sections;
--                   and b = label of the start solution;
--                 on return b contains the label of the matching solution
--                 in the list at the target hyperplane sections.
--         =  64 : reads a witness set from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--         =  65 : reads a witness set to file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 the system and the solutions are taken from containers.
--         =  67 : loads a polynomial from the container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 76;
--         =  68 : returns in a the number of irreducible factors in
--                 the current irreducible decomposition;
--         =  69 : given in a an index k to an irreducible component,
--                 returns in a the degree of the k-th component and
--                 in b the labels of the points that span the k-th
--                 component in the standard irreducible decomposition.
--   job   = 280 : returns in c the real and imaginary parts of
--                 a randomly generated complex number of modulus one,
--                 generated in standard double precision;
--   job   = 630 : makes the factorization with standard doubles go verbose.
--
-- ANALOGUE OPERATIONS FOR DOUBLE DOUBLE AND QUAD DOUBLE PRECISION :
--
--   job   = 631 : prompts for a witness set in double double precision
--                 stores the system in the dobldobl systems container,
--                 and its solutions in the dobldobl solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--   job   = 632 : takes the system and the solutions from the containers
--                 for double double precision
--                 and initializes the sampling machine, on input,
--                 the dimension of the witness set must be in a;
--   job   = 633 : assigns the double double coefficient, stored in the first
--                 four doubles in c, the real and imaginary parts, to the
--                 b-th coefficient of the a-th slice;
--   job   = 634 : uses the data in c to store the random gamma constant
--                 for the a-th equation, in double double precision;
--   job   = 635 : compute a new dobldobl witness set on the new slices;
--         = 636 : swaps dobldobl slices and solution sets to turn back;
--         = 637 : copy embedded system from sampler to systems container,
--                 for coefficients in double double precision;
--   job   = 638 : copy first dobldobl solution list to container;
--         = 639 : put solutions with index in a from monodromy grid
--                 in the dobldobl solutions container (companion to job = 11);
--   job   = 640 : init DoblDobl_Monodromy_Permutations with two numbers:
--                   a[0] : number of monodromy loops,
--                   b[0] : degree of the solution component to factor;
--   job   = 641 : store solutions in container in double double
--                 precision to DoblDobl_Monodromy_Permutations;
--   job   = 642 : compute permutation by last stored solution list,
--                 in double double precision,
--                 and return this new permutation in b;
--   job   = 643 : updates decomposition with a new permutation,
--                 computed on data in double double precision,
--                 a[0] must contain the dimension and b the permutation;
--   job   = 644 : writes the double double precision decomposition;
--         = 645 : applies the linear trace to certify the decomposition,
--                 in double double precision;
--   job   = 646 : returns in c the diagnostics of the dobldobl trace grid;
--         = 647 : returns in c difference between trace and actual sum,
--                 computed in double double precision;
--   job   = 648 : finds the index of a solution label in a slice,
--                 in double double precision,
--                 on entry: a[0] is label to a solution,
--                           a[1] is the number of a slice;
--                 on return: b is index to solution if label occurs,
--                            otherwise, b is zero;
--   job   = 649 : initialize number of slices in DoblDobl_Sampling_Operations
--                 with the content of a;
--   job   = 652 : sets the target slices to the a-th slice stored 
--                 in DoblDobl_Sampling_Operations.
--   job   = 653 : completes one loop, sampling from one solution,
--                 in double double precision,
--                 where a[0] = index for the starting hyperplane sections;
--                       a[1] = index for the target hyperplanes sections;
--                   and b = label of the start solution;
--                 on return b contains the label of the matching solution
--                 in the list at the target hyperplane sections.
--   job   = 654 : reads a witness set in double double precision from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set;
--   job   = 655 : writes a witness set in double double precision to file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 the system and the solutions are taken from containers.
--   job   = 656 : returns in a the number of irreducible factors in the
--                 the irreducible decomposition, in double double preicsion;
--   job   = 657 : given in a an index k to an irreducible component,
--                 returns in a the degree of the k-th component and
--                 in b the labels of the points that span the k-th
--                 component in the dobldobl irreducible decomposition.
--   job   = 658 : makes the factorization with double doubles go silent;
--   job   = 659 : returns in c the real and imaginary parts of
--                 a randomly generated complex number of modulus one,
--                 generated in double double precision;
--   job   = 660 : makes the factorization with double doubles go verbose.
--
--   job   = 661 : prompts for a witness set in quad double precision
--                 stores the system in the quaddobl systems container,
--                 and its solutions in the quaddobl solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set;
--   job   = 662 : takes the system and the solutions from the containers
--                 for quad double precision
--                 and initializes the sampling machine, on input,
--                 the dimension of the witness set must be in a.
--   job   = 663 : assigns the quad double coefficient, stored in the first
--                 eight doubles in c, the real and imaginary parts, to the
--                 b-th coefficient of the a-th slice;
--   job   = 664 : uses the data in c to store the random gamma constant
--                 for the a-th equation, in quad double precision;
--   job   = 665 : compute a new quaddobl witness set on the new slices;
--         = 666 : swaps quaddobl slices and solution sets to turn back;
--         = 667 : copy embedded system from sampler to systems container,
--                 for coefficients in quad double precision;
--   job   = 668 : copy first quaddobl solution list to container;
--         = 669 : put solutions with index in a from monodromy grid
--                 in the quaddobl solutions container (companion to job = 11);
--   job   = 670 : init QuadDobl_Monodromy_Permutations with two numbers:
--                   a[0] : number of monodromy loops,
--                   b[0] : degree of the solution component to factor;
--   job   = 671 : store solutions in container in quad double
--                 precision to QuadDobl_Monodromy_Permutations;
--   job   = 672 : compute permutation by last stored solution list,
--                 in quad double precision,
--                 and return this new permutation in b;
--   job   = 673 : updates decomposition with a new permutation,
--                 computed on data in quad double precision,
--                 a[0] must contain the dimension and b the permutation;
--   job   = 674 : writes the quad double precision decomposition;
--   job   = 675 : applies the linear trace to certify the decomposition,
--                 in quad double precision;
--   job   = 676 : returns in c the diagnostics of the quaddobl trace grid;
--         = 677 : returns in c difference between trace and actual sum,
--                 computed in quad double precision;
--   job   = 678 : finds the index of a solution label in a slice,
--                 in quad double precision,
--                 on entry: a[0] is label to a solution,
--                           a[1] is the number of a slice;
--                 on return: b is index to solution if label occurs,
--                            otherwise, b is zero;
--   job   = 679 : initialize number of slices in QuadDobl_Sampling_Operations
--                 with the content of a;
--   job   = 682 : sets the target slices to the a-th slice stored 
--                 in QuadDobl_Sampling_Operations.
--   job   = 683 : completes one loop, sampling from one solution,
--                 in quad double precision,
--                 where a[0] = index for the starting hyperplane sections;
--                       a[1] = index for the target hyperplanes sections;
--                   and b = label of the start solution;
--                 on return b contains the label of the matching solution
--                 in the list at the target hyperplane sections.
--   job   = 684 : reads a witness set in quad double precision from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set;
--   job   = 685 : writes a witness set in quad double precision to file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 the system and the solutions are taken from containers.
--   job   = 686 : returns in a the number of irreducible factors in the
--                 the irreducible decomposition, in quad double preicsion;
--   job   = 687 : given in a an index k to an irreducible component,
--                 returns in a the degree of the k-th component and
--                 in b the labels of the points that span the k-th
--                 component in the quaddobl irreducible decomposition.
--   job   = 688 : makes the factorization with quad doubles go silent;
--   job   = 689 : returns in c the real and imaginary parts of
--                 a randomly generated complex number of modulus one,
--                 generated in quad double precision;
--   job   = 690 : makes the factorization with quad doubles go verbose.
--
-- READING WITNESS SETS DEFINED BY LAURENT SYSTEMS :
--
--   job   = 798 : prompts for a witness set in standard double precision,
--                 defined by a Laurent polynomial system, stores the
--                 system in the standard Laurent systems container,
--                 and its solutions in the standard solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--         = 799 : prompts for a witness set in double double precision,
--                 defined by a Laurent polynomial system, stores the
--                 system in the dobldobl Laurent systems container,
--                 and its solutions in the dobldobl solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--         = 800 : prompts for a witness set in quad double precision,
--                 defined by a Laurent polynomial system, stores the
--                 system in the quaddobl Laurent systems container,
--                 and its solutions in the quaddobl solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--         = 801 : reads a witness set defined by a Laurent system
--                 in standard double precision from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the Laurent systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set;
--         = 802 : reads a witness set defined by a Laurent system
--                 in double double precision from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the Laurent systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set;
--         = 803 : reads a witness set defined by a Laurent system
--                 in quad double precision from file,
--                 on input in b is the file name, and in a the
--                          number of characters in the file name,
--                 stores the system in the Laurent systems container,
--                 and its solutions in the solutions container,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set;
--                   b[1] : degree of the solution set.
--         = 804 : takes the Laurent system and the solutions from the
--                 containers in standard double precision,
--                 and initializes the Laurent sampling machine, on input,
--                 the dimension of the witness set must be in a;
--         = 805 : takes the Laurent system and the solutions from the
--                 containers in double double precision,
--                 and initializes the Laurent sampling machine, on input,
--                 the dimension of the witness set must be in a;
--         = 806 : takes the Laurent system and the solutions from the
--                 containers in quad double precision,
--                 and initializes the Laurent sampling machine, on input,
--                 the dimension of the witness set must be in a.
--         = 807 : copy embedded system from sampler to Laurent systems
--                 container, for coefficients in standard double precision;
--         = 808 : copy embedded system from sampler to Laurent systems
--                 container, for coefficients in double double precision;
--         = 809 : copy embedded system from sampler to Laurent systems
--                 container, for coefficients in quad double precision.
--
-- diagonal homotopies for Laurent systems :
--
--   job   = 810 : make a diagonal homotopy from the Laurent systems stored
--                 as target and start systems in standard double precision,
--                 the input parameters a and b are the dimensions of 
--                 the witness sets;
--         = 811 : make a diagonal homotopy from the Laurent systems stored
--                 as target and start systems in double double precision,
--                 the input parameters a and b are the dimensions of 
--                 the witness sets;
--         = 812 : make a diagonal homotopy from the Laurent systems stored
--                 as target and start systems in quad double precision,
--                 the input parameters a and b are the dimensions of 
--                 the witness sets.
--
-- Jobs to make witness sets for Laurent polynomials,
-- in standard double, double double, and quad double precision :
--
--   job   = 813 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a Laurent polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in standard double precision for the Laurent
--                 polynomial stored in b;
--         = 814 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a Laurent polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in double double precision for the Laurent
--                 polynomial stored in b;
--         = 815 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a Laurent polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in quad double precision for the Laurent
--                 polynomial stored in b.
--
-- SWAPPING SLACK VARIABLES TO THE END :
--
--   job   = 816 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the polynomial system with standard double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set;
--         = 817 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the polynomial system with double double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set;
--         = 818 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the polynomial system with quad double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set;
--         = 819 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the Laurent system with standard double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set;
--         = 820 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the Laurent system with double double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set;
--         = 821 : given in a[0] is the total number of variables
--                 and in b[0] is the number of slack variables,
--                 swaps the slack variables to the end in the symbol table
--                 for the Laurent system with quad double precision
--                 coefficients and its corresponding solutions,
--                 as needed for the working with the witness set.
--
-- POWER SERIES NEWTON METHOD :
--
--   Before calling the jobs, the systems and solutions containers
--   must be initialized properly.  The resulting series are stored in
--   the systems pool, corresponding to each precision level.
--
--   job   = 691 : power series Newton method in standard double precision,
--                 the input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the number of steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, intermediate results are written to screen.
--   job   = 692 : power series Newton method in double double precision,
--                 the input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the number of steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, intermediate results are written to screen.
--   job   = 693 : power series Newton method in quad double precision,
--                 the input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the number of steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, intermediate results are written to screen.
--   job   = 694 : same as 691, but instead of solutions, the start terms
--                 on the series are given in the systems pool.
--   job   = 695 : same as 692, but instead of solutions, the start terms
--                 on the series are given in the systems pool.
--   job   = 696 : same as 693, but instead of solutions, the start terms
--                 on the series are given in the systems pool.
--   job   = 704 : power series Newton method in standard double precision,
--                 for a Pade approximant.  The input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the degree of the numerator,
--                 a[2] : the degree of the denominator,
--                 a[3] : the number of the steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--   job   = 705 : power series Newton method in double double precision,
--                 for a Pade approximant.  The input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the degree of the numerator,
--                 a[2] : the degree of the denominator,
--                 a[3] : the number of the steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--   job   = 706 : power series Newton method in quad double precision,
--                 for a Pade approximant.  The input parameters are
--                 a[0] : the index of the series parameter,
--                 a[1] : the degree of the numerator,
--                 a[2] : the degree of the denominator,
--                 a[3] : the number of the steps in Newton's method,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--
-- PADE CONTINUATION :
--
--   job   = 735 : set default values for homotopy continuation parameters.
--   job   = 736 : clears the homotopy continuation parameters;
--   job   = 737 : given in a[0] is a number k between 1 and 12,
--                 on return in b[0] or c is the value of the k-th
--                 homotopy continuation parameter, as follows:
--                 if k = 1, then c[0] contains the real part of gamma,
--                 and c[1] contains the imaginary part of gamma;
--                 if k = 2, then b[0] is the degree of Pade numerator,
--                 if k = 3, then b[0] is the degree of Pade denominator,
--                 if k = 4, then c[0] is the maximum step size,
--                 if k = 5, then c[0] is the minimum step size,
--                 if k = 6, then c[0] is the series step factor,
--                 if k = 7, then c[0] is the pole radius step factor,
--                 if k = 8, then c[0] is the predictor residual tolerance,
--                 if k = 9, then c[0] is the corrector residual tolerance,
--                 if k = 10, then c[0] is the zero coefficient tolerance,
--                 if k = 11, then b[0] is the maximum #corrector steps,
--                 if k = 12, then b[0] is the maximum #steps on a path.
--   job   = 738 : given in a[0] is a number k between 1 and 12,
--                 and in b[0] or c the value of the k-th parameter,
--                 sets the value of the k-th parameter to c[0],
--                 if k = 1, then c[0] must contain the real part
--                 of gamma and c[1] the imaginary part of gamma,
--                 if k = 2, then b[0] is the degree of Pade numerator,
--                 if k = 3, then b[0] is the degree of Pade denominator,
--                 if k = 4, then c[0] is the maximum step size,
--                 if k = 5, then c[0] is the minimum step size,
--                 if k = 6, then c[0] is the series step factor,
--                 if k = 7, then c[0] is the pole radius step factor,
--                 if k = 8, then c[0] is the predictor residual tolerance,
--                 if k = 9, then c[0] is the corrector residual tolerance,
--                 if k = 10, then c[0] is the zero coefficient tolerance,
--                 if k = 11, then b[0] is the maximum #corrector steps,
--                 if k = 12, then b[0] is the maximum #steps on a path;
--   job   = 739 : tracks the paths with the Pade predictors,
--                 for an artificial parameter homotopy,
--                 the value of a[0] is 0, 1, 2, for double, double double,
--                 or quad double precision, with target, start system, and
--                 start solutions defined via PHCpack_Operations,
--                 in a[1] is the number of characters of the name of the
--                 output file, if a[1] is zero, then no output is written,
--                 otherwise, the characters of the output file name are
--                 defined by b, in a[2] is the value of the verbose flag,
--                 in a[3] is the value of the homogeneous coordinates flag,
--                 on return are the end of the solution paths in the
--                 double, double double, or quad double solutions container.
--   job   = 740 : resets the homotopy continuation parameters for the
--                 step-by-step path tracker, using the value for a[0]
--                 for double (0), double double (1), or quad double (2).
--   job   = 860 : initializes homotopy for a step-by-step execution
--                 in double, double double, or quad double precision,
--                 depending on whether a[0] is 0, 1, or 2, the verbose option
--                 is in b[0], and in b[1] is the flag for homogeneous
--                 coordinates (1 if on, 0 for affine), before execution,
--                 the homotopy continuation parameters with job 0 is set,
--                 target and start system are defined in PHCpack_Operations.
--   job   = 861 : initializes next start solution in series-Pade tracker,
--                 in double, double double, or quad double precision,
--                 depending on whether a[0] is 0, 1, or 2,
--                 the index of the solution is a[1],
--                 the verbose option is in b[0],
--                 on return in a[0] is the failure code of the retrieval;
--   job   = 862 : runs the next predict-correct step in series-Pade tracker,
--                 in double, double double, or quad double precision,
--                 depending on whether a[0] is 0, 1, or 2,
--                 the verbose option is in b[0],
--                 on return in a[0] is the failure code of the next
--                 predict-correct step;
--   job   = 863 : gets the current solution at index a[1], 
--                 in double, double double, or quad double precision,
--                 depending on whether a[0] is 0, 1, or 2,
--                 the verbose option is in b[0],
--                 the current solution is placed at position index in
--                 the solutions container and the failure code of the
--                 placement is returned in a[0];
--   job   = 919 : gets the predicted solution at index a[1], 
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2,
--                 the verbose option is in b[0],
--                 the predicted solution is placed at position index in
--                 the solutions container and the failure code of the
--                 placement is returned in a[0];
--   job   = 864 : clears the data in the series-pade tracker,
--                 in double, double double, or quad double precision,
--                 depending on whether a[0] is 0, 1, or 2;
--   job   = 865 : returns in c[0] the value of the pole radius,
--                 computed in double, double double, or quad double,
--                 depending on whether a[0] is 0, 1, or 2.
--   job   = 866 : returns in c[0] and c[1] the real and imaginary parts
--                 of the closest pole (only meaningful if c[0] >= 0.0),
--                 computed in double, double double, or quad double,
--                 depending on whether a[0] is 0, 1, or 2;
--   job   = 867 : returns in c[0] the current t value of the path tracker
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2;
--   job   = 868 : returns in c[0] the current step size of the path tracker
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2.
--   job   = 885 : returns in c[0] the current series step of the path tracker
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2;
--   job   = 886 : returns in c[0] the current pole step of the path tracker
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2;
--   job   = 887 : returns in c[0] the distance to the closest solution
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2;
--   job   = 888 : returns in c[0] the current Hessian step of the path tracker
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2;
--   job   = 869 : returns in c[0] and c[1] the real and imaginary parts of
--                 the series coefficient at component a[1] with power a[2],
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2,
--                 the verbose flag (0 or 1) is in b[0].
--   job   = 870 : returns in c[0] and c[1] the real and imaginary parts of
--                 the Pade coefficient at component a[2] with power a[3],
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2,
--                 if a[1] = 0, then the denominator coefficient is returned,
--                 otherwise, on return is the numerator coefficient,
--                 the verbose flag (0 or 1) is in b[0];
--   job   = 871 : returns in c[0] and c[1] the real and imaginary parts of
--                 the pole of Pade approximant a[1] at position a[2],
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2,
--                 the verbose flag (0 or 1) is in b[0].
--   job   = 874 : writes the homotopy continuation parameters to the
--                 defined output file.
--   job   = 878 : initializes homotopy for a step-by-step execution
--                 in double, double double, or quad double precision,
--                 depending whether a[0] is 0, 1, or 2,
--                 for a natural parameter homotopy with index in b[0],
--                 the index of the continuation parameter,
--                 the verbose option is in b[1], before execution,
--                 the homotopy continuation parameters with job 0 is set
--                 and target system is defined in PHCpack_Operations.
--
-- EMBEDDING A POLYNOMIAL SYSTEM :
--
--   job   =  66 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for systems in standard
--                 double precision by the embedded system.
--         = 129 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for systems in double
--                 double precision by the embedded system.
--         = 260 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for systems in quad
--                 double precision by the embedded system.
--         = 625 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for Laurent systems
--                 in standard double precision by the embedded system.
--         = 626 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for Laurent systems
--                 in double double precision by the embedded system.
--         = 627 : given in a[0] the dimension of the embedding,
--                 replaces the system in container for Laurent systems
--                 in quad double precision by the embedded system.
--
-- tuning continuation parameters and setting output level :
--
--   job   =  70 : interactive tuning of the continuation parameters;
--         =  71 : interactive setting of output level during continuation;
--         =  72 : retrieve in c the values of the continuation parameters;
--         =  73 : set the continuation parameters with the values in c.
--         = 189 : given in a[0] an integer in the range 1..34,
--                 returns in c the value of the corresponding continuation
--                 parameter with index equal to a[0];
--   job   = 190 : given in a[0] an integer in the range 1..34, and
--                 given in c[0] the value of the corresponding continuation
--                 parameter with index equal to a[0], sets the value of
--                 that continuation parameter to the value of c[0];
--         = 193 : autotune of the continuation parameters with two values:
--                 in a : the difficulty level of the solution path;
--                 in b : the number of decimal places in the precision.
--         = 194 : writes the current settings of the continuation
--                 parameters to screen.
--
-- calling the blackbox solver in PHCpack :
--
--   job   =  74 : puts a Laurential given as a string in the system 
--                 container, with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : number of variables in the Laurent polynomial,
--                   a[2] : index of the polynomial in the system,
--                   b : string converted to an integer array,
--         =  75 : solves the Laurent system in the system container
--                 with the blackbox solver in standard double precision
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string;
--         =  76 : puts a polynomial given as a string in the system 
--                 container, with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : number of variables in the polynomial,
--                   a[2] : index of the polynomial in the system,
--                   b : string converted to an integer array,
--                 this operation is the reverse of job 67;
--         =  77 : solves the polynomial system in the system container
--                 with the blackbox solver in standard double precision
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string;
--         =  78 : computes the mixed volume for the system in the systems
--                 container and fills the cells container with the regular
--                 mixed-cell configuration constructed for the mixed volume,
--                 calling the Ada translation of MixedVol,
--                 if the standard systems container is empty, then the
--                 system in the standard Laurent systems container is taken;
--         =  79 : computes the mixed volume and stable mixed volume of the
--                 system in the container and fills the cells container with
--                 the mixed cells.
--         = 700 : solves the polynomial system in the system container
--                 with the blackbox solver in double double precision 
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string;
--         = 701 : solves the Laurent system in the system container
--                 with the blackbox solver in double double precision 
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string;
--         = 702 : solves the polynomial system in the system container
--                 with the blackbox solver in quad double precision 
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string;
--         = 703 : solves the Laurent system in the system container
--                 with the blackbox solver in quad double precision 
--                 and puts the solutions into the solution container,
--                 the two parameters on entry are as follows:
--                   a[0] : 1 or 2 for to be silent or not,
--                   a[1] : the number of tasks,
--                 on return in a[0] is the root count and if not silent,
--                 then a[1] contains the number of characters in b,
--                 where b is the root counter output string.
--
-- set and get the value of the gamma constant :
--
--   job   = 995 : returns the value of the complex gamma constant
--                 used in the solver (if the system was not special),
--                 on entry in a[0] is 1, 2, or 4, respectively for
--                 double, double double, or quad double precision,
--                 on return in c[0] is the real part of gamma,
--                 and in c[1] is the imaginary part of gamma;
--         = 996 : sets the value of the complex gamma constant,
--                 on entry in a[0] is 1, 2, or 4, respectively for
--                 double, double double, or quad double precision,
--                 and in c[0] is the real part of gamma,
--                 in c[1] is the imaginary part of gamma.
--
-- the size limit of the string representation of a polynomial :
-- 
--   job   = 600 : given on entry in a[0] the index k of a polynomial in
--                 the standard systems container, returns in b
--                 the size limit of the k-th standard polynomial;
--         = 601 : given on entry in a[0] the index k of a polynomial in
--                 the dobldobl systems container, returns in b
--                 the size limit of the k-th dobldobl polynomial;
--         = 602 : given on entry in a[0] the index k of a polynomial in
--                 the quaddobl systems container, returns in b
--                 the size limit of the k-th quaddobl polynomial;
--         = 603 : given on entry in a[0] the index k of a polynomial in
--                 the multprec systems container, returns in b
--                 the size limit of the k-th multprec polynomial;
--         = 604 : given on entry in a[0] the index k of a polynomial in
--                 the standard Laurent systems container, returns in b
--                 the size limit of the k-th standard Laurent polynomial;
--         = 605 : given on entry in a[0] the index k of a polynomial in
--                 the dobldobl Laurent systems container, returns in b
--                 the size limit of the k-th dobldobl Laurent polynomial;
--         = 606 : given on entry in a[0] the index k of a polynomial in
--                 the quaddobl Laurent systems container, returns in b
--                 the size limit of the k-th quaddobl Laurent polynomial;
--         = 607 : given on entry in a[0] the index k of a polynomial in
--                 the multprec Laurent systems container, returns in b
--                 the size limit of the k-th multprec Laurent polynomial.
--
-- the operations in the cells container :
--
--   job   =  80 : read mixed-cell configuration from file,
--                 and initializes the container;
--         =  81 : writes the mixed-cell configuration in the container;
--         =  82 : returns in a the number of cells in the container;
--         =  83 : returns in a the dimension of the lifted points
--                 in the container;
--         =  84 : returns in a the number of different supports
--                 and in b the number of occurrences of support;
--         =  85 : returns in a the number of different supports
--                 and in b the number of points in each support;
--         =  86 : returns in c the point of support a on place b;
--         =  87 : returns the inner normal in c for cell number in a;
--         =  88 : returns in b the number of points of each support
--                 in cell number a;
--         =  89 : given in a the cell number and with b = (i,j),
--                 returns in c the j-th point from the i-th list.
--         =  90 : returns in b the mixed volume of the cell a;
--         =  91 : sets the number of different supports to a[0],
--                 and in b[i] the number of occurrences of the
--                 (i+1)-th support list;
--         =  92 : appends the point in c to the i-th support, i = a[0]+1,
--                 b[0] must contain the length of the point;
--         =  93 : appends a mixed cell to the cells container,
--                 a[0] = number of different supports, r = a[0],
--                 a[1] = dimension of the lifted points, n = a[1],
--                 a[2] = length of the vector b,
--                 b[0] = total number of points in the cell,
--                 b[k] = number of points in k-th support,
--                 b[1+r+k] = label for the k-th point in cell,
--                 c = coordinates for the inner normal to the cell;
--         =  94 : clears the cell container;
--         =  95 : retrieves a mixed cell from the cell container,
--                 on entry: a[0] = number of the cell, on return
--                 are b and c, like in job 13, i.e.:
--                 b[0] = total number of points in the cell,
--                 b[k] = number of points in k-th support,
--                 b[1+r+k] = label for the k-th point in cell,
--                 c = coordinates for the inner normal to the cell;
--         =  96 : creates a random coefficient system, using the
--                 type of mixture and supports in the cells container;
--         =  97 : prompts the user for a polynomial system and stores it
--                 as random coefficient system in the cells container;
--         =  98 : writes the random coefficient system to the output;
--         =  99 : copy random coefficient system to systems container;
--         = 100 : copy system in systems container to cells container;
--         = 101 : create a polyhedral homotopy to solve a random system;
--         = 102 : solve start system corresponding with the k-th cell,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found;
--         = 103 : track the path starting at the i-th start solution 
--                 corresponding to the k-th mixed cell, on entry:
--                 a[0] = k, index to the corresponding mixed cell,
--                 b[0] = i, index to a start solution,
--                 b[1] = output code for the path trackers,
--                 on return: a target solution has been added;
--         = 104 : copy i-th target solution of the k-th cell to the
--                 solutions container, on entry: a = k and b = i;
--         = 105 : permutes the systems in the containers for standard
--                 complex polynomial and Laurent systems based on
--                 the induced permutation of the supports.
--   job   = 239 : returns in a the mixed volume of the points stored
--                 in the cells container.
--         = 240 : initializes the number of different supports with
--                 the value of a.
--
-- operations on cells induced by an integer valued lifting function :
--
--   job   = 741 : read an integer mixed-cell configuration from file,
--                 and initializes the integer cells container;
--         = 742 : writes the mixed-cell configuration in the container;
--         = 743 : returns in a the number of cells in the container;
--         = 744 : returns in a the dimension of the lifted points
--                 in the container;
--         = 745 : returns in a the number of different supports
--                 and in b the number of occurrences of support;
--         = 746 : returns in a the number of different supports
--                 and in b the number of points in each support;
--         = 747 : returns in c the point of support a on place b;
--         = 748 : returns the inner normal in c for cell number in a;
--         = 749 : returns in b the number of points of each support
--                 in cell number a;
--         = 750 : given in a the cell number and with b = (i,j),
--                 returns in c the j-th point from the i-th list.
--         = 751 : returns in b the mixed volume of the cell a;
--         = 752 : initializes the number of different supports
--                 with the value of a;
--         = 753 : sets the number of different supports to a[0],
--                 and in b[i] the number of occurrences of the
--                 (i+1)-th support list;
--         = 754 : appends the point in c to the i-th support, i = a[0],
--                 b[0] must contain the length of the point;
--         = 755 : appends a mixed cell to the cells container,
--                 a[0] = number of different supports, r = a[0],
--                 a[1] = dimension of the lifted points, n = a[1],
--                 a[2] = length of the vector b,
--                 b[0] = total number of points in the cell,
--                 b[k] = number of points in k-th support,
--                 b[1+r+k] = label for the k-th point in cell,
--                 c = coordinates for the inner normal to the cell;
--         = 756 : clears the cell container;
--         = 757 : retrieves a mixed cell from the cell container,
--                 on entry: a[0] = number of the cell, on return
--                 are b and c, like in job 13, i.e.:
--                 b[0] = total number of points in the cell,
--                 b[k] = number of points in k-th support,
--                 b[1+r+k] = label for the k-th point in cell,
--                 c = coordinates for the inner normal to the cell.
--         = 758 : makes the subdivision for the lifted points
--                 and type of mixture stored in the container.
--
-- operations for polyhedral homotopy in double double precision :
--
--         = 460 : creates a random coefficient system, using the
--                 type of mixture and supports in the cells container,
--                 with double double coefficients;
--         = 461 : prompts the user for a polynomial system with 
--                 double double complex coefficients and stores it
--                 as random coefficient system in the cells container;
--         = 462 : writes the random coefficient system with double
--                 double complex coefficients to the output;
--         = 463 : copy random coefficient system to systems container
--                 of polynomial systems with double double coefficients;
--         = 464 : copy system in systems container for double double
--                 complex coefficients into the cells container.
--         = 465 : create a polyhedral homotopy to solve a random system
--                 in double double precision;
--         = 466 : solve start system corresponding with the k-th cell,
--                 in double double precision,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found;
--         = 467 : track the path starting at the i-th start solution 
--                 corresponding to the k-th mixed cell, 
--                 in double double precision, on entry:
--                 a[0] = k, index to the corresponding mixed cell,
--                 b[0] = i, index to a start solution,
--                 b[1] = output code for the path trackers,
--                 on return: a target solution has been added;
--         = 468 : copy i-th target solution of the k-th cell to the
--                 dobldobl solutions container, on entry: a = k and b = i;
--         = 469 : permutes the systems in the containers for double
--                 double complex polynomial and Laurent systems based on
--                 the induced permutation of the supports.
--
-- operations for polyhedral homotopy in quad double precision :
--
--         = 470 : creates a random coefficient system, using the
--                 type of mixture and supports in the cells container,
--                 with quad double coefficients;
--         = 471 : prompts the user for a polynomial system with 
--                 quad double complex coefficients and stores it
--                 as random coefficient system in the cells container;
--         = 472 : writes the random coefficient system with quad
--                 double complex coefficients to the output;
--         = 473 : copy random coefficient system to systems container
--                 of polynomial systems with quad double coefficients;
--         = 474 : copy system in systems container for quad double
--                 complex coefficients into the cells container;
--         = 475 : create a polyhedral homotopy to solve a random system
--                 in quad double precision;
--         = 476 : solve start system corresponding with the k-th cell,
--                 in quad double precision,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found;
--         = 477 : track the path starting at the i-th start solution 
--                 corresponding to the k-th mixed cell, 
--                 in quad double precision, on entry:
--                 a[0] = k, index to the corresponding mixed cell,
--                 b[0] = i, index to a start solution,
--                 b[1] = output code for the path trackers,
--                 on return: a target solution has been added;
--         = 478 : copy i-th target solution of the k-th cell to the
--                 quaddobl solutions container, on entry: a = k and b = i;
--         = 479 : permutes the systems in the containers for quad
--                 double complex polynomial and Laurent systems based on
--                 the induced permutation of the supports.
--
-- functions to query the stable cells in the cells container :
--
--   job   = 879 : returns in a[0] the value 1 or 0, depending whether
--                 stable mixed cells are stored in the cells container
--                 or not;
--         = 880 : returns in a[0] the number of original cells,
--                 the cells without artificial origin; 
--         = 881 : returns in a[0] the number of stable mixed cells;
--         = 882 : solve start system corresponding to the k-th stable cell,
--                 in standard precision,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found;
--         = 883 : solve start system corresponding to the k-th stable cell,
--                 in double double precision,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found;
--         = 884 : solve start system corresponding to the k-th stable cell,
--                 in quad double precision,
--                 where k is given on input as the value of a,
--                 on return in b is the number of solutions found.
--
-- MOVING START SOLUTIONS TO CONTAINER :
--
--   job   = 597 : copy i-th start solution of the k-th cell to the
--                 standard solutions container, on entry: a = k and b = i;
--         = 598 : copy i-th start solution of the k-th cell to the
--                 dobldobl solutions container, on entry: a = k and b = i;
--         = 599 : copy i-th start solution of the k-th cell to the
--                 quaddobl solutions container, on entry: a = k and b = i.
--
--   job   = 109 : stores a random polynomial system in the container
--                 for systems with standard complex coefficients,
--                 the parameters on input should be as follows:
--                 a[0] : n, the number of variables in the system;
--                 a[1] : neq, the number of equations in the system;
--                 b[0] : m, the number of monomials per equations;
--                 b[1] : d, the degree bound on the monomials;
--                 b[2] : c, type of coefficient: 0, 1, or 2:
--                   c = 0 : default complex coefficient on unit circle,
--                   c = 1 : all coefficients are equal to one,
--                   c = 2 : real coefficients in [-1,+1].
--         = 548 : stores a random polynomial system in the container
--                 for systems with double double complex coefficients,
--                 the parameters on input should be as follows:
--                 a[0] : n, the number of variables in the system;
--                 a[1] : neq, the number of equations in the system;
--                 b[0] : m, the number of monomials per equations;
--                 b[1] : d, the degree bound on the monomials;
--                 b[2] : c, type of coefficient: 0, 1, or 2:
--                   c = 0 : default complex coefficient on unit circle,
--                   c = 1 : all coefficients are equal to one,
--                   c = 2 : real coefficients in [-1,+1].
--         = 549 : stores a random polynomial system in the container
--                 for systems with quad double complex coefficients,
--                 the parameters on input should be as follows:
--                 a[0] : n, the number of variables in the system;
--                 a[1] : neq, the number of equations in the system;
--                 b[0] : m, the number of monomials per equations;
--                 b[1] : d, the degree bound on the monomials;
--                 b[2] : c, type of coefficient: 0, 1, or 2:
--                   c = 0 : default complex coefficient on unit circle,
--                   c = 1 : all coefficients are equal to one,
--                   c = 2 : real coefficients in [-1,+1].
--
-- operations for linear-product root counts and systems :
--
--   job   = 110 : constructs a supporting set structure for the system
--                 in the systems container;
--         = 111 : writes the set structure to screen;
--         = 112 : returns in a the root count based on the set structure;
--         = 113 : puts in the system container a random linear-product
--                 system based on the supporting set structure;
--         = 114 : puts in the solution container all solution of
--                 the random linear-product system;
--         = 115 : clears the set structure;
--         = 116 : returns in b the string representation of the current
--                 set structure and in a[0] the number of characters in b;
--         = 117 : parses string in b, with number of characters in a[0]
--                 into a set structure.
--         = 118 : verifies whether the set structure supports the
--                 standard polynomial system in the container,
--                 and return 1 in a[0] if true, 0 in a[0] if false,
--                 if a[0] equals 1 on input, then extra information
--                 is written to screen.
--         = 119 : returns in b[0] the degree of polynomial with index a[0]
--                 stored in the standard polynomial systems container.
--
-- multihomogeneous Bezout numbers and start systems :
--
--         = 530 : creates a partition for the system in the container
--                 and returns this partition as a string in b,
--                 a[0] contains the Bezout number and
--                 a[1] the number of characters in the string b;
--         = 531 : given in a[0] the number of characters in the string b
--                 of a partition of the set of unknowns, returns in a[0]
--                 the m-homogeneous Bezout number of the system in the
--                 standard containers with respect to the given partition;
--         = 532 : puts in the systems container a random linear-product
--                 system based on a given partition, apply then job 114
--                 to solve this linear-product system.
--
-- the operations in the Laurent systems container :
-- 
--   job   = 120 : read polynomial system and put in container;
--         = 121 : write the polynomial system in the container;
--         = 122 : return in a[0] the dimension of the polynomial system;
--         = 123 : initializes the container with the dimension in a[0];
--         = 124 : return in a[0] the number of terms in the i-th polynomial;
--         = 125 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         = 126 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         = 127 : the systems container is cleared;
--         = 128 : loads a Laurent polynomial from the standard double
--                 systems container into a string:
--                   a[0] : index of the polynomial k on entry,
--                           and number of characters in the string on return,
--                   b : characters in the string representation of
--                        the k-th polynomial in the container,
--                 this is the reverse of operation 74.   
--
-- the operations in the Laurent systems container with double doubles :
--
--   job   = 550 : read polynomial system and put in container;
--         = 551 : write the polynomial system in the container;
--         = 552 : return in a[0] the dimension of the polynomial system;
--         = 553 : initializes the container with the dimension in a[0];
--         = 554 : return in a[0] the number of terms in the i-th polynomial;
--         = 555 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         = 556 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         = 557 : the systems container is cleared;
--         = 558 : puts a Laurent polynomial given as a string in the
--                 container for systems with double double precision,
--                 with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : number of variables in the Laurent polynomial,
--                   a[2] : index of the polynomial in the system,
--                   b : string converted to an integer array;
--         = 559 : loads a Laurent polynomial from the double double
--                 systems container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 558.   
--
-- the operations in the Laurent systems container with quad doubles :
--
--   job   = 560 : read polynomial system and put in container;
--         = 561 : write the polynomial system in the container;
--         = 562 : return in a[0] the dimension of the polynomial system;
--         = 563 : initializes the container with the dimension in a[0];
--         = 564 : return in a[0] the number of terms in the i-th polynomial;
--         = 565 : return in c the coefficient (real and imaginary part),
--                    and in b the exponent vector (i = a[1], j = a[2])
--                 of the j-th term in the i-th polynomial;
--         = 566 : add to the i-th polynomial the term with coefficient
--                     in c and exponent vector in b;
--         = 567 : the systems container is cleared;
--         = 568 : puts a Laurent polynomial given as a string in the
--                 container for systems with quad double precision,
--                 with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : number of variables in the Laurent polynomial,
--                   a[2] : index of the polynomial in the system,
--                   b : string converted to an integer array;
--         = 569 : loads a Laurent polynomial from the quad double
--                 systems container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 568.
--
-- the operations in the Laurent systems container in multiprecision :
--
--   job   = 570 : read polynomial system and put in container;
--         = 571 : write the polynomial system in the container;
--         = 572 : return in a[0] the dimension of the polynomial system;
--         = 573 : initializes the container with the dimension in a[0];
--         = 574 : return in a[0] the number of terms in the i-th polynomial;
--         = 577 : the contents of the systems container is cleared.
--         = 578 : puts a Laurent polynomial given as a string in the
--                 container for systems with quad double precision,
--                 with the input parameters as follows:
--                   a[0] : number of characters in the string,
--                   a[1] : number of variables in the Laurent polynomial,
--                   a[2] : index of the polynomial in the system,
--                   a[3] : precision to evaluate the coefficients,
--                   b : string converted to an integer array.
--         = 579 : loads a Laurent polynomial from the multprec
--                 systems container into a string:
--                   a[0] : index of the polynomial k on entry,
--                          and number of characters in the string on return,
--                   b : characters in the string representation of
--                       the k-th polynomial in the container,
--                 this is the reverse of operation 578.
--
-- operations to incrementally read/write solution from/to file :
--
--   job   = 130 : prompts the user for a file name for solutions,
--                 which is then opened for opened for input;
--         = 131 : prompts the user for a file name for solutions,
--                 which is then created for output;
--         = 132 : scans the file till after "SOLUTIONS", this scanning
--                 is needed if the file starts with a system;
--         = 133 : reads from file (opened by job 10) the length and 
--                 dimension of the solutions on file;
--         = 134 : writes to file (created by job 10) the length and
--                 dimension of the solutions on file;
--         = 135 : reads the next solution from file (opened by job 10)
--                 where a must contain the length of the solution vector,
--                 on return is the data in b and c as in job 4;
--         = 136 : writes the next solution to file (created by job 11)
--                 with the number in a and data in b and c as in job 4,
--                 on return is in a the updated counter;
--         = 137 : close solution input file;
--         = 138 : close solution output file;
--         = 139 : writes the solutions banner to the defined output file;
--         = 140 : writes the dimensions of the solutions to the output
--                 file as defined in PHCpack_Operations;
--         = 141 : writes next solution to the defined output file,
--                 the file stored in PHCpack_Operations, in the same
--                 format as job 136;
--         = 142 : computes next solution of total degree start system,
--                 on entry is in a the dimension and solution number,
--                 on return is the data in b and c as in job 4;
--         = 143 : computes next solution of linear product start system,
--                 on entry is in a the dimension and solution counter,
--                 on return is the data in b and c as in job 4,
--                 with in a the updated counter from the loop;
--         = 144 : solves one linear system to find a solution of a
--                 linear-product start system, indexed by the data
--                 on entry in a the dimension and solution number,
--                 on return is the data in b and c as in job 4;
--         = 145 : reads the next witness point from file for the set whose
--                 index is either 1 or 2, according to the value of a,
--                 on return is the data in b and c as in job 4.
--         = 146 : see job 38 (drop by name).
--
-- extra operations for tracking paths with incremental read/write :
--
--   job   = 147 : create an evaluator for the system in the container;
--         = 148 : create an evaluator for the Jacobian matrix;
--         = 149 : refine a solution with Newton on the container system  
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return in (a,b,c) is the refined solution;
--         = 150 : read target system without its solutions;
--         = 151 : read start system without start solutions;
--         = 152 : create homotopy with random gamma constant;
--         = 153 : create homotopy with gamma given in c;
--         = 154 : clear the homotopy.
--         = 155 : track one path silently, without intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 156 : track one path with intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 157 : writes the next solution to defined output file,
--                 with extra diagnostics, provided in a:
--                 as follows a = (#step,#fail,#iter,#syst);
--         = 158 : writes a string of characters to defined output file;
--                 with in a the number of characters, and
--                      in b the character string converted
--                      to an integer array;
--         = 159 : writes a sequence of integers to the defined output file,
--                 each integer is seperated from the next by a space,
--                 with in a the number of integers, and
--                      in b the sequence of integer numbers to be written;
--         = 160 : writes a sequence of doubles to the defined output file,
--                 each double is seperated from the next by a space,
--                 with in a the number of doubles, and
--                      in c the sequence of doubles to be written;
--         = 161 : file name of target system to read without solutions
--                 is given in b, in a is the number of characters;
--         = 162 : file name of start system to read without solutions
--                 is given in b, in a is the number of characters;
--         = 163 : file name of linear-product start system to read 
--                 is given in b, in a is the number of characters;
--         = 164 : create a cascade homotopy from the stored systems;
--         = 165 : create a diagonal homotopy from the systems stored
--                 as target and start systems in standard double precision,
--                 the input parameters a and b are the dimensions of the
--                 witness sets;
--         = 289 : create a diagonal homotopy from the systems stored
--                 as target and start systems in double double precision,
--                 the input parameters a and b are the dimensions of 
--                 the witness sets;
--         = 290 : create a diagonal homotopy from the systems stored
--                 as target and start systems in quad double precision,
--                 the input parameters a and b are the dimensions of 
--                 the witness sets.
--         = 166 : reads first or second witness set from file,
--                 depending on whether the value of a equals 1 or 2,
--                 and returns in a the dimension of the ambient space
--                 and in b the following two numbers:
--                   b[0] : dimension of the solution set,
--                   b[1] : degree of the solution set;
--         = 167 : resets the input file to read in the witness set k,
--                 where k is the value of a on input, on return are
--                 in b the following two numbers:
--                   b[0] : the length of the solution list,
--                   b[1] : the dimension of the solution vectors;
--         = 168 : given in a the ambient dimensions of two witness sets,
--                 and in b their respective dimensions,
--                 on return is in a the dimension of the diagonal homotopy
--                 to start the cascade in extrinsic coordinates.
--         = 169 : computes a witness set for a polynomial in container,
--                 on entry in a and b are
--                   a[0] : index of the polynomial in the container,
--                   a[1] : number of characters in the string b;
--                   b : characters of the name of the output file.
--         = 170 : eliminates the extrinsic diagonal for the system
--                 and the solutions in the container,
--                 in standard double precision, on entry are
--                   a[0] : current number of slack variables,
--                   a[1] : number of slack variables to be added.
--         = 299 : eliminates the extrinsic diagonal for the system
--                 and the solutions in the container,
--                 in double double precision, on entry are
--                   a[0] : current number of slack variables,
--                   a[1] : number of slack variables to be added.
--         = 312 : eliminates the extrinsic diagonal for the system
--                 and the solutions in the container,
--                 in quad double precision, on entry are
--                   a[0] : current number of slack variables,
--                   a[1] : number of slack variables to be added.
--         = 171 : removes the last slack variable for the system
--                 and the solutions in the container, on input is
--                 in a the current number of slack variables.
--
-- extra jobs for double double and quad double precision :
--
--         = 872 : read double double target system without solutions;
--         = 873 : read quad double target system without solutions.
--
-- ON RETURN :
--
-- track operations for double double precision :
--
--   job   = 172 : make a homotopy in double double precision
--                 with a random gamma constant.
--         = 173 : make a homotopy in double double precision
--                 with a given gamma constant.
--         = 174 : clear the homotopy.
--         = 175 : track one path silently, without intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 176 : track one path with intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 177 : writes the next solution to defined output file,
--                 with extra diagnostics, provided in a:
--                 as follows a = (#step,#fail,#iter,#syst);
--         = 178 : create a cascade homotopy from the stored systems.
--
-- track operations for quad double precision :
--
--   job   = 182 : create homotopy in quad double precision,
--                 with a random gamma constant.
--         = 183 : create homotopy in quad double precision,
--                 with a given gamma constant.
--         = 184 : clear the homotopy.
--         = 185 : track one path silently, without intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 186 : track one path with intermediate output,
--                 with in a the dimension of the solution,
--                      in b the multiplicity flag, and
--                      in c the coordinates of the start solution,
--                 on return is the solution at the end of the path,
--                 and in a are (#step,#fail,#iter,#syst);
--         = 187 : writes the next solution to defined output file,
--                 with extra diagnostics, provided in a:
--                 as follows a = (#step,#fail,#iter,#syst);
--         = 188 : create a cascade homotopy from the stored systems.
--
-- some ad hoc operations :
--
--   job   = 191 : define output file from a string given in b,
--                 with in a[0] the number of characters in b;
--         = 192 : close the defined output file.
--  
--   Jobs 193 and 194 involve tuning of numerical continuation parameters
--   and are described with related jobs 70 to 73.
--
-- deflation and one Newton step :
--
--   job   = 179 : applies the variable precision Newton's method,
--                 in a[0] is the dimension of the problem,
--                 in a[1] is the number of characters in the string b,
--                 in a[2] is the number of wanted decimal places,
--                 in a[3] is the maximum number of Newton steps,
--                 in a[4] is the maximum number of decimal places
--                 to estimate the loss of accuracy,
--                 in b is the string representation of a (Laurent)
--                 polynomial system.  The container with multiprecision
--                 solutions must be initialized and then the Newton step
--                 replaces the multiprecision solutions in the container
--                 with the updated solutions computed by the Newton step.
--
--   job   = 196 : applies deflation on the system and solutions in the
--                 containers with standard precision and settings in
--                 a[0] : the maximum number of iterations per root,
--                 b[0] : the maximum number of deflations per root,
--                 c[0] : the tolerance on the error on the root,
--                 c[1] : the tolerance on the residual on the root,
--                 c[2] : the tolerance for the numerical rank;
--         = 195 : does one Newton step with multiprecision arithmetic
--                 using system and solutions in the containers;
--         = 197 : does one Newton step with quad double arithmetic
--                 using system and solutions in the containers;
--         = 198 : does one Newton step with double double arithmetic
--                 using system and solutions in the containers;
--         = 199 : does one Newton step with standard double arithmetic
--                 using system and solutions in the containers.
--   job   = 249 : applies deflation on the system and solutions in the
--                 containers with double double precision and settings in
--                 a[0] : the maximum number of iterations per root,
--                 b[0] : the maximum number of deflations per root,
--                 c[0] : the tolerance on the error on the root,
--                 c[1] : the tolerance on the residual on the root,
--                 c[2] : the tolerance for the numerical rank;
--         = 250 : applies deflation on the system and solutions in the
--                 containers with double double precision and settings in
--                 a[0] : the maximum number of iterations per root,
--                 b[0] : the maximum number of deflations per root,
--                 c[0] : the tolerance on the error on the root,
--                 c[1] : the tolerance on the residual on the root,
--                 c[2] : the tolerance for the numerical rank.
--
-- computation of multiplicity structure :
--
--   job   = 732 : computes in standard double precision,
--                 on entry in a[0] is the maximum deflation order
--                 in b[0] is 0 or 1, as a flag to indicate whether
--                 to be silent or verbose (to screen) respectively,
--                 in c[0] is the tolerance for the numerical rank,
--                 on return in a is the computed multiplicity
--                 and in b are order+1 integers with the values
--                 of the Hilbert function;
--   job   = 733 : computes in double double precision,
--                 on entry in a[0] is the maximum deflation order
--                 in b[0] is 0 or 1, as a flag to indicate whether
--                 to be silent or verbose (to screen) respectively,
--                 in c[0] is the tolerance for the numerical rank,
--                 on return in a is the computed multiplicity
--                 and in b are order+1 integers with the values
--                 of the Hilbert function;
--   job   = 734 : computes in quad double precision,
--                 on entry in a[0] is the maximum deflation order
--                 in b[0] is 0 or 1, as a flag to indicate whether
--                 to be silent or verbose (to screen) respectively,
--                 in c[0] is the tolerance for the numerical rank,
--                 on return in a is the computed multiplicity
--                 and in b are order+1 integers with the values
--                 of the Hilbert function.
--
-- one Newton step on Laurent systems :
--
--   job   = 326 : does one Newton step with standard double arithmetic
--                 using Laurent system and solutions in the containers;
--         = 327 : does one Newton step with double double arithmetic
--                 using Laurent system and solutions in the containers;
--         = 328 : does one Newton step with quad double arithmetic
--                 using Laurent system and solutions in the containers;
--         = 329 : does one Newton step with multiprecision arithmetic
--                 using Laurent system and solutions in the containers.
--
-- operations to write solutions to strings :
-- 
--   job   = 200 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b
--                 the number of characters for the string representation
--                 of the solution with number a[0];
--         = 201 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b the string
--                 representation of the solution with number a[0];
--         = 202 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b
--                 the number of characters for the string representation
--                 of the introduction to the solution with number a[0];
--         = 203 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b the string
--                 representation of the introduction to the solution
--                 with number a[0];
--         = 204 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b
--                 the number of characters for the string representation
--                 of the vector in the solution with number a[0];
--         = 205 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b the string
--                 representation of the vector in the solution
--                 with number a[0];
--         = 206 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b
--                 the number of characters for the string representation
--                 of the diagnostics of the solution with number a[0];
--         = 207 : with the solutions container initialized,
--                 and in a[0] a solution number, returns in b the string
--                 representation of the diagnostics of the solution
--                 with number a[0];
--         = 208 : appends a solution string to the solutions container,
--                 on input in a[0] is the number of variables,
--                 in a[1] is the number of characters in the string,
--                 and in b is the solution string.
--         = 209 : replaces a solution string in the solutions container,
--                 on input in a[0] is the index to the solution,
--                 in a[1] is the number of variables,
--                 in a[2] is the number of characters in the string,
--                 and in b is the solution string.
--
-- Numerical Schubert calculus with Pieri homotopies :
--
--   job  =  210 : display the menu of all available options;
--        =  211 : initialize dimensions m,p,q calling use_c2pieri
--                 with a[0] = m, a[1] = p, and a[2] = q;
--        =  212 : initialize input planes calling use_c2pieri
--                 with a[0] = m, a[1] = p, and a[2] = q,
--                      b = m*p + q*(m+p), 
--                      c = coefficients of the input planes,
--                 in pairs of doubles (real + imaginary part of complex),
--                 and as matrices stored row wise;
--        =  213 : initialize interpolation points calling use_c2pieri
--                 with a[0] = m, a[1] = p, and a[2] = q,
--                      b = m*p + q*(m+p), 
--                      c = coefficients of the interpolation points,
--                 in pairs of doubles (real + imaginary part of complex);
--        =  214 : store the start pivots calling use_c2pieri
--                 with a[0] = p, and 
--                      b = the 2*p entries of top and bottom pivots;
--        =  215 : store the target pivots calling use_c2pieri
--                 with a[0] = p, and 
--                      b = the 2*p entries of top and bottom pivots;
--        =  216 : store the start solution curve calling use_c2pieri
--                 with a[0] = degree of freedom in start pivots, and
--                      c = coefficients of the complex vector in pairs
--                 of doubles (real + imaginary parts);
--        =  217 : retrieve target solution curve calling use_c2pieri
--                 with a[0] = degree of freedom in target pivots,
--                 on return are then in c the coefficients of the target;
--        =  218 : track solution path without intermediate output;
--        =  219 : track solution path with output diagnostics;
--        =  220 : verify intersection conditions without output,
--                 on return c contains sum of residuals;
--        =  211 : verify intersection conditions with extra output,
--                 on return c contains sum of residuals;
--        =  222 : destroy the Pieri state machine.
--        =  223 : compute Pieri root count
--        =  224 : return localization poset string
--        =  225 : run Pieri homotopies
--        =  226 : generate real osculating planes
--        =  227 : make Schubert polynomial system
--
-- Numerical Schubert calculus with Littlewood-Richardson homotopies :
--
--   job  =  228 : given in a the dimension of a general Schubert problem:
--                 a[0] : the ambient dimension n of the space,
--                 a[1] : the dimension k of the solution planes,
--                 a[2] : the number c of intersection conditions,
--                 and in a[3] is the verbose flag, 0 for silent, 1 for output;
--                 in b are the brackets, as many integers as the dimension k
--                 of the solution planes times c, the number of conditions.
--        =  229 : runs the Littlewood-Richardson homotopies on a generic,
--                 randomly generated set of flags, in standard double
--                 precision, with inputs:
--                 a[0] : the ambient dimension n of the space,
--                 a[1] : the dimension k of the solution planes,
--                 a[2] : the number c of intersection conditions,
--                 a[3] : indicates the monitoring of the homotopies,
--                 a[4] : indicates the verification of the homotopies,
--                 a[5] : number of characters in the file name;
--                 in b are the brackets, as many integers as the dimension k
--                 of the solution planes times c, the number of conditions;
--                 in c are the characters of the name of the output file;
--        =  180 : runs the Littlewood-Richardson homotopies on a generic,
--                 randomly generated set of flags, in double double precision,
--                 with inputs:
--                 a[0] : the ambient dimension n of the space,
--                 a[1] : the dimension k of the solution planes,
--                 a[2] : the number c of intersection conditions,
--                 a[3] : indicates the monitoring of the homotopies,
--                 a[4] : indicates the verification of the homotopies,
--                 a[5] : number of characters in the file name;
--                 in b are the brackets, as many integers as the dimension k
--                 of the solution planes times c, the number of conditions;
--                 in c are the characters of the name of the output file;
--        =  181 : runs the Littlewood-Richardson homotopies on a generic,
--                 randomly generated set of flags, in quad double precision,
--                 with inputs:
--                 a[0] : the ambient dimension n of the space,
--                 a[1] : the dimension k of the solution planes,
--                 a[2] : the number c of intersection conditions,
--                 a[3] : indicates the monitoring of the homotopies,
--                 a[4] : indicates the verification of the homotopies,
--                 a[5] : number of characters in the file name;
--                 in b are the brackets, as many integers as the dimension k
--                 of the solution planes times c, the number of conditions;
--                 in c are the characters of the name of the output file.
-- 
-- addition operations for diagonal homotopies :
--
--   job   = 270 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in standard double precision for the polynomial
--                 stored in b;
--         = 259 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in double double precision for the polynomial
--                 stored in b;
--         = 269 : given in a[0] the number n of variables, 
--                       in a[1] the number of characters stored in b,
--                 where b represents a polynomial in n variables,
--                 places a witness set in the systems and solutions
--                 container in quad double precision for the polynomial
--                 stored in b;
--         = 271 : makes the solutions to start the cascade to intersect
--                 two witness sets of dimensions in a[0] and b[0],
--                 in standard double precision;
--         = 230 : doubles the number of symbols in the symbol table
--                 needed to write the target system solved to start the
--                 cascade of diagonal homotopies in extrinsic coordinates,
--                 given in a[0] the ambient dimension, original #variables,
--                       in a[1] the top dimension of the set,
--                       in a[2] the number of characters stored in b,
--                 where b stores the names of the symbols in the first set,
--                 on a successful return, the symbol table will contain the
--                 suffixed symbols to write the target system properly;
--         = 297 : makes the solutions to start the cascade to intersect
--                 two witness sets of dimensions in a[0] and b[0],
--                 in double double precision;
--         = 298 : makes the solutions to start the cascade to intersect
--                 two witness sets of dimensions in a[0] and b[0],
--                 in quad double precision.
--
-- univariate root finders :
--
--   job   = 272 : standard precision univariate solver of polynomial
--                 which must be in the systems container, on input are
--                 in a: the maximum number of iterations;
--                 in c: the accuracy requirement, and on return are
--                 in b: the number of iterations spent and the solution
--                 container contains the solutions.
--   job   = 273 : double double precision univariate solver of polynomial
--                 which must be in the systems container, on input are
--                 in a: the maximum number of iterations;
--                 in c: the accuracy requirement, and on return are
--                 in b: the number of iterations spent and the solution
--                 container contains the solutions.
--   job   = 274 : quad double precision univariate solver of polynomial
--                 which must be in the systems container, on input are
--                 in a: the maximum number of iterations;
--                 in c: the accuracy requirement, and on return are
--                 in b: the number of iterations spent and the solution
--                 container contains the solutions.
--   job   = 275 : multiprecision univariate solver of polynomial
--                 which must be in the systems container, on input are
--                 in a[0]: number of decimal places in the working precision,
--                    a[1]: the maximum number of iterations,
--                 in c: the accuracy requirement, and on return are
--                 in b: the number of iterations spent and the solution
--                 container contains the solutions.
--
-- operations on the pool of systems :
--
--   job   = 300 : initializes the system pool with n = a[0];
--         = 301 : returns the size of the system pool in a[0];
--         = 302 : reads a system p iand with k = a[0], the data of p
--                 for the k-th system in the pool is created;
--         = 303 : writes the k-th system, with k = a[0];
--         = 304 : creates k-th system, k = a[0], from container.
--   job   = 313 : copies the k-th system in the pool to the standard system
--                 container, where k is given as a[0];
--         = 314 : copies the k-th system in the pool to the dobldobl system
--                 container, where k is given as a[0];
--         = 315 : copies the k-th system in the pool to the quaddobl system
--                 container, where k is given as a[0];
--         = 316 : the size of the dobldobl systems pool is returned in a[0];
--         = 317 : the size of the dobldobl systems pool is returned in a[0];
--         = 318 : initialize dobldobl system pool with n = a[0];
--         = 319 : initialize quaddobl system pool with n = a[0];
--         = 608 : takes system of the dobldobl container to make k-th 
--                 system in the dobldobl system pool, k = a[0];
--         = 609 : takes system of the quaddobl container to make k-th 
--                 system in the quaddobl system pool, k = a[0];
--         = 697 : clears the standard system pool;
--         = 698 : clears the dobldobl system pool;
--         = 699 : clears the quaddobl system pool.
-- 
--   a        memory allocated a natural number, either the size
--
-- operations on the pool of solution lists :
--
--   job   = 320 : initializes the solution pool with n = a[0];
--         = 321 : returns the size of the solution pool in a[0].
--         = 322 : returns the length of the k-th solution list,
--                 where k = a[0] on entry and length = b[0] on return;
--         = 323 : returns the dimension of the k-th solution list,
--                 where k = a[0] on entry and dimension = b[0] on return;
--         = 324 : appends a solution to the k-th solution list,
--                 where k = a[0], n = b[0], m = b[1], and c is an array
--                 of 2*n+5 doubles in the following order:
--                 two doubles for the complex continuation parameter t,
--                 2*n doubles for the coefficients of the solution vector,
--                 one double for the norm of last Newton update,
--                 one double for the inverse of condition# estimate,
--                 one double for the norm of the residual;
--         = 325 : retrieves the i-th solution of the k-th list,
--                 where k = a[0] and i = a[1] on entry,
--                 on return in b[0] is m and c is the array of doubles
--                 of dimension 2*n+5 to store the solution data.
--
-- operations on monomial maps as solutions of binomial systems :
--
--   job   = 430 : solves binomial system in Laurent container,
--                 the option puretopdim is given in a[0];
--         = 431 : writes the solution maps to screen;
--         = 432 : clears the maps stored in the container;
--         = 433 : returns in a the top dimension of the maps;
--         = 434 : returns in b the number of maps of dimension a.
--         = 435 : given in a[0] the dimension and in a[1] the index of
--                 a map, returns in b the degree of the map.
--         = 436 : given in a[0] the dimension of the map,
--                       in a[1] the index of of the map
--                       in a[2] the number n of variables,
--                 returns in c the coefficients of the map,
--                 as 2*n doubles, representing real and imaginary parts;
--         = 437 : given in a[0] the dimension of the map,
--                       in a[1] the index of of the map
--                       in a[2] the number n of variables,
--                 returns in b the exponents of the map, as 
--                 a flattened vector of dim vectors of range 1..n;
--         = 438 : given in a[0] the dimension of the map,
--                       in a[1] the index of of the map
--                       in a[2] the number n of variables,
--                 returns in b the exponents of the map, as 
--                 a flattened vector of dim vectors of range 1..n, and
--                 returns in c the coefficients of the map,
--                 as 2*n doubles, representing real and imaginary parts.
--
-- operations for the generators in the path trackers :
--
-- ON ENTRY :
--   job   = 500 : initialize homotopy in standard double precision
--                 with the target and start systems stored in containers;
--         = 501 : initialize homotopy in double double precision
--                 with the target and start systems stored in containers;
--         = 502 : initialize homotopy in quad double precision
--                 with the target and start systems stored in containers;
--         = 503 : takes solution at position a[0] in the standard solution
--                 container and initializes the standard path tracker;
--         = 504 : takes solution at position a[0] in the double double
--                 container and initializes the double double path tracker;
--         = 505 : takes solution at position a[0] in the quad double
--                 container and initializes the quad double path tracker;
--         = 506 : applies one predictor-corrector step in standard double
--                 precision and replaces the solution in the standard
--                 solutions container at position equal to the value of a[0];
--         = 507 : applies one predictor-corrector step in double double
--                 precision and replaces the solution in the double double
--                 solutions container at position equal to the value of a[0];
--         = 508 : applies one predictor-corrector step in quad double
--                 precision and replaces the solution in the quad double
--                 solutions container at position equal to the value of a[0].
--         = 509 : clears standard path tracker;
--         = 510 : clears double double path tracker;
--         = 511 : clears quad double path tracker;
--         = 512 : initialize homotopy for arbitrary multiprecision,
--                 with the target and start systems stored in container,
--                 using the number of decimal places in the working
--                 precision as given by the value in a[0];
--         = 513 : takes solution at position a[0] in the multiprecision 
--                 solution container and initializes the path tracker.
--         = 514 : applies one predictor-corrector step in multiple
--                 precision and replaces the solution in the multiprecision
--                 solutions container at position equal to the value of a[0];
--         = 515 : clears the multiprecision path tracker.
--         = 516 : initialize homotopy for variable precision tracking,
--                 with the target and start systems stored as strings,
--                 the function expects three values in a:
--                 a[0] = whether a fixed gamma is used or not (1 or 0),
--                 a[1] = the total number of characters in the string b,
--                 a[2] = the number of characters occupied by the first
--                 system (the target system) stored in b,
--                 b holds the string representations of two systems,
--                 respectively the target and start system in the homotopy;
--         = 517 : takes solution given as string representation in b,
--                 in a[0] = the number of characters in the string b,
--                 in a[1] = the number of variables in the solution
--                 represented by b, to initialize the variable precision
--                 path tracker with;
--         = 518 : applies one predictor-corrector step in variable
--                 precision and expects four values in a on entry:
--                 a[0] = the wanted number of accurate decimal places;
--                 a[1] = the maximum precision to be used;
--                 a[2] = the maximum number of corrector steps;
--                 a[3] = whether intermediate output is wanted or not,
--                 where 1 is true and 0 is false; and
--                 returns in b the number of characters in the string
--                 of the solution that can be retrieved with job 520;
--         = 519 : clears the variable precision path tracker;
--         = 520 : return current variable precision solution in b
--                 as computed by job 518, the number of characters in b
--                 equals the value as a[0] which should be the same value
--                 as the one returned in a[0] of job 518, called just before.
--
-- operations on multiprecision homotopies :
--
--   job   = 522 : create homotopy with multiprecision,
--                 with a random gamma constant.
--         = 523 : create homotopy with multiprecision,
--                 with a gamma constant given by two doubles in c.
--         = 524 : clear the homotopy.
--
-- Launching crude path trackers, for an artificial parameter homotopy,
-- with defined target system, start system, and start solutions,
-- in double, double double, and quad double precision :
--
--   job   = 622 : crude path trackers in double precision,
--                 if a[0] = 1, then verbose, otherwise mute;
--         = 623 : crude path trackers in double double precision,
--                 if a[0] = 1, then verbose, otherwise mute;
--         = 624 : crude path trackers in quad double precision,
--                 if a[0] = 1, then verbose, otherwise mute.
--
-- homotopy membership test on point, given a witness set :
--
--   job   = 537 : runs the membership test in standard double precision,
--                 for a witness set stored in the standard containers,
--                 defined by an ordinary polynomial system,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b[0] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 and in b[1] is the dimension of the witness set,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 2*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 538 : runs the membership test in double double precision,
--                 for a witness set stored in the dobldobl containers,
--                 defined by an ordinary polynomial system,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b is the dimension n of the test point,
--                 and in b[1] is the dimension of the witness set,
--                 which equals the number of complex coordinates,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 4*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 538 : runs the membership test in quad double precision,
--                 for a witness set stored in the quaddobl containers,
--                 defined by an ordinary polynomial system,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b is the dimension n of the test point,
--                 and in b[1] is the dimension of the witness set,
--                 which equals the number of complex coordinates,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 8*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success.
--   job   = 795 : runs the membership test in standard double precision,
--                 for a witness set stored in the standard containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b[0] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 and in b[1] is the dimension of the witness set,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 2*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 796 : runs the membership test in double double precision,
--                 for a witness set stored in the dobldobl containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b is the dimension n of the test point,
--                 and in b[1] is the dimension of the witness set,
--                 which equals the number of complex coordinates,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 4*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 797 : runs the membership test in quad double precision,
--                 for a witness set stored in the quaddobl containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in b is the dimension n of the test point,
--                 and in b[1] is the dimension of the witness set,
--                 which equals the number of complex coordinates,
--                 on input in c are first the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 followed then by the coordinates of the test point,
--                 if a test point has dimension n, then c on input
--                 is expected to have 2 + 8*n doubles;
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success.
--   job   = 822 : runs the membership test in standard double precision,
--                 for a witness set stored in the standard containers,
--                 defined by an ordinary polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in standard double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success.
--   job   = 823 : runs the membership test in double double precision,
--                 for a witness set stored in the double double containers,
--                 defined by an ordinary polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in double double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 824 : runs the membership test in quad double precision,
--                 for a witness set stored in the quad double containers,
--                 defined by an ordinary polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in quad double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 825 : runs the membership test in standard double precision,
--                 for a witness set stored in the standard containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in standard double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 826 : runs the membership test in double double precision,
--                 for a witness set stored in the double double containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in double double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success;
--   job   = 827 : runs the membership test in quad double precision,
--                 for a witness set stored in the quad double containers,
--                 defined by a Laurent polynomial systems,
--                 on input in a[0] is the verbose flag:
--                 0 for no output, or 1 for diagnostic intermediate output,
--                 on input in a[1] is the dimension n of the test point,
--                 which equals the number of complex coordinates,
--                 in a[2] is the dimension of the witness set,
--                 and in a[3] is the number of characters in the string
--                 representation of the test point, as a solution;
--                 on input in b are the a[3] integers which encode the
--                 characters of the string representation of the solution,
--                 which stores the coordinates of the test point,
--                 in quad double precision,
--                 on input in c are the two tolerances:
--                 first on the residual for the evaluation,
--                 second on the tolerance on the membership,
--                 on return in a is the result of the evaluation test:
--                 0 if failure, or 1 if success,
--                 on return in b is the result of the membership test:
--                 0 if failure, or 1 if success.
--
-- operations on reading systems and solution with given file name :
--
--   job   = 540 : reads a standard system into the container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 541 : reads a double double system into the container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 542 : reads a quad double system into the container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 543 : reads a multiprecision system into the container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input,
--                 the value of a[1] stores the number of decimal places
--                 as the precision for parsing the numbers;
--   job   = 544 : reads a standard system into the systems container 
--                 and its solutions into the solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 545 : reads a double double system into the systems container
--                 and its solutions into the solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 546 : reads a quad double system into the systems container
--                 and its solutions into the solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 547 : reads a multiprecision system into the systems container
--                 and its solutions into the solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input,
--                 the value of a[1] stores the number of decimal places
--                 as the precision for parsing the numbers;
--
-- reading solutions from file with given file name :
--
--   job   = 916 : reads double precision solutions from file
--                 into the double precision solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 917 : reads double double precision solutions from file
--                 into the double double solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--         = 918 : reads quad double precision solutions from file
--                 into the quad double solutions container where the
--                 file name is given as a string of n = a[0] characters,
--                 with the n characters are stored in given b on input;
--
-- convex hull computations via the gift wrapping method :
--
--   job   = 580 : convex hull in the plane, on input are
--                 in a: the number of characters in the string representation
--                       of the point configuration,
--                 in b: as many integers as there are characters in the
--                       string representation of the point configuration,
--                 on return are 
--                 in a: the number of characters of the representation of
--                       the string representation of the convex hull
--                 in b: is a string representation of a tuple:
--                 the vertices and the inner normals, both represented
--                 as string representations of point configurations.
--   job   = 581 : convex hull in 3-space or 4-space, on input are
--                 in a: the number of characters in the string representation
--                       of the point configuration,
--                 in b: as many integers as there are characters in the
--                       string representation of the point configuration,
--                 this operation initializes the giftwrap container with
--                 the list of facets of the convex hull.
--   job   = 582 : if given in a either 3 or 4, then the number of facets
--                 of a convex hull in 3-space or 4-space respectively is
--                 returned in b.
--   job   = 583 : if given in a either 3 or 4 and in b the label of a facet,
--                 then the string representation of the facet is returned
--                 in b, with in a the number of characters in the string.
--   job   = 584 : clear the list of facets for the convex hull in 3-space.
--   job   = 585 : clear the list of facets for the convex hull in 4-space.
--   job   = 586 : returns in a the number of characters in the string
--                 representation of a support set of the first
--                 polynomial in the Laurent systems container;
--   job   = 587 : given in a the number computed in job 586,
--                 and with sufficient space allocated in b,
--                 returns the string representation of the support in b;
--   job   = 588 : deallocates the string computed in job 586.
--   job   = 589 : replaces the system in the Laurent systems container
--                 with its initial form as defined by the inner normal
--                 with coordinates in b and number of variables in a.
--                 The normal is given as a string of a Python tuple.
--
-- scaling systems and solutions :
--
--   job   = 590 : scales the system in the standard container,
--                 on input in a is either 0, 1, or 2:
--                 0 : only equation scaling,
--                 1 : variable scaling without variability reduction
--                 2 : variable scaling with variability reduction;
--                 if a is 1 or 2, then on return c contains the
--                 scaling coefficients and the estimate for the
--                 condition number, stored as a standard complex vector,
--                 the size of this vector is 4*n + 2,
--                 where n equals the number of equations and variables;
--           591 : scales the system in the dobldobl container,
--                 on input in a is either 0, 1, or 2:
--                 0 : only equation scaling,
--                 1 : variable scaling without variability reduction
--                 2 : variable scaling with variability reduction;
--                 if a is 1 or 2, then on return c contains the
--                 scaling coefficients and the estimate for the
--                 condition number, stored as a dobldobl complex vector,
--                 the size of this vector is 8*n + 4,
--                 where n equals the number of equations and variables;
--           592 : scales the system in the quaddobl container,
--                 on input in a is either 0, 1, or 2:
--                 0 : only equation scaling,
--                 1 : variable scaling without variability reduction
--                 2 : variable scaling with variability reduction;
--                 if a is 1 or 2, then on return c contains the
--                 scaling coefficients and the estimate for the
--                 condition number, stored as a quaddobl complex vector,
--                 the size of this vector is 16*n + 8,
--                 where n equals the number of equations and variables;
--           593 : scales the system in the multprec container,
--                 on input in a is either 0, 1, or 2:
--                 0 : only equation scaling,
--                 1 : variable scaling without variability reduction
--                 2 : variable scaling with variability reduction;
--                 if a is 1 or 2, then on return c contains the
--                 scaling coefficients and the estimate for the
--                 condition number, stored as a quadobl complex vector,
--                 the size of this vector is 16*n + 8,
--                 where n equals the number of equations and variables;
--   job =   594 : scales the solutions in the standard container,
--                 in a is the number n, in b the basis, and in c
--                 there are n doubles for use as coefficients,
--                 note that n/2 is the dimension of the complex vector,
--                 and n/2 is then also the dimension of the solutions;
--           595 : scales the solutions in the dobldobl container,
--                 in a is the number n, in b the basis, and in c
--                 there are n doubles for use as coefficients,
--                 note that n/4 is the dimension of the complex vector,
--                 and n/4 is then also the dimension of the solutions;
--           596 : scales the solutions in the quaddobl container,
--                 in a is the number n, in b the basis, and in c
--                 there are n doubles for use as coefficients,
--                 note that n/8 is the dimension of the complex vector,
--                 and n/8 is then also the dimension of the solutions;
--
--  Reduction of system to obtain a lower total degree :
--
--   job =   707 : reduces the system in the standard container,
--                 applying row reduction in standard double precision,
--                 on the coefficient matrix:
--                 on input in a is either 0 or 1:
--                 0 : triangulation of the coefficient matrix,
--                 1 : makes the coefficient matrix diagonal;
--                 the system in the standard container is replaced
--                 by the reduced system;
--       =   708 : reduces the system in the dobldobl container,
--                 applying row reduction in double double precision,
--                 on the coefficient matrix:
--                 on input in a is either 0 or 1:
--                 0 : triangulation of the coefficient matrix,
--                 1 : makes the coefficient matrix diagonal;
--                 the system in the dobldobl container is replaced
--                 by the reduced system;
--       =   709 : reduces the system in the quaddobl container,
--                 applying row reduction in quad double precision,
--                 on the coefficient matrix:
--                 on input in a is either 0 or 1:
--                 0 : triangulation of the coefficient matrix,
--                 1 : makes the coefficient matrix diagonal;
--                 the system in the quaddobl container is replaced
--                 by the reduced system.
--       =   710 : applies nonlinear reduction to the systems in the
--                 standard double container, on input in a are three limits:
--                 (1) the maximum number of equal degree replacements,
--                 (2) the maximum number of computed S-polynomials, and
--                 (3) the maximum number of computed R-polynomials;
--                 on return in b are three counters:
--                 (1) the number of equal degree replacements,
--                 (2) the number of computed S-polynomials, and
--                 (3) the number of computed R-polynomials;
--                 the system in the standard container is replaced
--                 by the reduced system.
--
--  Operating a sweep homotopy :
--
--   job =   610 : defines the indices of the variables that serve
--                 as parameters in the sweep homotopy numerically, given 
--                 in a[0] the number of equations,
--                 in a[1] the total number of variables,
--                 in a[2] the number m of parameters,
--                 in b a list of m integers with indices
--                 in the range 1..n defining the parameters;
--       =   611 : defines the parameters in the sweep homotopy symbolically,
--                 given in a[0] the number of equations,
--                 in a[1] the total number of variables,
--                 in a[2] the number m of parameters, and
--                 in a[3] the number of characters stored in b,
--                 the symbols in b are separated by one space,
--                 and the symbol table must be initialized properly
--                 so it contains all the symbols listed in b;
--       =   612 : returns in a the number of equations;
--       =   613 : returns in a the number of variables;
--       =   614 : returns in a the number of parameters;
--       =   615 : returns the indices of the parameters in a;
--       =   616 : returns in b the string representations of the
--                 parameters in the sweep homotopy, given on input in a
--                 an upper bound on the length of the string to store
--                 the sequence of symbols (separated by one space);
--       =   617 : clears the definition of the parameters in the sweep.
--       =   618 : sets the start or target values of the parameters,
--                 in standard double, double double, or quad double
--                 precision, on input are
--                 in a[0] : the precision level, 0, 1, or 2 for standard
--                 double, double double, or quad double respectively,
--                 in a[0] : 0 or 1, for start or target respectively,
--                 in b[0] : the number of coefficients to store the values
--                 real and imaginary parts of the start or target,
--                 irrespective the precision (d, dd, or qd), and
--                 in c : the values of the start or target parameters;
--       =   619 : gets the start or target values of the parameters,
--                 in standard double, double double, or quad double
--                 precision, on input are
--                 in a[0] : the precision level, 0, 1, or 2 for standard
--                 double, double double, or quad double respectively,
--                 in a[0] : 0 or 1, for start or target respectively,
--                 in b[0] : the number of coefficients to store the values
--                 real and imaginary parts of the start or target,
--                 irrespective the precision (d, dd, or qd), and
--                 on return in c are the values of the start or target;
--       =   620 : runs a complex convex-parameter sweep between the
--                 defined values of the parameter for start and target,
--                 with on input 
--                 in a[0] : the precision level, 0, 1, or 2 for standard
--                 double, double double, or quad double respectively,
--                 in a[1] : 0, 1, or 2 for the choice of the gamma,
--                 0: randomly generated gamma, should be the default,
--                 1: no gamma constant, gamma = 1 (which could fail),
--                 2: user given gamma, with real and complex part in
--                 c[0] and c[1] respectively;
--                 for this to work, the proper systems and solutions
--                 containers must be initialized, on return, the new
--                 solutions are stored in the solutions container.
--       =   621 : runs a real natural parameter sweep between the
--                 defined values of the parameter for start and target,
--                 with on input 
--                 in a : the precision level, 0, 1, or 2 for standard
--                 double, double double, or quad double respectively,
--                 for this to work, the proper systems and solutions
--                 containers must be initialized, on return, the new
--                 solutions are stored in the solutions container.
--
-- access to the container for numerically computed tropisms :
--
--   job  =  711 : initialize the tropisms in standard double precision,
--                 on input in a[0] are the number of tropisms, and
--                 in a[1] the length of the tropisms, in b are then
--                 the winding numbers, as many as the value of a[0],
--                 in c are all the floating-point coefficients,
--                 as many as a[0]*(a[1]+1), for the coordinates of the
--                 tropisms and the errors on the numerical tropisms; 
--        =  712 : initialize the tropisms in double double precision,
--                 on input in a[0] are the number of tropisms, and
--                 in a[1] the length of the tropisms, in b are then
--                 the winding numbers, as many as the value of a[0],
--                 in c are all the floating-point coefficients,
--                 as many as 2*a[0]*(a[1]+1), for the coordinates of the
--                 tropisms and the errors on the numerical tropisms; 
--        =  713 : initialize the tropisms in quad double precision,
--                 on input in a[0] are the number of tropisms, and
--                 in a[1] the length of the tropisms, in b are then
--                 the winding numbers, as many as the value of a[0],
--                 in c are all the floating-point coefficients,
--                 as many as 4*a[0]*(a[1]+1), for the coordinates of the
--                 tropisms and the errors on the numerical tropisms; 
--        =  714 : store a tropism in standard double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] the index of the tropism, 
--                 in b is the winding number,
--                 in c are all the floating-point coefficients,
--                 as many as a[0] + 1, with the coordinates of the 
--                 tropisms and the error;
--        =  715 : store a tropism in double double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] the index of the tropism, 
--                 in b is the winding number,
--                 in c are all the floating-point coefficients,
--                 as many as 2*a[0] + 2, with the coordinates of the 
--                 tropisms and the error;
--        =  716 : store a tropism in quad double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] the index of the tropism, 
--                 in b is the winding number,
--                 in c are all the floating-point coefficients,
--                 as many as 4*a[0] + 4, with the coordinates of the 
--                 tropisms and the error;
--        =  717 : retrieve all tropisms in standard double precision,
--                 on return in a[0] are the number of tropisms, and
--                 in a[1] the length of each tropism,
--                 in b are the winding numbers for each tropism, and
--                 in c are all coefficients, as many as a[0]*(a[1]+1);
--        =  718 : retrieve all tropisms in double double precision,
--                 on return in a[0] are the number of tropisms, and
--                 in a[1] the length of each tropism,
--                 in b are the winding numbers for each tropism, and
--                 in c are all coefficients, as many as 2*a[0]*(a[1]+1);
--        =  719 : retrieve all tropisms in quad double precision,
--                 on return in a[0] are the number of tropisms, and
--                 in a[1] the length of each tropism,
--                 in b are the winding numbers for each tropism, and
--                 in c are all coefficients, as many as 4*a[0]*(a[1]+1);
--        =  720 : the number of tropisms in standard double precision
--                 is returned in a;
--        =  721 : the number of tropisms in double double precision
--                 is returned in a;
--        =  722 : number of tropisms in quad double precision
--                 is returned in a;
--        =  723 : retrieve one tropism in standard double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] is the index of the tropism,
--                 on return in b is the winding number and in c are
--                 the coefficiennts, as many as a[0] + 1, of the
--                 coordinates of the tropism and the error,
--        =  724 : retrieve one tropism in double double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] is the index of the tropism,
--                 on return in b is the winding number and in c are
--                 the coefficiennts, as many as 2*a[0] + 2, of the
--                 coordinates of the tropism and the error,
--        =  725 : retrieve one tropism in quad double precision,
--                 on input in a[0] is the length of the tropism, and
--                 in a[1] is the index of the tropism,
--                 on return in b is the winding number and in c are
--                 the coefficiennts, as many as 4*a[0] + 4, of the
--                 coordinates of the tropism and the error,
--        =  726 : clear all tropisms in standard double precision;
--        =  727 : clear all tropisms in double double precision;
--        =  728 : clear all tropisms in quad double precision;
--        =  729 : the length of the tropisms in standard double precision
--                 is returned in a;
--        =  730 : the length of the tropisms in double double precision
--                 is returned in a;
--        =  731 : the length of the tropisms in quad double precision
--                 is returned in a.
--
--   Jobs for the blackbox numerical irreducicble decomposition are below.
--
--   job  =  845 : numerical irreducible decomposition with standard doubles,
--                 on the system in the standard polynomial systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--        =  846 : numerical irreducible decomposition with standard doubles,
--                 on the system in the standard Laurent systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--        =  847 : numerical irreducible decomposition with double doubles,
--                 on the system in the dobldobl polynomial systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--         = 848 : numerical irreducible decomposition with double doubles,
--                 on the system in the dobldobl Laurent systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--        =  849 : numerical irreducible decomposition with quad doubles,
--                 on the system in the quaddobl polynomial systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--        =  850 : numerical irreducible decomposition with quad doubles,
--                 on the system in the quaddobl Laurent systems container,
--                 the input parameters are
--                 a[0] : the top dimension of the solution set,
--                 a[1] : the number of tasks, 0 for no multitasking,
--                 a[2] : 0 or 1 if the witness supersets need to be filtered,
--                 a[3] : 0 or 1 if the witness sets need to be factored,
--                 b[0] : the verbose flag, 0 for false, 1 for true.
--                 If verbose, then intermediate results are written to screen.
--        =  851 : copies the witness set from the stored witness solutions
--                 into the standard polynomial system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  852 : copies the witness set from the stored witness solutions
--                 into the standard Laurent system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  853 : copies the witness set from the stored witness solutions
--                 into the dobldobl polynomial system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  854 : copies the witness set from the stored witness solutions
--                 into the dobldobl Laurent system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  855 : copies the witness set from the stored witness solutions
--                 into the quaddobl polynomial system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  856 : copies the witness set from the stored witness solutions
--                 into the quaddobl Laurent system and solutions containers,
--                 on input in a[0] is the dimension of the witness set.
--        =  857 : clears the witness solutions for standard double precision.
--        =  858 : clears the witness solutions for double double precision.
--        =  859 : clears the witness solutions for quad double precision.
--        =  993 : given in b[0], the number of characters in the string,
--                 return the string representation of the factors in b,
--                 returns in a[0] the number of characters in b.
--
-- passing tableau forms to the systems containers :
--
--   job  =  889 : initializes the systems container with the system 
--                 defined by tableau form stored in the triplet (a, b, c):
--                 in a[0] is the number of equations, 
--                 in a[1] is the number of variables,
--                 in a[2] is the total number of monomials,
--                 in a[k+2] is the number of terms of the k-th polynomial,
--                 exponents of monomials are stored in b,
--                 the size of b is a[1]*a[2],
--                 complex coefficients of monomials are stored in c,
--                 the size of c is 2*a[2];
--        =  890 : returns in a the dimensions of the system in the
--                 container for the standard double precision systems,
--                 a[0] : the number of equations,
--                 a[1] : the number of variables, and
--                 a[2] : the total number of terms.
--                 This job is good to allocate the data to retrieve
--                 the tableau form of a system.
--
-- projective coordinate transformations :
--
--   job   = 891 : to the system with double precision coefficients,
--                 applies a 1-homogeneous projective transformation,
--                 adding a random linear equation if a[0] == 0,
--                 or the linear equation z0 - 1 = 0 if a[0]] = 1;
--         = 892 : to the system with double double precision coefficients,
--                 applies a 1-homogeneous projective transformation,
--                 adding a random linear equation if a[0] == 0,
--                 or the linear equation z0 - 1 = 0 if a[0]] = 1;
--         = 893 : to the system with quad double precision coefficients,
--                 applies a 1-homogeneous projective transformation,
--                 adding a random linear equation if a[0] == 0,
--                 or the linear equation z0 - 1 = 0 if a[0]] = 1.
--         = 894 : to the solutions in double precision,
--                 applies a 1-homogeneous projective transformation,
--                 augmenting every solution with one as extra coordinate;
--         = 895 : to the solutions in double double precision,
--                 applies a 1-homogeneous projective transformation,
--                 augmenting every solution with one as extra coordinate;
--         = 896 : to the solutions in quad double precision,
--                 applies a 1-homogeneous projective transformation,
--                 augmenting every solution with one as extra coordinate;
--         = 897 : in b are the a[0] characters of the string which
--                 defines the name of the variable to be added to
--                 the symbol table, this name represents the variable
--                 added as the last coordinate in the homogenization;
--         = 898 : transforms the solutions in double precision
--                 into affine coordinates, dividing every coordinate
--                 by the value of the last coordinate of the solution;
--         = 899 : transforms the solutions in double double precision
--                 into affine coordinates, dividing every coordinate
--                 by the value of the last coordinate of the solution;
--         = 900 : transforms the solutions in quad double precision
--                 into affine coordinates, dividing every coordinate
--                 by the value of the last coordinate of the solution;
--         = 901 : to the system with double precision coefficients,
--                 substitutes the last variable by the value one,
--                 and removes the last linear equation;
--         = 902 : to the system with double double precision coefficients,
--                 substitutes the last variable by the value one,
--                 and removes the last linear equation;
--         = 903 : to the system with quad double precision coefficients,
--                 substitutes the last variable by the value one,
--                 and removes the last linear equation;
--         = 904 : to the system with double precision coefficients,
--                 applies a m-homogeneous projective transformation,
--                 adding a random linear equation if a[2] == 0,
--                 or the linear equation z0 - 1 = 0 if a[2]] = 1,
--                 where the number n of variables is in a[0],
--                 the value of m is in a[1], and the n values of b
--                 define the index representation of the partition;
--         = 905 : to the system with double double precision coefficients,
--                 applies a m-homogeneous projective transformation,
--                 adding a random linear equation if a[2] == 0,
--                 or the linear equation z0 - 1 = 0 if a[2]] = 1,
--                 where the number n of variables is in a[0],
--                 the value of m is in a[1], and the n values of b
--                 define the index representation of the partition;
--         = 906 : to the system with quad double precision coefficients,
--                 applies a m-homogeneous projective transformation,
--                 adding a random linear equation if a[2] == 0,
--                 or the linear equation z0 - 1 = 0 if a[2]] = 1,
--                 where the number n of variables is in a[0],
--                 the value of m is in a[1], and the n values of b
--                 define the index representation of the partition.
--         = 907 : to the system with double precision coefficients,
--                 substitutes the last m variables by the value one,
--                 and removes the last m linear equations,
--                 where the value of m equals a[0] on input;
--         = 908 : to the system with double double precision coefficients,
--                 substitutes the last m variables by the value one,
--                 and removes the last m linear equations,
--                 where the value of m equals a[0] on input;
--         = 909 : to the system with quad double precision coefficients,
--                 substitutes the last m variables by the value one,
--                 and removes the last m linear equations,
--                 where the value of m equals a[0] on input;
--         = 910 : to the solutions in standard double precision,
--                 applies a m-homogeneous projective transformation,
--                 augmenting every solution with m extra ones;
--         = 911 : to the solutions in double double precision,
--                 applies a m-homogeneous projective transformation,
--                 augmenting every solution with m extra ones;
--         = 912 : to the solutions in quad double precision,
--                 applies a m-homogeneous projective transformation,
--                 augmenting every solution with m extra ones;
--         = 913 : transforms the solutions in double precision
--                 into affine coordinates, dividing coordinates by the
--                 value of their corresponding homogeneous coordinate;
--         = 914 : transforms the solutions in double double precision
--                 into affine coordinates, dividing coordinates by the
--                 value of their corresponding homogeneous coordinate;
--         = 915 : transforms the solutions in quad double precision
--                 into affine coordinates, dividing coordinates by the
--                 value of their corresponding homogeneous coordinate.
--
-- CONDITION REPORT :
--
--   job   = 920 : computes a job report for the system and solutions in
--                 the containers in double precision, on entry in 
--                   a[0] : the number of maximum Newton steps per solution;
--                   a[1] : value of the verbose flag;
--                   a[2] : number of characters in the output file name;
--                 and a contains space for 3 more output numbers,
--                 in b is the name of the output file if a[2] > 0
--                 and b contains the output for 48 integers, and
--                   c[0] : tolerance on the forward error,
--                   c[1] : tolerance on the residual,
--                   c[2] : tolerance on inverse condition number;
--                 on return are the counts for failures, real, complex,
--                 regular, singular, and clustered solutions, respectively
--                 in a[0], a[1], a[2], a[3], a[4], and a[5], and in
--                 b are the 48 integers for the frequency tables for
--                 the forward erors, condition numbers, and residuals.
--
-- ON RETURN :
--   0 if the operation was successful, otherwise something went wrong,
--   or job not in the right range.
