/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: LGPL-2.1+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */

#pragma once

#if !defined (__LIBCELLBROADCAST_H_INSIDE__) && !defined (LIBCELLBROADCAST_COMPILATION)
#error "Only <libcellbroadcast.h> can be included directly."
#endif

#include <gio/gio.h>

G_BEGIN_DECLS

GListModel       *lcb_util_load_messages_from_file        (const char *path,
                                                           GError    **error);
GListModel       *lcb_util_load_messages_from_bytes       (GBytes     *bytes,
                                                           GError    **error);
GPtrArray        *lcb_util_load_raw_messages_from_file    (const char *path,
                                                           GError    **error);
GPtrArray        *lcb_util_load_raw_messages_from_bytes   (GBytes     *bytes,
                                                           GError    **error);

G_END_DECLS
