<?php
/**
 * Copyright 2007-2016 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author Jan Schneider <jan@horde.org>
 */
require_once __DIR__ . '/lib/Application.php';
Horde_Registry::appInit('whups');

// Url.
$url = Horde::url('', true);

// Name.
$name = $registry->get('name', 'whups') . ' (' . $url . ')';

// Icon.
$icon = base64_encode(file_get_contents($registry->get('themesfs', 'whups') . '/default/graphics/whups.png'));

// Charset.
header('Content-Type: text/xml; charset=UTF-8');
echo <<<PAYLOAD
<OpenSearchDescription xmlns="http://a9.com/-/spec/opensearch/1.1/">
  <ShortName>$name</ShortName>
  <SearchForm>$url</SearchForm>
  <Url type="text/html"
       method="get"
       template="${url}ticket/">
    <Param name="id" value="{searchTerms}"/>
  </Url>
  <Image height="16" width="16">data:image/png;base64,$icon</Image>
  <InputEncoding>UTF-8</InputEncoding>

</OpenSearchDescription>
PAYLOAD;
