#!/usr/bin/perl
#
# This script is (c) Olivier Delhomme 2008
#

print "header {\n";
print "    title = \"SquidGuard picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline t [label=\"Time\"];\n";
print "    ipv4     i [label=\"IPaddr\"];\n";
print "    string   u [label=\"URL\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/,/ /g;    # We escape our quotes
	$line =~ s/\"/\\"/g; # We escape our quotes
        $line =~ s/&//g;     # We escape our quotes
        $line =~ s/<//g;     # We escape our quotes
        $line =~ s/>//g;     # We escape our quotes

        # 2008-10-21 10:46:33 [15906] Request(default/media/-) http://img.youtube.com/vi/1skpHUfnaig/2.jpg 10.1.13.33/- - GET REDIRECT
        $line =~ m/^\S* (\d+:\d+):\d+ \S* \S* http:\/\/([\w\.-]*)\/\S* (\d+.\d+.\d+.\d+)\/- .*/;

        $time=$1;
        $ipaddr=$3;
        $url=$2;

        print "    t=\"$time\",i=\"$ipaddr\",u=\"$url\" ";
        print ";\n";
}
print "}\n";
