/* PowerPC-32 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2002, 2004 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library.  If not, see http://www.gnu.org/licenses/.  */

#define BITS_PER_MP_LIMB 32
#define BYTES_PER_MP_LIMB 4


/* This file is used for 75x (G3) and for 7400/7410 (G4), both which have
   much slow multiply instructions.  */

/* 450 MHz PPC 7400 */

/* Generated by tuneup.c, 2008-12-23, gcc 4.0 */

#define MUL_KARATSUBA_THRESHOLD          10
#define MUL_TOOM3_THRESHOLD              41
#define MUL_TOOM44_THRESHOLD             88

#define SQR_BASECASE_THRESHOLD            4
#define SQR_KARATSUBA_THRESHOLD          18
#define SQR_TOOM3_THRESHOLD              57
#define SQR_TOOM4_THRESHOLD              88

#define MULLOW_BASECASE_THRESHOLD         0  /* always */
#define MULLOW_DC_THRESHOLD              32
#define MULLOW_MUL_N_THRESHOLD          194

#define DIV_SB_PREINV_THRESHOLD           0  /* always */
#define DIV_DC_THRESHOLD                 33
#define POWM_THRESHOLD                   48

#define MATRIX22_STRASSEN_THRESHOLD      13
#define HGCD_THRESHOLD                   91
#define GCD_DC_THRESHOLD                256
#define GCDEXT_DC_THRESHOLD             256
#define JACOBI_BASE_METHOD                1

#define DIVREM_1_NORM_THRESHOLD           0  /* always */
#define DIVREM_1_UNNORM_THRESHOLD         0  /* always */
#define MOD_1_NORM_THRESHOLD              0  /* always */
#define MOD_1_UNNORM_THRESHOLD            0  /* always */
#define USE_PREINV_DIVREM_1               1
#define USE_PREINV_MOD_1                  1
#define DIVEXACT_1_THRESHOLD              0  /* always */
#define MODEXACT_1_ODD_THRESHOLD          0  /* always (native) */

#define GET_STR_DC_THRESHOLD             13
#define GET_STR_PRECOMPUTE_THRESHOLD     27
#define SET_STR_DC_THRESHOLD            390
#define SET_STR_PRECOMPUTE_THRESHOLD    814

#define MUL_FFT_TABLE  { 240, 608, 896, 2560, 6144, 40960, 0 }
#define MUL_FFT_MODF_THRESHOLD          232
#define MUL_FFT_THRESHOLD              1792

#define SQR_FFT_TABLE  { 240, 544, 896, 2560, 6144, 24576, 0 }
#define SQR_FFT_MODF_THRESHOLD          216
#define SQR_FFT_THRESHOLD              1792
