package org.codehaus.plexus.component.repository.exception;

import org.codehaus.plexus.classworlds.realm.ClassRealm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The exception which is thrown by a component repository when
 * the requested component cannot be found.
 *
 * @author Kristian Rosenvold
 * @version $Id$
 */
public class ComponentLookupRuntimeException
    extends RuntimeException
{
    public ComponentLookupRuntimeException( ComponentLookupException cause )
    {
        super( cause );
    }

    public String getMessage()
    {
        return getCause().getMessage();
    }
}
