/*
Driver: PNG/Portable Network Graphics
Files: testraster.png
Size is 90, 90
Coordinate System is `'
Metadata:
  Comment=Created with GIMP
Image Structure Metadata:
  INTERLEAVE=PIXEL
Corner Coordinates:
Upper Left  (    0.0,    0.0)
Lower Left  (    0.0,   90.0)
Upper Right (   90.0,    0.0)
Lower Right (   90.0,   90.0)
Center      (   45.0,   45.0)
Band 1 Block=90x1 Type=Byte, ColorInterp=Red
Band 2 Block=90x1 Type=Byte, ColorInterp=Green
Band 3 Block=90x1 Type=Byte, ColorInterp=Blue
*/
WITH foo AS (
	SELECT ST_FromGDALRaster(E'\\x89504e470d0a1a0a0000000d494844520000005a0000005a0802000000b7cad655000000017352474200aece1ce9000000097048597300000b1300000b1301009a9c180000000774494d4507dc020e16332b734b11150000001d69545874436f6d6d656e7400000000004372656174656420776974682047494d50642e6507000000c14944415478daedd8410ac030080440edffff9cfe607b6a0c61bc8a974161b157c55aa9dfdd71f4c4d9aa34fb94c28103070e1c3870e018a8feca70b60387c28103070e1c3870fc9f4a737b5df72bcdb3b603070e1c3870e0c081632695fa95da0e1c3870e0c08103078ef9549adb7ea58e45e1c08103070e1c3876a452bf52db8103070e1c3870e0c0319f4a73dbafd4b1281c3870e0c08103c78e54ea576a3b70e0c08103070e1c38e65369c550baeabe5fa9ed702c3870e0c08103078ee3ea057386489dc63798000000000049454e44ae426082'::bytea) AS rast
)
SELECT
	ST_Metadata(rast),
	ST_SummaryStats(rast, 1),
	ST_SummaryStats(rast, 2),
	ST_SummaryStats(rast, 3)
FROM foo;

/*
Driver: GTiff/GeoTIFF
Files: test4269.tif
Size is 10, 10
Coordinate System is:
GEOGCS["NAD83",
    DATUM["North_American_Datum_1983",
        SPHEROID["GRS 1980",6378137,298.2572221010002,
            AUTHORITY["EPSG","7019"]],
        TOWGS84[0,0,0,0,0,0,0],
        AUTHORITY["EPSG","6269"]],
    PRIMEM["Greenwich",0],
    UNIT["degree",0.0174532925199433],
    AUTHORITY["EPSG","4269"]]
Origin = (-168.000000000000000,85.000000000000000)
Pixel Size = (0.083000000000000,-0.083000000000000)
Metadata:
  AREA_OR_POINT=Area
  TIFFTAG_DATETIME=2012:03:02 09:59:31
  TIFFTAG_RESOLUTIONUNIT=2 (pixels/inch)
  TIFFTAG_SOFTWARE=Adobe Photoshop CS Windows
  TIFFTAG_XRESOLUTION=96
  TIFFTAG_YRESOLUTION=96
Image Structure Metadata:
  INTERLEAVE=PIXEL
Corner Coordinates:
Upper Left  (-168.0000000,  85.0000000) (168d 0' 0.00"W, 85d 0' 0.00"N)
Lower Left  (-168.0000000,  84.1700000) (168d 0' 0.00"W, 84d10'12.00"N)
Upper Right (-167.1700000,  85.0000000) (167d10'12.00"W, 85d 0' 0.00"N)
Lower Right (-167.1700000,  84.1700000) (167d10'12.00"W, 84d10'12.00"N)
Center      (-167.5850000,  84.5850000) (167d35' 6.00"W, 84d35' 6.00"N)
Band 1 Block=10x10 Type=Byte, ColorInterp=Red
Band 2 Block=10x10 Type=Byte, ColorInterp=Green
Band 3 Block=10x10 Type=Byte, ColorInterp=Blue
*/
WITH foo AS (
	SELECT 1 AS rid, ST_FromGDALRaster(E'\\x49492a0008000000150000010300010000000a00000001010300010000000a00000002010300030000001a01000003010300010000000100000006010300010000000200000011010400010000001502000015010300010000000300000016010300010000000a00000017010400010000002c0100001a010500010000000a0100001b01050001000000120100001c0103000100000001000000280103000100000002000000310102001b0000003a0100003201020014000000260100005301030003000000200100000e830c00030000005601000082840c00060000006e010000af870300240000009e010000b0870c0005000000e6010000b1870200070000000e0200000000000060000000010000006000000001000000080008000800010001000100323031323a30333a30322030393a35393a33310041646f62652050686f746f73686f702043532057696e646f77730000736891ed7c3fb53f736891ed7c3fb53f000000000000000000000000000000000000000000000000000000000000000000000000000065c000000000004055400000000000000000010001000000080000040000010002000104000001000100000800000100ad100108b187060000000608000001008e230908b087010001000b08b087010000000e08b08703000200a8f9eb941da4724000000040a65458410000000000000000000000000000000000000000000000004e414438337c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'::bytea) AS rast
	UNION ALL
	SELECT 2 AS rid, ST_FromGDALRaster(E'\\x49492a0008000000150000010300010000000a00000001010300010000000a00000002010300030000001a01000003010300010000000100000006010300010000000200000011010400010000001502000015010300010000000300000016010300010000000a00000017010400010000002c0100001a010500010000000a0100001b01050001000000120100001c0103000100000001000000280103000100000002000000310102001b0000003a0100003201020014000000260100005301030003000000200100000e830c00030000005601000082840c00060000006e010000af870300240000009e010000b0870c0005000000e6010000b1870200070000000e0200000000000060000000010000006000000001000000080008000800010001000100323031323a30333a30322030393a35393a33310041646f62652050686f746f73686f702043532057696e646f77730000736891ed7c3fb53f736891ed7c3fb53f000000000000000000000000000000000000000000000000000000000000000000000000000065c000000000004055400000000000000000010001000000080000040000010002000104000001000100000800000100ad100108b187060000000608000001008e230908b087010001000b08b087010000000e08b08703000200a8f9eb941da4724000000040a65458410000000000000000000000000000000000000000000000004e414438337c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'::bytea, 4326) AS rast
)
SELECT
	rid,
	ST_Metadata(rast),
	ST_SummaryStats(rast, 1),
	ST_SummaryStats(rast, 2),
	ST_SummaryStats(rast, 3)
FROM foo
ORDER BY rid;
