from __future__ import absolute_import, division, print_function, unicode_literals

import errno
import os
import stat
import sys
import prelude
import preludedb

from prewikka import siteconfig

if sys.version_info >= (3, 0):
    import builtins
    builtins.text_type = str
else:
    import __builtin__ as builtins
    builtins.text_type = unicode

    prelude.python2_return_unicode(True)
    preludedb.python2_return_unicode(True)

try:
    from threading import local
except ImportError:
    from dummy_threading import local


# Set default umask and create temporary directory
os.umask(0o027)

try:
    os.mkdir(siteconfig.tmp_dir, 0o700)
except OSError as e:
    if e.errno != errno.EEXIST:
        raise

    if not os.access(siteconfig.tmp_dir, os.R_OK | os.W_OK | os.X_OK):
        raise Exception("Prewikka temporary directory '%s' lack u+rwx permissions" % siteconfig.tmp_dir)

    if stat.S_IMODE(os.stat(siteconfig.tmp_dir).st_mode) & stat.S_IRWXO:
        raise Exception("Prewikka temporary directory '%s' is world accessible" % siteconfig.tmp_dir)


class _cache(object):
    pass


class Request(local):
    def _init(self, request):
        self.web = request
        self.user = None
        self.view = None
        self.menu = None
        self.dataset = None
        self.parameters = None
        self.cache = _cache()
        self.view_kwargs = {}

    def init(self, request):
        self._init(request)

        # env.viewmanager might be empty in case of early error (database)
        if env.viewmanager:
            env.viewmanager.set_url_adapter(self)

    def __init__(self):
        local.__init__(self)
        self._init(None)


class Env(object):
    htdocs_mapping = {}
    request = Request()


env = Env()
builtins.env = env

# import after env creation
from . import localization
