/*
 *@BEGIN LICENSE
 *
 * PSI4: an ab initio quantum chemistry software package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *@END LICENSE
 */
#ifndef SRC_LIB_LIBFRAG_LIBMOLECULE_ATOMTYPES_H_
#define SRC_LIB_LIBFRAG_LIBMOLECULE_ATOMTYPES_H_

#include "Atom.h"

namespace psi{
namespace LibMolecule{

class DummyAtom: public Atom{
   public:
      DummyAtom(const double* Carts, const bool IsBohr=true);
};

class PointCharge: public Atom{
   public:
      PointCharge(const double* Carts,const double Charge=0.0,
         const bool IsBohr=true);
};

class GhostAtom: public Atom{
   public:
      ///Don't give Z's <=0!!!
      GhostAtom(const double* Carts,const int Z=0,
            const bool IsBohr=true);
      ///Makes a new ghost, that is other as a ghost
      GhostAtom(const Atom& Other);
};


}}



#endif /* SRC_LIB_LIBFRAG_LIBMOLECULE_ATOMTYPES_H_ */
