---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet epp'
canonical: "/puppet/latest/man/epp.html"
---

# Man Page: puppet epp

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-epp** - Interact directly with the EPP template
parser/renderer.

## SYNOPSIS
puppet epp *action*

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

## ACTIONS
-   **dump** - Outputs a dump of the internal template parse tree for
    debugging: **SYNOPSIS**

    puppet epp dump \[\--e *source*\] \[\--\[no-\]validate\] \[\--format
    *old, pn, or json*\] \[\--pretty\] \[\--\[no-\]header\] \[\--format
    *old\|pn\|json*\] \[\--pretty\] { -e *source* \| \[*templates*
    \...\] }

    **DESCRIPTION**

    The dump action parses and validates the EPP syntax and dumps the
    resulting AST model in a human readable (but not necessarily an easy
    to understand) format.

    The output format can be controlled using the \--format
    *old\|pn\|json* where:

-   \'old\' is the default, but now deprecated format which is not API.

-   \'pn\' is the Puppet Extended S-Expression Notation.

-   \'json\' outputs the same graph as \'pn\' but with JSON syntax.

    The output will be \"pretty printed\" when the option \--pretty is
    given together with \--format \'pn\' or \'json\'. This option has no
    effect on the \'old\' format.

    The command accepts one or more templates (.epp) files, or an -e
    followed by the template source text. The given templates can be
    paths to template files, or references to templates in modules when
    given on the form *modulename*/*template-name*.epp. If no arguments
    are given, the stdin is read (unless it is attached to a terminal)

    If multiple templates are given, they are separated with a header
    indicating the name of the template. This can be suppressed with the
    option \--no-header. The option \--\[no-\]header has no effect when
    a single template is dumped.

    When debugging the epp parser itself, it may be useful to suppress
    the validation step with the **\--no-validate** option to observe
    what the parser produced from the given source.

    This command ignores the \--render-as setting/option.

    **OPTIONS** *\--e \<source*\> - Dump one epp source expression given
    on the command line.

    *\--format \<old, pn, or json*\> - Get result in \'old\' (deprecated
    format), \'pn\' (new format), or \'json\' (new format in JSON).

    *\--\[no-\]header* - Whether or not to show a file name header
    between files.

    *\--pretty* - Pretty print output. Only applicable together with
    \--format pn or json

    *\--\[no-\]validate* - Whether or not to validate the parsed result,
    if no-validate only syntax errors are reported.

    **RETURNS**

    A dump of the resulting AST model unless there are syntax or
    validation errors.

-   **render** - Renders an epp template as text: **SYNOPSIS**

    puppet epp render \[\--node *node_name*\] \[\--e *source*\]
    \[\--values *values_hash*\] \[\--values_file *pp_or_yaml_file*\]
    \[\--facts *facts_file*\] \[\--\[no-\]header\] -e *source* \|
    \[*templates* \...\]

    **DESCRIPTION**

    This action renders one or more EPP templates.

    The command accepts one or more templates (.epp files), given the
    same way as templates are given to the puppet **epp** function (a
    full path, or a relative reference on the form
    \'*modulename*/*template-name*.epp\'), or as a relative path.args In
    case the given path matches both a modulename/template and a file,
    the template from the module is used.

    An inline_epp equivalent can also be performed by giving the
    template after an -e, or by piping the EPP source text to the
    command.

    Values to the template can be defined using the Puppet Language on
    the command line with **\--values** or in a .pp or .yaml file
    referenced with **\--values_file**. If specifying both the result is
    merged with \--values having higher precedence.

    The \--values option allows a Puppet Language sequence of
    expressions to be defined on the command line the same way as it may
    be given in a .pp file referenced with **\--values_file**. It may
    set variable values (that become available in the template), and
    must produce either **undef** or a **Hash** of values (the hash may
    be empty). Producing **undef** simulates that the template is called
    without an arguments hash and thus only references variables in its
    outer scope. When a hash is given, a template is limited to seeing
    only the global scope. It is thus possible to simulate the different
    types of calls to the **epp** and **inline_epp** functions, with or
    without a given hash. Note that if variables are given, they are
    always available in this simulation - to test that the template only
    references variables given as arguments, produce a hash in \--values
    or the \--values_file, do not specify any variables that are not
    global, and turn on \--strict_variables setting.

    If multiple templates are given, the same set of values are given to
    each template. If both \--values and \--value_file are used, the
    \--values are merged on top of those given in the file.

    When multiple templates are rendered, a separating header is output
    between the templates showing the name of the template before the
    output. The header output can be turned off with **\--no-header**.
    This also concatenates the template results without any added
    newline separators.

    Facts from the node where the command is being run are used by
    default.args Facts can be obtained for other nodes if they have
    called in, and reported their facts by using the **\--node
    \<nodename\>** flag.

    Overriding node facts as well as additional facts can be given in a
    .yaml or .json file and referencing it with the \--facts option.
    (Values can be obtained in yaml format directly from **facter**, or
    from puppet for a given node). Note that it is not possible to
    simulate the reserved variable name **\$facts** in any other way.

    Note that it is not possible to set variables using the Puppet
    Language that have the same names as facts as this result in an
    error; \"attempt to redefine a variable\" since facts are set first.

    Exits with 0 if there were no validation errors. On errors, no
    rendered output is produced for that template file.

    When designing EPP templates, it is strongly recommended to define
    all template arguments in the template, and to give them in a hash
    when calling **epp** or **inline_epp** and to use as few global
    variables as possible, preferably only the \$facts hash. This makes
    templates more free standing and are easier to reuse, and to test.

    **OPTIONS** *\--e \<source*\> - Render one inline epp template given
    on the command line.

    *\--facts \<facts_file*\> - A .yaml or .json file containing a hash
    of facts made available in \$facts and \$trusted

    *\--\[no-\]header* - Whether or not to show a file name header
    between rendered results.

    *\--node \<node_name*\> - The name of the node for which facts are
    obtained. Defaults to facts for the local node.

    *\--values \<values_hash*\> - A Hash in Puppet DSL form given as
    arguments to the template being rendered.

    *\--values_file \<pp_or_yaml_file*\> - A .pp or .yaml file that is
    processed to produce a hash of values for the template.

    **RETURNS**

    A rendered result of one or more given templates.

-   **validate** - Validate the syntax of one or more EPP templates.:
    **SYNOPSIS**

    puppet epp validate \[\--\[no-\]continue_on_error\] \[*template*\]
    \[*template* \...\]

    **DESCRIPTION**

    This action validates EPP syntax without producing any output.

    When validating, multiple issues per file are reported up to the
    settings of max_error, and max_warnings. The processing stops after
    having reported issues for the first encountered file with errors
    unless the option \--continue_on_error is given.

    Files can be given using the **modulename/template.epp** style to
    lookup the template from a module, or be given as a reference to a
    file. If the reference to a file can be resolved against a template
    in a module, the module version wins - in this case use an absolute
    path to reference the template file if the module version is not
    wanted.

    Exits with 0 if there were no validation errors.

    **OPTIONS** *\--\[no-\]continue_on_error* - Whether or not to
    continue after errors are reported for a template.

    **RETURNS**

    Nothing, or encountered syntax errors.

## EXAMPLES
**render**

Render the template in module \'mymodule\' called \'mytemplate.epp\',
and give it two arguments **a** and **b**:



    $ puppet epp render mymodule/mytemplate.epp --values '{a => 10, b => 20}'

Render a template using an absolute path:



    $ puppet epp render /tmp/testing/mytemplate.epp --values '{a => 10, b => 20}'

Render a template with data from a .pp file:



    $ puppet epp render /tmp/testing/mytemplate.epp --values_file mydata.pp

Render a template with data from a .pp file and override one value on
the command line:



    $ puppet epp render /tmp/testing/mytemplate.epp --values_file mydata.pp --values '{a=>10}'

Render from STDIN:



    $ cat template.epp | puppet epp render --values '{a => 10, b => 20}'

Set variables in a .pp file and render a template that uses variable
references:



    ## data.pp file    $greeted = 'a global var'
    undef

    $ puppet epp render -e 'hello <%= $greeted %>' --values_file data.pp

Render a template that outputs a fact:



    $ facter --yaml > data.yaml
    $ puppet epp render -e '<% $facts[osfamily] %>' --facts data.yaml

**validate**

Validate the template \'template.epp\' in module \'mymodule\':



    $ puppet epp validate mymodule/template.epp

Validate two arbitrary template files:



    $ puppet epp validate mymodule/template1.epp yourmodule/something.epp

Validate a template somewhere in the file system:



      $ puppet epp validate /tmp/testing/template1.epp

Validate a template against a file relative to the current directory:



     $ puppet epp validate template1.epp
     $ puppet epp validate ./template1.epp

Validate from STDIN:



    $ cat template.epp | puppet epp validate

Continue on error to see errors for all templates:



    $ puppet epp validate mymodule/template1.epp mymodule/template2.epp --continue_on_error

## COPYRIGHT AND LICENSE
Copyright 2014 by Puppet Inc. Apache 2 license; see COPYING
